/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.StatusRuntimeException;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.bigtable.grpc.async.AbstractRetryingOperation;
import com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import java.util.concurrent.ScheduledExecutorService;

public class RetryingUnaryOperation<RequestT, ResponseT>
extends AbstractRetryingOperation<RequestT, ResponseT, ResponseT> {
    static final StatusRuntimeException NO_VALUE_SET_EXCEPTION = Status.INTERNAL.withDescription("No value received for unary call").asRuntimeException();
    private ResponseT value;

    public RetryingUnaryOperation(RetryOptions retryOptions, RequestT request, BigtableAsyncRpc<RequestT, ResponseT> retryableRpc, CallOptions callOptions, ScheduledExecutorService executorService, Metadata metadata) {
        super(retryOptions, request, retryableRpc, callOptions, executorService, metadata);
    }

    @Override
    public void onMessage(ResponseT message) {
        this.value = message;
        this.completionFuture.set(this.value);
    }

    @Override
    protected void onOK() {
        if (this.value == null) {
            this.completionFuture.setException(NO_VALUE_SET_EXCEPTION);
        }
    }
}

