/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.scanner;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.stub.StreamObserver;
import com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.cloud.bigtable.grpc.scanner.ResultQueueEntry;
import com.google.cloud.bigtable.grpc.scanner.ScanTimeoutException;
import com.google.cloud.bigtable.metrics.BigtableClientMetrics;
import com.google.cloud.bigtable.metrics.Timer;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ResponseQueueReader
implements StreamObserver<FlatRow> {
    private static Timer firstResponseTimer;
    protected final BlockingQueue<ResultQueueEntry<FlatRow>> resultQueue;
    protected AtomicBoolean completionMarkerFound = new AtomicBoolean(false);
    private boolean lastResponseProcessed = false;
    private Long startTime;

    private static synchronized Timer getFirstResponseTimer() {
        if (firstResponseTimer == null) {
            firstResponseTimer = BigtableClientMetrics.timer(BigtableClientMetrics.MetricLevel.Info, "grpc.method.ReadRows.firstResponse.latency");
        }
        return firstResponseTimer;
    }

    public ResponseQueueReader(int capacityCap) {
        this.resultQueue = new LinkedBlockingQueue<ResultQueueEntry<FlatRow>>(capacityCap);
        if (BigtableClientMetrics.isEnabled(BigtableClientMetrics.MetricLevel.Info)) {
            this.startTime = System.nanoTime();
        }
    }

    public synchronized FlatRow getNextMergedRow() throws IOException {
        if (this.lastResponseProcessed) {
            return null;
        }
        ResultQueueEntry<FlatRow> queueEntry = this.getNext();
        switch (queueEntry.getType()) {
            case CompletionMarker: {
                this.lastResponseProcessed = true;
                break;
            }
            case Data: {
                if (this.startTime != null) {
                    ResponseQueueReader.getFirstResponseTimer().update(System.nanoTime() - this.startTime, TimeUnit.NANOSECONDS);
                    this.startTime = null;
                }
                return queueEntry.getResponseOrThrow();
            }
            case Exception: {
                return queueEntry.getResponseOrThrow();
            }
            default: {
                throw new IllegalStateException("Cannot process type: " + (Object)((Object)queueEntry.getType()));
            }
        }
        Preconditions.checkState(this.lastResponseProcessed, "Should only exit merge loop with by returning a complete FlatRow or hitting end of stream.");
        return null;
    }

    protected ResultQueueEntry<FlatRow> getNext() throws IOException {
        ResultQueueEntry<FlatRow> queueEntry;
        try {
            queueEntry = this.resultQueue.poll(250L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting for next result", e);
        }
        if (queueEntry == null) {
            throw new ScanTimeoutException("Timeout while merging responses.");
        }
        return queueEntry;
    }

    public int available() {
        return this.resultQueue.size();
    }

    @Override
    public void onNext(FlatRow row) {
        try {
            this.resultQueue.put(ResultQueueEntry.fromResponse(row));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while adding a ResultQueueEntry", e);
        }
    }

    @Override
    public void onError(Throwable t) {
        try {
            this.resultQueue.put(ResultQueueEntry.fromThrowable(t));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while adding a ResultQueueEntry", e);
        }
    }

    @Override
    public void onCompleted() {
        try {
            this.completionMarkerFound.set(true);
            this.resultQueue.put(ResultQueueEntry.completionMarker());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while adding a ResultQueueEntry", e);
        }
    }
}

