/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.scanner;

import com.google.bigtable.repackaged.com.google.api.client.util.BackOff;
import com.google.bigtable.repackaged.com.google.api.client.util.Clock;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.stub.StreamObserver;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.bigtable.grpc.async.AbstractRetryingOperation;
import com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import com.google.cloud.bigtable.grpc.scanner.BigtableRetriesExhaustedException;
import com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.cloud.bigtable.grpc.scanner.ReadRowsRequestManager;
import com.google.cloud.bigtable.grpc.scanner.RowMerger;
import com.google.cloud.bigtable.grpc.scanner.ScanHandler;
import com.google.cloud.bigtable.grpc.scanner.ScanTimeoutException;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class RetryingReadRowsOperation
extends AbstractRetryingOperation<ReadRowsRequest, ReadRowsResponse, Void>
implements ScanHandler {
    private static final String TIMEOUT_CANCEL_MSG = "Client side timeout induced cancellation";
    @VisibleForTesting
    Clock clock = Clock.SYSTEM;
    private final ReadRowsRequestManager requestManager;
    private final StreamObserver<FlatRow> rowObserver;
    private RowMerger rowMerger;
    private long lastResponseMs;
    private int timeoutRetryCount = 0;

    public RetryingReadRowsOperation(StreamObserver<FlatRow> observer, RetryOptions retryOptions, ReadRowsRequest request, BigtableAsyncRpc<ReadRowsRequest, ReadRowsResponse> retryableRpc, CallOptions callOptions, ScheduledExecutorService retryExecutorService, Metadata originalMetadata) {
        super(retryOptions, request, retryableRpc, callOptions, retryExecutorService, originalMetadata);
        this.rowObserver = observer;
        this.requestManager = new ReadRowsRequestManager(request);
    }

    @Override
    protected AbstractRetryingOperation.GrpcFuture<Void> createCompletionFuture() {
        return null;
    }

    @Override
    protected ReadRowsRequest getRetryRequest() {
        return this.requestManager.buildUpdatedRequest();
    }

    @Override
    public void run() {
        this.lastResponseMs = this.clock.currentTimeMillis();
        this.rowMerger = new RowMerger(this.rowObserver);
        super.run();
    }

    @Override
    public void onMessage(ReadRowsResponse message) {
        this.call.request(1);
        this.resetStatusBasedBackoff();
        this.lastResponseMs = this.clock.currentTimeMillis();
        this.timeoutRetryCount = 0;
        ByteString previouslyProcessedKey = this.rowMerger.getLastCompletedRowKey();
        this.rowMerger.onNext(message);
        ByteString lastProcessedKey = this.rowMerger.getLastCompletedRowKey();
        if (previouslyProcessedKey != lastProcessedKey) {
            this.updateLastFoundKey(lastProcessedKey);
        } else {
            this.updateLastFoundKey(message.getLastScannedRowKey());
        }
    }

    protected void updateLastFoundKey(ByteString lastProcessedKey) {
        if (lastProcessedKey != null && !lastProcessedKey.isEmpty()) {
            this.requestManager.updateLastFoundKey(lastProcessedKey);
        }
    }

    @Override
    public void onClose(Status status, Metadata trailers) {
        if (status.getCode() == Status.Code.CANCELLED && status.getDescription().contains(TIMEOUT_CANCEL_MSG)) {
            return;
        }
        super.onClose(status, trailers);
    }

    @Override
    public void setException(Exception exception) {
        this.rowObserver.onError(exception);
        this.rowMerger = new RowMerger(this.rowObserver);
    }

    @Override
    protected boolean isRequestRetryable() {
        return true;
    }

    @Override
    protected void onOK() {
        this.rowMerger.onCompleted();
    }

    void resetStatusBasedBackoff() {
        this.currentBackoff = null;
        this.failedCount = 0;
        this.lastResponseMs = this.clock.currentTimeMillis();
    }

    @Override
    public void handleTimeout(ScanTimeoutException rte) throws BigtableRetriesExhaustedException {
        if (this.clock.currentTimeMillis() - this.lastResponseMs < (long)this.retryOptions.getReadPartialRowTimeoutMillis()) {
            return;
        }
        this.retryOnTimeout(rte);
    }

    private void retryOnTimeout(ScanTimeoutException rte) throws BigtableRetriesExhaustedException {
        LOG.info("The client could not get a response in %d ms. Retrying the scan.", this.retryOptions.getReadPartialRowTimeoutMillis());
        this.cancel(TIMEOUT_CANCEL_MSG);
        this.rpcTimerContext.close();
        if (!this.retryOptions.enableRetries() || ++this.timeoutRetryCount > this.retryOptions.getMaxScanTimeoutRetries()) {
            this.rpc.getRpcMetrics().markRetriesExhasted();
            throw new BigtableRetriesExhaustedException("Exhausted streaming retries after too many timeouts", rte);
        }
        this.rpc.getRpcMetrics().markRetry();
        this.resetStatusBasedBackoff();
        this.retryExecutorService.execute(this.getRunnable());
    }

    @VisibleForTesting
    int getTimeoutRetryCount() {
        return this.timeoutRetryCount;
    }

    @VisibleForTesting
    BackOff getCurrentBackoff() {
        return this.currentBackoff;
    }

    public RowMerger getRowMerger() {
        return this.rowMerger;
    }
}

