/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.bigtable.repackaged.com.google.api.client.util.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Function;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.FutureCallback;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.SettableFuture;
import com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.Row;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.grpc.BigtableSession;
import com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.cloud.bigtable.grpc.async.AsyncExecutor;
import com.google.cloud.bigtable.grpc.async.BulkMutation;
import com.google.cloud.bigtable.grpc.async.BulkRead;
import com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.cloud.bigtable.hbase.adapters.Adapters;
import com.google.cloud.bigtable.hbase.adapters.HBaseRequestAdapter;
import com.google.cloud.bigtable.metrics.BigtableClientMetrics;
import com.google.cloud.bigtable.metrics.Timer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.util.Bytes;

public class BatchExecutor {
    protected static final Logger LOG = new Logger(BatchExecutor.class);
    public static final byte[] NO_REGION = new byte[0];
    private static final Function<List<FlatRow>, FlatRow> ROWS_TO_ROW_CONVERTER = new Function<List<FlatRow>, FlatRow>(){

        @Override
        public FlatRow apply(List<FlatRow> rows) {
            if (rows.isEmpty()) {
                return null;
            }
            return rows.get(0);
        }
    };
    protected final BigtableSession session;
    protected final AsyncExecutor asyncExecutor;
    protected final BigtableOptions options;
    protected final HBaseRequestAdapter requestAdapter;
    protected final Timer batchTimer = BigtableClientMetrics.timer(BigtableClientMetrics.MetricLevel.Info, "batch.latency");

    public BatchExecutor(BigtableSession session, HBaseRequestAdapter requestAdapter) {
        this.session = session;
        this.asyncExecutor = session.createAsyncExecutor();
        this.options = session.getOptions();
        this.requestAdapter = requestAdapter;
    }

    private <R extends org.apache.hadoop.hbase.client.Row, T> ListenableFuture<Result> issueAsyncRowRequest(BulkOperation bulkOperation, org.apache.hadoop.hbase.client.Row row, Batch.Callback<T> callback, Object[] results, int index) {
        LOG.trace("issueRowRequest(BulkOperation, Row, Batch.Callback, Object[], index", new Object[0]);
        SettableFuture<Result> resultFuture = SettableFuture.create();
        RpcResultFutureCallback<T> futureCallback = new RpcResultFutureCallback<T>(row, callback, index, results, resultFuture);
        results[index] = null;
        Futures.addCallback(this.issueAsyncRequest(bulkOperation, row), futureCallback);
        return resultFuture;
    }

    private ListenableFuture<?> issueAsyncRequest(BulkOperation bulkOperation, org.apache.hadoop.hbase.client.Row row) {
        try {
            if (row instanceof Get) {
                return bulkOperation.readRowsAsync(this.requestAdapter.adapt((Get)row));
            }
            if (row instanceof Put) {
                return bulkOperation.mutateRowAsync((Put)row);
            }
            if (row instanceof Delete) {
                return bulkOperation.mutateRowAsync((Delete)row);
            }
            if (row instanceof Append) {
                return this.asyncExecutor.readModifyWriteRowAsync(this.requestAdapter.adapt((Append)row));
            }
            if (row instanceof Increment) {
                return this.asyncExecutor.readModifyWriteRowAsync(this.requestAdapter.adapt((Increment)row));
            }
            if (row instanceof RowMutations) {
                return bulkOperation.mutateRowAsync((RowMutations)row);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Futures.immediateFailedFuture(new IOException("Could not process the batch due to interrupt", e));
        }
        catch (Throwable e) {
            return Futures.immediateFailedFuture(new IOException("Could not process the batch", e));
        }
        LOG.error("Encountered unknown action type %s", row.getClass());
        return Futures.immediateFailedFuture(new IllegalArgumentException("Encountered unknown action type: " + row.getClass()));
    }

    public void batch(List<? extends org.apache.hadoop.hbase.client.Row> actions, @Nullable Object[] results) throws IOException, InterruptedException {
        if (results == null) {
            results = new Object[actions.size()];
        }
        this.batchCallback(actions, results, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> List<ListenableFuture<?>> issueAsyncRowRequests(List<? extends org.apache.hadoop.hbase.client.Row> actions, Object[] results, Batch.Callback<R> callback) {
        BulkOperation bulkOperation = new BulkOperation(this.session, this.asyncExecutor, this.requestAdapter, this.requestAdapter.getBigtableTableName());
        try {
            ArrayList resultFutures = new ArrayList(actions.size());
            for (int i = 0; i < actions.size(); ++i) {
                resultFutures.add(this.issueAsyncRowRequest(bulkOperation, actions.get(i), callback, results, i));
            }
            ArrayList arrayList = resultFutures;
            return arrayList;
        }
        finally {
            bulkOperation.flush();
        }
    }

    public Result[] batch(List<? extends org.apache.hadoop.hbase.client.Row> actions) throws IOException {
        try {
            Object[] resultsOrErrors = new Object[actions.size()];
            this.batch(actions, resultsOrErrors);
            Result[] results = new Result[resultsOrErrors.length];
            System.arraycopy(resultsOrErrors, 0, results, 0, results.length);
            return results;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Encountered exception in batch(List<>).", e, new Object[0]);
            throw new IOException("Batch error", e);
        }
    }

    public <R> void batchCallback(List<? extends org.apache.hadoop.hbase.client.Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        Preconditions.checkArgument(results.length == actions.size(), "Result array must have same dimensions as actions list.");
        List<ListenableFuture<?>> resultFutures = this.issueAsyncRowRequests(actions, results, callback);
        try (Timer.Context timerContext = this.batchTimer.time();){
            Futures.successfulAsList(resultFutures).get();
            ArrayList<Throwable> problems = new ArrayList<Throwable>();
            ArrayList<org.apache.hadoop.hbase.client.Row> problemActions = new ArrayList<org.apache.hadoop.hbase.client.Row>();
            ArrayList<String> hosts = new ArrayList<String>();
            for (int i = 0; i < resultFutures.size(); ++i) {
                try {
                    resultFutures.get(i).get();
                    continue;
                }
                catch (ExecutionException e) {
                    problemActions.add(actions.get(i));
                    problems.add(e.getCause());
                    hosts.add(this.options.getDataHost().toString());
                }
            }
            if (problems.size() > 0) {
                throw new RetriesExhaustedWithDetailsException(problems, problemActions, hosts);
            }
        }
    }

    public Boolean[] exists(List<Get> gets) throws IOException {
        Result[] getResults = this.batch(gets);
        Boolean[] exists = new Boolean[getResults.length];
        for (int index = 0; index < getResults.length; ++index) {
            exists[index] = !getResults[index].isEmpty();
        }
        return exists;
    }

    protected static class BulkOperation {
        private final AsyncExecutor asyncExecutor;
        private final HBaseRequestAdapter requestAdapter;
        private final BigtableOptions options;
        private BulkMutation bulkMutation;
        private BulkRead bulkRead;

        protected BulkOperation(BigtableSession session, AsyncExecutor asyncExecutor, HBaseRequestAdapter requestAdapter, BigtableTableName tableName) {
            this.asyncExecutor = asyncExecutor;
            this.requestAdapter = requestAdapter;
            this.options = session.getOptions();
            this.bulkRead = session.createBulkRead(tableName);
            this.bulkMutation = session.createBulkMutation(tableName, asyncExecutor);
        }

        protected ListenableFuture<?> mutateRowAsync(Put put) throws InterruptedException {
            if (!this.options.getBulkOptions().useBulkApi()) {
                return this.asyncExecutor.mutateRowAsync(this.requestAdapter.adapt(put));
            }
            return this.bulkMutation.add(this.requestAdapter.adaptEntry(put));
        }

        protected ListenableFuture<?> mutateRowAsync(Delete delete) throws InterruptedException {
            if (!this.options.getBulkOptions().useBulkApi()) {
                return this.asyncExecutor.mutateRowAsync(this.requestAdapter.adapt(delete));
            }
            return this.bulkMutation.add(this.requestAdapter.adaptEntry(delete));
        }

        protected ListenableFuture<?> mutateRowAsync(RowMutations mutations) throws InterruptedException {
            if (!this.options.getBulkOptions().useBulkApi()) {
                return this.asyncExecutor.mutateRowAsync(this.requestAdapter.adapt(mutations));
            }
            return this.bulkMutation.add(this.requestAdapter.adaptEntry(mutations));
        }

        protected ListenableFuture<?> readRowsAsync(ReadRowsRequest request) throws InterruptedException {
            if (!this.options.getBulkOptions().useBulkApi()) {
                return Futures.transform(this.asyncExecutor.readFlatRowsAsync(request), ROWS_TO_ROW_CONVERTER);
            }
            return this.bulkRead.add(request);
        }

        protected void flush() {
            this.bulkMutation.flush();
            this.bulkRead.flush();
        }
    }

    static class RpcResultFutureCallback<T>
    implements FutureCallback<Object> {
        private final org.apache.hadoop.hbase.client.Row row;
        private final Batch.Callback<T> callback;
        private final int index;
        private final Object[] resultsArray;
        private final SettableFuture<Result> resultFuture;

        public RpcResultFutureCallback(org.apache.hadoop.hbase.client.Row row, Batch.Callback<T> callback, int index, Object[] resultsArray, SettableFuture<Result> resultFuture) {
            this.row = row;
            this.callback = callback;
            this.index = index;
            this.resultsArray = resultsArray;
            this.resultFuture = resultFuture;
        }

        @Override
        public final void onSuccess(Object message) {
            Result result = Result.EMPTY_RESULT;
            try {
                if (message instanceof FlatRow) {
                    result = Adapters.FLAT_ROW_ADAPTER.adaptResponse((FlatRow)message);
                } else if (message instanceof Row) {
                    result = Adapters.ROW_ADAPTER.adaptResponse((Row)message);
                } else if (message instanceof ReadModifyWriteRowResponse) {
                    result = Adapters.ROW_ADAPTER.adaptResponse(((ReadModifyWriteRowResponse)message).getRow());
                }
            }
            catch (Throwable throwable) {
                this.onFailure(throwable);
                return;
            }
            this.resultsArray[this.index] = result;
            this.resultFuture.set(result);
            if (this.callback != null) {
                try {
                    this.callback.update(NO_REGION, this.row.getRow(), (Object)result);
                }
                catch (Throwable t) {
                    LOG.error("User callback threw an exception for " + Bytes.toString((byte[])result.getRow()), new Object[0]);
                }
            }
        }

        @Override
        public final void onFailure(Throwable throwable) {
            this.resultsArray[this.index] = throwable;
            this.resultFuture.setException(throwable);
        }
    }
}

