/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.bigtable.repackaged.com.google.protobuf.MessageLite;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.cloud.bigtable.hbase.adapters.Adapters;
import com.google.cloud.bigtable.hbase.adapters.HBaseMutationAdapter;
import com.google.cloud.bigtable.hbase.adapters.PutAdapter;
import com.google.cloud.bigtable.hbase.adapters.RowMutationsAdapter;
import com.google.cloud.bigtable.hbase.adapters.read.DefaultReadHooks;
import com.google.cloud.bigtable.hbase.adapters.read.ReadHooks;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;

public class HBaseRequestAdapter {
    protected final MutationAdapters mutationAdapters;
    protected final TableName tableName;
    protected final BigtableTableName bigtableTableName;

    public HBaseRequestAdapter(BigtableOptions options, TableName tableName, Configuration config) {
        this(options, tableName, new MutationAdapters(options, config));
    }

    public HBaseRequestAdapter(BigtableOptions options, TableName tableName, MutationAdapters mutationAdapters) {
        this.tableName = tableName;
        this.bigtableTableName = options.getInstanceName().toTableName(tableName.getQualifierAsString());
        this.mutationAdapters = mutationAdapters;
    }

    public MutateRowRequest adapt(Delete delete) {
        MessageLite.Builder requestBuilder = Adapters.DELETE_ADAPTER.adapt((Row)delete);
        ((MutateRowRequest.Builder)requestBuilder).setTableName(this.getTableNameString());
        return ((MutateRowRequest.Builder)requestBuilder).build();
    }

    public MutateRowsRequest.Entry adaptEntry(Delete delete) {
        return Adapters.DELETE_ADAPTER.toEntry(delete);
    }

    public ReadRowsRequest adapt(Get get) {
        DefaultReadHooks readHooks = new DefaultReadHooks();
        ReadRowsRequest.Builder builder = Adapters.GET_ADAPTER.adapt(get, (ReadHooks)readHooks);
        builder.setTableName(this.getTableNameString());
        return readHooks.applyPreSendHook(builder.build());
    }

    public ReadRowsRequest adapt(Scan scan) {
        DefaultReadHooks readHooks = new DefaultReadHooks();
        ReadRowsRequest.Builder builder = Adapters.SCAN_ADAPTER.adapt(scan, (ReadHooks)readHooks);
        builder.setTableName(this.getTableNameString());
        return readHooks.applyPreSendHook(builder.build());
    }

    public ReadModifyWriteRowRequest adapt(Append append) {
        ReadModifyWriteRowRequest.Builder builder = Adapters.APPEND_ADAPTER.adapt(append);
        builder.setTableName(this.getTableNameString());
        return builder.build();
    }

    public ReadModifyWriteRowRequest adapt(Increment increment) {
        ReadModifyWriteRowRequest.Builder builder = Adapters.INCREMENT_ADAPTER.adapt(increment);
        builder.setTableName(this.getTableNameString());
        return builder.build();
    }

    public MutateRowRequest adapt(Put put) {
        MessageLite.Builder builder = this.mutationAdapters.putAdapter.adapt((Row)put);
        ((MutateRowRequest.Builder)builder).setTableName(this.getTableNameString());
        return ((MutateRowRequest.Builder)builder).build();
    }

    public MutateRowsRequest.Entry adaptEntry(Put put) {
        return this.mutationAdapters.putAdapter.toEntry(put);
    }

    public MutateRowRequest adapt(RowMutations mutations) {
        MessageLite.Builder builder = this.mutationAdapters.rowMutationsAdapter.adapt((Row)mutations);
        ((MutateRowRequest.Builder)builder).setTableName(this.getTableNameString());
        return ((MutateRowRequest.Builder)builder).build();
    }

    public MutateRowsRequest.Entry adaptEntry(RowMutations mutations) {
        return this.mutationAdapters.rowMutationsAdapter.toEntry(mutations);
    }

    public MutateRowRequest adapt(Mutation mutation) {
        MessageLite.Builder builder = this.mutationAdapters.hbaseMutationAdapter.adapt((Row)mutation);
        ((MutateRowRequest.Builder)builder).setTableName(this.getTableNameString());
        return ((MutateRowRequest.Builder)builder).build();
    }

    public BigtableTableName getBigtableTableName() {
        return this.bigtableTableName;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    protected String getTableNameString() {
        return this.getBigtableTableName().toString();
    }

    public static class MutationAdapters {
        protected final PutAdapter putAdapter;
        protected final HBaseMutationAdapter hbaseMutationAdapter;
        protected final RowMutationsAdapter rowMutationsAdapter;

        public MutationAdapters(BigtableOptions options, Configuration config) {
            this.putAdapter = Adapters.createPutAdapter(config, options);
            this.hbaseMutationAdapter = Adapters.createMutationsAdapter(this.putAdapter);
            this.rowMutationsAdapter = new RowMutationsAdapter(this.hbaseMutationAdapter);
        }
    }
}

