/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.cloud.bigtable.config.Logger;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.Bytes;

public class SampledRowKeysAdapter {
    protected static final Logger LOG = new Logger(SampledRowKeysAdapter.class);
    private final TableName tableName;
    private final ServerName serverName;

    public SampledRowKeysAdapter(TableName tableName, ServerName serverName) {
        this.tableName = tableName;
        this.serverName = serverName;
    }

    public List<HRegionLocation> adaptResponse(List<SampleRowKeysResponse> responses) {
        ArrayList<HRegionLocation> regions = new ArrayList<HRegionLocation>();
        byte[] startKey = HConstants.EMPTY_START_ROW;
        for (SampleRowKeysResponse response : responses) {
            byte[] endKey = response.getRowKey().toByteArray();
            if (Bytes.equals((byte[])startKey, (byte[])endKey)) continue;
            HRegionInfo regionInfo = new HRegionInfo(this.tableName, startKey, endKey);
            startKey = endKey;
            regions.add(new HRegionLocation(regionInfo, this.serverName));
        }
        byte[] endKey = HConstants.EMPTY_END_ROW;
        if (regions.isEmpty() || !Bytes.equals((byte[])startKey, (byte[])endKey)) {
            HRegionInfo regionInfo = new HRegionInfo(this.tableName, startKey, endKey);
            regions.add(new HRegionLocation(regionInfo, this.serverName));
        }
        return regions;
    }
}

