/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.admin;

import com.google.bigtable.admin.v2.ColumnFamily;
import com.google.bigtable.admin.v2.Table;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.grpc.BigtableInstanceName;
import com.google.cloud.bigtable.hbase.adapters.admin.ColumnDescriptorAdapter;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;

public class TableAdapter {
    private final BigtableInstanceName bigtableInstanceName;
    private final ColumnDescriptorAdapter columnDescriptorAdapter;

    public TableAdapter(BigtableOptions options, ColumnDescriptorAdapter columnDescriptorAdapter) {
        this.bigtableInstanceName = options.getInstanceName();
        this.columnDescriptorAdapter = columnDescriptorAdapter;
    }

    public Table adapt(HTableDescriptor desc) {
        HashMap<String, ColumnFamily> columnFamilies = new HashMap<String, ColumnFamily>();
        for (HColumnDescriptor column : desc.getColumnFamilies()) {
            String columnName = column.getNameAsString();
            ColumnFamily columnFamily = this.columnDescriptorAdapter.adapt(column).build();
            columnFamilies.put(columnName, columnFamily);
        }
        return Table.newBuilder().putAllColumnFamilies(columnFamilies).build();
    }

    public HTableDescriptor adapt(Table table) {
        String tableId = this.bigtableInstanceName.toTableId(table.getName());
        HTableDescriptor tableDescriptor = new HTableDescriptor(TableName.valueOf((String)tableId));
        for (Map.Entry<String, ColumnFamily> entry : table.getColumnFamiliesMap().entrySet()) {
            tableDescriptor.addFamily(this.columnDescriptorAdapter.adapt(entry.getKey(), entry.getValue()));
        }
        return tableDescriptor;
    }
}

