/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.v2.ColumnRange;
import com.google.bigtable.v2.RowFilter;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import java.io.IOException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class ColumnRangeFilterAdapter
extends TypedFilterAdapterBase<ColumnRangeFilter> {
    private static final String REQUIRE_SINGLE_FAMILY_MESSAGE = "Scan or Get operations using ColumnRangeFilter must have a single family specified with #addFamily().";
    private static final FilterSupportStatus UNSUPPORTED_STATUS = FilterSupportStatus.newNotSupported("Scan or Get operations using ColumnRangeFilter must have a single family specified with #addFamily().");

    @Override
    public RowFilter adapt(FilterAdapterContext context, ColumnRangeFilter filter) throws IOException {
        byte[] familyName = this.getSingleFamily(context.getScan());
        ColumnRange.Builder rangeBuilder = ColumnRange.newBuilder();
        rangeBuilder.setFamilyName(Bytes.toString((byte[])familyName));
        if (filter.getMinColumn() != null) {
            ByteString startQualifier = ByteString.copyFrom(filter.getMinColumn());
            if (filter.getMinColumnInclusive()) {
                rangeBuilder.setStartQualifierClosed(startQualifier);
            } else {
                rangeBuilder.setStartQualifierOpen(startQualifier);
            }
        }
        if (filter.getMaxColumn() != null) {
            ByteString endQualifier = ByteString.copyFrom(filter.getMaxColumn());
            if (filter.getMaxColumnInclusive()) {
                rangeBuilder.setEndQualifierClosed(endQualifier);
            } else {
                rangeBuilder.setEndQualifierOpen(endQualifier);
            }
        }
        return RowFilter.newBuilder().setColumnRangeFilter(rangeBuilder).build();
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, ColumnRangeFilter filter) {
        int familyCount = context.getScan().numFamilies();
        if (familyCount != 1) {
            return UNSUPPORTED_STATUS;
        }
        return FilterSupportStatus.SUPPORTED;
    }

    byte[] getSingleFamily(Scan scan) {
        return scan.getFamilies()[0];
    }
}

