/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.v2.RowFilter;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class KeyOnlyFilterAdapter
extends TypedFilterAdapterBase<KeyOnlyFilter> {
    protected static final Cell TEST_CELL = new KeyValue(Bytes.toBytes((int)114), Bytes.toBytes((int)102), Bytes.toBytes((int)113), 1L, Bytes.toBytes((int)118));

    @Override
    public RowFilter adapt(FilterAdapterContext context, KeyOnlyFilter filter) throws IOException {
        return RowFilter.newBuilder().setChain(RowFilter.Chain.newBuilder().addFilters(RowFilter.newBuilder().setCellsPerRowLimitFilter(1).build()).addFilters(RowFilter.newBuilder().setStripValueTransformer(true).build()).build()).build();
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, KeyOnlyFilter filter) {
        if (filter.transformCell(TEST_CELL).getValueLength() != 0) {
            return FilterSupportStatus.newNotSupported("KeyOnlyFilters with lenAsVal = true are not supported");
        }
        return FilterSupportStatus.SUPPORTED;
    }
}

