/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.common.collect.BoundType;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableRangeSet;
import com.google.bigtable.repackaged.com.google.common.collect.Range;
import com.google.bigtable.repackaged.com.google.common.collect.RangeSet;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.v2.RowFilter;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import com.google.cloud.bigtable.util.RowKeyWrapper;
import java.io.IOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;

public class MultiRowRangeFilterAdapter
extends TypedFilterAdapterBase<MultiRowRangeFilter> {
    private static final FilterSupportStatus NO_MUST_PASS_ONE = FilterSupportStatus.newNotSupported("MultiRowRange filters can not be contained in MUST_PASS_ONE FilterLists");

    @Override
    public RowFilter adapt(FilterAdapterContext context, MultiRowRangeFilter filter) throws IOException {
        return RowFilter.newBuilder().setPassAllFilter(true).build();
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, MultiRowRangeFilter filter) {
        for (FilterList filterList : context.getCurrentFilterLists()) {
            if (filterList.getOperator() != FilterList.Operator.MUST_PASS_ONE) continue;
            return NO_MUST_PASS_ONE;
        }
        return FilterSupportStatus.SUPPORTED;
    }

    @Override
    public RangeSet<RowKeyWrapper> getIndexScanHint(MultiRowRangeFilter filter) {
        ImmutableRangeSet.Builder<RowKeyWrapper> rangeSetBuilder = ImmutableRangeSet.builder();
        for (MultiRowRangeFilter.RowRange rowRange : filter.getRowRanges()) {
            rangeSetBuilder.add(this.rowRangeToRange(rowRange));
        }
        return rangeSetBuilder.build();
    }

    private Range<RowKeyWrapper> rowRangeToRange(MultiRowRangeFilter.RowRange rowRange) {
        BoundType stopboundType;
        boolean startUnbounded = HConstants.EMPTY_BYTE_ARRAY.equals(rowRange.getStartRow());
        RowKeyWrapper start = new RowKeyWrapper(ByteString.copyFrom(rowRange.getStartRow()));
        BoundType startboundType = rowRange.isStartRowInclusive() ? BoundType.CLOSED : BoundType.OPEN;
        boolean stopUnbounded = HConstants.EMPTY_BYTE_ARRAY.equals(rowRange.getStopRow());
        RowKeyWrapper stop = new RowKeyWrapper(ByteString.copyFrom(rowRange.getStopRow()));
        BoundType boundType = stopboundType = rowRange.isStopRowInclusive() ? BoundType.CLOSED : BoundType.OPEN;
        if (startUnbounded && stopUnbounded) {
            return Range.all();
        }
        if (startUnbounded) {
            return Range.upTo(stop, stopboundType);
        }
        if (stopUnbounded) {
            return Range.downTo(start, startboundType);
        }
        return Range.range(start, startboundType, stop, stopboundType);
    }
}

