/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.common.collect.ImmutableRangeSet;
import com.google.bigtable.repackaged.com.google.common.collect.Range;
import com.google.bigtable.repackaged.com.google.common.collect.RangeSet;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.v2.RowFilter;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import com.google.cloud.bigtable.hbase.adapters.read.ReaderExpressionHelper;
import com.google.cloud.bigtable.util.ByteStringer;
import com.google.cloud.bigtable.util.RowKeyUtil;
import com.google.cloud.bigtable.util.RowKeyWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.PrefixFilter;

public class PrefixFilterAdapter
extends TypedFilterAdapterBase<PrefixFilter> {
    @Override
    public RowFilter adapt(FilterAdapterContext context, PrefixFilter filter) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(filter.getPrefix().length * 2);
        ReaderExpressionHelper.writeQuotedRegularExpression(baos, filter.getPrefix());
        baos.write(ReaderExpressionHelper.ALL_QUALIFIERS_BYTES);
        ByteString quotedValue = ByteStringer.wrap(baos.toByteArray());
        return RowFilter.newBuilder().setRowKeyRegexFilter(quotedValue).build();
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, PrefixFilter filter) {
        return FilterSupportStatus.SUPPORTED;
    }

    @Override
    public RangeSet<RowKeyWrapper> getIndexScanHint(PrefixFilter filter) {
        if (filter.getPrefix().length == 0) {
            return ImmutableRangeSet.of(Range.all());
        }
        ByteString start = ByteString.copyFrom(filter.getPrefix());
        ByteString end = ByteString.copyFrom(RowKeyUtil.calculateTheClosestNextRowKeyForPrefix(filter.getPrefix()));
        return ImmutableRangeSet.of(Range.closedOpen(new RowKeyWrapper(start), new RowKeyWrapper(end)));
    }
}

