/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.read;

import com.google.bigtable.repackaged.com.google.common.collect.BoundType;
import com.google.bigtable.repackaged.com.google.common.collect.Range;
import com.google.bigtable.repackaged.com.google.common.collect.RangeSet;
import com.google.bigtable.repackaged.com.google.common.collect.TreeRangeSet;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.v2.RowRange;
import com.google.bigtable.v2.RowSet;
import com.google.cloud.bigtable.util.RowKeyWrapper;

public class RowRangeAdapter {
    RangeSet<RowKeyWrapper> rowSetToRangeSet(RowSet btRowSet) {
        TreeRangeSet<RowKeyWrapper> rangeSet = TreeRangeSet.create();
        for (RowRange btRowRange : btRowSet.getRowRangesList()) {
            rangeSet.add(this.rowRangeToRange(btRowRange));
        }
        for (ByteString key : btRowSet.getRowKeysList()) {
            rangeSet.add(Range.singleton(new RowKeyWrapper(key)));
        }
        return rangeSet;
    }

    private Range<RowKeyWrapper> rowRangeToRange(RowRange btRange) {
        ByteString endKey;
        BoundType endBound;
        ByteString startKey;
        BoundType startBound;
        switch (btRange.getStartKeyCase()) {
            case START_KEY_OPEN: {
                startBound = BoundType.OPEN;
                startKey = btRange.getStartKeyOpen();
                break;
            }
            case START_KEY_CLOSED: {
                startBound = BoundType.CLOSED;
                startKey = btRange.getStartKeyClosed();
                break;
            }
            case STARTKEY_NOT_SET: {
                startBound = BoundType.CLOSED;
                startKey = ByteString.EMPTY;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected start key case: " + btRange.getStartKeyCase());
            }
        }
        boolean startUnbounded = startKey.isEmpty();
        switch (btRange.getEndKeyCase()) {
            case END_KEY_OPEN: {
                endBound = BoundType.OPEN;
                endKey = btRange.getEndKeyOpen();
                break;
            }
            case END_KEY_CLOSED: {
                endBound = BoundType.CLOSED;
                endKey = btRange.getEndKeyClosed();
                break;
            }
            case ENDKEY_NOT_SET: {
                endBound = BoundType.OPEN;
                endKey = ByteString.EMPTY;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected end key case: " + btRange.getEndKeyCase());
            }
        }
        boolean endUnbounded = endKey.isEmpty();
        if (startUnbounded && endUnbounded) {
            return Range.all();
        }
        if (startUnbounded) {
            return Range.upTo(new RowKeyWrapper(endKey), endBound);
        }
        if (endUnbounded) {
            return Range.downTo(new RowKeyWrapper(startKey), startBound);
        }
        return Range.range(new RowKeyWrapper(startKey), startBound, new RowKeyWrapper(endKey), endBound);
    }

    RowSet rangeSetToRowSet(RangeSet<RowKeyWrapper> guavaRangeSet) {
        RowSet.Builder rowSet = RowSet.newBuilder();
        for (Range<RowKeyWrapper> guavaRange : guavaRangeSet.asRanges()) {
            if (guavaRange.hasLowerBound() && guavaRange.lowerBoundType() == BoundType.CLOSED && guavaRange.hasUpperBound() && guavaRange.upperBoundType() == BoundType.CLOSED && guavaRange.lowerEndpoint().equals(guavaRange.upperEndpoint())) {
                rowSet.addRowKeys(guavaRange.lowerEndpoint().getKey());
                continue;
            }
            RowRange.Builder btRange = RowRange.newBuilder();
            if (guavaRange.hasLowerBound()) {
                switch (guavaRange.lowerBoundType()) {
                    case CLOSED: {
                        btRange.setStartKeyClosed(guavaRange.lowerEndpoint().getKey());
                        break;
                    }
                    case OPEN: {
                        btRange.setStartKeyOpen(guavaRange.lowerEndpoint().getKey());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected lower bound type: " + (Object)((Object)guavaRange.lowerBoundType()));
                    }
                }
            }
            if (guavaRange.hasUpperBound()) {
                switch (guavaRange.upperBoundType()) {
                    case CLOSED: {
                        btRange.setEndKeyClosed(guavaRange.upperEndpoint().getKey());
                        break;
                    }
                    case OPEN: {
                        btRange.setEndKeyOpen(guavaRange.upperEndpoint().getKey());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected upper bound type: " + (Object)((Object)guavaRange.upperBoundType()));
                    }
                }
            }
            rowSet.addRowRanges(btRange);
        }
        return rowSet.build();
    }
}

