/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.metrics;

import com.codahale.metrics.Counting;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.Timer;
import com.google.cloud.bigtable.metrics.Counter;
import com.google.cloud.bigtable.metrics.Meter;
import com.google.cloud.bigtable.metrics.MetricRegistry;
import com.google.cloud.bigtable.metrics.Timer;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class DropwizardMetricRegistry
implements MetricRegistry {
    private final com.codahale.metrics.MetricRegistry registry = new com.codahale.metrics.MetricRegistry();

    public static void createSlf4jReporter(DropwizardMetricRegistry registry, Logger logger, long period, TimeUnit unit) {
        MetricFilter nonZeroMatcher = new MetricFilter(){

            @Override
            public boolean matches(String name, Metric metric) {
                if (metric instanceof Counting) {
                    Counting counter = (Counting)((Object)metric);
                    return counter.getCount() > 0L;
                }
                return true;
            }
        };
        Slf4jReporter.forRegistry(registry.getRegistry()).outputTo(logger).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(nonZeroMatcher).build().start(period, unit);
    }

    @Override
    public Counter counter(String name) {
        final com.codahale.metrics.Counter counter = this.registry.counter(name);
        return new Counter(){

            @Override
            public void inc() {
                counter.inc();
            }

            @Override
            public void dec() {
                counter.dec();
            }
        };
    }

    @Override
    public Timer timer(String name) {
        final com.codahale.metrics.Timer timer = this.registry.timer(name);
        return new Timer(){

            @Override
            public Timer.Context time() {
                final Timer.Context timerContext = timer.time();
                return new Timer.Context(){

                    @Override
                    public void close() {
                        timerContext.close();
                    }
                };
            }

            @Override
            public void update(long duration, TimeUnit unit) {
                timer.update(duration, unit);
            }
        };
    }

    @Override
    public Meter meter(String name) {
        final com.codahale.metrics.Meter meter = this.registry.meter(name);
        return new Meter(){

            @Override
            public void mark() {
                meter.mark();
            }

            @Override
            public void mark(long size) {
                meter.mark(size);
            }
        };
    }

    public com.codahale.metrics.MetricRegistry getRegistry() {
        return this.registry;
    }
}

