/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.util;

import com.google.bigtable.repackaged.com.google.protobuf.ByteOutput;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.com.google.protobuf.UnsafeByteOperations;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class ZeroCopyByteStringUtil {
    public static ByteString wrap(byte[] array) {
        return UnsafeByteOperations.unsafeWrap(array);
    }

    public static byte[] get(ByteString byteString) {
        try {
            ZeroCopyByteOutput byteOutput = new ZeroCopyByteOutput();
            UnsafeByteOperations.unsafeWriteTo(byteString, byteOutput);
            return byteOutput.bytes;
        }
        catch (IOException e) {
            return byteString.toByteArray();
        }
    }

    private static final class ZeroCopyByteOutput
    extends ByteOutput {
        private byte[] bytes;

        private ZeroCopyByteOutput() {
        }

        @Override
        public void writeLazy(byte[] value, int offset, int length) {
            if (offset != 0 || length != value.length) {
                throw new UnsupportedOperationException();
            }
            this.bytes = value;
        }

        @Override
        public void write(byte value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void write(byte[] value, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void write(ByteBuffer value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeLazy(ByteBuffer value) {
            throw new UnsupportedOperationException();
        }
    }
}

