/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.data;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.locationtech.geomesa.hbase.data.HBaseDataStoreFactory$;
import org.locationtech.geomesa.hbase.data.HBaseDataStoreParams$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HBaseConnectionPool$
implements LazyLogging {
    public static final HBaseConnectionPool$ MODULE$;
    private Option<User> userCheck;
    private final Configuration org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$configuration;
    private final LoadingCache<Tuple2<Option<String>, Option<String>>, Configuration> configCache;
    private final LoadingCache<Tuple2<Configuration, Object>, Connection> org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$connectionCache;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new HBaseConnectionPool$();
    }

    private Logger logger$lzycompute() {
        HBaseConnectionPool$ hBaseConnectionPool$ = this;
        synchronized (hBaseConnectionPool$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private Option<User> userCheck() {
        return this.userCheck;
    }

    private void userCheck_$eq(Option<User> x$1) {
        this.userCheck = x$1;
    }

    public Configuration org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$configuration() {
        return this.org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$configuration;
    }

    private LoadingCache<Tuple2<Option<String>, Option<String>>, Configuration> configCache() {
        return this.configCache;
    }

    public LoadingCache<Tuple2<Configuration, Object>, Connection> org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$connectionCache() {
        return this.org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$connectionCache;
    }

    public Configuration getConfiguration(Map<String, Serializable> params) {
        Option zk = HBaseDataStoreParams$.MODULE$.ZookeeperParam().lookupOpt(params);
        Option paths = HBaseDataStoreParams$.MODULE$.ConfigPathsParam().lookupOpt(params);
        return (Configuration)this.configCache().get((Object)new Tuple2((Object)zk, (Object)paths));
    }

    public Connection getConnection(Map<String, Serializable> params, boolean validate) {
        return HBaseDataStoreParams$.MODULE$.ConnectionParam().exists(params) ? (Connection)HBaseDataStoreParams$.MODULE$.ConnectionParam().lookup(params) : (Connection)this.org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$connectionCache().get((Object)new Tuple2((Object)this.getConfiguration(params), (Object)BoxesRunTime.boxToBoolean((boolean)validate)));
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void configureSecurity(Configuration conf) {
        block17: {
            block16: {
                last = this.userCheck();
                if (!User.isHBaseSecurityEnabled((Configuration)conf)) break block16;
                authMethod = SecurityUtil.getAuthenticationMethod((Configuration)conf);
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Auth method: {}", new Object[]{authMethod});
                    v0 = BoxedUnit.UNIT;
                } else {
                    v0 = BoxedUnit.UNIT;
                }
                v1 = authMethod;
                var4_4 = UserGroupInformation.AuthenticationMethod.KERBEROS;
                if (v1 != null ? v1.equals(var4_4) == false : var4_4 != null) ** GOTO lbl-1000
                v2 = authMethod;
                var5_5 = UserGroupInformation.AuthenticationMethod.KERBEROS_SSL;
                if (!(v2 != null ? v2.equals(var5_5) == false : var5_5 != null)) {
                    v3 = BoxedUnit.UNIT;
                } else if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("HBase is configured to used Kerberos, however Hadoop authentication is: {}", new Object[]{authMethod});
                    v3 = BoxedUnit.UNIT;
                } else {
                    v3 = BoxedUnit.UNIT;
                }
                UserGroupInformation.setConfiguration((Configuration)conf);
                principal = conf.get(HBaseDataStoreFactory$.MODULE$.HBaseGeoMesaPrincipal());
                keytab = conf.get(HBaseDataStoreFactory$.MODULE$.HBaseGeoMesaKeyTab());
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Is Hadoop security enabled: {}", new Object[]{BoxesRunTime.boxToBoolean((boolean)UserGroupInformation.isSecurityEnabled())});
                    v4 = BoxedUnit.UNIT;
                } else {
                    v4 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Using Kerberos with principal {} and file {}", (Object[])new String[]{principal, keytab});
                    v5 = BoxedUnit.UNIT;
                } else {
                    v5 = BoxedUnit.UNIT;
                }
                UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Logged into Hadoop with user '{}'", new Object[]{User.getCurrent()});
                    v6 = BoxedUnit.UNIT;
                } else {
                    v6 = BoxedUnit.UNIT;
                }
                break block17;
            }
            v6 = BoxedUnit.UNIT;
        }
        this.userCheck_$eq((Option<User>)Option$.MODULE$.apply((Object)User.getCurrent()));
        if (last != null) {
            v7 = last;
            var8_8 = this.userCheck();
            if (v7 == null ? var8_8 != null : v7.equals(var8_8) == false) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detected change in authenticated user from ", " to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{last.getOrElse((Function0)new scala.Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "unauthenticated";
                        }
                    })}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - this may not work properly with Hadoop security"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.userCheck().getOrElse((Function0)new scala.Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "unauthenticated";
                        }
                    })}))).toString());
                    v8 = BoxedUnit.UNIT;
                } else {
                    v8 = BoxedUnit.UNIT;
                }
            }
        }
    }

    public Configuration org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$withPaths(Configuration base, Option<String> paths) {
        Configuration configuration;
        Seq sanitized = (Seq)((TraversableLike)((TraversableLike)Option$.MODULE$.option2Iterable(paths.filterNot((Function1)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$4) {
                return x$4.trim().isEmpty();
            }
        })).toSeq().flatMap((Function1)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String x$5) {
                return Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(x$5)).split(','));
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$6) {
                return x$6.trim();
            }
        }, Seq$.MODULE$.canBuildFrom())).filterNot((Function1)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$7) {
                return x$7.isEmpty();
            }
        });
        if (sanitized.isEmpty()) {
            configuration = base;
        } else {
            Configuration conf = new Configuration(base);
            sanitized.foreach((Function1)new scala.Serializable(conf){
                public static final long serialVersionUID = 0L;
                private final Configuration conf$3;

                public final void apply(String p) {
                    this.conf$3.addResource(new Path(p));
                }
                {
                    this.conf$3 = conf$3;
                }
            });
            configuration = conf;
        }
        return configuration;
    }

    private HBaseConnectionPool$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$configuration = this.org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$withPaths(HBaseConfiguration.create(), (Option<String>)HBaseDataStoreFactory$.MODULE$.ConfigPathProperty().option());
        this.configCache = Caffeine.newBuilder().build((CacheLoader)new CacheLoader<Tuple2<Option<String>, Option<String>>, Configuration>(){

            /*
             * Unable to fully structure code
             */
            public Configuration load(Tuple2<Option<String>, Option<String>> key) {
                block4: {
                    var3_2 = key;
                    if (var3_2 == null) break block4;
                    zookeepers = (Option)var3_2._1();
                    paths = (Option)var3_2._2();
                    var2_6 = var6_5 = new Tuple2((Object)zookeepers, (Object)paths);
                    zookeepers = (Option)var2_6._1();
                    paths = (Option)var2_6._2();
                    conf = HBaseConnectionPool$.MODULE$.org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$withPaths(HBaseConnectionPool$.MODULE$.org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$configuration(), (Option<String>)paths);
                    zookeepers.foreach((Function1)new scala.Serializable(this, conf){
                        public static final long serialVersionUID = 0L;
                        private final Configuration conf$1;

                        public final void apply(String zk) {
                            this.conf$1.set("hbase.zookeeper.quorum", zk);
                        }
                        {
                            this.conf$1 = conf$1;
                        }
                    });
                    if (!zookeepers.isEmpty()) ** GOTO lbl-1000
                    v0 = conf.get("hbase.zookeeper.quorum");
                    var10_10 = "localhost";
                    if (!(v0 != null ? v0.equals(var10_10) == false : var10_10 != null)) {
                        if (HBaseConnectionPool$.MODULE$.logger().underlying().isWarnEnabled()) {
                            HBaseConnectionPool$.MODULE$.logger().underlying().warn("HBase connection is set to localhost - this may indicate that 'hbase-site.xml' is not on the classpath");
                            v1 = BoxedUnit.UNIT;
                        } else {
                            v1 = BoxedUnit.UNIT;
                        }
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = BoxedUnit.UNIT;
                    }
                    HBaseConnectionPool$.MODULE$.configureSecurity(conf);
                    return conf;
                }
                throw new MatchError(var3_2);
            }
        });
        this.org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$connectionCache = Caffeine.newBuilder().build((CacheLoader)new CacheLoader<Tuple2<Configuration, Object>, Connection>(){

            public Connection load(Tuple2<Configuration, Object> key) {
                Tuple2<Configuration, Object> tuple2;
                block2: {
                    None$ none$;
                    block5: {
                        Connection connection;
                        block4: {
                            PrivilegedExceptionAction<Connection> action;
                            block3: {
                                Tuple2 tuple22;
                                tuple2 = key;
                                if (tuple2 == null) break block2;
                                Configuration conf = (Configuration)tuple2._1();
                                boolean validate = tuple2._2$mcZ$sp();
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)conf, (Object)BoxesRunTime.boxToBoolean((boolean)validate));
                                Configuration conf2 = (Configuration)tuple23._1();
                                boolean validate2 = tuple23._2$mcZ$sp();
                                action = new PrivilegedExceptionAction<Connection>(this, conf2, validate2){
                                    private final Configuration conf$2;
                                    private final boolean validate$1;

                                    public Connection run() {
                                        if (this.validate$1) {
                                            BoxedUnit boxedUnit;
                                            if (HBaseConnectionPool$.MODULE$.logger().underlying().isDebugEnabled()) {
                                                HBaseConnectionPool$.MODULE$.logger().underlying().debug("Checking configuration availability");
                                                boxedUnit = BoxedUnit.UNIT;
                                            } else {
                                                boxedUnit = BoxedUnit.UNIT;
                                            }
                                            HBaseAdmin.checkHBaseAvailable((Configuration)this.conf$2);
                                        }
                                        return ConnectionFactory.createConnection((Configuration)this.conf$2);
                                    }
                                    {
                                        this.conf$2 = conf$2;
                                        this.validate$1 = validate$1;
                                    }
                                };
                                Object user = User.isHBaseSecurityEnabled((Configuration)conf2) ? Option$.MODULE$.apply((Object)User.getCurrent()) : None$.MODULE$;
                                none$ = user;
                                if (!None$.MODULE$.equals(none$)) break block3;
                                connection = (Connection)action.run();
                                break block4;
                            }
                            if (!(none$ instanceof Some)) break block5;
                            Some some = (Some)none$;
                            User u = (User)some.x();
                            connection = (Connection)u.runAs((PrivilegedExceptionAction)action);
                        }
                        return connection;
                    }
                    throw new MatchError((Object)none$);
                }
                throw new MatchError(tuple2);
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                JavaConversions$.MODULE$.mapAsScalaConcurrentMap(HBaseConnectionPool$.MODULE$.org$locationtech$geomesa$hbase$data$HBaseConnectionPool$$connectionCache().asMap()).foreach((Function1)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Tuple2<Tuple2<Configuration, Object>, Connection> x$3) {
                        ((Connection)x$3._2()).close();
                    }
                });
            }
        });
    }
}

