/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.data;

import com.google.protobuf.ByteString;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.util.Bytes;
import org.locationtech.geomesa.hbase.data.HBaseDataStoreParams$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.security.AuthorizationsProvider;
import org.locationtech.geomesa.security.package$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.geotools.GeoMesaParam;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class HBaseDataStoreFactory$
implements GeoMesaDataStoreFactory.GeoMesaDataStoreInfo,
LazyLogging {
    public static final HBaseDataStoreFactory$ MODULE$;
    private final String HBaseGeoMesaPrincipal;
    private final String HBaseGeoMesaKeyTab;
    private final GeoMesaSystemProperties.SystemProperty RemoteFilterProperty;
    private final GeoMesaSystemProperties.SystemProperty ConfigPathProperty;
    private final String DisplayName;
    private final String Description;
    private final GeoMesaParam<?>[] ParameterInfo;
    private final String BigTableParamCheck;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new HBaseDataStoreFactory$();
    }

    private Logger logger$lzycompute() {
        HBaseDataStoreFactory$ hBaseDataStoreFactory$ = this;
        synchronized (hBaseDataStoreFactory$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String HBaseGeoMesaPrincipal() {
        return this.HBaseGeoMesaPrincipal;
    }

    public String HBaseGeoMesaKeyTab() {
        return this.HBaseGeoMesaKeyTab;
    }

    public GeoMesaSystemProperties.SystemProperty RemoteFilterProperty() {
        return this.RemoteFilterProperty;
    }

    public GeoMesaSystemProperties.SystemProperty ConfigPathProperty() {
        return this.ConfigPathProperty;
    }

    public String DisplayName() {
        return this.DisplayName;
    }

    public String Description() {
        return this.Description;
    }

    public GeoMesaParam<?>[] ParameterInfo() {
        return this.ParameterInfo;
    }

    public String BigTableParamCheck() {
        return this.BigTableParamCheck;
    }

    public boolean canProcess(Map<String, Serializable> params) {
        return HBaseDataStoreParams$.MODULE$.HBaseCatalogParam().exists(params) && Option$.MODULE$.apply((Object)HBaseConfiguration.create().get(this.BigTableParamCheck())).forall((Function1)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return x$3.trim().isEmpty();
            }
        });
    }

    public AuthorizationsProvider buildAuthsProvider(Connection connection, Map<String, Serializable> params) {
        Option forceEmptyOpt = HBaseDataStoreParams$.MODULE$.ForceEmptyAuthsParam().lookupOpt(params);
        boolean forceEmptyAuths = BoxesRunTime.unboxToBoolean((Object)forceEmptyOpt.getOrElse((Function0)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final Boolean apply() {
                return Boolean.FALSE;
            }
        }));
        if (VisibilityClient.isCellVisibilityEnabled((Connection)connection)) {
            String userName = User.getCurrent().getName();
            Buffer masterAuths = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(VisibilityClient.getAuths((Connection)connection, (String)userName).getAuthList()).map((Function1)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(ByteString a) {
                    return Bytes.toString((byte[])a.toByteArray());
                }
            }, Buffer$.MODULE$.canBuildFrom());
            String[] configuredAuths = (String[])Predef$.MODULE$.refArrayOps((Object[])((String)HBaseDataStoreParams$.MODULE$.AuthsParam().lookupOpt(params).getOrElse((Function0)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            })).split(",")).filter((Function1)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String s) {
                    return !s.isEmpty();
                }
            });
            String[] invalidAuths = (String[])Predef$.MODULE$.refArrayOps((Object[])configuredAuths).filterNot((Function1)new scala.Serializable(masterAuths){
                public static final long serialVersionUID = 0L;
                private final Buffer masterAuths$1;

                public final boolean apply(Object elem) {
                    return this.masterAuths$1.contains(elem);
                }
                {
                    this.masterAuths$1 = masterAuths$1;
                }
            });
            if (Predef$.MODULE$.refArrayOps((Object[])invalidAuths).nonEmpty()) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The authorizations '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])invalidAuths).mkString(",")}))).append((Object)"are not valid for the HBase user and connection being used").toString());
            }
            if (configuredAuths.length != 0 && forceEmptyAuths) {
                throw new IllegalArgumentException("Forcing empty auths is checked, but explicit auths are provided");
            }
            List auths = forceEmptyAuths || configuredAuths.length > 0 ? Predef$.MODULE$.refArrayOps((Object[])configuredAuths).toList() : masterAuths.toList();
            return package$.MODULE$.getAuthorizationsProvider(params, (Seq)auths);
        }
        throw new IllegalArgumentException("HBase cell visibility is not enabled on cluster");
    }

    private HBaseDataStoreFactory$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.HBaseGeoMesaPrincipal = "hbase.geomesa.principal";
        this.HBaseGeoMesaKeyTab = "hbase.geomesa.keytab";
        this.RemoteFilterProperty = new GeoMesaSystemProperties.SystemProperty("geomesa.hbase.remote.filtering", "true");
        this.ConfigPathProperty = new GeoMesaSystemProperties.SystemProperty("geomesa.hbase.config.paths", GeoMesaSystemProperties.SystemProperty$.MODULE$.apply$default$2());
        this.DisplayName = "HBase (GeoMesa)";
        this.Description = "Apache HBase\u2122 distributed key/value store";
        this.ParameterInfo = (GeoMesaParam[])((Object[])new GeoMesaParam[]{HBaseDataStoreParams$.MODULE$.HBaseCatalogParam(), HBaseDataStoreParams$.MODULE$.ZookeeperParam(), HBaseDataStoreParams$.MODULE$.RemoteFilteringParam(), HBaseDataStoreParams$.MODULE$.CoprocessorUrlParam(), HBaseDataStoreParams$.MODULE$.ConfigPathsParam(), HBaseDataStoreParams$.MODULE$.QueryThreadsParam(), HBaseDataStoreParams$.MODULE$.QueryTimeoutParam(), HBaseDataStoreParams$.MODULE$.GenerateStatsParam(), HBaseDataStoreParams$.MODULE$.AuditQueriesParam(), HBaseDataStoreParams$.MODULE$.LooseBBoxParam(), HBaseDataStoreParams$.MODULE$.CachingParam(), HBaseDataStoreParams$.MODULE$.EnableSecurityParam(), HBaseDataStoreParams$.MODULE$.AuthsParam(), HBaseDataStoreParams$.MODULE$.ForceEmptyAuthsParam()});
        this.BigTableParamCheck = "google.bigtable.instance.id";
    }
}

