/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.index;

import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.locationtech.geomesa.hbase.coprocessor.package$;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.index.HBaseColumnGroups$;
import org.locationtech.geomesa.hbase.index.HBaseFeatureIndex;
import org.locationtech.geomesa.hbase.index.HBaseFeatureIndex$;
import org.locationtech.geomesa.hbase.index.HBaseFeatureIndex$$anonfun$removeAll$1$;
import org.locationtech.geomesa.hbase.package$HBaseSystemProperties$;
import org.locationtech.geomesa.hbase.utils.HBaseVersions$;
import org.locationtech.geomesa.index.conf.partition.TablePartition$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.ParIterableLike;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileByteRef;
import scala.util.control.NonFatal$;

public abstract class HBaseFeatureIndex$class {
    public static String configure(HBaseFeatureIndex $this, SimpleFeatureType sft, HBaseDataStore ds, Option partition) {
        String table = $this.org$locationtech$geomesa$hbase$index$HBaseFeatureIndex$$super$configure(sft, ds, partition);
        TableName name = TableName.valueOf((String)table);
        WithClose$.MODULE$.apply((Object)ds.connection().getAdmin(), (Function1)new Serializable($this, table, name, sft, ds, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseFeatureIndex $outer;
            private final String table$1;
            public final TableName name$1;
            public final SimpleFeatureType sft$1;
            private final HBaseDataStore ds$1;
            private final Option partition$1;

            public final void apply(Admin admin) {
                VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
                if (!admin.tableExists(this.name$1)) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug("Creating table {}", new Object[]{this.name$1});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Configuration conf = admin.getConfiguration();
                    Option compression = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.userData$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$1), (Object)SimpleFeatureTypes.Configs$.MODULE$.COMPRESSION_ENABLED()).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String x$1) {
                            return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ HBaseFeatureIndex$.anonfun.configure.1 $outer;

                        public final Compression.Algorithm apply(String x$2) {
                            BoxedUnit boxedUnit;
                            String compressionType = ((String)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.userData$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.$outer.sft$1), (Object)SimpleFeatureTypes.Configs$.MODULE$.COMPRESSION_TYPE()).getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "gz";
                                }
                            })).toLowerCase(Locale.US);
                            if (this.$outer.org$locationtech$geomesa$hbase$index$HBaseFeatureIndex$$anonfun$$$outer().logger().underlying().isDebugEnabled()) {
                                this.$outer.org$locationtech$geomesa$hbase$index$HBaseFeatureIndex$$anonfun$$$outer().logger().underlying().debug("Setting compression '{}' on table {} for feature {}", new Object[]{compressionType, this.$outer.name$1, this.$outer.sft$1.getTypeName()});
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            return Compression.getCompressionAlgorithmByName((String)compressionType);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    HTableDescriptor descriptor = new HTableDescriptor(this.name$1);
                    HBaseColumnGroups$.MODULE$.apply(this.sft$1).foreach((Function1)new Serializable(this, compression, descriptor){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ HBaseFeatureIndex$.anonfun.configure.1 $outer;
                        private final Option compression$1;
                        private final HTableDescriptor descriptor$1;

                        public final void apply(Tuple2<byte[], SimpleFeatureType> x0$1) {
                            Tuple2<byte[], SimpleFeatureType> tuple2 = x0$1;
                            if (tuple2 != null) {
                                byte[] group = (byte[])tuple2._1();
                                HColumnDescriptor column = new HColumnDescriptor(group);
                                this.compression$1.foreach((Function1)new Serializable(this, column){
                                    public static final long serialVersionUID = 0L;
                                    private final HColumnDescriptor column$1;

                                    public final HColumnDescriptor apply(Compression.Algorithm x$1) {
                                        return this.column$1.setCompressionType(x$1);
                                    }
                                    {
                                        this.column$1 = column$1;
                                    }
                                });
                                HBaseVersions$.MODULE$.addFamily(this.descriptor$1, column);
                                this.$outer.org$locationtech$geomesa$hbase$index$HBaseFeatureIndex$$anonfun$$$outer().dataBlockEncoding().foreach((Function1)new Serializable(this, column){
                                    public static final long serialVersionUID = 0L;
                                    private final HColumnDescriptor column$1;

                                    public final HColumnDescriptor apply(DataBlockEncoding x$1) {
                                        return this.column$1.setDataBlockEncoding(x$1);
                                    }
                                    {
                                        this.column$1 = column$1;
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.compression$1 = compression$1;
                            this.descriptor$1 = descriptor$1;
                        }
                    });
                    if (this.ds$1.config().remoteFilter()) {
                        ObjectRef coprocessorUrl$lzy = ObjectRef.zero();
                        Option installed = Option$.MODULE$.apply((Object)conf.get("hbase.coprocessor.user.region.classes"));
                        Set names = (Set)installed.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Set<String> apply(String x$4) {
                                return Predef$.MODULE$.refArrayOps((Object[])x$4.split(":")).toSet();
                            }
                        }).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Set<String> apply() {
                                return Predef$.MODULE$.Set().empty();
                            }
                        });
                        package$.MODULE$.AllCoprocessors().foreach((Function1)new Serializable(this, conf, descriptor, coprocessorUrl$lzy, names, bitmap$0){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ HBaseFeatureIndex$.anonfun.configure.1 $outer;
                            private final Configuration conf$1;
                            private final HTableDescriptor descriptor$1;
                            private final ObjectRef coprocessorUrl$lzy$1;
                            private final Set names$1;
                            private final VolatileByteRef bitmap$0$1;

                            public final void apply(Class<? extends Coprocessor> c) {
                                if (!this.names$1.contains((Object)c.getCanonicalName())) {
                                    this.$outer.org$locationtech$geomesa$hbase$index$HBaseFeatureIndex$class$$anonfun$$addCoprocessor$1(c, this.descriptor$1, this.conf$1, this.coprocessorUrl$lzy$1, this.bitmap$0$1);
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.conf$1 = conf$1;
                                this.descriptor$1 = descriptor$1;
                                this.coprocessorUrl$lzy$1 = coprocessorUrl$lzy$1;
                                this.names$1 = names$1;
                                this.bitmap$0$1 = bitmap$0$1;
                            }
                        });
                    }
                    try {
                        admin.createTableAsync(descriptor, (byte[][])this.$outer.getSplits(this.sft$1, this.partition$1).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))));
                    }
                    catch (TableExistsException tableExistsException) {}
                }
                if (!admin.isTableAvailable(this.name$1)) {
                    BoxedUnit boxedUnit;
                    Option timeout = package$HBaseSystemProperties$.MODULE$.TableAvailabilityTimeout().toDuration().filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Duration x$5) {
                            return x$5.isFinite();
                        }
                    });
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting for table '", "' to become available with "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timeout.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(Duration t) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a timeout of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t}));
                            }
                        }).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "no timeout";
                            }
                        })}))).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Option stop = timeout.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Duration t) {
                            return System.currentTimeMillis() + t.toMillis();
                        }
                    });
                    while (!admin.isTableAvailable(this.name$1) && stop.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(long x$6) {
                            return this.apply$mcZJ$sp(x$6);
                        }

                        public boolean apply$mcZJ$sp(long x$6) {
                            return x$6 > System.currentTimeMillis();
                        }
                    })) {
                        Thread.sleep(1000L);
                    }
                }
            }

            public /* synthetic */ HBaseFeatureIndex org$locationtech$geomesa$hbase$index$HBaseFeatureIndex$$anonfun$$$outer() {
                return this.$outer;
            }

            private final Option coprocessorUrl$lzycompute$1(Configuration conf$1, ObjectRef coprocessorUrl$lzy$1, VolatileByteRef bitmap$0$1) {
                HBaseFeatureIndex$.anonfun.configure.1 var4_4 = this;
                synchronized (var4_4) {
                    if ((byte)(bitmap$0$1.elem & 1) == 0) {
                        coprocessorUrl$lzy$1.elem = this.ds$1.config().coprocessorUrl().orElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Option<Path> apply() {
                                return package$HBaseSystemProperties$.MODULE$.CoprocessorPath().option().map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Path apply(String x$3) {
                                        return new Path(x$3);
                                    }
                                });
                            }
                        }).orElse((Function0)new Serializable(this, conf$1){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ HBaseFeatureIndex$.anonfun.configure.1 $outer;
                            private final Configuration conf$1;

                            public final Option<Path> apply() {
                                Option option;
                                try {
                                    Path dir = new Path(this.conf$1.get("hbase.dynamic.jars.dir"));
                                    option = (Option)WithClose$.MODULE$.apply((Object)dir.getFileSystem(this.conf$1), (Function1)new Serializable(this, dir){
                                        public static final long serialVersionUID = 0L;
                                        private final Path dir$1;

                                        public final Option<Path> apply(FileSystem fs) {
                                            return Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(this.dir$1)).collectFirst((PartialFunction)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final <A1 extends FileStatus, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                                    A1 A1 = x1;
                                                    Object object = HBaseFeatureIndex$.MODULE$.org$locationtech$geomesa$hbase$index$HBaseFeatureIndex$$DistributedJarNamePattern().matcher(A1.getPath().getName()).matches() ? A1.getPath() : function1.apply(x1);
                                                    return (B1)object;
                                                }

                                                public final boolean isDefinedAt(FileStatus x1) {
                                                    FileStatus fileStatus = x1;
                                                    boolean bl = HBaseFeatureIndex$.MODULE$.org$locationtech$geomesa$hbase$index$HBaseFeatureIndex$$DistributedJarNamePattern().matcher(fileStatus.getPath().getName()).matches();
                                                    return bl;
                                                }
                                            });
                                        }
                                        {
                                            this.dir$1 = dir$1;
                                        }
                                    });
                                }
                                catch (Throwable throwable) {
                                    BoxedUnit boxedUnit;
                                    Throwable throwable2 = throwable;
                                    Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                                    if (option2.isEmpty()) {
                                        throw throwable;
                                    }
                                    Throwable e = (Throwable)option2.get();
                                    if (this.$outer.org$locationtech$geomesa$hbase$index$HBaseFeatureIndex$$anonfun$$$outer().logger().underlying().isWarnEnabled()) {
                                        this.$outer.org$locationtech$geomesa$hbase$index$HBaseFeatureIndex$$anonfun$$$outer().logger().underlying().warn("Error checking dynamic jar path:", e);
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    None$ none$ = None$.MODULE$;
                                    option = none$;
                                }
                                return option;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.conf$1 = conf$1;
                            }
                        });
                        bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
                    }
                    return (Option)coprocessorUrl$lzy$1.elem;
                }
            }

            private final Option coprocessorUrl$1(Configuration conf$1, ObjectRef coprocessorUrl$lzy$1, VolatileByteRef bitmap$0$1) {
                return (byte)(bitmap$0$1.elem & 1) == 0 ? this.coprocessorUrl$lzycompute$1(conf$1, coprocessorUrl$lzy$1, bitmap$0$1) : (Option)coprocessorUrl$lzy$1.elem;
            }

            public final void org$locationtech$geomesa$hbase$index$HBaseFeatureIndex$class$$anonfun$$addCoprocessor$1(Class clazz, HTableDescriptor desc, Configuration conf$1, ObjectRef coprocessorUrl$lzy$1, VolatileByteRef bitmap$0$1) {
                String name = clazz.getCanonicalName();
                if (!desc.getCoprocessors().contains(name)) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug("Using coprocessor path {}", new Object[]{this.coprocessorUrl$1(conf$1, coprocessorUrl$lzy$1, bitmap$0$1).orNull(Predef$.MODULE$.$conforms())});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    HBaseVersions$.MODULE$.addCoprocessor(desc, name, (Option<Path>)this.coprocessorUrl$1(conf$1, coprocessorUrl$lzy$1, bitmap$0$1), HBaseVersions$.MODULE$.addCoprocessor$default$4(), HBaseVersions$.MODULE$.addCoprocessor$default$5());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.table$1 = table$1;
                this.name$1 = name$1;
                this.sft$1 = sft$1;
                this.ds$1 = ds$1;
                this.partition$1 = partition$1;
            }
        });
        return table;
    }

    public static void removeAll(HBaseFeatureIndex $this, SimpleFeatureType sft, HBaseDataStore ds) {
        if (TablePartition$.MODULE$.partitioned(sft)) {
            $this.delete(sft, ds, (Option<String>)None$.MODULE$);
        } else {
            ((ParIterableLike)$this.getTableNames(sft, ds, (Option)None$.MODULE$).par()).foreach((Function1)new Serializable($this, sft, ds){
                public static final long serialVersionUID = 0L;
                public final SimpleFeatureType sft$2;
                public final HBaseDataStore ds$2;

                public final void apply(String name) {
                    TableName tableName = TableName.valueOf((String)name);
                    WithClose$.MODULE$.apply((Object)this.ds$2.connection().getTable(tableName), (Function1)new Serializable(this, tableName){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ HBaseFeatureIndex$.anonfun.removeAll.1 $outer;
                        private final TableName tableName$1;

                        public final void apply(Table table) {
                            Scan scan2 = new Scan().setFilter((Filter)new KeyOnlyFilter());
                            Object object = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isTableSharing$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.$outer.sft$2)) ? scan2.setRowPrefixFilter(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.$outer.sft$2))) : BoxedUnit.UNIT;
                            this.$outer.ds$2.applySecurity((Query)scan2);
                            BufferedMutatorParams mutateParams = new BufferedMutatorParams(this.tableName$1);
                            WithClose$.MODULE$.apply((Object)table.getScanner(scan2), (Function0)new Serializable(this, mutateParams){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ HBaseFeatureIndex$$anonfun$removeAll$1$.anonfun.apply.12 $outer;
                                private final BufferedMutatorParams mutateParams$1;

                                public final BufferedMutator apply() {
                                    return this.$outer.org$locationtech$geomesa$hbase$index$HBaseFeatureIndex$$anonfun$$anonfun$$$outer().ds$2.connection().getBufferedMutator(this.mutateParams$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.mutateParams$1 = mutateParams$1;
                                }
                            }, (Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(ResultScanner x0$2, BufferedMutator x1$1) {
                                    Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)x1$1);
                                    if (tuple2 != null) {
                                        ResultScanner scanner = (ResultScanner)tuple2._1();
                                        BufferedMutator mutator = (BufferedMutator)tuple2._2();
                                        JavaConversions$.MODULE$.asScalaIterator(scanner.iterator()).grouped(10000).foreach((Function1)new Serializable(this, mutator){
                                            public static final long serialVersionUID = 0L;
                                            private final BufferedMutator mutator$1;

                                            public final void apply(Seq<Result> result) {
                                                Seq deletes = (Seq)result.map((Function1)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final Delete apply(Result r) {
                                                        return new Delete(r.getRow());
                                                    }
                                                }, Seq$.MODULE$.canBuildFrom());
                                                this.mutator$1.mutate(JavaConversions$.MODULE$.seqAsJavaList(deletes));
                                            }
                                            {
                                                this.mutator$1 = mutator$1;
                                            }
                                        });
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                    throw new MatchError((Object)tuple2);
                                }
                            });
                        }

                        public /* synthetic */ HBaseFeatureIndex$.anonfun.removeAll.1 org$locationtech$geomesa$hbase$index$HBaseFeatureIndex$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.tableName$1 = tableName$1;
                        }
                    });
                }
                {
                    this.sft$2 = sft$2;
                    this.ds$2 = ds$2;
                }
            });
        }
    }

    public static void delete(HBaseFeatureIndex $this, SimpleFeatureType sft, HBaseDataStore ds, Option partition) {
        WithClose$.MODULE$.apply((Object)ds.connection().getAdmin(), (Function1)new Serializable($this, sft, ds, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseFeatureIndex $outer;
            private final SimpleFeatureType sft$3;
            private final HBaseDataStore ds$3;
            private final Option partition$2;

            public final void apply(Admin admin) {
                ((ParIterableLike)this.$outer.getTableNames(this.sft$3, this.ds$3, this.partition$2).par()).foreach((Function1)new Serializable(this, admin){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HBaseFeatureIndex$.anonfun.delete.1 $outer;
                    private final Admin admin$1;

                    public final void apply(String name) {
                        TableName table = TableName.valueOf((String)name);
                        if (this.admin$1.tableExists(table)) {
                            BoxedUnit boxedUnit;
                            this.admin$1.disableTableAsync(table);
                            Option timeout = package$HBaseSystemProperties$.MODULE$.TableAvailabilityTimeout().toDuration().filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(Duration x$7) {
                                    return x$7.isFinite();
                                }
                            });
                            if (this.$outer.org$locationtech$geomesa$hbase$index$HBaseFeatureIndex$$anonfun$$$outer().logger().underlying().isDebugEnabled()) {
                                this.$outer.org$locationtech$geomesa$hbase$index$HBaseFeatureIndex$$anonfun$$$outer().logger().underlying().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting for table '", "' to be disabled with "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timeout.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(Duration t) {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a timeout of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t}));
                                    }
                                }).getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "no timeout";
                                    }
                                })}))).toString());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            Option stop = timeout.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final long apply(Duration t) {
                                    return System.currentTimeMillis() + t.toMillis();
                                }
                            });
                            while (!this.admin$1.isTableDisabled(table) && stop.forall((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(long x$8) {
                                    return this.apply$mcZJ$sp(x$8);
                                }

                                public boolean apply$mcZJ$sp(long x$8) {
                                    return x$8 > System.currentTimeMillis();
                                }
                            })) {
                                Thread.sleep(1000L);
                            }
                            this.admin$1.deleteTable(table);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.admin$1 = admin$1;
                    }
                });
            }

            public /* synthetic */ HBaseFeatureIndex org$locationtech$geomesa$hbase$index$HBaseFeatureIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$3 = sft$3;
                this.ds$3 = ds$3;
                this.partition$2 = partition$2;
            }
        });
        $this.org$locationtech$geomesa$hbase$index$HBaseFeatureIndex$$super$delete(sft, ds, partition);
    }

    public static void $init$(HBaseFeatureIndex $this) {
        $this.org$locationtech$geomesa$hbase$index$HBaseFeatureIndex$_setter_$dataBlockEncoding_$eq((Option)new Some((Object)DataBlockEncoding.FAST_DIFF));
    }
}

