/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.index;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.geotools.factory.Hints;
import org.geotools.filter.identity.FeatureIdImpl;
import org.locationtech.geomesa.features.SerializationOption;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer$;
import org.locationtech.geomesa.hbase.coprocessor.aggregators.HBaseArrowAggregator$;
import org.locationtech.geomesa.hbase.coprocessor.aggregators.HBaseBinAggregator$;
import org.locationtech.geomesa.hbase.coprocessor.aggregators.HBaseDensityAggregator$;
import org.locationtech.geomesa.hbase.coprocessor.aggregators.HBaseStatsAggregator$;
import org.locationtech.geomesa.hbase.coprocessor.utils.CoprocessorConfig;
import org.locationtech.geomesa.hbase.coprocessor.utils.CoprocessorConfig$;
import org.locationtech.geomesa.hbase.data.EmptyPlan;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.data.HBaseFeature;
import org.locationtech.geomesa.hbase.data.HBaseQueryPlan;
import org.locationtech.geomesa.hbase.filters.CqlTransformFilter$;
import org.locationtech.geomesa.hbase.index.HBaseColumnGroups$;
import org.locationtech.geomesa.hbase.index.HBaseIndexAdapter;
import org.locationtech.geomesa.hbase.index.HBaseIndexAdapter$;
import org.locationtech.geomesa.index.api.FilterStrategy;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.index.ClientSideFiltering;
import org.locationtech.geomesa.index.iterators.StatsScan$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public abstract class HBaseIndexAdapter$class {
    public static ClientSideFiltering.RowAndValue rowAndValue(HBaseIndexAdapter $this, Result result) {
        Cell cell = result.rawCells()[0];
        return new ClientSideFiltering.RowAndValue(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength(), cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    public static Mutation createInsert(HBaseIndexAdapter $this, byte[] row, HBaseFeature feature) {
        Put put = new Put(row);
        feature.values().foreach((Function1)new Serializable($this, put){
            public static final long serialVersionUID = 0L;
            private final Put put$1;

            public final Put apply(HBaseFeature.RowValue v) {
                return this.put$1.addImmutable(v.cf(), v.cq(), v.value());
            }
            {
                this.put$1 = put$1;
            }
        });
        feature.visibility().foreach((Function1)new Serializable($this, put){
            public static final long serialVersionUID = 0L;
            private final Put put$1;

            public final Put apply(CellVisibility x$1) {
                return this.put$1.setCellVisibility(x$1);
            }
            {
                this.put$1 = put$1;
            }
        });
        return put.setDurability(HBaseIndexAdapter$.MODULE$.durability());
    }

    /*
     * WARNING - void declaration
     */
    public static Mutation createDelete(HBaseIndexAdapter $this, byte[] row, HBaseFeature feature) {
        void var3_3;
        Delete del = new Delete(row);
        feature.values().foreach((Function1)new Serializable($this, del){
            public static final long serialVersionUID = 0L;
            private final Delete del$1;

            public final Delete apply(HBaseFeature.RowValue v) {
                return this.del$1.addFamily(v.cf());
            }
            {
                this.del$1 = del$1;
            }
        });
        feature.visibility().foreach((Function1)new Serializable($this, del){
            public static final long serialVersionUID = 0L;
            private final Delete del$1;

            public final Delete apply(CellVisibility x$1) {
                return this.del$1.setCellVisibility(x$1);
            }
            {
                this.del$1 = del$1;
            }
        });
        return var3_3;
    }

    public static Scan createRange(HBaseIndexAdapter $this, byte[] start, byte[] end) {
        return new Scan(start, end);
    }

    public static Scan createRange(HBaseIndexAdapter $this, byte[] row) {
        return new Scan(row, ByteArrays$.MODULE$.rowFollowingRow(row)).setSmall(true);
    }

    public static QueryPlan scanPlan(HBaseIndexAdapter $this, SimpleFeatureType sft, HBaseDataStore ds, FilterStrategy filter, HBaseIndexAdapter.ScanConfig config) {
        HBaseIndexAdapter.ScanConfig scanConfig;
        block4: {
            HBaseQueryPlan hBaseQueryPlan;
            block3: {
                Tuple5 tuple5;
                block2: {
                    if (!config.ranges().isEmpty()) break block2;
                    hBaseQueryPlan = new EmptyPlan((FilterStrategy<HBaseDataStore, HBaseFeature, Mutation>)filter);
                    break block3;
                }
                Seq tables = (Seq)$this.getTablesForQuery(sft, ds, filter.filter()).map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final TableName apply(String x$1) {
                        return TableName.valueOf((String)x$1);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                scanConfig = config;
                if (scanConfig == null) break block4;
                Seq<Scan> ranges = scanConfig.ranges();
                byte[] colFamily = scanConfig.colFamily();
                Seq<Tuple2<Object, Filter>> hbaseFilters = scanConfig.filters();
                Option<CoprocessorConfig> coprocessor = scanConfig.coprocessor();
                Function1<Iterator<Result>, Iterator<SimpleFeature>> toFeatures = scanConfig.entriesToFeatures();
                Tuple5 tuple52 = tuple5 = new Tuple5(ranges, (Object)colFamily, hbaseFilters, coprocessor, toFeatures);
                Seq ranges2 = (Seq)tuple52._1();
                byte[] colFamily2 = (byte[])tuple52._2();
                Seq hbaseFilters2 = (Seq)tuple52._3();
                Option coprocessor2 = (Option)tuple52._4();
                Function1 toFeatures2 = (Function1)tuple52._5();
                hBaseQueryPlan = $this.buildPlatformScanPlan(ds, sft, (FilterStrategy<HBaseDataStore, HBaseFeature, Mutation>)filter, (Seq<Scan>)ranges2, colFamily2, (Seq<TableName>)tables, (Seq<Tuple2<Object, Filter>>)hbaseFilters2, (Option<CoprocessorConfig>)coprocessor2, (Function1<Iterator<Result>, Iterator<SimpleFeature>>)toFeatures2);
            }
            return hBaseQueryPlan;
        }
        throw new MatchError((Object)scanConfig);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HBaseIndexAdapter.ScanConfig scanConfig(HBaseIndexAdapter $this, SimpleFeatureType sft, HBaseDataStore ds, FilterStrategy filter, Seq ranges, Option ecql, Hints hints) {
        HBaseIndexAdapter.ScanConfig scanConfig;
        Tuple2 tuple2;
        Tuple2<byte[], SimpleFeatureType> tuple22;
        Option transform = QueryHints$.MODULE$.RichHints(hints).getTransform();
        Option option = transform;
        if (None$.MODULE$.equals(option)) {
            tuple22 = new Tuple2<byte[], SimpleFeatureType>((Object)HBaseColumnGroups$.MODULE$.default(), (Object)sft);
        } else {
            Some some;
            Tuple2 tuple23;
            if (!(option instanceof Some) || (tuple23 = (Tuple2)(some = (Some)option).x()) == null) throw new MatchError((Object)option);
            String tdefs = (String)tuple23._1();
            tuple22 = HBaseColumnGroups$.MODULE$.group(sft, tdefs, (Option<org.opengis.filter.Filter>)ecql);
        }
        Tuple2<byte[], SimpleFeatureType> tuple24 = tuple22;
        if (tuple24 == null) throw new MatchError((Object)tuple24);
        byte[] colFamily = (byte[])tuple24._1();
        SimpleFeatureType schema = (SimpleFeatureType)tuple24._2();
        Tuple2 tuple25 = tuple2 = new Tuple2((Object)colFamily, (Object)schema);
        byte[] colFamily2 = (byte[])tuple25._1();
        SimpleFeatureType schema2 = (SimpleFeatureType)tuple25._2();
        if (ds.config().remoteFilter()) {
            Some some;
            SimpleFeatureType returnSchema = (SimpleFeatureType)transform.map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final SimpleFeatureType apply(Tuple2<String, SimpleFeatureType> x$3) {
                    return (SimpleFeatureType)x$3._2();
                }
            }).getOrElse((Function0)new Serializable($this, schema2){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType schema$1;

                public final SimpleFeatureType apply() {
                    return this.schema$1;
                }
                {
                    this.schema$1 = schema$1;
                }
            });
            Function1<Iterator<Result>, Iterator<SimpleFeature>> toFeatures = $this.resultsToFeatures(schema2, returnSchema);
            if (QueryHints$.MODULE$.RichHints(hints).isDensityQuery()) {
                Map<String, String> options = HBaseDensityAggregator$.MODULE$.configure(schema2, $this, (Option<org.opengis.filter.Filter>)ecql, hints);
                some = new Some((Object)new CoprocessorConfig(options, (Function1<byte[], SimpleFeature>)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final SimpleFeature apply(byte[] bytes) {
                        return HBaseDensityAggregator$.MODULE$.bytesToFeatures(bytes);
                    }
                }, CoprocessorConfig$.MODULE$.apply$default$3()));
            } else if (QueryHints$.MODULE$.RichHints(hints).isArrowQuery()) {
                Tuple2 tuple26;
                Tuple2<Map<String, String>, Function1<CloseableIterator<SimpleFeature>, CloseableIterator<SimpleFeature>>> tuple27 = HBaseArrowAggregator$.MODULE$.configure(schema2, $this, ds.stats(), (Option<org.opengis.filter.Filter>)filter.filter(), (Option<org.opengis.filter.Filter>)ecql, hints);
                if (tuple27 == null) throw new MatchError(tuple27);
                Map options = (Map)tuple27._1();
                Function1 reduce = (Function1)tuple27._2();
                Tuple2 tuple28 = tuple26 = new Tuple2((Object)options, (Object)reduce);
                Map options2 = (Map)tuple28._1();
                Function1 reduce2 = (Function1)tuple28._2();
                some = new Some((Object)new CoprocessorConfig((Map<String, String>)options2, (Function1<byte[], SimpleFeature>)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final SimpleFeature apply(byte[] bytes) {
                        return HBaseArrowAggregator$.MODULE$.bytesToFeatures(bytes);
                    }
                }, (Function1<CloseableIterator<SimpleFeature>, CloseableIterator<SimpleFeature>>)reduce2));
            } else if (QueryHints$.MODULE$.RichHints(hints).isStatsQuery()) {
                Map<String, String> options = HBaseStatsAggregator$.MODULE$.configure(schema2, (GeoMesaFeatureIndex<HBaseDataStore, HBaseFeature, Mutation>)filter.index(), (Option<org.opengis.filter.Filter>)ecql, hints);
                Serializable reduce = new Serializable($this, returnSchema, hints){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeatureType returnSchema$1;
                    private final Hints hints$1;

                    public final CloseableIterator<SimpleFeature> apply(CloseableIterator<SimpleFeature> x$5) {
                        return StatsScan$.MODULE$.reduceFeatures(this.returnSchema$1, this.hints$1, x$5);
                    }
                    {
                        this.returnSchema$1 = returnSchema$1;
                        this.hints$1 = hints$1;
                    }
                };
                some = new Some((Object)new CoprocessorConfig(options, (Function1<byte[], SimpleFeature>)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final SimpleFeature apply(byte[] bytes) {
                        return HBaseStatsAggregator$.MODULE$.bytesToFeatures(bytes);
                    }
                }, (Function1<CloseableIterator<SimpleFeature>, CloseableIterator<SimpleFeature>>)reduce));
            } else if (QueryHints$.MODULE$.RichHints(hints).isBinQuery()) {
                Map<String, String> options = HBaseBinAggregator$.MODULE$.configure(schema2, (GeoMesaFeatureIndex<HBaseDataStore, HBaseFeature, Mutation>)filter.index(), (Option<org.opengis.filter.Filter>)ecql, hints);
                some = new Some((Object)new CoprocessorConfig(options, (Function1<byte[], SimpleFeature>)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final SimpleFeature apply(byte[] bytes) {
                        return HBaseBinAggregator$.MODULE$.bytesToFeatures(bytes);
                    }
                }, CoprocessorConfig$.MODULE$.apply$default$3()));
            } else {
                some = None$.MODULE$;
            }
            Some coprocessorConfig = some;
            Seq filters = coprocessorConfig.isDefined() || ecql.isEmpty() && transform.isEmpty() ? (Seq)Seq$.MODULE$.empty() : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)CqlTransformFilter$.MODULE$.Priority()), (Object)CqlTransformFilter$.MODULE$.apply(schema2, (Option<org.opengis.filter.Filter>)ecql, (Option<Tuple2<String, SimpleFeatureType>>)transform))}));
            scanConfig = new HBaseIndexAdapter.ScanConfig((Seq<Scan>)ranges, colFamily2, (Seq<Tuple2<Object, Filter>>)filters, (Option<CoprocessorConfig>)coprocessorConfig, toFeatures);
            return scanConfig;
        } else {
            scanConfig = new HBaseIndexAdapter.ScanConfig((Seq<Scan>)ranges, colFamily2, (Seq<Tuple2<Object, Filter>>)((Seq)Seq$.MODULE$.empty()), (Option<CoprocessorConfig>)None$.MODULE$, (Function1<Iterator<Result>, Iterator<SimpleFeature>>)$this.resultsToFeatures(schema2, ecql, transform));
        }
        return scanConfig;
    }

    public static boolean hasDuplicates(HBaseIndexAdapter $this, SimpleFeatureType sft, Option filter) {
        return false;
    }

    public static Function1 resultsToFeatures(HBaseIndexAdapter $this, SimpleFeatureType sft, SimpleFeatureType returnSft) {
        Function4 getId = $this.getIdFromRow(sft);
        KryoFeatureSerializer deserializer = KryoFeatureSerializer$.MODULE$.apply(returnSft, SerializationOption.SerializationOptions$.MODULE$.withoutId());
        return new Serializable($this, getId, deserializer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseIndexAdapter $outer;
            private final Function4 getId$2;
            private final KryoFeatureSerializer deserializer$2;

            public final Iterator<SimpleFeature> apply(Iterator<Result> results) {
                return HBaseIndexAdapter$class.org$locationtech$geomesa$hbase$index$HBaseIndexAdapter$$resultsToFeatures(this.$outer, this.deserializer$2, this.getId$2, results);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.getId$2 = getId$2;
                this.deserializer$2 = deserializer$2;
            }
        };
    }

    public static Iterator org$locationtech$geomesa$hbase$index$HBaseIndexAdapter$$resultsToFeatures(HBaseIndexAdapter $this, KryoFeatureSerializer deserializer, Function4 getId, Iterator results) {
        return results.map((Function1)new Serializable($this, deserializer, getId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseIndexAdapter $outer;
            private final KryoFeatureSerializer deserializer$1;
            private final Function4 getId$1;

            public final SimpleFeature apply(Result result) {
                ClientSideFiltering.RowAndValue rowAndValue = this.$outer.rowAndValue(result);
                if (rowAndValue != null) {
                    Tuple6 tuple6;
                    byte[] row = rowAndValue.row();
                    int rowOffset = rowAndValue.rowOffset();
                    int rowLength = rowAndValue.rowLength();
                    byte[] value = rowAndValue.value();
                    int valueOffset = rowAndValue.valueOffset();
                    int valueLength = rowAndValue.valueLength();
                    Tuple6 tuple62 = tuple6 = new Tuple6((Object)row, (Object)BoxesRunTime.boxToInteger((int)rowOffset), (Object)BoxesRunTime.boxToInteger((int)rowLength), (Object)value, (Object)BoxesRunTime.boxToInteger((int)valueOffset), (Object)BoxesRunTime.boxToInteger((int)valueLength));
                    byte[] row2 = (byte[])tuple62._1();
                    int rowOffset2 = BoxesRunTime.unboxToInt((Object)tuple62._2());
                    int rowLength2 = BoxesRunTime.unboxToInt((Object)tuple62._3());
                    byte[] value2 = (byte[])tuple62._4();
                    int valueOffset2 = BoxesRunTime.unboxToInt((Object)tuple62._5());
                    int valueLength2 = BoxesRunTime.unboxToInt((Object)tuple62._6());
                    SimpleFeature sf = this.deserializer$1.deserialize(value2, valueOffset2, valueLength2);
                    ((FeatureIdImpl)sf.getIdentifier()).setID((String)this.getId$1.apply((Object)row2, (Object)BoxesRunTime.boxToInteger((int)rowOffset2), (Object)BoxesRunTime.boxToInteger((int)rowLength2), (Object)sf));
                    return sf;
                }
                throw new MatchError((Object)rowAndValue);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.deserializer$1 = deserializer$1;
                this.getId$1 = getId$1;
            }
        });
    }

    public static void $init$(HBaseIndexAdapter $this) {
    }
}

