/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand$HBaseParams$class;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand$ToggleRemoteFilterParam$class;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand$class;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalZookeepersParam;
import org.locationtech.geomesa.tools.QueryHintsParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.ExportParams;
import org.locationtech.geomesa.tools.export.FileExportParams;
import org.locationtech.geomesa.tools.export.PlaybackCommand;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Tuple2;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001\u001f\t!\u0002JQ1tKBc\u0017-\u001f2bG.\u001cu.\\7b]\u0012T!a\u0001\u0003\u0002\r\u0015D\bo\u001c:u\u0015\t)a!A\u0003u_>d7O\u0003\u0002\b\u0011\u0005)\u0001NY1tK*\u0011\u0011BC\u0001\bO\u0016|W.Z:b\u0015\tYA\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001C\u0006\u0012\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\r9\"\u0004H\u0007\u00021)\u00111!\u0007\u0006\u0003\u000b!I!a\u0007\r\u0003\u001fAc\u0017-\u001f2bG.\u001cu.\\7b]\u0012\u0004\"!\b\u0011\u000e\u0003yQ!a\b\u0004\u0002\t\u0011\fG/Y\u0005\u0003Cy\u0011a\u0002\u0013\"bg\u0016$\u0015\r^1Ti>\u0014X\r\u0005\u0002$I5\tA!\u0003\u0002&\t\t)\u0002JQ1tK\u0012\u000bG/Y*u_J,7i\\7nC:$\u0007\"B\u0014\u0001\t\u0003A\u0013A\u0002\u001fj]&$h\bF\u0001*!\tQ\u0003!D\u0001\u0003\u0011\u001da\u0003A1A\u0005B5\na\u0001]1sC6\u001cX#\u0001\u0018\u0011\u0005=2eB\u0001\u0019@\u001d\t\tdH\u0004\u00023{9\u00111\u0007\u0010\b\u0003imr!!\u000e\u001e\u000f\u0005YJT\"A\u001c\u000b\u0005ar\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\b\u000b\u0001\u0013\u0001\u0012A!\u0002)!\u0013\u0015m]3QY\u0006L(-Y2l\u0007>lW.\u00198e!\tQ#IB\u0003\u0002\u0005!\u00051i\u0005\u0002C!!)qE\u0011C\u0001\u000bR\t\u0011I\u0002\u0003H\u0005\u0002A%a\u0005%CCN,\u0007\u000b\\1zE\u0006\u001c7\u000eU1sC6\u001c8#\u0002$\u0011\u0013R[\u0006C\u0001&R\u001d\tYuJ\u0004\u0002M\u001d:\u00111'T\u0005\u0003\u000b!I!aA\r\n\u0005AC\u0012a\u0004)mCf\u0014\u0017mY6D_6l\u0017M\u001c3\n\u0005I\u001b&A\u0004)mCf\u0014\u0017mY6QCJ\fWn\u001d\u0006\u0003!b\u0001\"!\u0016-\u000f\u0005E2\u0016BA,\u0005\u0003UA%)Y:f\t\u0006$\u0018m\u0015;pe\u0016\u001cu.\\7b]\u0012L!!\u0017.\u0003\u0017!\u0013\u0015m]3QCJ\fWn\u001d\u0006\u0003/\u0012\u0001\"!\u0016/\n\u0005uS&a\u0006+pO\u001edWMU3n_R,g)\u001b7uKJ\u0004\u0016M]1n\u0011\u00159c\t\"\u0001`)\u0005\u0001\u0007CA1G\u001b\u0005\u0011\u0005\u0006\u0002$d[:\u0004\"\u0001Z6\u000e\u0003\u0015T!AZ4\u0002\u0015)\u001cw.\\7b]\u0012,'O\u0003\u0002iS\u0006)!-Z;ti*\t!.A\u0002d_6L!\u0001\\3\u0003\u0015A\u000b'/Y7fi\u0016\u00148/\u0001\nd_6l\u0017M\u001c3EKN\u001c'/\u001b9uS>t\u0017%A8\u0002\rBc\u0017-\u001f2bG.\u0004c-Z1ukJ,7\u000f\t4s_6\u0004\u0013\rI$f_6+7/\u0019\u0011eCR\f\u0007e\u001d;pe\u0016d\u0003EY1tK\u0012\u0004sN\u001c\u0011uQ\u0016\u0004c-Z1ukJ,\u0007\u0005Z1uK\"1\u0011\u000f\u0001Q\u0001\n9\nq\u0001]1sC6\u001c\b\u0005")
public class HBasePlaybackCommand
implements PlaybackCommand<HBaseDataStore>,
HBaseDataStoreCommand {
    private final HBasePlaybackParams params;
    private final String name;
    private final Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public scala.collection.immutable.Map<String, String> connection() {
        return HBaseDataStoreCommand$class.connection(this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$export$PlaybackCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public SimpleFeatureCollection getFeatures(DataStore ds, Query query) {
        return PlaybackCommand.class.getFeatures((PlaybackCommand)this, (DataStore)ds, (Query)query);
    }

    public void org$locationtech$geomesa$tools$export$ExportCommand$_setter_$name_$eq(String x$1) {
    }

    public void execute() {
        ExportCommand.class.execute((ExportCommand)this);
    }

    public Option export(DataStore ds) {
        return ExportCommand.class.export((ExportCommand)this, (DataStore)ds);
    }

    public Option<Object> export(FeatureExporter exporter, SimpleFeatureCollection collection) {
        return ExportCommand.class.export((ExportCommand)this, (FeatureExporter)exporter, (SimpleFeatureCollection)collection);
    }

    public SimpleFeatureType getSchema(DataStore ds) {
        return ExportCommand.class.getSchema((ExportCommand)this, (DataStore)ds);
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        HBasePlaybackCommand hBasePlaybackCommand = this;
        synchronized (hBasePlaybackCommand) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public <T> T withDataStore(Function1<HBaseDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    @Override
    public HBasePlaybackParams params() {
        return this.params;
    }

    public HBasePlaybackCommand() {
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        LazyLogging.class.$init$((LazyLogging)this);
        MethodProfiling.class.$init$((MethodProfiling)this);
        ExportCommand.class.$init$((ExportCommand)this);
        PlaybackCommand.class.$init$((PlaybackCommand)this);
        HBaseDataStoreCommand$class.$init$(this);
        this.params = new HBasePlaybackParams();
    }

    @Parameters(commandDescription="Playback features from a GeoMesa data store, based on the feature date")
    public static class HBasePlaybackParams
    implements PlaybackCommand.PlaybackParams,
    HBaseDataStoreCommand.HBaseParams,
    HBaseDataStoreCommand.ToggleRemoteFilterParam {
        @Parameter(names={"--no-remote-filters"}, description="Disable remote filtering and coprocessors", arity=0)
        private boolean noRemote;
        @Parameter(names={"--secure"}, description="Enable HBase security (visibilities)")
        private boolean secure;
        @Parameter(names={"--authorizations"}, description="Authorizations used for querying, comma-delimited")
        private String auths;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"--interval"}, description="Date interval to query, in the format yyyy-MM-dd'T'HH:mm:ss.SSSZ/yyyy-MM-dd'T'HH:mm:ss.SSSZ", required=true, converter=ParameterConverters.IntervalConverter.class)
        private Tuple2<Date, Date> interval;
        @Parameter(names={"--dtg"}, description="Date attribute to base playback on")
        private String dtg;
        @Parameter(names={"--step-window"}, description="Query the interval in discrete chunks instead of all at once ('10 minutes', '30 seconds', etc)", converter=ParameterConverters.DurationConverter.class)
        private Duration window;
        @Parameter(names={"--rate"}, description="Rate multiplier to speed-up (or slow down) features being returned")
        private Float rate;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"-a", "--attributes"}, description="Attributes from feature to export (comma-separated)...Comma-separated expressions with each in the format attribute[=filter_function_expression]|derived-attribute=filter_function_expression|'id'. 'id' will export the feature ID, filter_function_expression is an expression of filter function applied to attributes, literals and filter functions, i.e. can be nested")
        private List<String> attributes;
        @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
        private File file;
        @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
        private Integer gzip;
        @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro|leaflet)", converter=ParameterConverters.DataFormatConverter.class)
        private Enumeration.Value outputFormat;
        @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header", required=false)
        private boolean noHeader;
        @Parameter(names={"-m", "--max-features"}, description="Maximum number of features to return. default: Unlimited")
        private Integer maxFeatures;
        @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
        private Map<String, String> hints;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;

        @Override
        public boolean noRemote() {
            return this.noRemote;
        }

        @Override
        @TraitSetter
        public void noRemote_$eq(boolean x$1) {
            this.noRemote = x$1;
        }

        @Override
        public boolean secure() {
            return this.secure;
        }

        @Override
        @TraitSetter
        public void secure_$eq(boolean x$1) {
            this.secure = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        @TraitSetter
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        public String zookeepers() {
            return this.zookeepers;
        }

        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        public Tuple2<Date, Date> interval() {
            return this.interval;
        }

        public void interval_$eq(Tuple2<Date, Date> x$1) {
            this.interval = x$1;
        }

        public String dtg() {
            return this.dtg;
        }

        public void dtg_$eq(String x$1) {
            this.dtg = x$1;
        }

        public Duration window() {
            return this.window;
        }

        public void window_$eq(Duration x$1) {
            this.window = x$1;
        }

        public Float rate() {
            return this.rate;
        }

        public void rate_$eq(Float x$1) {
            this.rate = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public List<String> attributes() {
            return this.attributes;
        }

        public void attributes_$eq(List<String> x$1) {
            this.attributes = x$1;
        }

        public File file() {
            return this.file;
        }

        public void file_$eq(File x$1) {
            this.file = x$1;
        }

        public Integer gzip() {
            return this.gzip;
        }

        public void gzip_$eq(Integer x$1) {
            this.gzip = x$1;
        }

        public Enumeration.Value outputFormat() {
            return this.outputFormat;
        }

        public void outputFormat_$eq(Enumeration.Value x$1) {
            this.outputFormat = x$1;
        }

        public boolean noHeader() {
            return this.noHeader;
        }

        public void noHeader_$eq(boolean x$1) {
            this.noHeader = x$1;
        }

        public Integer maxFeatures() {
            return this.maxFeatures;
        }

        public void maxFeatures_$eq(Integer x$1) {
            this.maxFeatures = x$1;
        }

        public Map<String, String> hints() {
            return this.hints;
        }

        public void hints_$eq(Map<String, String> x$1) {
            this.hints = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public HBasePlaybackParams() {
            OptionalCqlFilterParam.class.$init$((OptionalCqlFilterParam)this);
            QueryHintsParams.class.$init$((QueryHintsParams)this);
            FileExportParams.class.$init$((FileExportParams)this);
            ExportParams.class.$init$((ExportParams)this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            PlaybackCommand.PlaybackParams.class.$init$((PlaybackCommand.PlaybackParams)this);
            CatalogParam.class.$init$((CatalogParam)this);
            OptionalZookeepersParam.class.$init$((OptionalZookeepersParam)this);
            HBaseDataStoreCommand$HBaseParams$class.$init$(this);
            HBaseDataStoreCommand$ToggleRemoteFilterParam$class.$init$(this);
        }
    }
}

