/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.filter;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Date;
import org.locationtech.geomesa.arrow.filter.ArrowFilterOptimizer;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.filter.expression.AttributeExpression;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.temporal.During;
import org.opengis.temporal.Period;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class ArrowFilterOptimizer$
implements LazyLogging {
    public static final ArrowFilterOptimizer$ MODULE$;
    private final FilterFactory2 ff;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ArrowFilterOptimizer$();
    }

    private Logger logger$lzycompute() {
        ArrowFilterOptimizer$ arrowFilterOptimizer$ = this;
        synchronized (arrowFilterOptimizer$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private FilterFactory2 ff() {
        return this.ff;
    }

    public Filter rewrite(Filter filter, SimpleFeatureType sft, Map<String, ArrowDictionary> dictionaries2) {
        Filter bound = FastFilterFactory$.MODULE$.optimize(sft, filter);
        FastFilterFactory$.MODULE$.sfts().set(sft);
        try {
            return this.org$locationtech$geomesa$arrow$filter$ArrowFilterOptimizer$$rewriteFilter(bound, sft, dictionaries2);
        }
        finally {
            FastFilterFactory$.MODULE$.sfts().remove();
        }
    }

    public Filter org$locationtech$geomesa$arrow$filter$ArrowFilterOptimizer$$rewriteFilter(Filter filter, SimpleFeatureType sft, Map<String, ArrowDictionary> dictionaries2) {
        Filter filter2;
        try {
            Filter filter3;
            Filter filter4 = filter;
            if (filter4 instanceof BBOX) {
                BBOX bBOX = (BBOX)filter4;
                filter3 = this.rewriteBBox(bBOX, sft);
            } else if (filter4 instanceof During) {
                During during = (During)filter4;
                filter3 = this.rewriteDuring(during, sft);
            } else if (filter4 instanceof PropertyIsBetween) {
                PropertyIsBetween propertyIsBetween = (PropertyIsBetween)filter4;
                filter3 = this.rewriteBetween(propertyIsBetween, sft);
            } else if (filter4 instanceof PropertyIsEqualTo) {
                PropertyIsEqualTo propertyIsEqualTo = (PropertyIsEqualTo)filter4;
                filter3 = this.rewritePropertyIsEqualTo(propertyIsEqualTo, sft, dictionaries2);
            } else if (filter4 instanceof And) {
                And and = (And)filter4;
                filter3 = this.ff().and(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(and.getChildren()).map((Function1)new Serializable(sft, dictionaries2){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeatureType sft$1;
                    private final Map dictionaries$1;

                    public final Filter apply(Filter x$1) {
                        return ArrowFilterOptimizer$.MODULE$.org$locationtech$geomesa$arrow$filter$ArrowFilterOptimizer$$rewriteFilter(x$1, this.sft$1, (Map<String, ArrowDictionary>)this.dictionaries$1);
                    }
                    {
                        this.sft$1 = sft$1;
                        this.dictionaries$1 = dictionaries$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom())));
            } else if (filter4 instanceof Or) {
                Or or = (Or)filter4;
                filter3 = this.ff().or(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(or.getChildren()).map((Function1)new Serializable(sft, dictionaries2){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeatureType sft$1;
                    private final Map dictionaries$1;

                    public final Filter apply(Filter x$2) {
                        return ArrowFilterOptimizer$.MODULE$.org$locationtech$geomesa$arrow$filter$ArrowFilterOptimizer$$rewriteFilter(x$2, this.sft$1, (Map<String, ArrowDictionary>)this.dictionaries$1);
                    }
                    {
                        this.sft$1 = sft$1;
                        this.dictionaries$1 = dictionaries$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom())));
            } else if (filter4 instanceof Not) {
                Not not = (Not)filter4;
                filter3 = this.ff().not(this.org$locationtech$geomesa$arrow$filter$ArrowFilterOptimizer$$rewriteFilter(not.getFilter(), sft, dictionaries2));
            } else {
                filter3 = filter;
            }
            filter2 = filter3;
        }
        catch (Throwable throwable) {
            Filter filter5;
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error re-writing filter ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filter})), e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            filter2 = filter5 = filter;
        }
        return filter2;
    }

    private Filter rewriteBBox(BBOX filter, SimpleFeatureType sft) {
        Object object;
        if (RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)) || RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isLines$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))) {
            AttributeExpression props = package$.MODULE$.checkOrderUnsafe(filter.getExpression1(), filter.getExpression2());
            Envelope bbox = ((Polygon)props.literal().evaluate(null)).getEnvelopeInternal();
            int attrIndex = sft.indexOf(props.name());
            object = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)) ? new ArrowFilterOptimizer.ArrowPointBBox(attrIndex, bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY()) : new ArrowFilterOptimizer.ArrowLineStringBBox(attrIndex, bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY());
        } else {
            object = filter;
        }
        return object;
    }

    private Filter rewriteDuring(During filter, SimpleFeatureType sft) {
        AttributeExpression props = package$.MODULE$.checkOrderUnsafe(filter.getExpression1(), filter.getExpression2());
        int attrIndex = sft.indexOf(props.name());
        Period period = (Period)props.literal().evaluate(null, Period.class);
        long lower = period.getBeginning().getPosition().getDate().getTime();
        long upper = period.getEnding().getPosition().getDate().getTime();
        return new ArrowFilterOptimizer.ArrowDuring(attrIndex, lower, upper);
    }

    private Filter rewriteBetween(PropertyIsBetween filter, SimpleFeatureType sft) {
        Object object;
        String attribute2 = ((PropertyName)filter.getExpression()).getPropertyName();
        int attrIndex = sft.indexOf(attribute2);
        Class clazz = sft.getDescriptor(attrIndex).getType().getBinding();
        Class<Date> clazz2 = Date.class;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            long lower = ((Date)filter.getLowerBoundary().evaluate(null, Date.class)).getTime();
            long upper = ((Date)filter.getUpperBoundary().evaluate(null, Date.class)).getTime();
            object = new ArrowFilterOptimizer.ArrowBetweenDate(attrIndex, lower, upper);
        } else {
            object = filter;
        }
        return object;
    }

    private Filter rewritePropertyIsEqualTo(PropertyIsEqualTo filter, SimpleFeatureType sft, Map<String, ArrowDictionary> dictionaries2) {
        Option option;
        block4: {
            Object object;
            block3: {
                AttributeExpression props;
                block2: {
                    props = package$.MODULE$.checkOrderUnsafe(filter.getExpression1(), filter.getExpression2());
                    option = dictionaries2.get((Object)props.name());
                    if (!None$.MODULE$.equals(option)) break block2;
                    object = filter;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                ArrowDictionary dictionary = (ArrowDictionary)some.x();
                int attrIndex = sft.indexOf(props.name());
                int numericValue = dictionary.index(props.literal().evaluate(null));
                object = new ArrowFilterOptimizer.ArrowDictionaryEquals(attrIndex, numericValue);
            }
            return object;
        }
        throw new MatchError((Object)option);
    }

    private ArrowFilterOptimizer$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.ff = FastFilterFactory$.MODULE$.factory();
    }
}

