/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.jobs;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat2;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.geotools.data.DataStoreFinder;
import org.locationtech.geomesa.hbase.data.HBaseConnectionPool$;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.jobs.HBaseIndexFileMapper;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.partition.TablePartition$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;

public final class HBaseIndexFileMapper$ {
    public static final HBaseIndexFileMapper$ MODULE$;

    static {
        new HBaseIndexFileMapper$();
    }

    /*
     * WARNING - void declaration
     */
    public void configure(Job job, Map<String, String> params, String typeName, String index, Path output) {
        HBaseDataStore ds = (HBaseDataStore)DataStoreFinder.getDataStore((java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap(params));
        Predef$.MODULE$.require(ds != null, (Function0)new Serializable(params){
            public static final long serialVersionUID = 0L;
            private final Map params$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find data store with provided parameters ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params$1.mkString(",")}));
            }
            {
                this.params$1 = params$1;
            }
        });
        try {
            SimpleFeatureType sft = ds.getSchema(typeName);
            Predef$.MODULE$.require(sft != null, (Function0)new Serializable(typeName){
                public static final long serialVersionUID = 0L;
                private final String typeName$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema ", " does not exist, please create it first"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.typeName$1}));
                }
                {
                    this.typeName$1 = typeName$1;
                }
            });
            Predef$.MODULE$.require(!TablePartition$.MODULE$.partitioned(sft), (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Writing to partitioned tables is not currently supported";
                }
            });
            GeoMesaFeatureIndex idx = ds.manager().index(index);
            TableName tableName = TableName.valueOf((String)((String)idx.getTableNames(sft, (GeoMesaDataStore)ds, (Option)None$.MODULE$).head()));
            Table table = ds.connection().getTable(tableName);
            GeoMesaConfigurator$.MODULE$.setDataStoreOutParams(job.getConfiguration(), params);
            GeoMesaConfigurator$.MODULE$.setFeatureTypeOut(job.getConfiguration(), typeName);
            GeoMesaConfigurator$.MODULE$.setIndicesOut(job.getConfiguration(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeoMesaFeatureIndex[]{idx})));
            FileOutputFormat.setOutputPath((Job)job, (Path)output);
            job.getConfiguration().set("hbase.fs.tmp.dir", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/hbase-staging"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{System.getProperty("java.io.tmpdir")})));
            job.getConfiguration().set("hbase.bulkload.locality.sensitive.enabled", "false");
            job.setMapperClass(HBaseIndexFileMapper.class);
            job.setMapOutputKeyClass(ImmutableBytesWritable.class);
            job.setMapOutputValueClass(Put.class);
            HBaseConfiguration.merge((Configuration)job.getConfiguration(), (Configuration)HBaseConfiguration.create((Configuration)job.getConfiguration()));
            HBaseConnectionPool$.MODULE$.configureSecurity(job.getConfiguration());
            String libjars = job.getConfiguration().get("tmpjars");
            HFileOutputFormat2.configureIncrementalLoad((Job)job, (Table)table, (RegionLocator)ds.connection().getRegionLocator(tableName));
            job.getConfiguration().set("tmpjars", libjars);
        }
        catch (Throwable throwable) {
            void var6_6;
            var6_6.dispose();
            throw throwable;
        }
        ds.dispose();
    }

    private HBaseIndexFileMapper$() {
        MODULE$ = this;
    }
}

