/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.bigtable.spark;

import com.google.bigtable.v2.RowSet;
import com.google.cloud.bigtable.hbase.BigtableExtendedScan;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.locationtech.geomesa.bigtable.spark.BigtableExtendedScanSplit;
import org.locationtech.geomesa.bigtable.spark.BigtableTableRecordReader;

public abstract class BigtableInputFormatBase
extends InputFormat<ImmutableBytesWritable, Result> {
    private static final Log LOG = LogFactory.getLog(BigtableInputFormatBase.class);
    private List<Scan> scans;
    private TableName name;
    private BigtableTableRecordReader tableRecordReader = null;

    public void setName(TableName name) {
        this.name = name;
    }

    public RecordReader<ImmutableBytesWritable, Result> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        BigtableExtendedScanSplit tSplit = (BigtableExtendedScanSplit)split;
        LOG.info((Object)MessageFormat.format("Input split length: {0} bytes.", tSplit.getLength()));
        if (tSplit.name == null) {
            throw new IOException("Cannot create a record reader because of a previous error. Please look at the previous logs lines from the task's full log for more details.");
        }
        final Connection connection = ConnectionFactory.createConnection((Configuration)context.getConfiguration());
        Table table = connection.getTable(tSplit.name);
        if (this.tableRecordReader == null) {
            this.tableRecordReader = new BigtableTableRecordReader();
        }
        final BigtableTableRecordReader trr = this.tableRecordReader;
        BigtableExtendedScan sc = tSplit.scan;
        trr.setHTable(table);
        trr.setScan(sc);
        return new RecordReader<ImmutableBytesWritable, Result>(){

            public void close() throws IOException {
                trr.close();
                connection.close();
            }

            public ImmutableBytesWritable getCurrentKey() throws IOException, InterruptedException {
                return trr.getCurrentKey();
            }

            public Result getCurrentValue() throws IOException, InterruptedException {
                return trr.getCurrentValue();
            }

            public float getProgress() throws IOException, InterruptedException {
                return trr.getProgress();
            }

            public void initialize(InputSplit inputsplit, TaskAttemptContext context) throws IOException, InterruptedException {
                trr.initialize(inputsplit, context);
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                return trr.nextKeyValue();
            }
        };
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException {
        if (this.scans.isEmpty()) {
            throw new IOException("No scans were provided.");
        }
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        int count = 0;
        for (Scan s : this.scans) {
            BigtableExtendedScan scan = (BigtableExtendedScan)s;
            BigtableExtendedScanSplit split = new BigtableExtendedScanSplit(this.name, scan);
            splits.add(split);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("getSplits: split -> " + count++ + " -> " + split));
        }
        return splits;
    }

    protected List<Scan> getScans() {
        return this.scans;
    }

    protected void setScans(List<Scan> scans) {
        this.scans = scans;
    }

    protected void setTableRecordReader(BigtableTableRecordReader tableRecordReader) {
        this.tableRecordReader = tableRecordReader;
    }

    public static String scanToString(BigtableExtendedScan scan) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] table = scan.getAttribute("scan.attributes.table.name");
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeInt(table.length);
        dos.write(table);
        scan.getRowSet().writeTo((OutputStream)dos);
        dos.flush();
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }

    public static BigtableExtendedScan stringToScan(String encoded) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(encoded)));
        int tableLength = dis.readInt();
        byte[] table = new byte[tableLength];
        dis.read(table, 0, tableLength);
        int available = dis.available();
        byte[] rowsetbytes = new byte[available];
        dis.readFully(rowsetbytes);
        RowSet rs = RowSet.parseFrom((byte[])rowsetbytes);
        BigtableExtendedScan scan = new BigtableExtendedScan();
        rs.getRowRangesList().forEach(arg_0 -> ((BigtableExtendedScan)scan).addRange(arg_0));
        scan.setAttribute("scan.attributes.table.name", table);
        return scan;
    }
}

