/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.commons;

import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTWriter;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.temporal.Period;

public class ExpressionToText
implements ExpressionVisitor {
    static final Logger LOGGER = Logging.getLogger(ExpressionToText.class);
    boolean encodeEWKT;
    private static final Pattern SIMPLE_IDENTIFIER = Pattern.compile("[a-zA-Z][_a-zA-Z0-9]*");
    private static final Set<String> RESERVED_WORDS;

    public ExpressionToText() {
        this(ECQL.isEwktEncodingEnabled());
    }

    public ExpressionToText(boolean encodeEWKT) {
        this.encodeEWKT = encodeEWKT;
    }

    private static StringBuilder asStringBuilder(Object extraData) {
        if (extraData instanceof StringBuilder) {
            return (StringBuilder)extraData;
        }
        return new StringBuilder();
    }

    public StringBuilder dateToText(Date date, StringBuilder output) {
        SimpleDateFormat formatter = date.getTime() % 1000L == 0L ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSz");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
        String text = formatter.format(date);
        text = text.replace("GMT", "");
        output.append(text);
        return output;
    }

    public Object visit(NilExpression expression, Object extraData) {
        StringBuilder output = ExpressionToText.asStringBuilder(extraData);
        output.append("\"\"");
        return output;
    }

    public Object visit(Add expression, Object extraData) {
        StringBuilder output = ExpressionToText.asStringBuilder(extraData);
        expression.getExpression1().accept((ExpressionVisitor)this, (Object)output);
        output.append(" + ");
        expression.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        return output;
    }

    public Object visit(Divide expression, Object extraData) {
        StringBuilder output = ExpressionToText.asStringBuilder(extraData);
        expression.getExpression1().accept((ExpressionVisitor)this, (Object)output);
        output.append(" / ");
        expression.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        return output;
    }

    public Object visit(Function function, Object extraData) {
        StringBuilder output = ExpressionToText.asStringBuilder(extraData);
        output.append(function.getName());
        output.append("(");
        List parameters = function.getParameters();
        if (parameters != null) {
            Iterator i = parameters.iterator();
            while (i.hasNext()) {
                Expression argument = (Expression)i.next();
                argument.accept((ExpressionVisitor)this, (Object)output);
                if (!i.hasNext()) continue;
                output.append(",");
            }
        }
        output.append(")");
        return output;
    }

    public Object visit(Literal expression, Object extraData) {
        StringBuilder output = ExpressionToText.asStringBuilder(extraData);
        Object literal = expression.getValue();
        if (literal instanceof Geometry) {
            Geometry geometry = (Geometry)literal;
            if (geometry.getUserData() instanceof CoordinateReferenceSystem && this.encodeEWKT) {
                CoordinateReferenceSystem crs = (CoordinateReferenceSystem)geometry.getUserData();
                try {
                    Integer code = CRS.lookupEpsgCode(crs, false);
                    if (code != null) {
                        output.append("SRID=").append(code).append(";");
                    }
                }
                catch (FactoryException e) {
                    LOGGER.log(Level.FINE, "Error while trying to get SRID for geometry, will not encode it", e);
                }
            }
            WKTWriter writer = new WKTWriter();
            String wkt = writer.write(geometry);
            output.append(wkt);
        } else if (literal instanceof Number) {
            output.append(literal);
        } else {
            if (literal instanceof Date) {
                return this.dateToText((Date)literal, output);
            }
            if (literal instanceof Period) {
                Period period = (Period)literal;
                output = this.dateToText(period.getBeginning().getPosition().getDate(), output);
                output.append("/");
                output = this.dateToText(period.getEnding().getPosition().getDate(), output);
                return output;
            }
            if (literal instanceof Color) {
                Color color = (Color)literal;
                String redCode = Integer.toHexString(color.getRed());
                String greenCode = Integer.toHexString(color.getGreen());
                String blueCode = Integer.toHexString(color.getBlue());
                output.append("'#");
                if (redCode.length() == 1) {
                    output.append("0");
                }
                output.append(redCode.toUpperCase());
                if (greenCode.length() == 1) {
                    output.append("0");
                }
                output.append(greenCode.toUpperCase());
                if (blueCode.length() == 1) {
                    output.append("0");
                }
                output.append(blueCode.toUpperCase());
                output.append("'");
            } else if (literal instanceof Boolean) {
                output.append(literal);
            } else {
                String escaped = literal.toString().replaceAll("'", "''");
                output.append("'" + escaped + "'");
            }
        }
        return output;
    }

    public Object visit(Multiply expression, Object extraData) {
        StringBuilder output = ExpressionToText.asStringBuilder(extraData);
        expression.getExpression1().accept((ExpressionVisitor)this, (Object)output);
        output.append(" * ");
        expression.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        return output;
    }

    public Object visit(PropertyName expression, Object extraData) {
        StringBuilder output = ExpressionToText.asStringBuilder(extraData);
        if (this.propertyNeedsDelimiters(expression)) {
            output.append('\"');
            output.append(expression.getPropertyName().replace("\"", "\"\""));
            output.append('\"');
        } else {
            output.append(expression.getPropertyName());
        }
        return output;
    }

    protected boolean propertyNeedsDelimiters(PropertyName name) {
        if (!SIMPLE_IDENTIFIER.matcher(name.getPropertyName()).matches()) {
            return true;
        }
        return RESERVED_WORDS.contains(name.getPropertyName());
    }

    public Object visit(Subtract expression, Object extraData) {
        StringBuilder output = ExpressionToText.asStringBuilder(extraData);
        expression.getExpression1().accept((ExpressionVisitor)this, (Object)output);
        output.append(" - ");
        expression.getExpression2().accept((ExpressionVisitor)this, (Object)output);
        return output;
    }

    static {
        TreeSet<String> reservedWords = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        reservedWords.addAll(Arrays.asList("NOT", "AND", "OR", "LIKE", "IS", "NULL", "EXISTS", "DOES-NOT-EXIST", "DURING", "AFTER", "BEFORE", "ID", "IN", "INCLUDE", "EXCLUDE", "TRUE", "FALSE", "EQUALS", "DISJOINT", "INTERSECTS", "TOUCHES", "CROSSES", "WITHIN", "CONTAINS", "OVERLAPS", "RELATE", "DWITHIN", "BEYOND", "POINT", "LINESTRING", "POLYGON", "MULTIPOINT", "MULTILINESTRING", "MULTIPOLYGON", "GEOMETRYCOLLECTION"));
        RESERVED_WORDS = Collections.unmodifiableSet(reservedWords);
    }
}

