/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.apache.hadoop.fs.Path;
import org.geotools.data.Query;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.AbstractFileSystemStorage$;
import org.locationtech.geomesa.fs.storage.common.FileSystemThreadedReader$;
import org.locationtech.geomesa.fs.storage.common.observer.FileSystemObserver;
import org.locationtech.geomesa.fs.storage.common.observer.FileSystemObserverFactory;
import org.locationtech.geomesa.fs.storage.common.package$;
import org.locationtech.geomesa.fs.storage.common.package$RichSimpleFeatureType$;
import org.locationtech.geomesa.fs.storage.common.utils.PathCache$;
import org.locationtech.geomesa.fs.storage.common.utils.StorageUtils$;
import org.locationtech.geomesa.fs.storage.common.utils.StorageUtils$FileType$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.planning.QueryRunner$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.io.CloseQuietly$;
import org.locationtech.geomesa.utils.io.FlushQuietly$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r\rc!B\u0001\u0003\u0003\u0003y!!G!cgR\u0014\u0018m\u0019;GS2,7+_:uK6\u001cFo\u001c:bO\u0016T!a\u0001\u0003\u0002\r\r|W.\\8o\u0015\t)a!A\u0004ti>\u0014\u0018mZ3\u000b\u0005\u001dA\u0011A\u00014t\u0015\tI!\"A\u0004hK>lWm]1\u000b\u0005-a\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001b\u0003\b\u0013\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t9\"$D\u0001\u0019\u0015\tIB!A\u0002ba&L!a\u0007\r\u0003#\u0019KG.Z*zgR,Wn\u0015;pe\u0006<W\r\u0005\u0002\u001eE5\taD\u0003\u0002 A\u0005)1\u000f^1ug*\u0011\u0011\u0005C\u0001\u0006kRLGn]\u0005\u0003Gy\u0011q\"T3uQ>$\u0007K]8gS2Lgn\u001a\t\u0003K1j\u0011A\n\u0006\u0003O!\nAb]2bY\u0006dwnZ4j]\u001eT!!\u000b\u0016\u0002\u0011QL\b/Z:bM\u0016T\u0011aK\u0001\u0004G>l\u0017BA\u0017'\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u0011=\u0002!Q1A\u0005\u0002A\nqaY8oi\u0016DH/F\u00012!\t\u0011DI\u0004\u00024\u0005:\u0011A'\u0011\b\u0003k\u0001s!AN \u000f\u0005]rdB\u0001\u001d>\u001d\tID(D\u0001;\u0015\tYd\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA\r\u0005\u0013\t\u0019\u0005$A\u0004qC\u000e\\\u0017mZ3\n\u0005\u00153%!\u0005$jY\u0016\u001c\u0016p\u001d;f[\u000e{g\u000e^3yi*\u00111\t\u0007\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005c\u0005A1m\u001c8uKb$\b\u0005\u0003\u0005K\u0001\t\u0015\r\u0011\"\u0001L\u0003!iW\r^1eCR\fW#\u0001'\u0011\u0005]i\u0015B\u0001(\u0019\u0005=\u0019Fo\u001c:bO\u0016lU\r^1eCR\f\u0007\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\u0002\u00135,G/\u00193bi\u0006\u0004\u0003\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011B*\u0002\u0013\u0015DH/\u001a8tS>t\u0007C\u0001+X\u001d\t\tR+\u0003\u0002W%\u00051\u0001K]3eK\u001aL!\u0001W-\u0003\rM#(/\u001b8h\u0015\t1&\u0003C\u0003\\\u0001\u0011\u0005A,\u0001\u0004=S:LGO\u0010\u000b\u0005;~\u0003\u0017\r\u0005\u0002_\u00015\t!\u0001C\u000305\u0002\u0007\u0011\u0007C\u0003K5\u0002\u0007A\nC\u0003S5\u0002\u00071\u000b\u0003\u0005d\u0001!\u0015\r\u0011\"\u0003e\u0003%y'm]3sm\u0016\u00148/F\u0001f!\r1\u0017n[\u0007\u0002O*\u0011\u0001NE\u0001\u000bG>dG.Z2uS>t\u0017B\u00016h\u0005\r\u0019V-\u001d\t\u0003Y>l\u0011!\u001c\u0006\u0003]\n\t\u0001b\u001c2tKJ4XM]\u0005\u0003a6\u0014\u0011DR5mKNK8\u000f^3n\u001f\n\u001cXM\u001d<fe\u001a\u000b7\r^8ss\"A!\u000f\u0001E\u0001B\u0003&Q-\u0001\u0006pEN,'O^3sg\u0002BQ\u0001\u001e\u0001\u0007\u0012U\fAb\u0019:fCR,wK]5uKJ$BA^?\u0002\u0012A\u0011qO\u001f\b\u0003gaL!!\u001f\r\u0002#\u0019KG.Z*zgR,Wn\u0015;pe\u0006<W-\u0003\u0002|y\n\u0001b)\u001b7f'f\u001cH/Z7Xe&$XM\u001d\u0006\u0003sbAQA`:A\u0002}\fAAZ5mKB!\u0011\u0011AA\u0007\u001b\t\t\u0019AC\u0002\b\u0003\u000bQA!a\u0002\u0002\n\u00051\u0001.\u00193p_BT1!a\u0003\r\u0003\u0019\t\u0007/Y2iK&!\u0011qBA\u0002\u0005\u0011\u0001\u0016\r\u001e5\t\r9\u001c\b\u0019AA\n!\ra\u0017QC\u0005\u0004\u0003/i'A\u0005$jY\u0016\u001c\u0016p\u001d;f[>\u00137/\u001a:wKJDq!a\u0007\u0001\r#\ti\"\u0001\u0007de\u0016\fG/\u001a*fC\u0012,'\u000f\u0006\u0004\u0002 \u0005]\u00171\u001e\t\u0005\u0003C\t)D\u0004\u0003\u0002$\u0005\u001dbb\u0001\u001b\u0002&%\u00111\u0001B\u0004\b\u0003S\u0011\u0001\u0012AA\u0016\u0003e\t%m\u001d;sC\u000e$h)\u001b7f'f\u001cH/Z7Ti>\u0014\u0018mZ3\u0011\u0007y\u000biC\u0002\u0004\u0002\u0005!\u0005\u0011qF\n\u0004\u0003[\u0001\u0002bB.\u0002.\u0011\u0005\u00111\u0007\u000b\u0003\u0003W1!\"a\u000e\u0002.A\u0005\u0019\u0013AA\u001d\u0005Q1\u0015\u000e\\3TsN$X-\u001c)bi\"\u0014V-\u00193feN\u0019\u0011Q\u0007\t\t\u0011\u0005u\u0012Q\u0007D\u0001\u0003\u007f\tAA]3bIR!\u0011\u0011IA0!\u0019\t\u0019%a\u0012\u0002L5\u0011\u0011Q\t\u0006\u0003Q\u0002JA!!\u0013\u0002F\t\t2\t\\8tK\u0006\u0014G.Z%uKJ\fGo\u001c:\u0011\t\u00055\u00131L\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u000511/[7qY\u0016TA!!\u0016\u0002X\u00059a-Z1ukJ,'bAA-\u0019\u00059q\u000e]3oO&\u001c\u0018\u0002BA/\u0003\u001f\u0012QbU5na2,g)Z1ukJ,\u0007bBA1\u0003w\u0001\ra`\u0001\u0005a\u0006$\bN\u0002\u0005\u0002f\u00055\u0012\u0011AA4\u0005AiU\r^1eCR\fwJY:feZ,'o\u0005\u0004\u0002d\u0005%\u00141\u0003\t\u0005\u0003W\n)(\u0004\u0002\u0002n)!\u0011qNA9\u0003\u0011a\u0017M\\4\u000b\u0005\u0005M\u0014\u0001\u00026bm\u0006LA!a\u001e\u0002n\t1qJ\u00196fGRDqaWA2\t\u0003\tY\b\u0006\u0002\u0002~A!\u0011qPA2\u001b\t\ti\u0003\u0003\u0006\u0002\u0004\u0006\r\u0004\u0019!C\u0005\u0003\u000b\u000bQaY8v]R,\"!a\"\u0011\u0007E\tI)C\u0002\u0002\fJ\u0011A\u0001T8oO\"Q\u0011qRA2\u0001\u0004%I!!%\u0002\u0013\r|WO\u001c;`I\u0015\fH\u0003BAJ\u00033\u00032!EAK\u0013\r\t9J\u0005\u0002\u0005+:LG\u000f\u0003\u0006\u0002\u001c\u00065\u0015\u0011!a\u0001\u0003\u000f\u000b1\u0001\u001f\u00132\u0011%\ty*a\u0019!B\u0013\t9)\u0001\u0004d_VtG\u000f\t\u0005\u000b\u0003G\u000b\u0019G1A\u0005\n\u0005\u0015\u0016A\u00022pk:$7/\u0006\u0002\u0002(B!\u0011\u0011VAZ\u001b\t\tYK\u0003\u0003\u0002.\u0006=\u0016\u0001B4f_6T1!!-\u000b\u0003\rQGo]\u0005\u0005\u0003k\u000bYK\u0001\u0005F]Z,Gn\u001c9f\u0011%\tI,a\u0019!\u0002\u0013\t9+A\u0004c_VtGm\u001d\u0011\t\u0011\u0005u\u00161\rC!\u0003\u007f\u000bQa\u001e:ji\u0016$B!a%\u0002B\"A\u0011QKA^\u0001\u0004\tY\u0005\u0003\u0005\u0002F\u0006\rD\u0011IAd\u0003\u00151G.^:i)\t\t\u0019\n\u0003\u0005\u0002L\u0006\rD\u0011IAd\u0003\u0015\u0019Gn\\:f\u0011!\ty-a\u0019\u0007\u0012\u0005E\u0017aB8o\u00072|7/\u001a\u000b\u0007\u0003'\u000b\u0019.!6\t\u0011\u0005\r\u0016Q\u001aa\u0001\u0003OC\u0001\"a!\u0002N\u0002\u0007\u0011q\u0011\u0005\t\u00033\fI\u00021\u0001\u0002\\\u00061a-\u001b7uKJ\u0004R!EAo\u0003CL1!a8\u0013\u0005\u0019y\u0005\u000f^5p]B!\u00111]At\u001b\t\t)O\u0003\u0003\u0002Z\u0006]\u0013\u0002BAu\u0003K\u0014aAR5mi\u0016\u0014\b\u0002CAw\u00033\u0001\r!a<\u0002\u0013Q\u0014\u0018M\\:g_Jl\u0007#B\t\u0002^\u0006E\bCB\t\u0002tN\u000b90C\u0002\u0002vJ\u0011a\u0001V;qY\u0016\u0014\u0004\u0003BA'\u0003sLA!a?\u0002P\t\t2+[7qY\u00164U-\u0019;ve\u0016$\u0016\u0010]3\t\u000f\u0005}\b\u0001\"\u0011\u0003\u0002\u0005aq-\u001a;GS2,\u0007+\u0019;igR!!1\u0001B\u0010!\u0019\u0011)A!\u0004\u0003\u00129!!q\u0001B\u0006\u001d\rI$\u0011B\u0005\u0002'%\u00111IE\u0005\u0004U\n=!BA\"\u0013!\u0011\u0011\u0019B!\u0007\u000f\u0007M\u0012)\"C\u0002\u0003\u0018a\tqb\u0015;pe\u0006<W-T3uC\u0012\fG/Y\u0005\u0005\u00057\u0011iBA\bTi>\u0014\u0018mZ3GS2,\u0007+\u0019;i\u0015\r\u00119\u0002\u0007\u0005\b\u0005C\ti\u00101\u0001T\u0003%\u0001\u0018M\u001d;ji&|g\u000eC\u0004\u0003&\u0001!\tEa\n\u0002\u0013\u001d,GOU3bI\u0016\u0014H\u0003\u0003B\u0015\u0005_\u0011\u0019Ea\u0012\u0011\u0007I\u0012Y#C\u0002\u0003.\u0019\u0013\u0001d\u00117pg\u0016\f'\r\\3GK\u0006$XO]3Ji\u0016\u0014\u0018\r^8s\u0011!\u0011\tDa\tA\u0002\tM\u0012\u0001C8sS\u001eLg.\u00197\u0011\t\tU\"qH\u0007\u0003\u0005oQAA!\u000f\u0003<\u0005!A-\u0019;b\u0015\r\u0011i\u0004D\u0001\tO\u0016|Go\\8mg&!!\u0011\tB\u001c\u0005\u0015\tV/\u001a:z\u0011)\u0011\tCa\t\u0011\u0002\u0003\u0007!Q\t\t\u0005#\u0005u7\u000b\u0003\u0006\u0003J\t\r\u0002\u0013!a\u0001\u0005\u0017\nq\u0001\u001e5sK\u0006$7\u000fE\u0002\u0012\u0005\u001bJ1Aa\u0014\u0013\u0005\rIe\u000e\u001e\u0005\b\u0005'\u0002A\u0011\tB+\u0003%9W\r^,sSR,'\u000fF\u0002w\u0005/BqA!\t\u0003R\u0001\u00071\u000bC\u0004\u0003T\u0001!\tEa\u0017\u0015\u0011\tu#1\rB3\u0005O\u00022a\u001eB0\u0013\r\u0011\t\u0007 \u0002\u0017\r&dWmU=ti\u0016lW\u000b\u001d3bi\u0016<&/\u001b;fe\"A\u0011\u0011\u001cB-\u0001\u0004\t\t\u000f\u0003\u0006\u0003\"\te\u0003\u0013!a\u0001\u0005\u000bB!B!\u0013\u0003ZA\u0005\t\u0019\u0001B&\u0011\u001d\u0011Y\u0007\u0001C!\u0005[\nqaY8na\u0006\u001cG\u000f\u0006\u0004\u0002\u0014\n=$\u0011\u000f\u0005\t\u0005C\u0011I\u00071\u0001\u0003F!Q!\u0011\nB5!\u0003\u0005\rAa\u0013\t\rQ\u0004A\u0011\u0002B;)\u00151(q\u000fB=\u0011\u001d\u0011\tCa\u001dA\u0002MC\u0001Ba\u001f\u0003t\u0001\u0007!QP\u0001\u0007C\u000e$\u0018n\u001c8\u0011\t\t}$Q\u0011\b\u0005\u0005'\u0011\t)\u0003\u0003\u0003\u0004\nu\u0011!E*u_J\fw-\u001a$jY\u0016\f5\r^5p]&!!q\u0011BE\u0005E\u0019Fo\u001c:bO\u00164\u0015\u000e\\3BGRLwN\u001c\u0006\u0005\u0005\u0007\u0013iB\u0002\u0004\u0003\u000e\u0002\u0001!q\u0012\u0002\u001b\r&dWmU=ti\u0016lW\u000b\u001d3bi\u0016<&/\u001b;fe&k\u0007\u000f\\\n\u0006\u0005\u0017\u0003\"Q\f\u0005\f\u0005'\u0013YI!A!\u0002\u0013\u0011I#\u0001\u0004sK\u0006$WM\u001d\u0005\f\u0005/\u0013YI!A!\u0002\u0013\u0011)%A\u0007sK\u0006$\u0007+\u0019:uSRLwN\u001c\u0005\b7\n-E\u0011\u0001BN)\u0019\u0011iJ!)\u0003$B!!q\u0014BF\u001b\u0005\u0001\u0001\u0002\u0003BJ\u00053\u0003\rA!\u000b\t\u0011\t]%\u0011\u0014a\u0001\u0005\u000bB!Ba*\u0003\f\n\u0007I\u0011\u0002BU\u0003%iw\u000eZ5gS\u0016\u00148/\u0006\u0002\u0003,B1!Q\u0016BZ'Zl!Aa,\u000b\u0007\tEv-A\u0004nkR\f'\r\\3\n\t\tU&q\u0016\u0002\u0004\u001b\u0006\u0004\b\"\u0003B]\u0005\u0017\u0003\u000b\u0011\u0002BV\u0003)iw\u000eZ5gS\u0016\u00148\u000f\t\u0005\u000b\u0005{\u0013YI1A\u0005\n\t%\u0016\u0001\u00033fY\u0016$XM]:\t\u0013\t\u0005'1\u0012Q\u0001\n\t-\u0016!\u00033fY\u0016$XM]:!\u00111\t)Fa#A\u0002\u0003\u0007I\u0011\u0002Bc+\t\tY\u0005\u0003\u0007\u0003J\n-\u0005\u0019!a\u0001\n\u0013\u0011Y-A\u0006gK\u0006$XO]3`I\u0015\fH\u0003BAJ\u0005\u001bD!\"a'\u0003H\u0006\u0005\t\u0019AA&\u0011%\u0011\tNa#!B\u0013\tY%\u0001\u0005gK\u0006$XO]3!\u00111\u0011\tCa#A\u0002\u0003\u0007I\u0011\u0002Bk+\u0005\u0019\u0006\u0002\u0004Bm\u0005\u0017\u0003\r\u00111A\u0005\n\tm\u0017!\u00049beRLG/[8o?\u0012*\u0017\u000f\u0006\u0003\u0002\u0014\nu\u0007\"CAN\u0005/\f\t\u00111\u0001T\u0011!\u0011\tOa#!B\u0013\u0019\u0016A\u00039beRLG/[8oA!A\u0011Q\u0018BF\t\u0003\n9\r\u0003\u0005\u0003h\n-E\u0011IAd\u0003\u0019\u0011X-\\8wK\"A!1\u001eBF\t\u0003\u0012i/A\u0004iCNtU\r\u001f;\u0016\u0005\t=\bcA\t\u0003r&\u0019!1\u001f\n\u0003\u000f\t{w\u000e\\3b]\"A!q\u001fBF\t\u0003\u0012I0\u0001\u0003oKb$HCAA&\u0011!\t)Ma#\u0005B\u0005\u001d\u0007\u0002CAf\u0005\u0017#\t%a2\u0007\r\r\u0005\u0001\u0001AB\u0002\u00059)\u0006\u000fZ1uK>\u00137/\u001a:wKJ\u001cBAa@\u0004\u0006A!\u0011\u0011EA2\u0011)\u0011\tCa@\u0003\u0002\u0003\u0006Ia\u0015\u0005\n}\n}(\u0011!Q\u0001\n}D1Ba\u001f\u0003\u0000\n\u0005\t\u0015!\u0003\u0003~!91La@\u0005\u0002\r=A\u0003CB\t\u0007'\u0019)ba\u0006\u0011\t\t}%q \u0005\b\u0005C\u0019i\u00011\u0001T\u0011\u0019q8Q\u0002a\u0001\u007f\"A!1PB\u0007\u0001\u0004\u0011i\b\u0003\u0005\u0002P\n}H\u0011KB\u000e)\u0019\t\u0019j!\b\u0004 !A\u00111UB\r\u0001\u0004\t9\u000b\u0003\u0005\u0002\u0004\u000ee\u0001\u0019AAD\r\u0019\u0019\u0019\u0003\u0001\u0001\u0004&\ty1i\\7qC\u000e$xJY:feZ,'o\u0005\u0003\u0004\"\r\u0015\u0001B\u0003B\u0011\u0007C\u0011\t\u0011)A\u0005'\"Iap!\t\u0003\u0002\u0003\u0006Ia \u0005\f\u0007[\u0019\tC!A!\u0002\u0013\u0011\u0019!\u0001\u0005sKBd\u0017mY3e\u0011\u001dY6\u0011\u0005C\u0001\u0007c!\u0002ba\r\u00046\r]2\u0011\b\t\u0005\u0005?\u001b\t\u0003C\u0004\u0003\"\r=\u0002\u0019A*\t\ry\u001cy\u00031\u0001\u0000\u0011!\u0019ica\fA\u0002\t\r\u0001\u0002CAh\u0007C!\tf!\u0010\u0015\r\u0005M5qHB!\u0011!\t\u0019ka\u000fA\u0002\u0005\u001d\u0006\u0002CAB\u0007w\u0001\r!a\"")
public abstract class AbstractFileSystemStorage
implements FileSystemStorage,
MethodProfiling {
    private final package.FileSystemContext context;
    private final StorageMetadata metadata;
    public final String org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$extension;
    private Seq<FileSystemObserverFactory> org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers;
    private final Logger logger;
    private volatile byte bitmap$0;

    private Seq org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers$lzycompute() {
        AbstractFileSystemStorage abstractFileSystemStorage = this;
        synchronized (abstractFileSystemStorage) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Builder builder = Seq$.MODULE$.newBuilder();
                package$RichSimpleFeatureType$.MODULE$.getObservers$extension(package$.MODULE$.RichSimpleFeatureType(this.metadata().sft())).foreach((Function1)new Serializable(this, builder){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AbstractFileSystemStorage $outer;
                    private final Builder builder$1;

                    public final void apply(String c) {
                        try {
                            ClassLoader cl = (ClassLoader)Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final ClassLoader apply() {
                                    return ClassLoader.getSystemClassLoader();
                                }
                            });
                            FileSystemObserverFactory observer = (FileSystemObserverFactory)cl.loadClass(c).newInstance();
                            this.builder$1.$plus$eq((Object)observer);
                            observer.init(this.$outer.context().conf(), this.$outer.context().root(), this.$outer.metadata().sft());
                            return;
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (option.isEmpty()) {
                                throw throwable;
                            }
                            Throwable e = (Throwable)option.get();
                            CloseQuietly$.MODULE$.apply((Iterable)this.builder$1.result()).foreach((Function1)new Serializable(this, e){
                                public static final long serialVersionUID = 0L;
                                private final Throwable e$1;

                                public final void apply(Throwable x$1) {
                                    this.e$1.addSuppressed(x$1);
                                }
                                {
                                    this.e$1 = e$1;
                                }
                            });
                            throw e;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.builder$1 = builder$1;
                    }
                });
                this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers = (Seq)builder.result();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers;
        }
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        AbstractFileSystemStorage abstractFileSystemStorage = this;
        synchronized (abstractFileSystemStorage) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public Seq<StorageMetadata.PartitionMetadata> getPartitions() {
        return FileSystemStorage.class.getPartitions((FileSystemStorage)this);
    }

    public Seq<StorageMetadata.PartitionMetadata> getPartitions(Filter filter) {
        return FileSystemStorage.class.getPartitions((FileSystemStorage)this, (Filter)filter);
    }

    public Seq<package.PartitionFilter> getPartitionFilters(Filter filter, Option<String> partition) {
        return FileSystemStorage.class.getPartitionFilters((FileSystemStorage)this, (Filter)filter, partition);
    }

    public void close() {
        FileSystemStorage.class.close((FileSystemStorage)this);
    }

    public Option<String> getPartitionFilters$default$2() {
        return FileSystemStorage.class.getPartitionFilters$default$2((FileSystemStorage)this);
    }

    public Option<String> getReader$default$2() {
        return FileSystemStorage.class.getReader$default$2((FileSystemStorage)this);
    }

    public int getReader$default$3() {
        return FileSystemStorage.class.getReader$default$3((FileSystemStorage)this);
    }

    public Option<String> getWriter$default$2() {
        return FileSystemStorage.class.getWriter$default$2((FileSystemStorage)this);
    }

    public int getWriter$default$3() {
        return FileSystemStorage.class.getWriter$default$3((FileSystemStorage)this);
    }

    public int compact$default$2() {
        return package.Compactable.class.compact$default$2((package.Compactable)this);
    }

    public package.FileSystemContext context() {
        return this.context;
    }

    public StorageMetadata metadata() {
        return this.metadata;
    }

    public Seq<FileSystemObserverFactory> org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers$lzycompute() : this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers;
    }

    public abstract FileSystemStorage.FileSystemWriter createWriter(Path var1, FileSystemObserver var2);

    public abstract FileSystemPathReader createReader(Option<Filter> var1, Option<Tuple2<String, SimpleFeatureType>> var2);

    public Seq<StorageMetadata.StorageFilePath> getFilePaths(String partition) {
        Path baseDir = StorageUtils$.MODULE$.baseDirectory(this.context().root(), partition, this.metadata().leafStorage());
        Seq files = (Seq)this.metadata().getPartition(partition).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<StorageMetadata.StorageFile> apply(StorageMetadata.PartitionMetadata x$1) {
                return x$1.files();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
        return (Seq)files.flatMap((Function1)new Serializable(this, baseDir){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractFileSystemStorage $outer;
            private final Path baseDir$1;

            public final Seq<StorageMetadata.StorageFilePath> apply(StorageMetadata.StorageFile file) {
                Seq seq;
                Path path = new Path(this.baseDir$1, file.name());
                if (PathCache$.MODULE$.exists(this.$outer.context().fc(), path, PathCache$.MODULE$.exists$default$3())) {
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StorageMetadata.StorageFilePath[]{new StorageMetadata.StorageFilePath(file, path)}));
                } else {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn("Inconsistent metadata for {}: {}", new Object[]{this.$outer.metadata().sft().getTypeName(), path});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    seq = (Seq)Seq$.MODULE$.empty();
                }
                return seq;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.baseDir$1 = baseDir$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Iterator<SimpleFeature> getReader(Query original, Option<String> partition, int threads) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        Query query = QueryRunner$.MODULE$.configureDefaultQuery(this.metadata().sft(), original);
        Option transform = QueryHints$.MODULE$.RichHints(query.getHints()).getTransform();
        Filter filter = (Filter)Option$.MODULE$.apply((Object)query.getFilter()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final IncludeFilter apply() {
                return Filter.INCLUDE;
            }
        });
        Seq<package.PartitionFilter> filters = this.getPartitionFilters(filter, partition);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running query '{}' {}", (Object[])new String[]{query.getTypeName(), ECQL.toCQL((Filter)query.getFilter())});
            boxedUnit4 = BoxedUnit.UNIT;
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("  Original filter: {}", new Object[]{ECQL.toCQL((Filter)original.getFilter())});
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Transforms: "})).s((Seq)Nil$.MODULE$)).append(QueryHints$.MODULE$.RichHints(query.getHints()).getTransformDefinition().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String t) {
                    return t.isEmpty() ? "empty" : t;
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "none";
                }
            })).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Threading the read of ", " partitions with "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)filters.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(package.PartitionFilter x$2) {
                    return x$2.partitions().size();
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " reader threads"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)threads)}))).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Iterator readers = filters.iterator().flatMap((Function1)new Serializable(this, transform){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractFileSystemStorage $outer;
            private final Option transform$1;

            public final Iterator<Tuple2<FileSystemPathReader, Seq<StorageMetadata.StorageFilePath>>> apply(package.PartitionFilter fp) {
                ObjectRef reader$lzy = ObjectRef.zero();
                VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
                return fp.partitions().iterator().flatMap((Function1)new Serializable(this, reader$lzy, fp, bitmap$0){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    private final ObjectRef reader$lzy$1;
                    private final package.PartitionFilter fp$1;
                    private final VolatileByteRef bitmap$0$1;

                    public final Iterator<Tuple2<FileSystemPathReader, Seq<StorageMetadata.StorageFilePath>>> apply(String p) {
                        Seq<StorageMetadata.StorageFilePath> files = this.$outer.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$anonfun$$$outer().getFilePaths(p);
                        return files.isEmpty() ? scala.package$.MODULE$.Iterator().empty() : scala.package$.MODULE$.Iterator().single((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$anonfun$$reader$1(this.reader$lzy$1, this.fp$1, this.bitmap$0$1)), files));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.reader$lzy$1 = reader$lzy$1;
                        this.fp$1 = fp$1;
                        this.bitmap$0$1 = bitmap$0$1;
                    }
                });
            }

            public /* synthetic */ AbstractFileSystemStorage org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$anonfun$$$outer() {
                return this.$outer;
            }

            private final FileSystemPathReader reader$lzycompute$1(ObjectRef reader$lzy$1, package.PartitionFilter fp$1, VolatileByteRef bitmap$0$1) {
                $anonfun$5 var4_4 = this;
                synchronized (var4_4) {
                    if ((byte)(bitmap$0$1.elem & 1) == 0) {
                        BoxedUnit boxedUnit;
                        BoxedUnit boxedUnit2;
                        Option filter = Option$.MODULE$.apply((Object)fp$1.filter()).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Filter x$3) {
                                Filter filter = x$3;
                                IncludeFilter includeFilter = Filter.INCLUDE;
                                return filter != null ? !filter.equals(includeFilter) : includeFilter != null;
                            }
                        });
                        FileSystemPathReader reader2 = this.$outer.createReader((Option<Filter>)filter, (Option<Tuple2<String, SimpleFeatureType>>)this.transform$1);
                        if (this.$outer.logger().underlying().isDebugEnabled()) {
                            this.$outer.logger().underlying().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Reading ", " partitions with filter: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)fp$1.partitions().size())}))).append(filter.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(Filter x$1) {
                                    return ECQL.toCQL((Filter)x$1);
                                }
                            }).getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "INCLUDE";
                                }
                            })).toString());
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        if (this.$outer.logger().underlying().isTraceEnabled()) {
                            this.$outer.logger().underlying().trace(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Filter: ", " Partitions: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filter.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(Filter x$1) {
                                    return ECQL.toCQL((Filter)x$1);
                                }
                            }).getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "INCLUDE";
                                }
                            })}))).append((Object)fp$1.partitions().mkString(", ")).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        reader$lzy$1.elem = reader2;
                        bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
                    }
                    return (FileSystemPathReader)reader$lzy$1.elem;
                }
            }

            public final FileSystemPathReader org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$anonfun$$reader$1(ObjectRef reader$lzy$1, package.PartitionFilter fp$1, VolatileByteRef bitmap$0$1) {
                return (byte)(bitmap$0$1.elem & 1) == 0 ? this.reader$lzycompute$1(reader$lzy$1, fp$1, bitmap$0$1) : (FileSystemPathReader)reader$lzy$1.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.transform$1 = transform$1;
            }
        });
        return readers.isEmpty() ? CloseableIterator$.MODULE$.empty() : FileSystemThreadedReader$.MODULE$.apply((Iterator<Tuple2<FileSystemPathReader, Seq<StorageMetadata.StorageFilePath>>>)readers, threads);
    }

    public FileSystemStorage.FileSystemWriter getWriter(String partition) {
        return this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(partition, StorageMetadata.StorageFileAction$.MODULE$.Append());
    }

    public FileSystemStorage.FileSystemUpdateWriter getWriter(Filter filter, Option<String> partition, int threads) {
        Query query = new Query(this.metadata().sft().getTypeName(), filter);
        return new FileSystemUpdateWriterImpl(this, this.getReader(query, partition, threads), partition);
    }

    public void compact(Option<String> partition, int threads) {
        ((IterableLike)partition.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String x$4) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$4}));
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractFileSystemStorage $outer;

            public final Seq<String> apply() {
                return (Seq)this.$outer.metadata().getPartitions(this.$outer.metadata().getPartitions$default$1()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(StorageMetadata.PartitionMetadata x$5) {
                        return x$5.name();
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).foreach((Function1)new Serializable(this, threads){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractFileSystemStorage $outer;
            private final int threads$1;

            public final void apply(String partition) {
                Seq<StorageMetadata.StorageFilePath> toCompact = this.$outer.getFilePaths(partition);
                if (toCompact.lengthCompare(2) < 0) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug("Skipping compaction for single data file: {}", new Object[]{toCompact.mkString(", ")});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    BoxedUnit boxedUnit;
                    BoxedUnit boxedUnit2;
                    BoxedUnit boxedUnit3;
                    BoxedUnit boxedUnit4;
                    BoxedUnit boxedUnit5;
                    Path path = StorageUtils$.MODULE$.nextFile(this.$outer.context().root(), partition, this.$outer.metadata().leafStorage(), this.$outer.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$extension, StorageUtils$FileType$.MODULE$.Compacted());
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug("Compacting data files: [{}] to into file {}", new Object[]{toCompact.mkString(", "), path});
                        boxedUnit5 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit5 = BoxedUnit.UNIT;
                    }
                    LongRef written = LongRef.create((long)0L);
                    FileSystemPathReader reader2 = this.$outer.createReader((Option<Filter>)None$.MODULE$, (Option<Tuple2<String, SimpleFeatureType>>)None$.MODULE$);
                    CompactObserver compactObserver = new CompactObserver(this.$outer, partition, path, toCompact);
                    FileSystemObserver observer = this.$outer.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers().isEmpty() ? compactObserver : new FileSystemObserverFactory.CompositeObserver((Seq<FileSystemObserver>)((Seq)((SeqLike)this.$outer.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers().map((Function1)new Serializable(this, path){
                        public static final long serialVersionUID = 0L;
                        private final Path path$1;

                        public final FileSystemObserver apply(FileSystemObserverFactory x$6) {
                            return x$6.apply(this.path$1);
                        }
                        {
                            this.path$1 = path$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)compactObserver, Seq$.MODULE$.canBuildFrom())));
                    WithClose$.MODULE$.apply((Object)this.$outer.createWriter(path, observer), (Function0)new Serializable(this, toCompact, reader2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$compact$3 $outer;
                        private final Seq toCompact$1;
                        private final FileSystemPathReader reader$2;

                        public final CloseableIterator<SimpleFeature> apply() {
                            return this.$outer.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$anonfun$$threaded$1(this.toCompact$1, this.reader$2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.toCompact$1 = toCompact$1;
                            this.reader$2 = reader$2;
                        }
                    }, (Function2)new Serializable(this, written){
                        public static final long serialVersionUID = 0L;
                        private final LongRef written$1;

                        public final void apply(FileSystemStorage.FileSystemWriter x0$1, CloseableIterator<SimpleFeature> x1$1) {
                            Tuple2 tuple2 = new Tuple2((Object)x0$1, x1$1);
                            if (tuple2 != null) {
                                FileSystemStorage.FileSystemWriter writer = (FileSystemStorage.FileSystemWriter)tuple2._1();
                                CloseableIterator features = (CloseableIterator)tuple2._2();
                                while (features.hasNext()) {
                                    writer.write((SimpleFeature)features.next());
                                    ++this.written$1.elem;
                                }
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError((Object)tuple2);
                        }
                        {
                            this.written$1 = written$1;
                        }
                    });
                    PathCache$.MODULE$.register(this.$outer.context().fc(), path, PathCache$.MODULE$.register$default$3(), PathCache$.MODULE$.register$default$4());
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug("Wrote compacted file {}", new Object[]{path});
                        boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit4 = BoxedUnit.UNIT;
                    }
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug("Deleting old files [{}]", new Object[]{toCompact.mkString(", ")});
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    ListBuffer failures = (ListBuffer)ListBuffer$.MODULE$.empty();
                    toCompact.foreach((Function1)new Serializable(this, failures){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$compact$3 $outer;
                        private final ListBuffer failures$1;

                        public final void apply(StorageMetadata.StorageFilePath file) {
                            if (!this.$outer.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$anonfun$$$outer().context().fc().delete(file.path(), false)) {
                                this.failures$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{file.path()}));
                            }
                            PathCache$.MODULE$.invalidate(this.$outer.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$anonfun$$$outer().context().fc(), file.path());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.failures$1 = failures$1;
                        }
                    });
                    if (failures.nonEmpty()) {
                        if (this.$outer.logger().underlying().isErrorEnabled()) {
                            this.$outer.logger().underlying().error("Failed to delete some files: [{}]", new Object[]{failures.mkString(", ")});
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug("Compacted {} records into file {}", new Object[]{BoxesRunTime.boxToLong((long)written.elem), path});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }

            public /* synthetic */ AbstractFileSystemStorage org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$anonfun$$$outer() {
                return this.$outer;
            }

            public final CloseableIterator org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$anonfun$$threaded$1(Seq toCompact$1, FileSystemPathReader reader$2) {
                return FileSystemThreadedReader$.MODULE$.apply((Iterator<Tuple2<FileSystemPathReader, Seq<StorageMetadata.StorageFilePath>>>)scala.package$.MODULE$.Iterator().single((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)reader$2), (Object)toCompact$1)), this.threads$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.threads$1 = threads$1;
            }
        });
    }

    public FileSystemStorage.FileSystemWriter org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(String partition, Enumeration.Value action) {
        block5: {
            Enumeration.Value value;
            block3: {
                Enumeration.Value value2;
                block4: {
                    block2: {
                        value2 = action;
                        Enumeration.Value value3 = StorageMetadata.StorageFileAction$.MODULE$.Append();
                        Enumeration.Value value4 = value2;
                        if (value3 != null ? !value3.equals(value4) : value4 != null) break block2;
                        value = StorageUtils$FileType$.MODULE$.Written();
                        break block3;
                    }
                    Enumeration.Value value5 = StorageMetadata.StorageFileAction$.MODULE$.Modify();
                    Enumeration.Value value6 = value2;
                    if (value5 != null ? !value5.equals(value6) : value6 != null) break block4;
                    value = StorageUtils$FileType$.MODULE$.Modified();
                    break block3;
                }
                Enumeration.Value value7 = StorageMetadata.StorageFileAction$.MODULE$.Delete();
                Enumeration.Value value8 = value2;
                if (value7 != null ? !value7.equals(value8) : value8 != null) break block5;
                value = StorageUtils$FileType$.MODULE$.Deleted();
            }
            Enumeration.Value fileType = value;
            Path path = StorageUtils$.MODULE$.nextFile(this.context().root(), partition, this.metadata().leafStorage(), this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$extension, fileType);
            PathCache$.MODULE$.register(this.context().fc(), path, PathCache$.MODULE$.register$default$3(), PathCache$.MODULE$.register$default$4());
            UpdateObserver updateObserver = new UpdateObserver(this, partition, path, action);
            FileSystemObserver observer = this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers().isEmpty() ? updateObserver : new FileSystemObserverFactory.CompositeObserver((Seq<FileSystemObserver>)((Seq)((SeqLike)this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers().map((Function1)new Serializable(this, path){
                public static final long serialVersionUID = 0L;
                private final Path path$2;

                public final FileSystemObserver apply(FileSystemObserverFactory x$7) {
                    return x$7.apply(this.path$2);
                }
                {
                    this.path$2 = path$2;
                }
            }, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)updateObserver, Seq$.MODULE$.canBuildFrom())));
            return this.createWriter(path, observer);
        }
        throw new NotImplementedError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected storage action type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action})));
    }

    public AbstractFileSystemStorage(package.FileSystemContext context, StorageMetadata metadata, String extension2) {
        this.context = context;
        this.metadata = metadata;
        this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$extension = extension2;
        package.Compactable.class.$init$((package.Compactable)this);
        FileSystemStorage.class.$init$((FileSystemStorage)this);
        LazyLogging.class.$init$((LazyLogging)this);
        MethodProfiling.class.$init$((MethodProfiling)this);
    }

    public class UpdateObserver
    extends MetadataObserver {
        private final String partition;
        private final Path file;
        private final Enumeration.Value action;
        public final /* synthetic */ AbstractFileSystemStorage $outer;

        @Override
        public void onClose(Envelope bounds, long count) {
            Seq files = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StorageMetadata.StorageFile[]{new StorageMetadata.StorageFile(this.file.getName(), System.currentTimeMillis(), this.action)}));
            this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$UpdateObserver$$$outer().metadata().addPartition(new StorageMetadata.PartitionMetadata(this.partition, files, StorageMetadata.PartitionBounds$.MODULE$.apply(bounds), count));
        }

        public /* synthetic */ AbstractFileSystemStorage org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$UpdateObserver$$$outer() {
            return this.$outer;
        }

        public UpdateObserver(AbstractFileSystemStorage $outer, String partition, Path file, Enumeration.Value action) {
            this.partition = partition;
            this.file = file;
            this.action = action;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class CompactObserver
    extends MetadataObserver {
        private final String partition;
        private final Path file;
        private final Seq<StorageMetadata.StorageFilePath> replaced;
        public final /* synthetic */ AbstractFileSystemStorage $outer;

        @Override
        public void onClose(Envelope bounds, long count) {
            Option partitionBounds = StorageMetadata.PartitionBounds$.MODULE$.apply(bounds);
            this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$CompactObserver$$$outer().metadata().removePartition(new StorageMetadata.PartitionMetadata(this.partition, (Seq)this.replaced.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final StorageMetadata.StorageFile apply(StorageMetadata.StorageFilePath x$8) {
                    return x$8.file();
                }
            }, Seq$.MODULE$.canBuildFrom()), partitionBounds, count));
            Seq added = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StorageMetadata.StorageFile[]{new StorageMetadata.StorageFile(this.file.getName(), System.currentTimeMillis(), StorageMetadata.StorageFileAction$.MODULE$.Append())}));
            this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$CompactObserver$$$outer().metadata().addPartition(new StorageMetadata.PartitionMetadata(this.partition, added, partitionBounds, count));
        }

        public /* synthetic */ AbstractFileSystemStorage org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$CompactObserver$$$outer() {
            return this.$outer;
        }

        public CompactObserver(AbstractFileSystemStorage $outer, String partition, Path file, Seq<StorageMetadata.StorageFilePath> replaced) {
            this.partition = partition;
            this.file = file;
            this.replaced = replaced;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public static abstract class MetadataObserver
    implements FileSystemObserver {
        private long count = 0L;
        private final Envelope bounds = new Envelope();

        private long count() {
            return this.count;
        }

        private void count_$eq(long x$1) {
            this.count = x$1;
        }

        private Envelope bounds() {
            return this.bounds;
        }

        public void write(SimpleFeature feature) {
            this.count_$eq(this.count() + 1L);
            Geometry geom = (Geometry)feature.getDefaultGeometry();
            if (geom != null) {
                this.bounds().expandToInclude(geom.getEnvelopeInternal());
            }
        }

        public void flush() {
        }

        public void close() {
            this.onClose(this.bounds(), this.count());
        }

        public abstract void onClose(Envelope var1, long var2);
    }

    public static interface FileSystemPathReader {
        public CloseableIterator<SimpleFeature> read(Path var1);
    }

    public class FileSystemUpdateWriterImpl
    implements FileSystemStorage.FileSystemUpdateWriter {
        private final Iterator<SimpleFeature> reader;
        private final Option<String> readPartition;
        private final Map<String, FileSystemStorage.FileSystemWriter> modifiers;
        private final Map<String, FileSystemStorage.FileSystemWriter> deleters;
        private SimpleFeature org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$feature;
        private String org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$partition;
        public final /* synthetic */ AbstractFileSystemStorage $outer;

        public Iterator<SimpleFeature> seq() {
            return Iterator.class.seq((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.class.isEmpty((Iterator)this);
        }

        public boolean isTraversableAgain() {
            return Iterator.class.isTraversableAgain((Iterator)this);
        }

        public boolean hasDefiniteSize() {
            return Iterator.class.hasDefiniteSize((Iterator)this);
        }

        public Iterator<SimpleFeature> take(int n) {
            return Iterator.class.take((Iterator)this, (int)n);
        }

        public Iterator<SimpleFeature> drop(int n) {
            return Iterator.class.drop((Iterator)this, (int)n);
        }

        public Iterator<SimpleFeature> slice(int from2, int until) {
            return Iterator.class.slice((Iterator)this, (int)from2, (int)until);
        }

        public <B> Iterator<B> map(Function1<SimpleFeature, B> f) {
            return Iterator.class.map((Iterator)this, f);
        }

        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
            return Iterator.class.$plus$plus((Iterator)this, that);
        }

        public <B> Iterator<B> flatMap(Function1<SimpleFeature, GenTraversableOnce<B>> f) {
            return Iterator.class.flatMap((Iterator)this, f);
        }

        public Iterator<SimpleFeature> filter(Function1<SimpleFeature, Object> p) {
            return Iterator.class.filter((Iterator)this, p);
        }

        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<SimpleFeature, B, Object> p) {
            return Iterator.class.corresponds((Iterator)this, that, p);
        }

        public Iterator<SimpleFeature> withFilter(Function1<SimpleFeature, Object> p) {
            return Iterator.class.withFilter((Iterator)this, p);
        }

        public Iterator<SimpleFeature> filterNot(Function1<SimpleFeature, Object> p) {
            return Iterator.class.filterNot((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<SimpleFeature, B> pf) {
            return Iterator.class.collect((Iterator)this, pf);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, SimpleFeature, B> op) {
            return Iterator.class.scanLeft((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<SimpleFeature, B, B> op) {
            return Iterator.class.scanRight((Iterator)this, z, op);
        }

        public Iterator<SimpleFeature> takeWhile(Function1<SimpleFeature, Object> p) {
            return Iterator.class.takeWhile((Iterator)this, p);
        }

        public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> partition(Function1<SimpleFeature, Object> p) {
            return Iterator.class.partition((Iterator)this, p);
        }

        public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> span(Function1<SimpleFeature, Object> p) {
            return Iterator.class.span((Iterator)this, p);
        }

        public Iterator<SimpleFeature> dropWhile(Function1<SimpleFeature, Object> p) {
            return Iterator.class.dropWhile((Iterator)this, p);
        }

        public <B> Iterator<Tuple2<SimpleFeature, B>> zip(Iterator<B> that) {
            return Iterator.class.zip((Iterator)this, that);
        }

        public <A1> Iterator<A1> padTo(int len, A1 elem) {
            return Iterator.class.padTo((Iterator)this, (int)len, elem);
        }

        public Iterator<Tuple2<SimpleFeature, Object>> zipWithIndex() {
            return Iterator.class.zipWithIndex((Iterator)this);
        }

        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
            return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
        }

        public <U> void foreach(Function1<SimpleFeature, U> f) {
            Iterator.class.foreach((Iterator)this, f);
        }

        public boolean forall(Function1<SimpleFeature, Object> p) {
            return Iterator.class.forall((Iterator)this, p);
        }

        public boolean exists(Function1<SimpleFeature, Object> p) {
            return Iterator.class.exists((Iterator)this, p);
        }

        public boolean contains(Object elem) {
            return Iterator.class.contains((Iterator)this, (Object)elem);
        }

        public Option<SimpleFeature> find(Function1<SimpleFeature, Object> p) {
            return Iterator.class.find((Iterator)this, p);
        }

        public int indexWhere(Function1<SimpleFeature, Object> p) {
            return Iterator.class.indexWhere((Iterator)this, p);
        }

        public <B> int indexOf(B elem) {
            return Iterator.class.indexOf((Iterator)this, elem);
        }

        public BufferedIterator<SimpleFeature> buffered() {
            return Iterator.class.buffered((Iterator)this);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size) {
            return Iterator.class.grouped((Iterator)this, (int)size);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size, int step2) {
            return Iterator.class.sliding((Iterator)this, (int)size, (int)step2);
        }

        public int length() {
            return Iterator.class.length((Iterator)this);
        }

        public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> duplicate() {
            return Iterator.class.duplicate((Iterator)this);
        }

        public <B> Iterator<B> patch(int from2, Iterator<B> patchElems, int replaced) {
            return Iterator.class.patch((Iterator)this, (int)from2, patchElems, (int)replaced);
        }

        public <B> void copyToArray(Object xs, int start, int len) {
            Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
        }

        public boolean sameElements(Iterator<?> that) {
            return Iterator.class.sameElements((Iterator)this, that);
        }

        public Traversable<SimpleFeature> toTraversable() {
            return Iterator.class.toTraversable((Iterator)this);
        }

        public Iterator<SimpleFeature> toIterator() {
            return Iterator.class.toIterator((Iterator)this);
        }

        public Stream<SimpleFeature> toStream() {
            return Iterator.class.toStream((Iterator)this);
        }

        public String toString() {
            return Iterator.class.toString((Iterator)this);
        }

        public <B> int sliding$default$2() {
            return Iterator.class.sliding$default$2((Iterator)this);
        }

        public List<SimpleFeature> reversed() {
            return TraversableOnce.class.reversed((TraversableOnce)this);
        }

        public int size() {
            return TraversableOnce.class.size((TraversableOnce)this);
        }

        public boolean nonEmpty() {
            return TraversableOnce.class.nonEmpty((TraversableOnce)this);
        }

        public int count(Function1<SimpleFeature, Object> p) {
            return TraversableOnce.class.count((TraversableOnce)this, p);
        }

        public <B> Option<B> collectFirst(PartialFunction<SimpleFeature, B> pf) {
            return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
        }

        public <B> B $div$colon(B z, Function2<B, SimpleFeature, B> op) {
            return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
        }

        public <B> B $colon$bslash(B z, Function2<SimpleFeature, B, B> op) {
            return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
        }

        public <B> B foldLeft(B z, Function2<B, SimpleFeature, B> op) {
            return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
        }

        public <B> B foldRight(B z, Function2<SimpleFeature, B, B> op) {
            return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
        }

        public <B> B reduceLeft(Function2<B, SimpleFeature, B> op) {
            return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
        }

        public <B> B reduceRight(Function2<SimpleFeature, B, B> op) {
            return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, SimpleFeature, B> op) {
            return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<SimpleFeature, B, B> op) {
            return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
        }

        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
        }

        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
            return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, SimpleFeature, B> seqop, Function2<B, B, B> combop) {
            return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)TraversableOnce.class.product((TraversableOnce)this, num);
        }

        public Object min(Ordering cmp) {
            return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
        }

        public Object max(Ordering cmp) {
            return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
        }

        public Object maxBy(Function1 f, Ordering cmp) {
            return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public Object minBy(Function1 f, Ordering cmp) {
            return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public <B> void copyToBuffer(Buffer<B> dest) {
            TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
        }

        public <B> void copyToArray(Object xs, int start) {
            TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
        }

        public <B> void copyToArray(Object xs) {
            TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
        }

        public <B> Object toArray(ClassTag<B> evidence$1) {
            return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
        }

        public List<SimpleFeature> toList() {
            return TraversableOnce.class.toList((TraversableOnce)this);
        }

        public Iterable<SimpleFeature> toIterable() {
            return TraversableOnce.class.toIterable((TraversableOnce)this);
        }

        public Seq<SimpleFeature> toSeq() {
            return TraversableOnce.class.toSeq((TraversableOnce)this);
        }

        public IndexedSeq<SimpleFeature> toIndexedSeq() {
            return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
        }

        public <B> Buffer<B> toBuffer() {
            return TraversableOnce.class.toBuffer((TraversableOnce)this);
        }

        public <B> Set<B> toSet() {
            return TraversableOnce.class.toSet((TraversableOnce)this);
        }

        public Vector<SimpleFeature> toVector() {
            return TraversableOnce.class.toVector((TraversableOnce)this);
        }

        public <Col> Col to(CanBuildFrom<Nothing$, SimpleFeature, Col> cbf) {
            return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
        }

        public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef$.less.colon.less<SimpleFeature, Tuple2<T, U>> ev) {
            return TraversableOnce.class.toMap((TraversableOnce)this, ev);
        }

        public String mkString(String start, String sep, String end) {
            return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
        }

        public String mkString(String sep) {
            return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
        }

        public String mkString() {
            return TraversableOnce.class.mkString((TraversableOnce)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public StringBuilder addString(StringBuilder b, String sep) {
            return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
        }

        public StringBuilder addString(StringBuilder b) {
            return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
        }

        private Map<String, FileSystemStorage.FileSystemWriter> modifiers() {
            return this.modifiers;
        }

        private Map<String, FileSystemStorage.FileSystemWriter> deleters() {
            return this.deleters;
        }

        public SimpleFeature org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$feature() {
            return this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$feature;
        }

        private void org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$feature_$eq(SimpleFeature x$1) {
            this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$feature = x$1;
        }

        public String org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$partition() {
            return this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$partition;
        }

        private void org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$partition_$eq(String x$1) {
            this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$partition = x$1;
        }

        public void write() {
            String update;
            if (this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$feature() == null) {
                throw new IllegalArgumentException("Must call 'next' before calling 'write'");
            }
            String string = update = this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().metadata().scheme().getPartitionName(this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$feature());
            String string2 = this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$partition();
            if (string == null ? string2 != null : !string.equals(string2)) {
                ((FileSystemStorage.FileSystemWriter)this.deleters().getOrElseUpdate((Object)this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$partition(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileSystemUpdateWriterImpl $outer;

                    public final FileSystemStorage.FileSystemWriter apply() {
                        return this.$outer.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(this.$outer.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$partition(), StorageMetadata.StorageFileAction$.MODULE$.Delete());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).write(this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$feature());
            }
            ((FileSystemStorage.FileSystemWriter)this.modifiers().getOrElseUpdate((Object)update, (Function0)new Serializable(this, update){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileSystemUpdateWriterImpl $outer;
                private final String update$1;

                public final FileSystemStorage.FileSystemWriter apply() {
                    return this.$outer.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(this.update$1, StorageMetadata.StorageFileAction$.MODULE$.Modify());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.update$1 = update$1;
                }
            })).write(this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$feature());
            this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$feature_$eq(null);
        }

        public void remove() {
            if (this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$feature() == null) {
                throw new IllegalArgumentException("Must call 'next' before calling 'remove'");
            }
            ((FileSystemStorage.FileSystemWriter)this.deleters().getOrElseUpdate((Object)this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$partition(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileSystemUpdateWriterImpl $outer;

                public final FileSystemStorage.FileSystemWriter apply() {
                    return this.$outer.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(this.$outer.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$partition(), StorageMetadata.StorageFileAction$.MODULE$.Delete());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            })).write(this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$feature());
            this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$feature_$eq(null);
        }

        public boolean hasNext() {
            return this.reader.hasNext();
        }

        public SimpleFeature next() {
            this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$feature_$eq((SimpleFeature)this.reader.next());
            this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$partition_$eq((String)this.readPartition.getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileSystemUpdateWriterImpl $outer;

                public final String apply() {
                    return this.$outer.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().metadata().scheme().getPartitionName(this.$outer.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$feature());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            return this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$feature();
        }

        public void flush() {
            FlushQuietly$.MODULE$.apply((Seq)this.modifiers().values().toSeq().$plus$plus((GenTraversableOnce)this.deleters().values(), Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply(Throwable e) {
                    throw e;
                }
            });
        }

        public void close() {
            CloseQuietly$.MODULE$.apply((Iterable)((TraversableLike)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Iterator[]{this.reader}))).$plus$plus((GenTraversableOnce)this.modifiers().values(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.deleters().values(), Seq$.MODULE$.canBuildFrom())).$plus$plus(this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers(), Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply(Throwable e) {
                    throw e;
                }
            });
        }

        public /* synthetic */ AbstractFileSystemStorage org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer() {
            return this.$outer;
        }

        public FileSystemUpdateWriterImpl(AbstractFileSystemStorage $outer, Iterator<SimpleFeature> reader2, Option<String> readPartition) {
            this.reader = reader2;
            this.readPartition = readPartition;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            TraversableOnce.class.$init$((TraversableOnce)this);
            Iterator.class.$init$((Iterator)this);
            this.modifiers = Map$.MODULE$.empty();
            this.deleters = Map$.MODULE$.empty();
        }
    }
}

