/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Phaser;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata$;
import org.locationtech.geomesa.fs.storage.common.AbstractFileSystemStorage;
import org.locationtech.geomesa.fs.storage.common.FileSystemThreadedReader;
import org.locationtech.geomesa.fs.storage.common.FileSystemThreadedReader$ChainedReaderTask$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.opengis.feature.simple.SimpleFeature;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

public final class FileSystemThreadedReader$
implements StrictLogging {
    public static final FileSystemThreadedReader$ MODULE$;
    private final Logger logger;

    static {
        new FileSystemThreadedReader$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CloseableIterator<SimpleFeature> apply(Iterator<Tuple2<AbstractFileSystemStorage.FileSystemPathReader, Seq<StorageMetadata.StorageFilePath>>> readers, int threads) {
        CloseableIterator closeableIterator;
        if (threads < 2) {
            closeableIterator = CloseableIterator$.MODULE$.iteratorToCloseable(readers.flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final CloseableIterator<SimpleFeature> apply(Tuple2<AbstractFileSystemStorage.FileSystemPathReader, Seq<StorageMetadata.StorageFilePath>> x0$1) {
                    Tuple2<AbstractFileSystemStorage.FileSystemPathReader, Seq<StorageMetadata.StorageFilePath>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        AbstractFileSystemStorage.FileSystemPathReader reader2 = (AbstractFileSystemStorage.FileSystemPathReader)tuple2._1();
                        Seq files = (Seq)tuple2._2();
                        HashSet mods = HashSet$.MODULE$.empty();
                        CloseableIterator closeableIterator = CloseableIterator$.MODULE$.apply(((IterableLike)files.sorted(StorageMetadata$.MODULE$.StorageFilePathOrdering())).iterator(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                CloseableIterator$.MODULE$.apply$default$2();
                            }
                        }).flatMap((Function1)new Serializable(this, reader2, mods){
                            public static final long serialVersionUID = 0L;
                            private final AbstractFileSystemStorage.FileSystemPathReader reader$1;
                            private final HashSet mods$1;

                            public final CloseableIterator<SimpleFeature> apply(StorageMetadata.StorageFilePath f) {
                                return FileSystemThreadedReader$.MODULE$.org$locationtech$geomesa$fs$storage$common$FileSystemThreadedReader$$read(this.reader$1, f, (scala.collection.mutable.Set<String>)this.mods$1);
                            }
                            {
                                this.reader$1 = reader$1;
                                this.mods$1 = mods$1;
                            }
                        });
                        return closeableIterator;
                    }
                    throw new MatchError(tuple2);
                }
            }));
            return closeableIterator;
        }
        LinkedBlockingQueue<SimpleFeature> queue = new LinkedBlockingQueue<SimpleFeature>(2000000);
        ExecutorService es = Executors.newFixedThreadPool(threads);
        Phaser phaser = new Phaser(es){
            private final ExecutorService es$1;

            public boolean onAdvance(int phase, int registeredParties) {
                this.es$1.shutdown();
                return true;
            }
            {
                this.es$1 = es$1;
                super(1);
            }
        };
        try {
            readers.foreach((Function1)new Serializable(queue, es, phaser){
                public static final long serialVersionUID = 0L;
                private final LinkedBlockingQueue queue$1;
                private final ExecutorService es$1;
                private final Phaser phaser$1;

                public final Future<?> apply(Tuple2<AbstractFileSystemStorage.FileSystemPathReader, Seq<StorageMetadata.StorageFilePath>> x0$2) {
                    Tuple2<AbstractFileSystemStorage.FileSystemPathReader, Seq<StorageMetadata.StorageFilePath>> tuple2 = x0$2;
                    if (tuple2 != null) {
                        AbstractFileSystemStorage.FileSystemPathReader reader2 = (AbstractFileSystemStorage.FileSystemPathReader)tuple2._1();
                        Seq files = (Seq)tuple2._2();
                        ListBuffer groups = (ListBuffer)ListBuffer$.MODULE$.empty();
                        ObjectRef group = ObjectRef.create((Object)((ArrayBuffer)ArrayBuffer$.MODULE$.empty()));
                        ((IterableLike)files.sorted(StorageMetadata$.MODULE$.StorageFilePathOrdering())).foreach((Function1)new Serializable(this, groups, group){
                            public static final long serialVersionUID = 0L;
                            private final ListBuffer groups$1;
                            private final ObjectRef group$1;

                            public final AbstractBuffer<? extends Object> apply(StorageMetadata.StorageFilePath file) {
                                ArrayBuffer arrayBuffer;
                                Enumeration.Value value = file.file().action();
                                Enumeration.Value value2 = StorageMetadata.StorageFileAction$.MODULE$.Append();
                                if (!(value != null ? !value.equals(value2) : value2 != null)) {
                                    arrayBuffer = ((ArrayBuffer)this.group$1.elem).$plus$eq((Object)file);
                                } else {
                                    if (((ArrayBuffer)this.group$1.elem).nonEmpty()) {
                                        this.groups$1.$plus$eq((Object)((ArrayBuffer)this.group$1.elem));
                                        this.group$1.elem = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                                    }
                                    arrayBuffer = this.groups$1.$plus$eq((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StorageMetadata.StorageFilePath[]{file})));
                                }
                                return arrayBuffer;
                            }
                            {
                                this.groups$1 = groups$1;
                                this.group$1 = group$1;
                            }
                        });
                        Object object = ((ArrayBuffer)group.elem).nonEmpty() ? groups.$plus$eq((Object)((ArrayBuffer)group.elem)) : BoxedUnit.UNIT;
                        Future<?> future = this.es$1.submit(new FileSystemThreadedReader.ChainedReaderTask(this.es$1, this.phaser$1, reader2, (Seq<StorageMetadata.StorageFilePath>)((Seq)groups.head()), (Seq<Seq<StorageMetadata.StorageFilePath>>)((Seq)groups.tail()), this.queue$1, FileSystemThreadedReader$ChainedReaderTask$.MODULE$.$lessinit$greater$default$7()));
                        return future;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.queue$1 = queue$1;
                    this.es$1 = es$1;
                    this.phaser$1 = phaser$1;
                }
            });
            phaser.arriveAndDeregister();
        }
        catch (Throwable throwable) {
            try {
                void var4_4;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                var4_4.shutdownNow();
                throw e;
            }
            catch (Throwable throwable3) {
                void var5_5;
                var5_5.arriveAndDeregister();
                throw throwable3;
            }
        }
        closeableIterator = new FileSystemThreadedReader(es, phaser, queue);
        return closeableIterator;
    }

    public CloseableIterator<SimpleFeature> org$locationtech$geomesa$fs$storage$common$FileSystemThreadedReader$$read(AbstractFileSystemStorage.FileSystemPathReader reader2, StorageMetadata.StorageFilePath file, scala.collection.mutable.Set<String> mods) {
        block5: {
            Object object;
            block3: {
                Enumeration.Value value;
                block4: {
                    block2: {
                        value = file.file().action();
                        Enumeration.Value value2 = StorageMetadata.StorageFileAction$.MODULE$.Append();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                        object = new FileSystemThreadedReader.AppendingReaderIterator(reader2, file.path(), (Set<String>)mods);
                        break block3;
                    }
                    Enumeration.Value value4 = StorageMetadata.StorageFileAction$.MODULE$.Modify();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                    object = new FileSystemThreadedReader.ModifyingReaderIterator(reader2, file.path(), mods);
                    break block3;
                }
                Enumeration.Value value6 = StorageMetadata.StorageFileAction$.MODULE$.Delete();
                Enumeration.Value value7 = value;
                if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                object = new FileSystemThreadedReader.DeletingReaderIterator(reader2, file.path(), mods);
            }
            return object;
        }
        throw new NotImplementedError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected storage action: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.file().action()})));
    }

    private FileSystemThreadedReader$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
    }
}

