/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.metadata;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.metadata.FileBasedMetadata$;
import org.locationtech.geomesa.fs.storage.common.metadata.FileBasedMetadataFactory;
import org.locationtech.geomesa.fs.storage.common.metadata.MetadataJson$;
import org.locationtech.geomesa.fs.storage.common.package$;
import org.locationtech.geomesa.fs.storage.common.utils.PathCache$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.feature.simple.SimpleFeatureType;
import pureconfig.ConfigWriter$;
import pureconfig.Derivation;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

public final class MetadataJson$
implements MethodProfiling {
    public static final MetadataJson$ MODULE$;
    private final String MetadataPath;
    private final ConcurrentHashMap<String, package.NamedOptions> cache;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new MetadataJson$();
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        MetadataJson$ metadataJson$ = this;
        synchronized (metadataJson$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private String MetadataPath() {
        return this.MetadataPath;
    }

    private ConcurrentHashMap<String, package.NamedOptions> cache() {
        return this.cache;
    }

    public Option<package.NamedOptions> readMetadata(package.FileSystemContext context) {
        BoxedUnit boxedUnit;
        String key2 = context.root().toUri().toString();
        ObjectRef cached = ObjectRef.create((Object)this.cache().get(key2));
        if ((package.NamedOptions)cached.elem == null) {
            Path file = new Path(context.root(), this.MetadataPath());
            if (PathCache$.MODULE$.exists(context.fc(), file, PathCache$.MODULE$.exists$default$3())) {
                Config config = (Config)this.profile("Loaded metadata configuration", (Function0)new Serializable(context, file){
                    public static final long serialVersionUID = 0L;
                    private final package.FileSystemContext context$1;
                    private final Path file$1;

                    public final Config apply() {
                        return (Config)WithClose$.MODULE$.apply((Object)new InputStreamReader((InputStream)this.context$1.fc().open(this.file$1), StandardCharsets.UTF_8), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Config apply(InputStreamReader in) {
                                return ConfigFactory.parseReader((Reader)in, (ConfigParseOptions)package$.MODULE$.ParseOptions());
                            }
                        });
                    }
                    {
                        this.context$1 = context$1;
                        this.file$1 = file$1;
                    }
                });
                if (config.hasPath("name")) {
                    cached.elem = (package.NamedOptions)this.profile("Parsed metadata configuration", (Function0)new Serializable(config){
                        public static final long serialVersionUID = 0L;
                        private final Config config$1;

                        public final package.NamedOptions apply() {
                            return (package.NamedOptions)pureconfig.package$.MODULE$.loadConfigOrThrow(this.config$1, ClassTag$.MODULE$.apply(package.NamedOptions.class), (Derivation)new Derivation.Successful(package$.MODULE$.NamedOptionsConvert()));
                        }
                        {
                            this.config$1 = config$1;
                        }
                    });
                    boxedUnit = this.cache().put(key2, (package.NamedOptions)cached.elem);
                } else {
                    context.fc().rename(file, new Path(context.root(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".bak"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.MetadataPath()}))), new Options.Rename[0]);
                    PathCache$.MODULE$.invalidate(context.fc(), file);
                    this.transitionMetadata(context, config).foreach((Function1)new Serializable(cached){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef cached$1;

                        public final void apply(package.NamedOptions meta) {
                            this.cached$1.elem = meta;
                        }
                        {
                            this.cached$1 = cached$1;
                        }
                    });
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply((Object)((package.NamedOptions)cached.elem));
    }

    public void writeMetadata(package.FileSystemContext context, package.NamedOptions metadata) {
        Path file = new Path(context.root(), this.MetadataPath());
        if (PathCache$.MODULE$.exists(context.fc(), file, true)) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to create a new storage instance but metadata already exists at '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
        }
        String data = (String)this.profile("Serialized metadata configuration", (Function0)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final package.NamedOptions metadata$1;

            public final String apply() {
                return ConfigWriter$.MODULE$.apply((Derivation)new Derivation.Successful(package$.MODULE$.NamedOptionsConvert())).to((Object)this.metadata$1).render(package$.MODULE$.RenderOptions());
            }
            {
                this.metadata$1 = metadata$1;
            }
        });
        this.profile("Persisted metadata configuration", (Function0)new Serializable(context, file, data){
            public static final long serialVersionUID = 0L;
            private final package.FileSystemContext context$2;
            private final Path file$2;
            public final String data$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                WithClose$.MODULE$.apply((Object)this.context$2.fc().create(this.file$2, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.createParent()}), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.writeMetadata.1 $outer;

                    public final void apply(FSDataOutputStream out) {
                        out.write(this.$outer.data$1.getBytes(StandardCharsets.UTF_8));
                        out.hflush();
                        out.hsync();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.context$2 = context$2;
                this.file$2 = file$2;
                this.data$1 = data$1;
            }
        });
        this.cache().put(context.root().toUri().toString(), metadata);
        PathCache$.MODULE$.register(context.fc(), file, PathCache$.MODULE$.register$default$3(), PathCache$.MODULE$.register$default$4());
    }

    private Option<package.NamedOptions> transitionMetadata(package.FileSystemContext context, Config config) {
        None$ none$;
        try {
            Config x$3 = config.getConfig("featureType");
            None$ x$4 = None$.MODULE$;
            Option x$5 = SimpleFeatureTypes$.MODULE$.createType$default$2();
            SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createType(x$3, x$5, (Option)x$4);
            String encoding = config.getString("encoding");
            Config schemeConfig = config.getConfig("partitionScheme");
            Config schemeOpts = schemeConfig.getConfig("options");
            package.NamedOptions scheme = new package.NamedOptions(schemeConfig.getString("scheme"), ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(schemeOpts.entrySet()).asScala()).map((Function1)new Serializable(schemeOpts){
                public static final long serialVersionUID = 0L;
                private final Config schemeOpts$1;

                public final Tuple2<String, String> apply(Map.Entry<String, ConfigValue> e) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.getKey()), (Object)this.schemeOpts$1.getString(e.getKey()));
                }
                {
                    this.schemeOpts$1 = schemeOpts$1;
                }
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            boolean leafStorage = scheme.options().get((Object)"leaf-storage").forall((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$1) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
                }
            });
            package.Metadata meta = new package.Metadata(sft, encoding, scheme, leafStorage);
            Config partitionConfig = config.getConfig("partitions");
            WithClose$.MODULE$.apply((Object)new FileBasedMetadataFactory().create(context, (Map<String, String>)Predef$.MODULE$.Map().empty(), meta), (Function1)new Serializable(partitionConfig){
                public static final long serialVersionUID = 0L;
                public final Config partitionConfig$1;

                public final void apply(StorageMetadata metadata) {
                    ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.partitionConfig$1.root().entrySet()).asScala()).foreach((Function1)new Serializable(this, metadata){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.transitionMetadata.1 $outer;
                        private final StorageMetadata metadata$2;

                        public final void apply(Map.Entry<String, ConfigValue> e) {
                            String name = e.getKey();
                            Buffer files = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.$outer.partitionConfig$1.getStringList(name)).asScala()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final StorageMetadata.StorageFile apply(String x$2) {
                                    return new StorageMetadata.StorageFile(x$2, 0L, StorageMetadata.StorageFile$.MODULE$.apply$default$3());
                                }
                            }, Buffer$.MODULE$.canBuildFrom());
                            this.metadata$2.addPartition(new StorageMetadata.PartitionMetadata(name, (Seq)files, (Option)None$.MODULE$, 0L));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.metadata$2 = metadata$2;
                        }
                    });
                }
                {
                    this.partitionConfig$1 = partitionConfig$1;
                }
            });
            none$ = new Some((Object)FileBasedMetadata$.MODULE$.DefaultOptions());
        }
        catch (Throwable throwable) {
            None$ none$2;
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Error transitioning old metadata format: ", e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = none$2 = None$.MODULE$;
        }
        return none$;
    }

    private MetadataJson$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        MethodProfiling.class.$init$((MethodProfiling)this);
        this.MetadataPath = "metadata.json";
        this.cache = new ConcurrentHashMap();
    }
}

