/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.api;

import java.io.Closeable;
import org.apache.hadoop.fs.Path;
import org.locationtech.geomesa.fs.storage.api.PartitionScheme;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0011UeaB\u0001\u0003!\u0003\r\ta\u0004\u0002\u0010'R|'/Y4f\u001b\u0016$\u0018\rZ1uC*\u00111\u0001B\u0001\u0004CBL'BA\u0003\u0007\u0003\u001d\u0019Ho\u001c:bO\u0016T!a\u0002\u0005\u0002\u0005\u0019\u001c(BA\u0005\u000b\u0003\u001d9Wm\\7fg\u0006T!a\u0003\u0007\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u0017=A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"aF\u000e\u000f\u0005aIR\"\u0001\u0002\n\u0005i\u0011\u0011a\u00029bG.\fw-Z\u0005\u00039u\u00111bQ8na\u0006\u001cG/\u00192mK*\u0011!D\u0001\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\n!![8\u000b\u0003\r\nAA[1wC&\u0011Q\u0005\t\u0002\n\u00072|7/Z1cY\u0016DQa\n\u0001\u0007\u0002!\n1a\u001d4u+\u0005I\u0003C\u0001\u00162\u001b\u0005Y#B\u0001\u0017.\u0003\u0019\u0019\u0018.\u001c9mK*\u0011afL\u0001\bM\u0016\fG/\u001e:f\u0015\t\u0001D\"A\u0004pa\u0016tw-[:\n\u0005IZ#!E*j[BdWMR3biV\u0014X\rV=qK\")A\u0007\u0001D\u0001k\u0005AQM\\2pI&tw-F\u00017!\t9$H\u0004\u0002\u0012q%\u0011\u0011HE\u0001\u0007!J,G-\u001a4\n\u0005mb$AB*ue&twM\u0003\u0002:%!)a\b\u0001D\u0001\u007f\u000511o\u00195f[\u0016,\u0012\u0001\u0011\t\u00031\u0005K!A\u0011\u0002\u0003\u001fA\u000b'\u000f^5uS>t7k\u00195f[\u0016DQ\u0001\u0012\u0001\u0007\u0002\u0015\u000b1\u0002\\3bMN#xN]1hKV\ta\t\u0005\u0002\u0012\u000f&\u0011\u0001J\u0005\u0002\b\u0005>|G.Z1o\u0011\u0015Q\u0005A\"\u0001L\u000319W\r\u001e)beRLG/[8o)\raEq\f\t\u0004#5{\u0015B\u0001(\u0013\u0005\u0019y\u0005\u000f^5p]B\u0019\u0001K!\u001c\u000f\u0005E\u0003gB\u0001*`\u001d\t\u0019fL\u0004\u0002U;:\u0011Q\u000b\u0018\b\u0003-ns!a\u0016.\u000e\u0003aS!!\u0017\b\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u00119Q!\u0019\u0002\t\u0002\t\fqb\u0015;pe\u0006<W-T3uC\u0012\fG/\u0019\t\u00031\r4Q!\u0001\u0002\t\u0002\u0011\u001c\"a\u0019\t\t\u000b\u0019\u001cG\u0011A4\u0002\rqJg.\u001b;?)\u0005\u0011\u0007bB5d\u0005\u0004%\u0019A[\u0001\u0014'R|'/Y4f\r&dWm\u0014:eKJLgnZ\u000b\u0002WB\u0019A\u000e]:\u000f\u00055|gBA,o\u0013\u0005\u0019\u0012B\u0001\u000e\u0013\u0013\t\t(O\u0001\u0005Pe\u0012,'/\u001b8h\u0015\tQ\"\u0003\u0005\u0002uk6\t1M\u0002\u0003wG\u0002;(aC*u_J\fw-\u001a$jY\u0016\u001cB!\u001e\tywB\u0011\u0011#_\u0005\u0003uJ\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0012y&\u0011QP\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t\u007fV\u0014)\u001a!C\u0001k\u0005!a.Y7f\u0011%\t\u0019!\u001eB\tB\u0003%a'A\u0003oC6,\u0007\u0005\u0003\u0006\u0002\bU\u0014)\u001a!C\u0001\u0003\u0013\t\u0011\u0002^5nKN$\u0018-\u001c9\u0016\u0005\u0005-\u0001cA\t\u0002\u000e%\u0019\u0011q\u0002\n\u0003\t1{gn\u001a\u0005\u000b\u0003')(\u0011#Q\u0001\n\u0005-\u0011A\u0003;j[\u0016\u001cH/Y7qA!Q\u0011qC;\u0003\u0016\u0004%\t!!\u0007\u0002\r\u0005\u001cG/[8o+\t\tY\u0002\u0005\u0003\u0002\u001e\u0005Ubb\u0001)\u0002 \u001d9\u0011\u0011E2\t\u0002\u0005\r\u0012!E*u_J\fw-\u001a$jY\u0016\f5\r^5p]B\u0019A/!\n\u0007\u000f\u0005\u001d2\r#\u0001\u0002*\t\t2\u000b^8sC\u001e,g)\u001b7f\u0003\u000e$\u0018n\u001c8\u0014\t\u0005\u0015\u00121\u0006\t\u0004#\u00055\u0012bAA\u0018%\tYQI\\;nKJ\fG/[8o\u0011\u001d1\u0017Q\u0005C\u0001\u0003g!\"!a\t\u0006\u000f\u0005\u001d\u0012Q\u0005\u0001\u00028A!\u0011\u0011HA\u001e\u001b\t\t)#\u0003\u0003\u0002>\u00055\"!\u0002,bYV,\u0007BCA!\u0003K\u0011\r\u0011\"\u0001\u0002D\u00051\u0011\t\u001d9f]\u0012,\"!a\u000e\t\u0013\u0005\u001d\u0013Q\u0005Q\u0001\n\u0005]\u0012aB!qa\u0016tG\r\t\u0005\u000b\u0003\u0017\n)C1A\u0005\u0002\u0005\r\u0013AB'pI&4\u0017\u0010C\u0005\u0002P\u0005\u0015\u0002\u0015!\u0003\u00028\u00059Qj\u001c3jMf\u0004\u0003BCA*\u0003K\u0011\r\u0011\"\u0001\u0002D\u00051A)\u001a7fi\u0016D\u0011\"a\u0016\u0002&\u0001\u0006I!a\u000e\u0002\u000f\u0011+G.\u001a;fA!Q\u00111L;\u0003\u0012\u0003\u0006I!a\u0007\u0002\u000f\u0005\u001cG/[8oA!1a-\u001eC\u0001\u0003?\"ra]A1\u0003G\n)\u0007\u0003\u0004\u0000\u0003;\u0002\rA\u000e\u0005\t\u0003\u000f\ti\u00061\u0001\u0002\f!Q\u0011qCA/!\u0003\u0005\r!a\u0007\t\u0013\u0005%T/!A\u0005\u0002\u0005-\u0014\u0001B2paf$ra]A7\u0003_\n\t\b\u0003\u0005\u0000\u0003O\u0002\n\u00111\u00017\u0011)\t9!a\u001a\u0011\u0002\u0003\u0007\u00111\u0002\u0005\u000b\u0003/\t9\u0007%AA\u0002\u0005m\u0001\"CA;kF\u0005I\u0011AA<\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u001f+\u0007Y\nYh\u000b\u0002\u0002~A!\u0011qPAE\u001b\t\t\tI\u0003\u0003\u0002\u0004\u0006\u0015\u0015!C;oG\",7m[3e\u0015\r\t9IE\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAF\u0003\u0003\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\ty)^I\u0001\n\u0003\t\t*\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005M%\u0006BA\u0006\u0003wB\u0011\"a&v#\u0003%\t!!'\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0014\u0016\u0005\u00037\tY\bC\u0005\u0002 V\f\t\u0011\"\u0011\u0002\"\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a)\u0011\t\u0005\u0015\u00161V\u0007\u0003\u0003OS1!!+#\u0003\u0011a\u0017M\\4\n\u0007m\n9\u000bC\u0005\u00020V\f\t\u0011\"\u0001\u00022\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u0017\t\u0004#\u0005U\u0016bAA\\%\t\u0019\u0011J\u001c;\t\u0013\u0005mV/!A\u0005\u0002\u0005u\u0016A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u007f\u000b)\rE\u0002\u0012\u0003\u0003L1!a1\u0013\u0005\r\te.\u001f\u0005\u000b\u0003\u000f\fI,!AA\u0002\u0005M\u0016a\u0001=%c!I\u00111Z;\u0002\u0002\u0013\u0005\u0013QZ\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u001a\t\u0007\u0003#\f9.a0\u000e\u0005\u0005M'bAAk%\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u00171\u001b\u0002\t\u0013R,'/\u0019;pe\"I\u0011Q\\;\u0002\u0002\u0013\u0005\u0011q\\\u0001\tG\u0006tW)];bYR\u0019a)!9\t\u0015\u0005\u001d\u00171\\A\u0001\u0002\u0004\ty\fC\u0005\u0002fV\f\t\u0011\"\u0011\u0002h\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u00024\"I\u00111^;\u0002\u0002\u0013\u0005\u0013Q^\u0001\ti>\u001cFO]5oOR\u0011\u00111\u0015\u0005\n\u0003c,\u0018\u0011!C!\u0003g\fa!Z9vC2\u001cHc\u0001$\u0002v\"Q\u0011qYAx\u0003\u0003\u0005\r!a0\t\u000f\u0005e8\r)A\u0005W\u0006!2\u000b^8sC\u001e,g)\u001b7f\u001fJ$WM]5oO\u0002B\u0011\"!@d\u0005\u0004%\u0019!a@\u0002/M#xN]1hK\u001aKG.\u001a)bi\"|%\u000fZ3sS:<WC\u0001B\u0001!\u0011a\u0007Oa\u0001\u0011\u0007Q\u0014)A\u0002\u0004\u0003\b\r\u0004%\u0011\u0002\u0002\u0010'R|'/Y4f\r&dW\rU1uQN)!Q\u0001\tyw\"Y!Q\u0002B\u0003\u0005+\u0007I\u0011\u0001B\b\u0003\u00111\u0017\u000e\\3\u0016\u0003MD!Ba\u0005\u0003\u0006\tE\t\u0015!\u0003t\u0003\u00151\u0017\u000e\\3!\u0011-\u00119B!\u0002\u0003\u0016\u0004%\tA!\u0007\u0002\tA\fG\u000f[\u000b\u0003\u00057\u0001BA!\b\u0003*5\u0011!q\u0004\u0006\u0004\u000f\t\u0005\"\u0002\u0002B\u0012\u0005K\ta\u0001[1e_>\u0004(b\u0001B\u0014\u0019\u00051\u0011\r]1dQ\u0016LAAa\u000b\u0003 \t!\u0001+\u0019;i\u0011-\u0011yC!\u0002\u0003\u0012\u0003\u0006IAa\u0007\u0002\u000bA\fG\u000f\u001b\u0011\t\u000f\u0019\u0014)\u0001\"\u0001\u00034Q1!1\u0001B\u001b\u0005oAqA!\u0004\u00032\u0001\u00071\u000f\u0003\u0005\u0003\u0018\tE\u0002\u0019\u0001B\u000e\u0011)\tIG!\u0002\u0002\u0002\u0013\u0005!1\b\u000b\u0007\u0005\u0007\u0011iDa\u0010\t\u0013\t5!\u0011\bI\u0001\u0002\u0004\u0019\bB\u0003B\f\u0005s\u0001\n\u00111\u0001\u0003\u001c!Q\u0011Q\u000fB\u0003#\u0003%\tAa\u0011\u0016\u0005\t\u0015#fA:\u0002|!Q\u0011q\u0012B\u0003#\u0003%\tA!\u0013\u0016\u0005\t-#\u0006\u0002B\u000e\u0003wB!\"a(\u0003\u0006\u0005\u0005I\u0011IAQ\u0011)\tyK!\u0002\u0002\u0002\u0013\u0005\u0011\u0011\u0017\u0005\u000b\u0003w\u0013)!!A\u0005\u0002\tMC\u0003BA`\u0005+B!\"a2\u0003R\u0005\u0005\t\u0019AAZ\u0011)\tYM!\u0002\u0002\u0002\u0013\u0005\u0013Q\u001a\u0005\u000b\u0003;\u0014)!!A\u0005\u0002\tmCc\u0001$\u0003^!Q\u0011q\u0019B-\u0003\u0003\u0005\r!a0\t\u0015\u0005\u0015(QAA\u0001\n\u0003\n9\u000f\u0003\u0006\u0002l\n\u0015\u0011\u0011!C!\u0003[D!\"!=\u0003\u0006\u0005\u0005I\u0011\tB3)\r1%q\r\u0005\u000b\u0003\u000f\u0014\u0019'!AA\u0002\u0005}\u0006\u0002\u0003B6G\u0002\u0006IA!\u0001\u00021M#xN]1hK\u001aKG.\u001a)bi\"|%\u000fZ3sS:<\u0007E\u0002\u0004\u0003p\r\u0004%\u0011\u000f\u0002\u0012!\u0006\u0014H/\u001b;j_:lU\r^1eCR\f7#\u0002B7!a\\\b\"C@\u0003n\tU\r\u0011\"\u00016\u0011)\t\u0019A!\u001c\u0003\u0012\u0003\u0006IA\u000e\u0005\f\u0005s\u0012iG!f\u0001\n\u0003\u0011Y(A\u0003gS2,7/\u0006\u0002\u0003~A!ANa t\u0013\r\u0011\tI\u001d\u0002\u0004'\u0016\f\bb\u0003BC\u0005[\u0012\t\u0012)A\u0005\u0005{\naAZ5mKN\u0004\u0003b\u0003BE\u0005[\u0012)\u001a!C\u0001\u0005\u0017\u000baAY8v]\u0012\u001cXC\u0001BG!\u0011\tRJa$\u0011\u0007Q\u0014\tJ\u0002\u0004\u0003\u0014\u000e\u0004%Q\u0013\u0002\u0010!\u0006\u0014H/\u001b;j_:\u0014u.\u001e8egN)!\u0011\u0013\tyw\"Y!\u0011\u0014BI\u0005+\u0007I\u0011\u0001BN\u0003\u0011AX.\u001b8\u0016\u0005\tu\u0005cA\t\u0003 &\u0019!\u0011\u0015\n\u0003\r\u0011{WO\u00197f\u0011-\u0011)K!%\u0003\u0012\u0003\u0006IA!(\u0002\u000bal\u0017N\u001c\u0011\t\u0017\t%&\u0011\u0013BK\u0002\u0013\u0005!1T\u0001\u0005s6Lg\u000eC\u0006\u0003.\nE%\u0011#Q\u0001\n\tu\u0015!B=nS:\u0004\u0003b\u0003BY\u0005#\u0013)\u001a!C\u0001\u00057\u000bA\u0001_7bq\"Y!Q\u0017BI\u0005#\u0005\u000b\u0011\u0002BO\u0003\u0015AX.\u0019=!\u0011-\u0011IL!%\u0003\u0016\u0004%\tAa'\u0002\tel\u0017\r\u001f\u0005\f\u0005{\u0013\tJ!E!\u0002\u0013\u0011i*A\u0003z[\u0006D\b\u0005C\u0004g\u0005##\tA!1\u0015\u0015\t=%1\u0019Bc\u0005\u000f\u0014I\r\u0003\u0005\u0003\u001a\n}\u0006\u0019\u0001BO\u0011!\u0011IKa0A\u0002\tu\u0005\u0002\u0003BY\u0005\u007f\u0003\rA!(\t\u0011\te&q\u0018a\u0001\u0005;C\u0001B!4\u0003\u0012\u0012\u0005!qZ\u0001\u0006IAdWo\u001d\u000b\u0005\u0005\u001f\u0013\t\u000e\u0003\u0005\u0003T\n-\u0007\u0019\u0001BH\u0003\u0005\u0011\u0007\u0002\u0003Bl\u0005##\tA!7\u0002\u0011\u0015tg/\u001a7pa\u0016,\"Aa7\u0011\t\tu'q]\u0007\u0003\u0005?TAA!9\u0003d\u0006!q-Z8n\u0015\r\u0011)OC\u0001\u0004UR\u001c\u0018\u0002\u0002Bu\u0005?\u0014\u0001\"\u00128wK2|\u0007/\u001a\u0005\u000b\u0003S\u0012\t*!A\u0005\u0002\t5HC\u0003BH\u0005_\u0014\tPa=\u0003v\"Q!\u0011\u0014Bv!\u0003\u0005\rA!(\t\u0015\t%&1\u001eI\u0001\u0002\u0004\u0011i\n\u0003\u0006\u00032\n-\b\u0013!a\u0001\u0005;C!B!/\u0003lB\u0005\t\u0019\u0001BO\u0011)\t)H!%\u0012\u0002\u0013\u0005!\u0011`\u000b\u0003\u0005wTCA!(\u0002|!Q\u0011q\u0012BI#\u0003%\tA!?\t\u0015\u0005]%\u0011SI\u0001\n\u0003\u0011I\u0010\u0003\u0006\u0004\u0004\tE\u0015\u0013!C\u0001\u0005s\fabY8qs\u0012\"WMZ1vYR$C\u0007\u0003\u0006\u0002 \nE\u0015\u0011!C!\u0003CC!\"a,\u0003\u0012\u0006\u0005I\u0011AAY\u0011)\tYL!%\u0002\u0002\u0013\u000511\u0002\u000b\u0005\u0003\u007f\u001bi\u0001\u0003\u0006\u0002H\u000e%\u0011\u0011!a\u0001\u0003gC!\"a3\u0003\u0012\u0006\u0005I\u0011IAg\u0011)\tiN!%\u0002\u0002\u0013\u000511\u0003\u000b\u0004\r\u000eU\u0001BCAd\u0007#\t\t\u00111\u0001\u0002@\"Q\u0011Q\u001dBI\u0003\u0003%\t%a:\t\u0015\u0005-(\u0011SA\u0001\n\u0003\ni\u000f\u0003\u0006\u0002r\nE\u0015\u0011!C!\u0007;!2ARB\u0010\u0011)\t9ma\u0007\u0002\u0002\u0003\u0007\u0011q\u0018\u0005\f\u0007G\u0011iG!E!\u0002\u0013\u0011i)A\u0004c_VtGm\u001d\u0011\t\u0017\r\u001d\"Q\u000eBK\u0002\u0013\u0005\u0011\u0011B\u0001\u0006G>,h\u000e\u001e\u0005\f\u0007W\u0011iG!E!\u0002\u0013\tY!\u0001\u0004d_VtG\u000f\t\u0005\bM\n5D\u0011AB\u0018))\u0019\tda\r\u00046\r]2\u0011\b\t\u0004i\n5\u0004BB@\u0004.\u0001\u0007a\u0007\u0003\u0005\u0003z\r5\u0002\u0019\u0001B?\u0011!\u0011Ii!\fA\u0002\t5\u0005\u0002CB\u0014\u0007[\u0001\r!a\u0003\t\u0011\t5'Q\u000eC\u0001\u0007{!Ba!\r\u0004@!A1\u0011IB\u001e\u0001\u0004\u0019\t$A\u0003pi\",'\u000f\u0003\u0005\u0004F\t5D\u0011AB$\u0003\u0019!S.\u001b8vgR!1\u0011GB%\u0011!\u0019\tea\u0011A\u0002\rE\u0002BCA5\u0005[\n\t\u0011\"\u0001\u0004NQQ1\u0011GB(\u0007#\u001a\u0019f!\u0016\t\u0011}\u001cY\u0005%AA\u0002YB!B!\u001f\u0004LA\u0005\t\u0019\u0001B?\u0011)\u0011Iia\u0013\u0011\u0002\u0003\u0007!Q\u0012\u0005\u000b\u0007O\u0019Y\u0005%AA\u0002\u0005-\u0001BCA;\u0005[\n\n\u0011\"\u0001\u0002x!Q\u0011q\u0012B7#\u0003%\taa\u0017\u0016\u0005\ru#\u0006\u0002B?\u0003wB!\"a&\u0003nE\u0005I\u0011AB1+\t\u0019\u0019G\u000b\u0003\u0003\u000e\u0006m\u0004BCB\u0002\u0005[\n\n\u0011\"\u0001\u0002\u0012\"Q\u0011q\u0014B7\u0003\u0003%\t%!)\t\u0015\u0005=&QNA\u0001\n\u0003\t\t\f\u0003\u0006\u0002<\n5\u0014\u0011!C\u0001\u0007[\"B!a0\u0004p!Q\u0011qYB6\u0003\u0003\u0005\r!a-\t\u0015\u0005-'QNA\u0001\n\u0003\ni\r\u0003\u0006\u0002^\n5\u0014\u0011!C\u0001\u0007k\"2ARB<\u0011)\t9ma\u001d\u0002\u0002\u0003\u0007\u0011q\u0018\u0005\u000b\u0003K\u0014i'!A\u0005B\u0005\u001d\bBCAv\u0005[\n\t\u0011\"\u0011\u0002n\"Q\u0011\u0011\u001fB7\u0003\u0003%\tea \u0015\u0007\u0019\u001b\t\t\u0003\u0006\u0002H\u000eu\u0014\u0011!a\u0001\u0003\u007f;\u0011b!\"d\u0003\u0003E\taa\"\u0002#A\u000b'\u000f^5uS>tW*\u001a;bI\u0006$\u0018\rE\u0002u\u0007\u00133\u0011Ba\u001cd\u0003\u0003E\taa#\u0014\u000b\r%5QR>\u0011\u001b\r=5Q\u0013\u001c\u0003~\t5\u00151BB\u0019\u001b\t\u0019\tJC\u0002\u0004\u0014J\tqA];oi&lW-\u0003\u0003\u0004\u0018\u000eE%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oi!9am!#\u0005\u0002\rmECABD\u0011)\tYo!#\u0002\u0002\u0013\u0015\u0013Q\u001e\u0005\u000b\u0007C\u001bI)!A\u0005\u0002\u000e\r\u0016!B1qa2LHCCB\u0019\u0007K\u001b9k!+\u0004,\"1qpa(A\u0002YB\u0001B!\u001f\u0004 \u0002\u0007!Q\u0010\u0005\t\u0005\u0013\u001by\n1\u0001\u0003\u000e\"A1qEBP\u0001\u0004\tY\u0001\u0003\u0006\u00040\u000e%\u0015\u0011!CA\u0007c\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u00044\u000em\u0006\u0003B\tN\u0007k\u0003\"\"EB\\m\tu$QRA\u0006\u0013\r\u0019IL\u0005\u0002\u0007)V\u0004H.\u001a\u001b\t\u0015\ru6QVA\u0001\u0002\u0004\u0019\t$A\u0002yIAB!b!1\u0004\n\u0006\u0005I\u0011BBb\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\r\u0015\u0007\u0003BAS\u0007\u000fLAa!3\u0002(\n1qJ\u00196fGR<\u0011b!4d\u0003\u0003E\taa4\u0002\u0017M#xN]1hK\u001aKG.\u001a\t\u0004i\u000eEg\u0001\u0003<d\u0003\u0003E\taa5\u0014\u000b\rE7Q[>\u0011\u0015\r=5q\u001b\u001c\u0002\f\u0005m1/\u0003\u0003\u0004Z\u000eE%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8og!9am!5\u0005\u0002\ruGCABh\u0011)\tYo!5\u0002\u0002\u0013\u0015\u0013Q\u001e\u0005\u000b\u0007C\u001b\t.!A\u0005\u0002\u000e\rHcB:\u0004f\u000e\u001d8\u0011\u001e\u0005\u0007\u007f\u000e\u0005\b\u0019\u0001\u001c\t\u0011\u0005\u001d1\u0011\u001da\u0001\u0003\u0017A!\"a\u0006\u0004bB\u0005\t\u0019AA\u000e\u0011)\u0019yk!5\u0002\u0002\u0013\u00055Q\u001e\u000b\u0005\u0007_\u001c9\u0010\u0005\u0003\u0012\u001b\u000eE\b\u0003C\t\u0004tZ\nY!a\u0007\n\u0007\rU(C\u0001\u0004UkBdWm\r\u0005\n\u0007{\u001bY/!AA\u0002MD!ba?\u0004RF\u0005I\u0011AAM\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g!Q1q`Bi#\u0003%\t!!'\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIMB!b!1\u0004R\u0006\u0005I\u0011BBb\u000f%!)aYA\u0001\u0012\u0003!9!A\bTi>\u0014\u0018mZ3GS2,\u0007+\u0019;i!\r!H\u0011\u0002\u0004\n\u0005\u000f\u0019\u0017\u0011!E\u0001\t\u0017\u0019R\u0001\"\u0003\u0005\u000em\u0004\u0012ba$\u0005\u0010M\u0014YBa\u0001\n\t\u0011E1\u0011\u0013\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004b\u00024\u0005\n\u0011\u0005AQ\u0003\u000b\u0003\t\u000fA!\"a;\u0005\n\u0005\u0005IQIAw\u0011)\u0019\t\u000b\"\u0003\u0002\u0002\u0013\u0005E1\u0004\u000b\u0007\u0005\u0007!i\u0002b\b\t\u000f\t5A\u0011\u0004a\u0001g\"A!q\u0003C\r\u0001\u0004\u0011Y\u0002\u0003\u0006\u00040\u0012%\u0011\u0011!CA\tG!B\u0001\"\n\u0005.A!\u0011#\u0014C\u0014!\u0019\tB\u0011F:\u0003\u001c%\u0019A1\u0006\n\u0003\rQ+\b\u000f\\33\u0011)\u0019i\f\"\t\u0002\u0002\u0003\u0007!1\u0001\u0005\u000b\u0007\u0003$I!!A\u0005\n\r\rwa\u0002C\u001aG\"\u0005AQG\u0001\u0010!\u0006\u0014H/\u001b;j_:\u0014u.\u001e8egB\u0019A\u000fb\u000e\u0007\u000f\tM5\r#\u0001\u0005:M!Aq\u0007\t|\u0011\u001d1Gq\u0007C\u0001\t{!\"\u0001\"\u000e\t\u0011\r\u0005Fq\u0007C\u0001\t\u0003\"BA!$\u0005D!AAQ\tC \u0001\u0004\u0011Y.A\u0002f]ZD!b!)\u00058\u0005\u0005I\u0011\u0011C%))\u0011y\tb\u0013\u0005N\u0011=C\u0011\u000b\u0005\t\u00053#9\u00051\u0001\u0003\u001e\"A!\u0011\u0016C$\u0001\u0004\u0011i\n\u0003\u0005\u00032\u0012\u001d\u0003\u0019\u0001BO\u0011!\u0011I\fb\u0012A\u0002\tu\u0005BCBX\to\t\t\u0011\"!\u0005VQ!Aq\u000bC.!\u0011\tR\n\"\u0017\u0011\u0017E\u00199L!(\u0003\u001e\nu%Q\u0014\u0005\u000b\u0007{#\u0019&!AA\u0002\t=\u0005BCBa\to\t\t\u0011\"\u0003\u0004D\")q0\u0013a\u0001m!9A1\r\u0001\u0007\u0002\u0011\u0015\u0014!D4fiB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0005h\u0011%\u0004\u0003\u00027\u0003\u0000=C!\u0002b\u001b\u0005bA\u0005\t\u0019\u0001C7\u0003\u0019\u0001(/\u001a4jqB\u0019\u0011#\u0014\u001c\t\u000f\u0011E\u0004A\"\u0001\u0005t\u0005a\u0011\r\u001a3QCJ$\u0018\u000e^5p]R!AQ\u000fC>!\r\tBqO\u0005\u0004\ts\u0012\"\u0001B+oSRDq\u0001\" \u0005p\u0001\u0007q*A\u0005qCJ$\u0018\u000e^5p]\"9A\u0011\u0011\u0001\u0007\u0002\u0011\r\u0015a\u0004:f[>4X\rU1si&$\u0018n\u001c8\u0015\t\u0011UDQ\u0011\u0005\b\t{\"y\b1\u0001P\u0011\u001d!I\t\u0001D\u0001\t\u0017\u000baA]3m_\u0006$GC\u0001C;\u0011%!y\tAI\u0001\n\u0003!\t*A\fhKR\u0004\u0016M\u001d;ji&|gn\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011A1\u0013\u0016\u0005\t[\nY\b")
public interface StorageMetadata
extends package.Compactable,
Closeable {
    public SimpleFeatureType sft();

    public String encoding();

    public PartitionScheme scheme();

    public boolean leafStorage();

    public Option<PartitionMetadata> getPartition(String var1);

    public Seq<PartitionMetadata> getPartitions(Option<String> var1);

    public Option<String> getPartitions$default$1();

    public void addPartition(PartitionMetadata var1);

    public void removePartition(PartitionMetadata var1);

    public void reload();

    public static class StorageFile
    implements Product,
    Serializable {
        private final String name;
        private final long timestamp;
        private final Enumeration.Value action;

        public String name() {
            return this.name;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public Enumeration.Value action() {
            return this.action;
        }

        public StorageFile copy(String name, long timestamp, Enumeration.Value action) {
            return new StorageFile(name, timestamp, action);
        }

        public String copy$default$1() {
            return this.name();
        }

        public long copy$default$2() {
            return this.timestamp();
        }

        public Enumeration.Value copy$default$3() {
            return this.action();
        }

        public String productPrefix() {
            return "StorageFile";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    object = this.action();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.timestamp());
                    break;
                }
                case 0: {
                    object = this.name();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StorageFile;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.timestamp()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.action()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StorageFile)) return false;
            boolean bl = true;
            if (!bl) return false;
            StorageFile storageFile = (StorageFile)x$1;
            String string = this.name();
            String string2 = storageFile.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.timestamp() != storageFile.timestamp()) return false;
            Enumeration.Value value = this.action();
            Enumeration.Value value2 = storageFile.action();
            if (value == null) {
                if (value2 != null) {
                    return false;
                }
            } else if (!value.equals(value2)) return false;
            if (!storageFile.canEqual(this)) return false;
            return true;
        }

        public StorageFile(String name, long timestamp, Enumeration.Value action) {
            this.name = name;
            this.timestamp = timestamp;
            this.action = action;
            Product.class.$init$((Product)this);
        }
    }

    public static class StorageFilePath
    implements Product,
    Serializable {
        private final StorageFile file;
        private final Path path;

        public StorageFile file() {
            return this.file;
        }

        public Path path() {
            return this.path;
        }

        public StorageFilePath copy(StorageFile file, Path path) {
            return new StorageFilePath(file, path);
        }

        public StorageFile copy$default$1() {
            return this.file();
        }

        public Path copy$default$2() {
            return this.path();
        }

        public String productPrefix() {
            return "StorageFilePath";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.path();
                    break;
                }
                case 0: {
                    object = this.file();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StorageFilePath;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StorageFilePath)) return false;
            boolean bl = true;
            if (!bl) return false;
            StorageFilePath storageFilePath = (StorageFilePath)x$1;
            StorageFile storageFile = this.file();
            StorageFile storageFile2 = storageFilePath.file();
            if (storageFile == null) {
                if (storageFile2 != null) {
                    return false;
                }
            } else if (!((Object)storageFile).equals(storageFile2)) return false;
            Path path = this.path();
            Path path2 = storageFilePath.path();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!path.equals(path2)) return false;
            if (!storageFilePath.canEqual(this)) return false;
            return true;
        }

        public StorageFilePath(StorageFile file, Path path) {
            this.file = file;
            this.path = path;
            Product.class.$init$((Product)this);
        }
    }

    public static class PartitionBounds
    implements Product,
    Serializable {
        private final double xmin;
        private final double ymin;
        private final double xmax;
        private final double ymax;

        public double xmin() {
            return this.xmin;
        }

        public double ymin() {
            return this.ymin;
        }

        public double xmax() {
            return this.xmax;
        }

        public double ymax() {
            return this.ymax;
        }

        public PartitionBounds $plus(PartitionBounds b) {
            return new PartitionBounds(package$.MODULE$.min(this.xmin(), b.xmin()), package$.MODULE$.min(this.ymin(), b.ymin()), package$.MODULE$.max(this.xmax(), b.xmax()), package$.MODULE$.max(this.ymax(), b.ymax()));
        }

        public Envelope envelope() {
            return new Envelope(this.xmin(), this.xmax(), this.ymin(), this.ymax());
        }

        public PartitionBounds copy(double xmin, double ymin, double xmax, double ymax) {
            return new PartitionBounds(xmin, ymin, xmax, ymax);
        }

        public double copy$default$1() {
            return this.xmin();
        }

        public double copy$default$2() {
            return this.ymin();
        }

        public double copy$default$3() {
            return this.xmax();
        }

        public double copy$default$4() {
            return this.ymax();
        }

        public String productPrefix() {
            return "PartitionBounds";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Double d;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 3: {
                    d = BoxesRunTime.boxToDouble((double)this.ymax());
                    break;
                }
                case 2: {
                    d = BoxesRunTime.boxToDouble((double)this.xmax());
                    break;
                }
                case 1: {
                    d = BoxesRunTime.boxToDouble((double)this.ymin());
                    break;
                }
                case 0: {
                    d = BoxesRunTime.boxToDouble((double)this.xmin());
                }
            }
            return d;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PartitionBounds;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.xmin()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.ymin()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.xmax()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.ymax()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PartitionBounds)) return false;
            boolean bl = true;
            if (!bl) return false;
            PartitionBounds partitionBounds = (PartitionBounds)x$1;
            if (this.xmin() != partitionBounds.xmin()) return false;
            if (this.ymin() != partitionBounds.ymin()) return false;
            if (this.xmax() != partitionBounds.xmax()) return false;
            if (this.ymax() != partitionBounds.ymax()) return false;
            if (!partitionBounds.canEqual(this)) return false;
            return true;
        }

        public PartitionBounds(double xmin, double ymin, double xmax, double ymax) {
            this.xmin = xmin;
            this.ymin = ymin;
            this.xmax = xmax;
            this.ymax = ymax;
            Product.class.$init$((Product)this);
        }
    }

    public static class PartitionMetadata
    implements Product,
    Serializable {
        private final String name;
        private final Seq<StorageFile> files;
        private final Option<PartitionBounds> bounds;
        private final long count;

        public String name() {
            return this.name;
        }

        public Seq<StorageFile> files() {
            return this.files;
        }

        public Option<PartitionBounds> bounds() {
            return this.bounds;
        }

        public long count() {
            return this.count;
        }

        public PartitionMetadata $plus(PartitionMetadata other) {
            Option merged = this.bounds().map((Function1)new Serializable(this, other){
                public static final long serialVersionUID = 0L;
                private final PartitionMetadata other$1;

                public final PartitionBounds apply(PartitionBounds b) {
                    return (PartitionBounds)this.other$1.bounds().map((Function1)new Serializable(this, b){
                        public static final long serialVersionUID = 0L;
                        private final PartitionBounds b$1;

                        public final PartitionBounds apply(PartitionBounds x$3) {
                            return x$3.$plus(this.b$1);
                        }
                        {
                            this.b$1 = b$1;
                        }
                    }).getOrElse((Function0)new Serializable(this, b){
                        public static final long serialVersionUID = 0L;
                        private final PartitionBounds b$1;

                        public final PartitionBounds apply() {
                            return this.b$1;
                        }
                        {
                            this.b$1 = b$1;
                        }
                    });
                }
                {
                    this.other$1 = other$1;
                }
            }).orElse((Function0)new Serializable(this, other){
                public static final long serialVersionUID = 0L;
                private final PartitionMetadata other$1;

                public final Option<PartitionBounds> apply() {
                    return this.other$1.bounds();
                }
                {
                    this.other$1 = other$1;
                }
            });
            Seq x$4 = (Seq)this.files().$plus$plus(other.files(), Seq$.MODULE$.canBuildFrom());
            Option x$5 = merged;
            long x$6 = this.count() + other.count();
            String x$7 = this.copy$default$1();
            return this.copy(x$7, (Seq<StorageFile>)x$4, (Option<PartitionBounds>)x$5, x$6);
        }

        public PartitionMetadata $minus(PartitionMetadata other) {
            Seq x$8 = (Seq)this.files().diff(other.files());
            long x$9 = package$.MODULE$.max(0L, this.count() - other.count());
            String x$10 = this.copy$default$1();
            Option<PartitionBounds> x$11 = this.copy$default$3();
            return this.copy(x$10, (Seq<StorageFile>)x$8, x$11, x$9);
        }

        public PartitionMetadata copy(String name, Seq<StorageFile> files, Option<PartitionBounds> bounds, long count) {
            return new PartitionMetadata(name, files, bounds, count);
        }

        public String copy$default$1() {
            return this.name();
        }

        public Seq<StorageFile> copy$default$2() {
            return this.files();
        }

        public Option<PartitionBounds> copy$default$3() {
            return this.bounds();
        }

        public long copy$default$4() {
            return this.count();
        }

        public String productPrefix() {
            return "PartitionMetadata";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 3: {
                    object = BoxesRunTime.boxToLong((long)this.count());
                    break;
                }
                case 2: {
                    object = this.bounds();
                    break;
                }
                case 1: {
                    object = this.files();
                    break;
                }
                case 0: {
                    object = this.name();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PartitionMetadata;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.files()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.bounds()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.count()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PartitionMetadata)) return false;
            boolean bl = true;
            if (!bl) return false;
            PartitionMetadata partitionMetadata = (PartitionMetadata)x$1;
            String string = this.name();
            String string2 = partitionMetadata.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Seq<StorageFile> seq = this.files();
            Seq<StorageFile> seq2 = partitionMetadata.files();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Option<PartitionBounds> option = this.bounds();
            Option<PartitionBounds> option2 = partitionMetadata.bounds();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (this.count() != partitionMetadata.count()) return false;
            if (!partitionMetadata.canEqual(this)) return false;
            return true;
        }

        public PartitionMetadata(String name, Seq<StorageFile> files, Option<PartitionBounds> bounds, long count) {
            this.name = name;
            this.files = files;
            this.bounds = bounds;
            this.count = count;
            Product.class.$init$((Product)this);
        }
    }
}

