/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.cdi;

import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.server.impl.InitialContextHelper;
import com.sun.jersey.server.impl.cdi.CDIComponentProviderFactory;
import com.sun.jersey.spi.container.WebApplication;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class CDIComponentProviderFactoryInitializer {
    private static final Logger LOGGER = Logger.getLogger(CDIComponentProviderFactoryInitializer.class.getName());

    public static void initialize(ResourceConfig rc, WebApplication wa) {
        try {
            InitialContext ic = InitialContextHelper.getInitialContext();
            if (ic == null) {
                return;
            }
            Object beanManager = ic.lookup("java:comp/BeanManager");
            if (beanManager == null) {
                LOGGER.config("The CDI BeanManager is not available. JAX-RS CDI support is disabled.");
                return;
            }
            rc.getSingletons().add(new CDIComponentProviderFactory(beanManager, rc, wa));
            LOGGER.info("CDI support is enabled");
        }
        catch (NamingException ex) {
            LOGGER.log(Level.CONFIG, "The CDI BeanManager is not available. JAX-RS CDI support is disabled.", ex);
        }
    }
}

