/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.api;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.utils.conf.IndexId;
import org.locationtech.geomesa.utils.geotools.Conversions;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.geomesa.utils.text.StringSerialization$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.runtime.BoxesRunTime;

public final class GeoMesaFeatureIndex$ {
    public static final GeoMesaFeatureIndex$ MODULE$;

    static {
        new GeoMesaFeatureIndex$();
    }

    public String identifier(String name, int version, Seq<String> attributes2) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, BoxesRunTime.boxToInteger((int)version), attributes2.mkString(":")}));
    }

    public String identifier(IndexId id) {
        return this.identifier(id.name(), id.version(), (Seq<String>)id.attributes());
    }

    public String identifier(GeoMesaFeatureIndex<?, ?> index) {
        return this.identifier(index.name(), index.version(), index.attributes());
    }

    public String baseTableNameKey(String name, Seq<String> attributes2, int version) {
        String attrs = attributes2.isEmpty() ? "" : ((TraversableOnce)attributes2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String input) {
                return StringSerialization$.MODULE$.alphaNumericSafeString(input);
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(".", ".", "");
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table.", "", ".v", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, attrs, BoxesRunTime.boxToInteger((int)version)}));
    }

    public Function1<String, byte[]> idToBytes(SimpleFeatureType sft) {
        return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isUuidEncoded$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)) ? new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(String id) {
                return GeoMesaFeatureIndex$.MODULE$.org$locationtech$geomesa$index$api$GeoMesaFeatureIndex$$uuidToBytes(id);
            }
        } : new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(String id) {
                return GeoMesaFeatureIndex$.MODULE$.org$locationtech$geomesa$index$api$GeoMesaFeatureIndex$$stringToBytes(id);
            }
        };
    }

    public Function4<byte[], Object, Object, SimpleFeature, String> idFromBytes(SimpleFeatureType sft) {
        return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isUuidEncoded$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)) ? new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(byte[] bytes, int offset, int ignored, SimpleFeature sf) {
                return GeoMesaFeatureIndex$.MODULE$.org$locationtech$geomesa$index$api$GeoMesaFeatureIndex$$uuidFromBytes(bytes, offset, ignored, sf);
            }
        } : new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(byte[] bytes, int offset, int length, SimpleFeature ignored) {
                return GeoMesaFeatureIndex$.MODULE$.org$locationtech$geomesa$index$api$GeoMesaFeatureIndex$$stringFromBytes(bytes, offset, length, ignored);
            }
        };
    }

    public byte[] org$locationtech$geomesa$index$api$GeoMesaFeatureIndex$$uuidToBytes(String id) {
        UUID uuid = UUID.fromString(id);
        return ByteArrays$.MODULE$.uuidToBytes(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public String org$locationtech$geomesa$index$api$GeoMesaFeatureIndex$$uuidFromBytes(byte[] bytes, int offset, int ignored, SimpleFeature sf) {
        Tuple2 uuid = ByteArrays$.MODULE$.uuidFromBytes(bytes, offset);
        if (sf != null) {
            Conversions.RichSimpleFeature$.MODULE$.cacheUuid$extension(Conversions$.MODULE$.RichSimpleFeature(sf), uuid);
        }
        return new UUID(uuid._1$mcJ$sp(), uuid._2$mcJ$sp()).toString();
    }

    public byte[] org$locationtech$geomesa$index$api$GeoMesaFeatureIndex$$stringToBytes(String id) {
        return id.getBytes(StandardCharsets.UTF_8);
    }

    public String org$locationtech$geomesa$index$api$GeoMesaFeatureIndex$$stringFromBytes(byte[] bytes, int offset, int length, SimpleFeature ignored) {
        return new String(bytes, offset, length, StandardCharsets.UTF_8);
    }

    public String formatTableName(String catalog, String suffix, SimpleFeatureType sft) {
        return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isTableSharing$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)) ? this.formatSharedTableName(catalog, suffix) : this.formatSoloTableName(catalog, suffix, sft.getTypeName());
    }

    public String formatSoloTableName(String prefix, String suffix, String typeName) {
        return this.concatenate((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{prefix, this.hexEncodeNonAlphaNumeric(typeName), suffix}));
    }

    public String formatSharedTableName(String prefix, String suffix) {
        return this.concatenate((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{prefix, suffix}));
    }

    public String tableSuffix(GeoMesaFeatureIndex<?, ?> index, Option<String> partition) {
        String base = index.version() == 1 ? index.name() : this.concatenate((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{index.name(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index.version())}))}));
        return (String)partition.map((Function1)new Serializable(base){
            public static final long serialVersionUID = 0L;
            private final String base$1;

            public final String apply(String x$13) {
                return GeoMesaFeatureIndex$.MODULE$.concatenate((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.base$1, x$13}));
            }
            {
                this.base$1 = base$1;
            }
        }).getOrElse((Function0)new Serializable(base){
            public static final long serialVersionUID = 0L;
            private final String base$1;

            public final String apply() {
                return this.base$1;
            }
            {
                this.base$1 = base$1;
            }
        });
    }

    public Option<String> tableSuffix$default$2() {
        return None$.MODULE$;
    }

    public String concatenate(Seq<String> parts) {
        return parts.mkString("_");
    }

    public String hexEncodeNonAlphaNumeric(String input) {
        return StringSerialization$.MODULE$.alphaNumericSafeString(input);
    }

    private GeoMesaFeatureIndex$() {
        MODULE$ = this;
    }
}

