/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.filters;

import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2LatLng;
import org.locationtech.geomesa.index.filters.RowFilter;
import org.locationtech.geomesa.index.filters.S2Filter$;
import org.locationtech.geomesa.index.index.s2.package;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import scala.collection.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001B\u0001\u0003\u00015\u0011\u0001b\u0015\u001aGS2$XM\u001d\u0006\u0003\u0007\u0011\tqAZ5mi\u0016\u00148O\u0003\u0002\u0006\r\u0005)\u0011N\u001c3fq*\u0011q\u0001C\u0001\bO\u0016|W.Z:b\u0015\tI!\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0002\n\u0005]\u0011!!\u0003*po\u001aKG\u000e^3s\u0011!I\u0002A!b\u0001\n\u0003Q\u0012A\u0001=z+\u0005Y\u0002cA\b\u001d=%\u0011Q\u0004\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u001fqy\u0002CA\b!\u0013\t\t\u0003C\u0001\u0004E_V\u0014G.\u001a\u0005\tG\u0001\u0011\t\u0011)A\u00057\u0005\u0019\u00010\u001f\u0011\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\t9\u0003\u0006\u0005\u0002\u0016\u0001!)\u0011\u0004\na\u00017!)!\u0006\u0001C!W\u0005A\u0011N\u001c\"pk:$7\u000fF\u0002-_U\u0002\"aD\u0017\n\u00059\u0002\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006a%\u0002\r!M\u0001\u0004EV4\u0007cA\b\u001deA\u0011qbM\u0005\u0003iA\u0011AAQ=uK\")a'\u000ba\u0001o\u00051qN\u001a4tKR\u0004\"a\u0004\u001d\n\u0005e\u0002\"aA%oi\u001e)1H\u0001E\u0001y\u0005A1K\r$jYR,'\u000f\u0005\u0002\u0016{\u0019)\u0011A\u0001E\u0001}M\u0019QHD \u0011\u0007\u0001\u0003vE\u0004\u0002B\u001d:\u0011!)\u0014\b\u0003\u00072s!\u0001R&\u000f\u0005\u0015SeB\u0001$J\u001b\u00059%B\u0001%\r\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\n\u0005=\u0013\u0011!\u0003*po\u001aKG\u000e^3s\u0013\t\t&K\u0001\tS_^4\u0015\u000e\u001c;fe\u001a\u000b7\r^8ss*\u0011qJ\u0001\u0005\u0006Ku\"\t\u0001\u0016\u000b\u0002y!9a+\u0010b\u0001\n\u00139\u0016A\u0004*b]\u001e,7+\u001a9be\u0006$xN]\u000b\u00021B\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\u0005Y\u0006twMC\u0001^\u0003\u0011Q\u0017M^1\n\u0005}S&AB*ue&tw\r\u0003\u0004b{\u0001\u0006I\u0001W\u0001\u0010%\u0006tw-Z*fa\u0006\u0014\u0018\r^8sA!91-\u0010b\u0001\n\u00139\u0016!\u0004+fe6\u001cV\r]1sCR|'\u000f\u0003\u0004f{\u0001\u0006I\u0001W\u0001\u000f)\u0016\u0014XnU3qCJ\fGo\u001c:!\u0011\u001d9WH1A\u0005\u0002]\u000bQ\u0001W-LKfDa![\u001f!\u0002\u0013A\u0016A\u0002-Z\u0017\u0016L\b\u0005C\u0003l{\u0011\u0005A.A\u0003baBd\u0017\u0010\u0006\u0002([\")aN\u001ba\u0001_\u00061a/\u00197vKN\u0004\"\u0001\u001d>\u000f\u0005E<hB\u0001:u\u001d\t\u00115/\u0003\u0002\u0006\t%\u0011QO^\u0001\u0003gJR!!\u0002\u0003\n\u0005aL\u0018a\u00029bG.\fw-\u001a\u0006\u0003kZL!a\u001f?\u0003\u001bM\u0013\u0014J\u001c3fqZ\u000bG.^3t\u0015\tA\u0018\u0010C\u0003\u007f{\u0011\u0005s0\u0001\ttKJL\u0017\r\\5{KR{')\u001f;fgR\u0019\u0011'!\u0001\t\r\u0005\rQ\u00101\u0001(\u0003\u00191\u0017\u000e\u001c;fe\"9\u0011qA\u001f\u0005B\u0005%\u0011\u0001\u00063fg\u0016\u0014\u0018.\u00197ju\u00164%o\\7CsR,7\u000fF\u0002(\u0003\u0017Aq!!\u0004\u0002\u0006\u0001\u0007\u0011'\u0001\u0006tKJL\u0017\r\\5{K\u0012Dq!!\u0005>\t\u0003\n\u0019\"\u0001\ntKJL\u0017\r\\5{KR{7\u000b\u001e:j]\u001e\u001cH\u0003BA\u000b\u0003O\u0001\u0002\"a\u0006\u0002\u001e\u0005\r\u00121\u0005\b\u0004\u001f\u0005e\u0011bAA\u000e!\u00051\u0001K]3eK\u001aLA!a\b\u0002\"\t\u0019Q*\u00199\u000b\u0007\u0005m\u0001\u0003\u0005\u0003\u0002\u0018\u0005\u0015\u0012bA0\u0002\"!9\u00111AA\b\u0001\u00049\u0003bBA\u0016{\u0011\u0005\u0013QF\u0001\u0017I\u0016\u001cXM]5bY&TXM\u0012:p[N#(/\u001b8hgR\u0019q%a\f\t\u0011\u00055\u0011\u0011\u0006a\u0001\u0003c\u0001\u0002\"a\r\u0002:\u0005\r\u00121E\u0007\u0003\u0003kQ1!a\u000e\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003?\t)\u0004")
public class S2Filter
implements RowFilter {
    private final double[][] xy;

    public static S2Filter deserializeFromStrings(Map<String, String> map) {
        return S2Filter$.MODULE$.deserializeFromStrings((Map)map);
    }

    public static scala.collection.immutable.Map<String, String> serializeToStrings(S2Filter s2Filter) {
        return S2Filter$.MODULE$.serializeToStrings(s2Filter);
    }

    public static S2Filter deserializeFromBytes(byte[] byArray) {
        return S2Filter$.MODULE$.deserializeFromBytes(byArray);
    }

    public static byte[] serializeToBytes(S2Filter s2Filter) {
        return S2Filter$.MODULE$.serializeToBytes(s2Filter);
    }

    public static S2Filter apply(package.S2IndexValues s2IndexValues) {
        return S2Filter$.MODULE$.apply(s2IndexValues);
    }

    public static String XYKey() {
        return S2Filter$.MODULE$.XYKey();
    }

    public double[][] xy() {
        return this.xy;
    }

    @Override
    public boolean inBounds(byte[] buf, int offset) {
        S2LatLng latLon = new S2CellId(ByteArrays$.MODULE$.readLong(buf, offset)).toLatLng();
        double x = latLon.lngDegrees();
        double y = latLon.latDegrees();
        for (int i = 0; i < this.xy().length; ++i) {
            double[] xyi = this.xy()[i];
            if (!(x >= xyi[0]) || !(x <= xyi[2]) || !(y >= xyi[1]) || !(y <= xyi[3])) continue;
            return true;
        }
        return false;
    }

    public S2Filter(double[][] xy) {
        this.xy = xy;
    }
}

