/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.filters;

import com.google.common.geometry.S2CellId;
import org.locationtech.geomesa.index.filters.RowFilter;
import org.locationtech.geomesa.index.filters.S3Filter$;
import org.locationtech.geomesa.index.index.s3.package;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import scala.Function1;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0001\u0003\u00015\u0011\u0001bU\u001aGS2$XM\u001d\u0006\u0003\u0007\u0011\tqAZ5mi\u0016\u00148O\u0003\u0002\u0006\r\u0005)\u0011N\u001c3fq*\u0011q\u0001C\u0001\bO\u0016|W.Z:b\u0015\tI!\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0002\n\u0005]\u0011!!\u0003*po\u001aKG\u000e^3s\u0011!I\u0002A!b\u0001\n\u0003Q\u0012A\u0001=z+\u0005Y\u0002cA\b\u001d=%\u0011Q\u0004\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u001fqy\u0002CA\b!\u0013\t\t\u0003C\u0001\u0004E_V\u0014G.\u001a\u0005\tG\u0001\u0011\t\u0011)A\u00057\u0005\u0019\u00010\u001f\u0011\t\u0011\u0015\u0002!Q1A\u0005\u0002\u0019\n\u0011\u0001^\u000b\u0002OA\u0019q\u0002\b\u0015\u0011\u0007=a\u0012\u0006E\u0002\u00109)\u0002\"aD\u0016\n\u00051\u0002\"aA%oi\"Aa\u0006\u0001B\u0001B\u0003%q%\u0001\u0002uA!A\u0001\u0007\u0001BC\u0002\u0013\u0005\u0011'\u0001\u0005nS:,\u0005o\\2i+\u0005\u0011\u0004CA\b4\u0013\t!\u0004CA\u0003TQ>\u0014H\u000f\u0003\u00057\u0001\t\u0005\t\u0015!\u00033\u0003%i\u0017N\\#q_\u000eD\u0007\u0005\u0003\u00059\u0001\t\u0015\r\u0011\"\u00012\u0003!i\u0017\r_#q_\u000eD\u0007\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\u00135\f\u00070\u00129pG\"\u0004\u0003\"\u0002\u001f\u0001\t\u0003i\u0014A\u0002\u001fj]&$h\bF\u0003?\u007f\u0001\u000b%\t\u0005\u0002\u0016\u0001!)\u0011d\u000fa\u00017!)Qe\u000fa\u0001O!)\u0001g\u000fa\u0001e!)\u0001h\u000fa\u0001e!)A\t\u0001C!\u000b\u0006A\u0011N\u001c\"pk:$7\u000fF\u0002G\u0013>\u0003\"aD$\n\u0005!\u0003\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0015\u000e\u0003\raS\u0001\u0004EV4\u0007cA\b\u001d\u0019B\u0011q\"T\u0005\u0003\u001dB\u0011AAQ=uK\")\u0001k\u0011a\u0001U\u00051qN\u001a4tKRDQA\u0015\u0001\u0005\nM\u000bQ\u0002]8j]RLeNQ8v]\u0012\u001cHC\u0001$U\u0011\u0015)\u0016\u000b1\u0001W\u0003!\u00198GV1mk\u0016\u001c\bCA\bX\u0013\tA\u0006C\u0001\u0003M_:<\u0007\"\u0002.\u0001\t\u0013Y\u0016\u0001\u0004;j[\u0016LeNQ8v]\u0012\u001cHc\u0001$]=\")Q,\u0017a\u0001e\u0005)Q\r]8dQ\")\u0001+\u0017a\u0001U!)\u0001\r\u0001C!C\u0006AAo\\*ue&tw\rF\u0001c!\t\u0019gM\u0004\u0002\u0010I&\u0011Q\rE\u0001\u0007!J,G-\u001a4\n\u0005\u001dD'AB*ue&twM\u0003\u0002f!\u001d)!N\u0001E\u0001W\u0006A1k\r$jYR,'\u000f\u0005\u0002\u0016Y\u001a)\u0011A\u0001E\u0001[N\u0019AN\u00048\u0011\u0007=|hH\u0004\u0002q{:\u0011\u0011\u000f \b\u0003ent!a\u001d>\u000f\u0005QLhBA;y\u001b\u00051(BA<\r\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\n\u0005y\u0014\u0011!\u0003*po\u001aKG\u000e^3s\u0013\u0011\t\t!a\u0001\u0003!I{wOR5mi\u0016\u0014h)Y2u_JL(B\u0001@\u0003\u0011\u0019aD\u000e\"\u0001\u0002\bQ\t1\u000eC\u0005\u0002\f1\u0014\r\u0011\"\u0003\u0002\u000e\u0005q!+\u00198hKN+\u0007/\u0019:bi>\u0014XCAA\b!\u0011\t\t\"a\u0007\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\tA\u0001\\1oO*\u0011\u0011\u0011D\u0001\u0005U\u00064\u0018-C\u0002h\u0003'A\u0001\"a\bmA\u0003%\u0011qB\u0001\u0010%\u0006tw-Z*fa\u0006\u0014\u0018\r^8sA!I\u00111\u00057C\u0002\u0013%\u0011QB\u0001\u000e)\u0016\u0014XnU3qCJ\fGo\u001c:\t\u0011\u0005\u001dB\u000e)A\u0005\u0003\u001f\ta\u0002V3s[N+\u0007/\u0019:bi>\u0014\b\u0005C\u0005\u0002,1\u0014\r\u0011\"\u0003\u0002\u000e\u0005qQ\t]8dQN+\u0007/\u0019:bi>\u0014\b\u0002CA\u0018Y\u0002\u0006I!a\u0004\u0002\u001f\u0015\u0003xn\u00195TKB\f'/\u0019;pe\u0002B\u0011\"a\rm\u0005\u0004%\t!!\u0004\u0002\u000baK6*Z=\t\u0011\u0005]B\u000e)A\u0005\u0003\u001f\ta\u0001W-LKf\u0004\u0003\"CA\u001eY\n\u0007I\u0011AA\u0007\u0003\u0011!6*Z=\t\u0011\u0005}B\u000e)A\u0005\u0003\u001f\tQ\u0001V&fs\u0002B\u0011\"a\u0011m\u0005\u0004%\t!!\u0004\u0002\u0011\u0015\u0003xn\u00195LKfD\u0001\"a\u0012mA\u0003%\u0011qB\u0001\n\u000bB|7\r[&fs\u0002Bq!a\u0013m\t\u0003\ti%A\u0003baBd\u0017\u0010F\u0002?\u0003\u001fB\u0001\"!\u0015\u0002J\u0001\u0007\u00111K\u0001\u0007m\u0006dW/Z:\u0011\t\u0005U\u0013\u0011\u000e\b\u0005\u0003/\n\u0019G\u0004\u0003\u0002Z\u0005ucbA9\u0002\\%\u0011Q\u0001B\u0005\u0005\u0003?\n\t'\u0001\u0002tg)\u0011Q\u0001B\u0005\u0005\u0003K\n9'A\u0004qC\u000e\\\u0017mZ3\u000b\t\u0005}\u0013\u0011M\u0005\u0005\u0003W\niGA\u0007Tg%sG-\u001a=WC2,Xm\u001d\u0006\u0005\u0003K\n9\u0007C\u0004\u0002r1$\t%a\u001d\u0002!M,'/[1mSj,Gk\u001c\"zi\u0016\u001cHcA&\u0002v!9\u0011qOA8\u0001\u0004q\u0014A\u00024jYR,'\u000fC\u0004\u0002|1$\t%! \u0002)\u0011,7/\u001a:jC2L'0\u001a$s_6\u0014\u0015\u0010^3t)\rq\u0014q\u0010\u0005\b\u0003\u0003\u000bI\b1\u0001L\u0003)\u0019XM]5bY&TX\r\u001a\u0005\b\u0003\u000bcG\u0011IAD\u0003I\u0019XM]5bY&TX\rV8TiJLgnZ:\u0015\t\u0005%\u0015q\u0012\t\u0006G\u0006-%MY\u0005\u0004\u0003\u001bC'aA'ba\"9\u0011qOAB\u0001\u0004q\u0004bBAJY\u0012\u0005\u0013QS\u0001\u0017I\u0016\u001cXM]5bY&TXM\u0012:p[N#(/\u001b8hgR\u0019a(a&\t\u0011\u0005\u0005\u0015\u0011\u0013a\u0001\u00033\u0003b!a'\u0002\"\n\u0014WBAAO\u0015\r\ty\nE\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAG\u0003;\u0003")
public class S3Filter
implements RowFilter {
    private final double[][] xy;
    private final int[][][] t;
    private final short minEpoch;
    private final short maxEpoch;

    public static S3Filter deserializeFromStrings(Map<String, String> map) {
        return S3Filter$.MODULE$.deserializeFromStrings((Map)map);
    }

    public static scala.collection.immutable.Map<String, String> serializeToStrings(S3Filter s3Filter) {
        return S3Filter$.MODULE$.serializeToStrings(s3Filter);
    }

    public static S3Filter deserializeFromBytes(byte[] byArray) {
        return S3Filter$.MODULE$.deserializeFromBytes(byArray);
    }

    public static byte[] serializeToBytes(S3Filter s3Filter) {
        return S3Filter$.MODULE$.serializeToBytes(s3Filter);
    }

    public static S3Filter apply(package.S3IndexValues s3IndexValues) {
        return S3Filter$.MODULE$.apply(s3IndexValues);
    }

    public static String EpochKey() {
        return S3Filter$.MODULE$.EpochKey();
    }

    public static String TKey() {
        return S3Filter$.MODULE$.TKey();
    }

    public static String XYKey() {
        return S3Filter$.MODULE$.XYKey();
    }

    public double[][] xy() {
        return this.xy;
    }

    public int[][][] t() {
        return this.t;
    }

    public short minEpoch() {
        return this.minEpoch;
    }

    public short maxEpoch() {
        return this.maxEpoch;
    }

    @Override
    public boolean inBounds(byte[] buf, int offset) {
        long keyS = ByteArrays$.MODULE$.readLong(buf, offset + 2);
        int timeOffset = ByteArrays$.MODULE$.readInt(buf, offset + 10);
        return this.pointInBounds(keyS) && this.timeInBounds(ByteArrays$.MODULE$.readShort(buf, offset), timeOffset);
    }

    private boolean pointInBounds(long s3Values) {
        S2CellId s2CellId = new S2CellId(s3Values);
        double x = s2CellId.toLatLng().lngDegrees();
        double y = s2CellId.toLatLng().latDegrees();
        for (int i = 0; i < this.xy().length; ++i) {
            double[] xyi = this.xy()[i];
            if (!(x >= xyi[0]) || !(x <= xyi[2]) || !(y >= xyi[1]) || !(y <= xyi[3])) continue;
            return true;
        }
        return false;
    }

    private boolean timeInBounds(short epoch, int offset) {
        boolean bl;
        if (epoch > this.maxEpoch() || epoch < this.minEpoch()) {
            bl = false;
        } else {
            int[][] tEpoch = this.t()[epoch - this.minEpoch()];
            if (tEpoch == null) {
                bl = true;
            } else {
                int time = offset;
                for (int i = 0; i < tEpoch.length; ++i) {
                    int[] ti = tEpoch[i];
                    if (time < ti[0] || time > ti[1]) continue;
                    return true;
                }
                bl = false;
            }
        }
        return bl;
    }

    public String toString() {
        return ((TraversableOnce)S3Filter$.MODULE$.serializeToStrings(this).toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x$1) {
                return (String)x$1._1();
            }
        }, (Ordering)Ordering.String$.MODULE$)).mkString(",");
    }

    public S3Filter(double[][] xy, int[][][] t, short minEpoch, short maxEpoch) {
        this.xy = xy;
        this.t = t;
        this.minEpoch = minEpoch;
        this.maxEpoch = maxEpoch;
    }
}

