/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.geoserver;

import com.google.common.collect.ImmutableBiMap;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import org.geotools.data.Query;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryHints$Internal$;
import org.locationtech.geomesa.index.geoserver.ViewParams$;
import org.locationtech.geomesa.index.planning.QueryPlanner$CostEvaluation$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.geomesa.utils.text.StringSerialization$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class ViewParams$
implements LazyLogging {
    public static final ViewParams$ MODULE$;
    private final ImmutableBiMap<String, Hints.Key> QueryHintMap;
    private final ImmutableBiMap<String, Hints.Key> org$locationtech$geomesa$index$geoserver$ViewParams$$InternalHintMap;
    private final java.util.Map<String, Hints.Key> AllHintsMap;
    private final Regex org$locationtech$geomesa$index$geoserver$ViewParams$$envelope;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ViewParams$();
    }

    private Logger logger$lzycompute() {
        ViewParams$ viewParams$ = this;
        synchronized (viewParams$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private ImmutableBiMap<String, Hints.Key> QueryHintMap() {
        return this.QueryHintMap;
    }

    public ImmutableBiMap<String, Hints.Key> org$locationtech$geomesa$index$geoserver$ViewParams$$InternalHintMap() {
        return this.org$locationtech$geomesa$index$geoserver$ViewParams$$InternalHintMap;
    }

    private java.util.Map<String, Hints.Key> AllHintsMap() {
        return this.AllHintsMap;
    }

    public Regex org$locationtech$geomesa$index$geoserver$ViewParams$$envelope() {
        return this.org$locationtech$geomesa$index$geoserver$ViewParams$$envelope;
    }

    public String serialize(Hints hints) {
        scala.collection.mutable.Map map = (scala.collection.mutable.Map)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.QueryHintMap()).asScala()).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.org$locationtech$geomesa$index$geoserver$ViewParams$$InternalHintMap()).asScala()).flatMap((Function1)new Serializable(hints){
            public static final long serialVersionUID = 0L;
            private final Hints hints$1;

            public final Iterable<Tuple2<String, String>> apply(Tuple2<String, Hints.Key> x0$1) {
                Tuple2<String, Hints.Key> tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Hints.Key hint = (Hints.Key)tuple2._2();
                    Iterable iterable = Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(this.hints$1.get((Object)hint)).flatMap((Function1)new Serializable(this, name){
                        public static final long serialVersionUID = 0L;
                        private final String name$1;

                        public final Option<Tuple2<String, String>> apply(Object x0$2) {
                            Some some;
                            Object object = x0$2;
                            if (object instanceof String) {
                                String string = (String)object;
                                some = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.name$1), (Object)string));
                            } else if (object instanceof Boolean) {
                                Boolean bl = (Boolean)object;
                                some = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.name$1), (Object)bl.toString()));
                            } else if (object instanceof Integer) {
                                Integer n = (Integer)object;
                                some = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.name$1), (Object)n.toString()));
                            } else if (object instanceof Float) {
                                Float f = (Float)object;
                                some = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.name$1), (Object)f.toString()));
                            } else if (object instanceof ReferencedEnvelope) {
                                ReferencedEnvelope referencedEnvelope = (ReferencedEnvelope)object;
                                some = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.name$1), (Object)ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$toString(referencedEnvelope)));
                            } else if (object instanceof Enumeration.Value) {
                                Enumeration.Value value = (Enumeration.Value)object;
                                some = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.name$1), (Object)value.toString()));
                            } else if (object instanceof SimpleFeatureType) {
                                SimpleFeatureType simpleFeatureType = (SimpleFeatureType)object;
                                some = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.name$1), (Object)SimpleFeatureTypes$.MODULE$.serialize(simpleFeatureType)));
                            } else {
                                BoxedUnit boxedUnit;
                                if (ViewParams$.MODULE$.logger().underlying().isWarnEnabled()) {
                                    ViewParams$.MODULE$.logger().underlying().warn("Unhandled hint type for '{}'", new Object[]{this.name$1});
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                some = None$.MODULE$;
                            }
                            return some;
                        }
                        {
                            this.name$1 = name$1;
                        }
                    }));
                    return iterable;
                }
                throw new MatchError(tuple2);
            }
            {
                this.hints$1 = hints$1;
            }
        }, Map$.MODULE$.canBuildFrom());
        return StringSerialization$.MODULE$.encodeMap((Map)map);
    }

    /*
     * WARNING - void declaration
     */
    public Hints deserialize(String serialized) {
        void var2_2;
        Hints hints = new Hints();
        this.setHints(hints, (scala.collection.immutable.Map<String, String>)StringSerialization$.MODULE$.decodeMap(serialized), this.AllHintsMap());
        return var2_2;
    }

    public void setHints(Query query2) {
        java.util.Map viewParams = (java.util.Map)query2.getHints().get((Object)Hints.VIRTUAL_TABLE_PARAMETERS);
        scala.collection.immutable.Map params = (scala.collection.immutable.Map)Option$.MODULE$.apply((Object)viewParams).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, String> apply(java.util.Map<String, String> x$1) {
                return ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(x$1).asScala()).toMap(Predef$.MODULE$.$conforms());
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, Nothing$> apply() {
                return Predef$.MODULE$.Map().empty();
            }
        });
        this.setHints(query2.getHints(), (scala.collection.immutable.Map<String, String>)params, (java.util.Map<String, Hints.Key>)this.QueryHintMap());
    }

    public String getReadableHints(Query query2) {
        Builder readable = Seq$.MODULE$.newBuilder();
        readable.sizeHint(query2.getHints().size());
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)query2.getHints()).asScala()).foreach((Function1)new Serializable(readable){
            public static final long serialVersionUID = 0L;
            private final Builder readable$1;

            public final Builder<String, Seq<String>> apply(Tuple2<Object, Object> x0$3) {
                Tuple2<Object, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    Object k = tuple2._1();
                    Object v = tuple2._2();
                    if (k instanceof Hints.Key) {
                        String string;
                        Hints.Key key = (Hints.Key)k;
                        String key2 = ViewParams$.MODULE$.hintToString(key);
                        Object object = v;
                        if (object == null) {
                            string = "null";
                        } else if (object instanceof SimpleFeatureType) {
                            SimpleFeatureType simpleFeatureType = (SimpleFeatureType)object;
                            string = SimpleFeatureTypes$.MODULE$.encodeType(simpleFeatureType);
                        } else {
                            string = object.toString();
                        }
                        String value = string;
                        Builder builder = this.readable$1.$plus$eq((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key2, value})));
                        return builder;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.readable$1 = readable$1;
            }
        });
        return ((TraversableOnce)((SeqLike)readable.result()).sorted((Ordering)Ordering.String$.MODULE$)).mkString(", ");
    }

    public String hintToString(Hints.Key hint) {
        return (String)Option$.MODULE$.apply(this.QueryHintMap().inverse().get((Object)hint)).orElse((Function0)new Serializable(hint){
            public static final long serialVersionUID = 0L;
            private final Hints.Key hint$1;

            public final Option<String> apply() {
                return Option$.MODULE$.apply(ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$InternalHintMap().inverse().get((Object)this.hint$1));
            }
            {
                this.hint$1 = hint$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "unknown_hint";
            }
        });
    }

    private void setHints(Hints hints, scala.collection.immutable.Map<String, String> params, java.util.Map<String, Hints.Key> lookup) {
        params.foreach((Function1)new Serializable(hints, lookup){
            public static final long serialVersionUID = 0L;
            public final Hints hints$2;
            private final java.util.Map lookup$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(Tuple2<String, String> x0$4) {
                Tuple2<String, String> tuple2 = x0$4;
                if (tuple2 == null) throw new MatchError(tuple2);
                String original = (String)tuple2._1();
                String value = (String)tuple2._2();
                String string = original;
                String string2 = "STRATEGY";
                String key = !(string != null ? !string.equals(string2) : string2 != null) ? "QUERY_INDEX" : original;
                Hints.Key key2 = (Hints.Key)this.lookup$1.get(key);
                if (key2 == null) {
                    BoxedUnit boxedUnit;
                    if (ViewParams$.MODULE$.logger().underlying().isDebugEnabled()) {
                        ViewParams$.MODULE$.logger().underlying().debug("Ignoring view param {}={}", (Object[])new String[]{key, value});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else {
                    BoxedUnit boxedUnit;
                    try {
                        Class clazz;
                        Class clazz2 = clazz = key2.getValueClass();
                        Class<String> clazz3 = String.class;
                        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                            ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$setHint(this.hints$2, key, key2, value);
                            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            Class clazz4 = clazz;
                            Class<Boolean> clazz5 = Boolean.class;
                            if (!(clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null)) {
                                ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$toBoolean(key, value).foreach((Function1)new Serializable(this, key, key2){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.setHints.1 $outer;
                                    private final String key$1;
                                    private final Hints.Key x1$1;

                                    public final void apply(boolean x$2) {
                                        ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$setHint(this.$outer.hints$2, this.key$1, this.x1$1, BoxesRunTime.boxToBoolean((boolean)x$2));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.key$1 = key$1;
                                        this.x1$1 = x1$1;
                                    }
                                });
                                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                            } else {
                                Class clazz6 = clazz;
                                Class<Integer> clazz7 = Integer.class;
                                if (!(clazz6 != null ? !clazz6.equals(clazz7) : clazz7 != null)) {
                                    ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$toInt(key, value).foreach((Function1)new Serializable(this, key, key2){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun.setHints.1 $outer;
                                        private final String key$1;
                                        private final Hints.Key x1$1;

                                        public final void apply(int x$3) {
                                            this.apply$mcVI$sp(x$3);
                                        }

                                        public void apply$mcVI$sp(int x$3) {
                                            ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$setHint(this.$outer.hints$2, this.key$1, this.x1$1, BoxesRunTime.boxToInteger((int)x$3));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.key$1 = key$1;
                                            this.x1$1 = x1$1;
                                        }
                                    });
                                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                                } else {
                                    Class clazz8 = clazz;
                                    Class<Float> clazz9 = Float.class;
                                    if (!(clazz8 != null ? !clazz8.equals(clazz9) : clazz9 != null)) {
                                        ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$toFloat(key, value).foreach((Function1)new Serializable(this, key, key2){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ anonfun.setHints.1 $outer;
                                            private final String key$1;
                                            private final Hints.Key x1$1;

                                            public final void apply(float x$4) {
                                                this.apply$mcVF$sp(x$4);
                                            }

                                            public void apply$mcVF$sp(float x$4) {
                                                ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$setHint(this.$outer.hints$2, this.key$1, this.x1$1, BoxesRunTime.boxToFloat((float)x$4));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.key$1 = key$1;
                                                this.x1$1 = x1$1;
                                            }
                                        });
                                        BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                                    } else {
                                        Class clazz10 = clazz;
                                        Class<ReferencedEnvelope> clazz11 = ReferencedEnvelope.class;
                                        if (!(clazz10 != null ? !clazz10.equals(clazz11) : clazz11 != null)) {
                                            ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$toEnvelope(key, value).foreach((Function1)new Serializable(this, key, key2){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ anonfun.setHints.1 $outer;
                                                private final String key$1;
                                                private final Hints.Key x1$1;

                                                public final void apply(ReferencedEnvelope x$5) {
                                                    ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$setHint(this.$outer.hints$2, this.key$1, this.x1$1, x$5);
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                    this.key$1 = key$1;
                                                    this.x1$1 = x1$1;
                                                }
                                            });
                                            BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                                        } else {
                                            Class clazz12 = clazz;
                                            Class<Enumeration.Value> clazz13 = Enumeration.Value.class;
                                            if (!(clazz12 != null ? !clazz12.equals(clazz13) : clazz13 != null)) {
                                                ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$toCost(value).foreach((Function1)new Serializable(this, key, key2){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ anonfun.setHints.1 $outer;
                                                    private final String key$1;
                                                    private final Hints.Key x1$1;

                                                    public final void apply(Enumeration.Value x$6) {
                                                        ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$setHint(this.$outer.hints$2, this.key$1, this.x1$1, x$6);
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw null;
                                                        }
                                                        this.$outer = $outer;
                                                        this.key$1 = key$1;
                                                        this.x1$1 = x1$1;
                                                    }
                                                });
                                                BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
                                            } else {
                                                Class clazz14 = clazz;
                                                Class<SimpleFeatureType> clazz15 = SimpleFeatureType.class;
                                                if (!(clazz14 != null ? !clazz14.equals(clazz15) : clazz15 != null)) {
                                                    ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$toFeatureType(key, value).foreach((Function1)new Serializable(this, key, key2){
                                                        public static final long serialVersionUID = 0L;
                                                        private final /* synthetic */ anonfun.setHints.1 $outer;
                                                        private final String key$1;
                                                        private final Hints.Key x1$1;

                                                        public final void apply(SimpleFeatureType x$7) {
                                                            ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$setHint(this.$outer.hints$2, this.key$1, this.x1$1, x$7);
                                                        }
                                                        {
                                                            if ($outer == null) {
                                                                throw null;
                                                            }
                                                            this.$outer = $outer;
                                                            this.key$1 = key$1;
                                                            this.x1$1 = x1$1;
                                                        }
                                                    });
                                                    BoxedUnit boxedUnit9 = BoxedUnit.UNIT;
                                                } else {
                                                    BoxedUnit boxedUnit10;
                                                    if (ViewParams$.MODULE$.logger().underlying().isWarnEnabled()) {
                                                        ViewParams$.MODULE$.logger().underlying().warn("Unhandled hint type for '{}'", new Object[]{key});
                                                        boxedUnit10 = BoxedUnit.UNIT;
                                                    } else {
                                                        boxedUnit10 = BoxedUnit.UNIT;
                                                    }
                                                    BoxedUnit boxedUnit11 = boxedUnit10;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Throwable throwable) {
                        BoxedUnit boxedUnit12;
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (option.isEmpty()) {
                            throw throwable;
                        }
                        Throwable e = (Throwable)option.get();
                        if (ViewParams$.MODULE$.logger().underlying().isWarnEnabled()) {
                            ViewParams$.MODULE$.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error invoking query hint for ", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, value})), e);
                            boxedUnit12 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit12 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit13 = boxedUnit12;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit14 = boxedUnit;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            {
                this.hints$2 = hints$2;
                this.lookup$1 = lookup$1;
            }
        });
    }

    public void org$locationtech$geomesa$index$geoserver$ViewParams$$setHint(Hints hints, String name, Hints.Key hint, Object value) {
        Object old = hints.get((Object)hint);
        if (old == null) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Using query hint from geoserver view params: {}={}", new Object[]{name, value});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            hints.put((Object)hint, value);
        } else if (!BoxesRunTime.equals((Object)old, (Object)value)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder().append((Object)"Ignoring query hint from geoserver in favor of hint directly set in query. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using ", "=", " and disregarding ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, old, value}))).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Option<Enumeration.Value> org$locationtech$geomesa$index$geoserver$ViewParams$$toCost(String name) {
        void var3_3;
        BoxedUnit boxedUnit;
        String check = name.toLowerCase(Locale.US);
        Option value = QueryPlanner$CostEvaluation$.MODULE$.values().find((Function1)new Serializable(check){
            public static final long serialVersionUID = 0L;
            private final String check$1;

            public final boolean apply(Enumeration.Value x$8) {
                String string = x$8.toString().toLowerCase(Locale.US);
                String string2 = this.check$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.check$1 = check$1;
            }
        });
        if (value.isEmpty()) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignoring invalid cost type from view params: ", ". Valid values "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"are ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{QueryPlanner$CostEvaluation$.MODULE$.values().mkString(", ")}))).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    public String org$locationtech$geomesa$index$geoserver$ViewParams$$toString(ReferencedEnvelope env) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", ",", ",", ",", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)env.getMinX()), BoxesRunTime.boxToDouble((double)env.getMinY()), BoxesRunTime.boxToDouble((double)env.getMaxX()), BoxesRunTime.boxToDouble((double)env.getMaxY())}));
    }

    /*
     * WARNING - void declaration
     */
    public Option<ReferencedEnvelope> org$locationtech$geomesa$index$geoserver$ViewParams$$toEnvelope(String name, String geom) {
        void var3_3;
        BoxedUnit boxedUnit;
        Option value = this.fromBbox$1(geom).orElse((Function0)new Serializable(geom){
            public static final long serialVersionUID = 0L;
            private final String geom$1;

            public final Try<ReferencedEnvelope> apply() {
                return ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$fromWkt$1(this.geom$1);
            }
            {
                this.geom$1 = geom$1;
            }
        }).toOption();
        if (value.isEmpty()) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignoring invalid envelope from view params: ", "=", ". Envelope should be "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, geom}))).append((Object)"WKT or in the form [-180.0,-90.0,180.0,90.0]").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    public Option<Object> org$locationtech$geomesa$index$geoserver$ViewParams$$toInt(String name, String string) {
        Some some;
        try {
            some = new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(string)).toInt()));
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Ignoring invalid int type from view params: {}={}", (Object[])new String[]{name, string});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    public Option<Object> org$locationtech$geomesa$index$geoserver$ViewParams$$toFloat(String name, String string) {
        Some some;
        try {
            some = new Some((Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(string)).toFloat()));
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Ignoring invalid float type from view params: {}={}", (Object[])new String[]{name, string});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    public Option<Object> org$locationtech$geomesa$index$geoserver$ViewParams$$toBoolean(String name, String bool) {
        Some some;
        try {
            some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(bool)).toBoolean()));
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Ignoring invalid int type from view params: {}={}", (Object[])new String[]{name, bool});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    public Option<SimpleFeatureType> org$locationtech$geomesa$index$geoserver$ViewParams$$toFeatureType(String name, String sft) {
        Some some;
        try {
            some = new Some((Object)SimpleFeatureTypes$.MODULE$.deserialize(sft));
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Ignoring invalid simple feature type from view params: {}={}", (Object[])new String[]{name, sft});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    private ImmutableBiMap<String, Hints.Key> buildHintsMap(Object obj) {
        Method[] methods = (Method[])Predef$.MODULE$.refArrayOps((Object[])obj.getClass().getDeclaredMethods()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Method m) {
                return m.getParameterCount() == 0 && Hints.Key.class.isAssignableFrom(m.getReturnType());
            }
        });
        ImmutableBiMap.Builder map = ImmutableBiMap.builder();
        Predef$.MODULE$.refArrayOps((Object[])methods).foreach((Function1)new Serializable(obj, map){
            public static final long serialVersionUID = 0L;
            private final Object obj$1;
            private final ImmutableBiMap.Builder map$1;

            public final ImmutableBiMap.Builder<String, Hints.Key> apply(Method m) {
                return this.map$1.put((Object)m.getName().toUpperCase(Locale.US), (Object)((Hints.Key)m.invoke(this.obj$1, new Object[0])));
            }
            {
                this.obj$1 = obj$1;
                this.map$1 = map$1;
            }
        });
        return map.build();
    }

    private final Try fromBbox$1(String geom$1) {
        return Try$.MODULE$.apply((Function0)new Serializable(geom$1){
            public static final long serialVersionUID = 0L;
            private final String geom$1;

            public final ReferencedEnvelope apply() {
                String string = this.geom$1;
                Option option = ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$envelope().unapplySeq((CharSequence)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(8) == 0) {
                    Tuple4 tuple4;
                    String xmin = (String)((LinearSeqOptimized)option.get()).apply(0);
                    String ymin = (String)((LinearSeqOptimized)option.get()).apply(2);
                    String xmax = (String)((LinearSeqOptimized)option.get()).apply(4);
                    String ymax = (String)((LinearSeqOptimized)option.get()).apply(6);
                    Tuple4 tuple42 = tuple4 = new Tuple4((Object)xmin, (Object)ymin, (Object)xmax, (Object)ymax);
                    String xmin2 = (String)tuple42._1();
                    String ymin2 = (String)tuple42._2();
                    String xmax2 = (String)tuple42._3();
                    String ymax2 = (String)tuple42._4();
                    return new ReferencedEnvelope(new StringOps(Predef$.MODULE$.augmentString(xmin2)).toDouble(), new StringOps(Predef$.MODULE$.augmentString(xmax2)).toDouble(), new StringOps(Predef$.MODULE$.augmentString(ymin2)).toDouble(), new StringOps(Predef$.MODULE$.augmentString(ymax2)).toDouble(), package$.MODULE$.CRS_EPSG_4326());
                }
                throw new MatchError((Object)string);
            }
            {
                this.geom$1 = geom$1;
            }
        });
    }

    public final Try org$locationtech$geomesa$index$geoserver$ViewParams$$fromWkt$1(String geom$1) {
        return Try$.MODULE$.apply((Function0)new Serializable(geom$1){
            public static final long serialVersionUID = 0L;
            private final String geom$1;

            public final ReferencedEnvelope apply() {
                return new ReferencedEnvelope(WKTUtils$.MODULE$.read(this.geom$1).getEnvelopeInternal(), package$.MODULE$.CRS_EPSG_4326());
            }
            {
                this.geom$1 = geom$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private ViewParams$() {
        void var1_1;
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.QueryHintMap = this.buildHintsMap(QueryHints$.MODULE$);
        this.org$locationtech$geomesa$index$geoserver$ViewParams$$InternalHintMap = this.buildHintsMap(QueryHints$Internal$.MODULE$);
        HashMap<String, Hints.Key> map = new HashMap<String, Hints.Key>();
        map.putAll((java.util.Map<String, Hints.Key>)this.QueryHintMap());
        map.putAll((java.util.Map<String, Hints.Key>)this.org$locationtech$geomesa$index$geoserver$ViewParams$$InternalHintMap());
        this.AllHintsMap = var1_1;
        this.org$locationtech$geomesa$index$geoserver$ViewParams$$envelope = new StringOps(Predef$.MODULE$.augmentString("\\[\\s*(-?\\d+(\\.\\d+)?),\\s*(-?\\d+(\\.\\d+)?),\\s*(-?\\d+(\\.\\d+)?),\\s*(-?\\d+(\\.\\d+)?)\\s*]")).r();
    }
}

