/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.s3;

import com.google.common.geometry.S2CellId;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.time.ZonedDateTime;
import java.util.Date;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.S2SFC;
import org.locationtech.geomesa.curve.S2SFC$;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.api.IndexKeySpace;
import org.locationtech.geomesa.index.api.IndexKeySpace$class;
import org.locationtech.geomesa.index.api.ShardStrategy;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.api.package$ByteRange$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.s3.S3IndexKeySpace$;
import org.locationtech.geomesa.index.index.s3.S3IndexKeySpace$$anonfun$5$;
import org.locationtech.geomesa.index.index.s3.package;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.sfcurve.IndexRange;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tMe\u0001B\u0001\u0003\u00019\u0011qbU\u001aJ]\u0012,\u0007pS3z'B\f7-\u001a\u0006\u0003\u0007\u0011\t!a]\u001a\u000b\u0005\u00151\u0011!B5oI\u0016D(BA\u0003\b\u0015\tA\u0011\"A\u0004hK>lWm]1\u000b\u0005)Y\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001yQC\n\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\tYI2dI\u0007\u0002/)\u0011\u0001DB\u0001\u0004CBL\u0017B\u0001\u000e\u0018\u00055Ie\u000eZ3y\u0017\u0016L8\u000b]1dKB\u0011A\u0004\t\b\u0003;yi\u0011AA\u0005\u0003?\t\tq\u0001]1dW\u0006<W-\u0003\u0002\"E\ti1kM%oI\u0016Dh+\u00197vKNT!a\b\u0002\u0011\u0005q!\u0013BA\u0013#\u0005)\u00196'\u00138eKb\\U-\u001f\t\u0003O9j\u0011\u0001\u000b\u0006\u0003S)\nAb]2bY\u0006dwnZ4j]\u001eT!a\u000b\u0017\u0002\u0011QL\b/Z:bM\u0016T\u0011!L\u0001\u0004G>l\u0017BA\u0018)\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u0011E\u0002!Q1A\u0005\u0002I\n1a\u001d4u+\u0005\u0019\u0004C\u0001\u001b<\u001b\u0005)$B\u0001\u001c8\u0003\u0019\u0019\u0018.\u001c9mK*\u0011\u0001(O\u0001\bM\u0016\fG/\u001e:f\u0015\tQ4\"A\u0004pa\u0016tw-[:\n\u0005q*$!E*j[BdWMR3biV\u0014X\rV=qK\"Aa\b\u0001B\u0001B\u0003%1'\u0001\u0003tMR\u0004\u0003\u0002\u0003!\u0001\u0005\u000b\u0007I\u0011A!\u0002\u0011MD\u0017M\u001d3j]\u001e,\u0012A\u0011\t\u0003-\rK!\u0001R\f\u0003\u001bMC\u0017M\u001d3TiJ\fG/Z4z\u0011!1\u0005A!A!\u0002\u0013\u0011\u0015!C:iCJ$\u0017N\\4!\u0011!A\u0005A!A!\u0002\u0013I\u0015!C4f_64\u0015.\u001a7e!\tQUJ\u0004\u0002\u0011\u0017&\u0011A*E\u0001\u0007!J,G-\u001a4\n\u00059{%AB*ue&twM\u0003\u0002M#!A\u0011\u000b\u0001B\u0001B\u0003%\u0011*\u0001\u0005ei\u001e4\u0015.\u001a7e\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0003\u0019a\u0014N\\5u}Q)QKV,Y3B\u0011Q\u0004\u0001\u0005\u0006cI\u0003\ra\r\u0005\u0006\u0001J\u0003\rA\u0011\u0005\u0006\u0011J\u0003\r!\u0013\u0005\u0006#J\u0003\r!\u0013\u0005\b7\u0002\u0011\r\u0011\"\u0003]\u0003\r\u0019hmY\u000b\u0002;B\u0011a,Y\u0007\u0002?*\u0011\u0001mB\u0001\u0006GV\u0014h/Z\u0005\u0003E~\u0013Qa\u0015\u001aT\r\u000eCa\u0001\u001a\u0001!\u0002\u0013i\u0016\u0001B:gG\u0002BqA\u001a\u0001C\u0002\u0013%q-A\u0005hK>l\u0017J\u001c3fqV\t\u0001\u000e\u0005\u0002\u0011S&\u0011!.\u0005\u0002\u0004\u0013:$\bB\u00027\u0001A\u0003%\u0001.\u0001\u0006hK>l\u0017J\u001c3fq\u0002BqA\u001c\u0001C\u0002\u0013%q-\u0001\u0005ei\u001eLe\u000eZ3y\u0011\u0019\u0001\b\u0001)A\u0005Q\u0006IA\r^4J]\u0012,\u0007\u0010\t\u0005\be\u0002\u0011\r\u0011\"\u0003t\u0003-!\u0018.\\3U_&sG-\u001a=\u0016\u0003Q\u00042!^A\u0004\u001d\r1\u00181\u0001\b\u0004o\u0006\u0005aB\u0001=\u0000\u001d\tIhP\u0004\u0002{{6\t1P\u0003\u0002}\u001b\u00051AH]8pizJ\u0011\u0001D\u0005\u0003\u0015-I!\u0001C\u0005\n\u0005\u0001<\u0011bAA\u0003?\u0006Q!)\u001b8oK\u0012$\u0016.\\3\n\t\u0005%\u00111\u0002\u0002\u0011)&lW\rV8CS:tW\r\u001a+j[\u0016T1!!\u0002`\u0011\u001d\ty\u0001\u0001Q\u0001\nQ\fA\u0002^5nKR{\u0017J\u001c3fq\u0002B\u0001\"a\u0005\u0001\u0005\u0004%IaZ\u0001\b[\u0006DH+[7f\u0011\u001d\t9\u0002\u0001Q\u0001\n!\f\u0001\"\\1y)&lW\r\t\u0005\n\u00037\u0001!\u0019!C\u0005\u0003;\t1\u0002Z1uKR{\u0017J\u001c3fqV\u0011\u0011q\u0004\t\u0005\u0003C\t\u0019CD\u0002_\u0003\u0007IA!!\n\u0002\f\t\u0001B)\u0019;f)>\u0014\u0015N\u001c8fIRKW.\u001a\u0005\t\u0003S\u0001\u0001\u0015!\u0003\u0002 \u0005aA-\u0019;f)>Le\u000eZ3yA!I\u0011Q\u0006\u0001C\u0002\u0013%\u0011qF\u0001\u000eE>,h\u000eZ:U_\u0012\u000bG/Z:\u0016\u0005\u0005E\u0002c\u0002\t\u00024\u0005]\u00121K\u0005\u0004\u0003k\t\"!\u0003$v]\u000e$\u0018n\u001c82!\u001d\u0001\u0012\u0011HA\u001f\u0003{I1!a\u000f\u0012\u0005\u0019!V\u000f\u001d7feA)\u0001#a\u0010\u0002D%\u0019\u0011\u0011I\t\u0003\r=\u0003H/[8o!\u0011\t)%a\u0014\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\nA\u0001^5nK*\u0011\u0011QJ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002R\u0005\u001d#!\u0004.p]\u0016$G)\u0019;f)&lW\rE\u0004\u0011\u0003s\t\u0019%a\u0011\t\u0011\u0005]\u0003\u0001)A\u0005\u0003c\taBY8v]\u0012\u001cHk\u001c#bi\u0016\u001c\b\u0005C\u0005\u0002\\\u0001\u0011\r\u0011\"\u0011\u0002^\u0005Q\u0011\r\u001e;sS\n,H/Z:\u0016\u0005\u0005}\u0003#BA1\u0003SJe\u0002BA2\u0003Or1A_A3\u0013\u0005\u0011\u0012BA\u0010\u0012\u0013\u0011\tY'!\u001c\u0003\u0007M+\u0017O\u0003\u0002 #!A\u0011\u0011\u000f\u0001!\u0002\u0013\ty&A\u0006biR\u0014\u0018NY;uKN\u0004\u0003\"CA;\u0001\t\u0007I\u0011IA<\u0003IIg\u000eZ3y\u0017\u0016L()\u001f;f\u0019\u0016tw\r\u001e5\u0016\u0005\u0005e\u0004cBA1\u0003w\ny\b[\u0005\u0005\u0003{\niGA\u0003SS\u001eDG\u000f\u0005\u0005\u0011\u0003\u0003\u000b)\t\u001b5i\u0013\r\t\u0019)\u0005\u0002\n\rVt7\r^5p]N\u0002R\u0001EAD\u0003\u0017K1!!#\u0012\u0005\u0015\t%O]1z!\r\u0001\u0012QR\u0005\u0004\u0003\u001f\u000b\"\u0001\u0002\"zi\u0016D\u0001\"a%\u0001A\u0003%\u0011\u0011P\u0001\u0014S:$W\r_&fs\nKH/\u001a'f]\u001e$\b\u000e\t\u0005\n\u0003/\u0003!\u0019!C!\u00033\u000bqa\u001d5be&tw-\u0006\u0002\u0002\u0006\"A\u0011Q\u0014\u0001!\u0002\u0013\t))\u0001\u0005tQ\u0006\u0014\u0018N\\4!\u0011\u001d\t\t\u000b\u0001C!\u0003G\u000b!\u0002^8J]\u0012,\u0007pS3z))\t)+!/\u0002D\u0006\u001d\u00171\u001a\t\u0006\u0003O\u000b\u0019l\t\b\u0005\u0003S\u000b\tL\u0004\u0003\u0002,\u0006=fbA<\u0002.&\u0011QaB\u0005\u00031\u0019I!aH\f\n\t\u0005U\u0016q\u0017\u0002\f%><8*Z=WC2,XM\u0003\u0002 /!A\u00111XAP\u0001\u0004\ti,\u0001\u0005xe&$\u0018M\u00197f!\r1\u0012qX\u0005\u0004\u0003\u0003<\"aD,sSR\f'\r\\3GK\u0006$XO]3\t\u0011\u0005\u0015\u0017q\u0014a\u0001\u0003\u000b\u000bA\u0001^5fe\"A\u0011\u0011ZAP\u0001\u0004\t))\u0001\u0002jI\"Q\u0011QZAP!\u0003\u0005\r!a4\u0002\u000f1,g.[3oiB\u0019\u0001#!5\n\u0007\u0005M\u0017CA\u0004C_>dW-\u00198\t\u000f\u0005]\u0007\u0001\"\u0011\u0002Z\u0006qq-\u001a;J]\u0012,\u0007PV1mk\u0016\u001cH#B\u000e\u0002\\\u0006%\b\u0002CAo\u0003+\u0004\r!a8\u0002\r\u0019LG\u000e^3s!\u0011\t\t/!:\u000e\u0005\u0005\r(bAAos%!\u0011q]Ar\u0005\u00191\u0015\u000e\u001c;fe\"A\u00111^Ak\u0001\u0004\ti/A\u0004fqBd\u0017-\u001b8\u0011\t\u0005=\u0018Q_\u0007\u0003\u0003cT1!a=\u0007\u0003\u0015)H/\u001b7t\u0013\u0011\t90!=\u0003\u0013\u0015C\b\u000f\\1j]\u0016\u0014\bbBA~\u0001\u0011\u0005\u0013Q`\u0001\nO\u0016$(+\u00198hKN$b!a@\u0003\f\t=\u0001CBA1\u0005\u0003\u0011)!\u0003\u0003\u0003\u0004\u00055$\u0001C%uKJ\fGo\u001c:\u0011\u000b\u0005\u001d&qA\u0012\n\t\t%\u0011q\u0017\u0002\n'\u000e\fgNU1oO\u0016DqA!\u0004\u0002z\u0002\u00071$\u0001\u0004wC2,Xm\u001d\u0005\n\u0005#\tI\u0010%AA\u0002!\f!\"\\;mi&\u0004H.[3s\u0011\u001d\u0011)\u0002\u0001C!\u0005/\tQbZ3u%\u0006tw-\u001a\"zi\u0016\u001cHC\u0002B\r\u0005C\u0011)\u0003\u0005\u0004\u0002b\t\u0005!1\u0004\t\u0005\u0003O\u0013i\"\u0003\u0003\u0003 \u0005]&!\u0003\"zi\u0016\u0014\u0016M\\4f\u0011!\u0011\u0019Ca\u0005A\u0002\u0005}\u0018A\u0002:b]\u001e,7\u000f\u0003\u0006\u0002F\nM\u0001\u0013!a\u0001\u0003\u001fDqA!\u000b\u0001\t\u0003\u0012Y#A\u0007vg\u00164U\u000f\u001c7GS2$XM\u001d\u000b\t\u0003\u001f\u0014iC!\r\u0003L!A!Q\u0002B\u0014\u0001\u0004\u0011y\u0003\u0005\u0003\u0011\u0003\u007fY\u0002\u0002\u0003B\u001a\u0005O\u0001\rA!\u000e\u0002\r\r|gNZ5h!\u0015\u0001\u0012q\bB\u001c!\u0011\u0011ID!\u0012\u000f\t\tm\"\u0011I\u0007\u0003\u0005{Q1Aa\u0010\u0007\u0003!9Wm\u001c;p_2\u001c\u0018\u0002\u0002B\"\u0005{\tqcR3p\u001b\u0016\u001c\u0018\rR1uCN#xN]3GC\u000e$xN]=\n\t\t\u001d#\u0011\n\u0002\u0017\u000f\u0016|W*Z:b\t\u0006$\u0018m\u0015;pe\u0016\u001cuN\u001c4jO*!!1\tB\u001f\u0011!\u0011iEa\nA\u0002\t=\u0013!\u00025j]R\u001c\b\u0003\u0002B)\u0005;j!Aa\u0015\u000b\t\tU#qK\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\u0011IFa\u0017\u0002\tU$\u0018\u000e\u001c\u0006\u0004\u0005\u007fY\u0011\u0002\u0002B0\u0005'\u0012Q\u0001S5oiN<qAa\u0019\u0003\u0011\u0003\u0011)'A\bTg%sG-\u001a=LKf\u001c\u0006/Y2f!\ri\"q\r\u0004\u0007\u0003\tA\tA!\u001b\u0014\u000b\t\u001dtBa\u001b\u0011\r\t5$1O\u000e$\u001d\u0011\tIKa\u001c\n\u0007\tEt#A\u0007J]\u0012,\u0007pS3z'B\f7-Z\u0005\u0005\u0005k\u00129H\u0001\u000bJ]\u0012,\u0007pS3z'B\f7-\u001a$bGR|'/\u001f\u0006\u0004\u0005c:\u0002bB*\u0003h\u0011\u0005!1\u0010\u000b\u0003\u0005KB\u0001Ba \u0003h\u0011\u0005#\u0011Q\u0001\tgV\u0004\bo\u001c:ugR1\u0011q\u001aBB\u0005\u000bCa!\rB?\u0001\u0004\u0019\u0004\u0002CA.\u0005{\u0002\r!a\u0018\t\u0011\t%%q\rC!\u0005\u0017\u000bQ!\u00199qYf$r!\u0016BG\u0005\u001f\u0013\t\n\u0003\u00042\u0005\u000f\u0003\ra\r\u0005\t\u00037\u00129\t1\u0001\u0002`!A\u0011Q\u0019BD\u0001\u0004\ty\r")
public class S3IndexKeySpace
implements IndexKeySpace<package.S3IndexValues, package.S3IndexKey>,
LazyLogging {
    private final SimpleFeatureType sft;
    private final ShardStrategy sharding;
    public final String org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$geomField;
    public final String org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$dtgField;
    private final S2SFC sfc;
    private final int geomIndex;
    private final int dtgIndex;
    private final Function1<Object, BinnedTime> timeToIndex;
    private final int org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$maxTime;
    private final Function1<ZonedDateTime, BinnedTime> org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$dateToIndex;
    private final Function1<Tuple2<Option<ZonedDateTime>, Option<ZonedDateTime>>, Tuple2<ZonedDateTime, ZonedDateTime>> org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$boundsToDates;
    private final Seq<String> attributes;
    private final Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength;
    private final byte[] sharing;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static S3IndexKeySpace apply(SimpleFeatureType simpleFeatureType, Seq<String> seq, boolean bl) {
        return S3IndexKeySpace$.MODULE$.apply(simpleFeatureType, (Seq)seq, bl);
    }

    public static boolean supports(SimpleFeatureType simpleFeatureType, Seq<String> seq) {
        return S3IndexKeySpace$.MODULE$.supports(simpleFeatureType, seq);
    }

    private Logger logger$lzycompute() {
        S3IndexKeySpace s3IndexKeySpace = this;
        synchronized (s3IndexKeySpace) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public int getRanges$default$2() {
        return IndexKeySpace$class.getRanges$default$2(this);
    }

    @Override
    public boolean getRangeBytes$default$2() {
        return IndexKeySpace$class.getRangeBytes$default$2(this);
    }

    @Override
    public boolean toIndexKey$default$4() {
        return IndexKeySpace$class.toIndexKey$default$4(this);
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    @Override
    public ShardStrategy sharding() {
        return this.sharding;
    }

    private S2SFC sfc() {
        return this.sfc;
    }

    private int geomIndex() {
        return this.geomIndex;
    }

    private int dtgIndex() {
        return this.dtgIndex;
    }

    private Function1<Object, BinnedTime> timeToIndex() {
        return this.timeToIndex;
    }

    public int org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$maxTime() {
        return this.org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$maxTime;
    }

    public Function1<ZonedDateTime, BinnedTime> org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$dateToIndex() {
        return this.org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$dateToIndex;
    }

    public Function1<Tuple2<Option<ZonedDateTime>, Option<ZonedDateTime>>, Tuple2<ZonedDateTime, ZonedDateTime>> org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$boundsToDates() {
        return this.org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$boundsToDates;
    }

    @Override
    public Seq<String> attributes() {
        return this.attributes;
    }

    public Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength() {
        return this.indexKeyByteLength;
    }

    @Override
    public byte[] sharing() {
        return this.sharing;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public package.RowKeyValue<package.S3IndexKey> toIndexKey(WritableFeature writable, byte[] tier, byte[] id, boolean lenient) {
        byte[] shard;
        S2CellId s;
        Tuple2 tuple2;
        Point geom = (Point)writable.getAttribute(this.geomIndex());
        if (geom == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Null geometry in feature ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writable.feature().getID()})));
        }
        Date dtg = (Date)writable.getAttribute(this.dtgIndex());
        long time = dtg == null ? 0L : dtg.getTime();
        BinnedTime binnedTime = (BinnedTime)this.timeToIndex().apply((Object)BoxesRunTime.boxToLong((long)time));
        if (binnedTime == null) throw new MatchError((Object)binnedTime);
        short b = binnedTime.bin();
        long t = binnedTime.offset();
        Tuple2 tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)b), (Object)BoxesRunTime.boxToLong((long)t));
        short b2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
        long t2 = tuple22._2$mcJ$sp();
        try {
            s = this.sfc().index(geom.getX(), geom.getY(), lenient);
            shard = this.sharding().apply(writable);
        }
        catch (Throwable throwable) {
            void var6_6;
            void var5_5;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid s value from geometry/time: ", ",", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var5_5, var6_6})), e);
        }
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(shard.length + 14 + id.length, ClassTag$.MODULE$.Byte());
        if (Predef$.MODULE$.byteArrayOps(shard).isEmpty()) {
            ByteArrays$.MODULE$.writeShort(b2, bytes, ByteArrays$.MODULE$.writeShort$default$3());
            ByteArrays$.MODULE$.writeLong(s.id(), bytes, 2);
            ByteArrays$.MODULE$.writeInt((int)t2, bytes, 10);
            System.arraycopy(id, 0, bytes, 14, id.length);
            return new package.SingleRowKeyValue<package.S3IndexKey>(bytes, this.sharing(), shard, new package.S3IndexKey(b2, s.id(), (int)t2), tier, id, writable.values());
        } else {
            bytes[0] = BoxesRunTime.unboxToByte((Object)Predef$.MODULE$.byteArrayOps(shard).head());
            ByteArrays$.MODULE$.writeShort(b2, bytes, 1);
            ByteArrays$.MODULE$.writeLong(s.id(), bytes, 3);
            ByteArrays$.MODULE$.writeInt((int)t2, bytes, 11);
            System.arraycopy(id, 0, bytes, 15, id.length);
        }
        return new package.SingleRowKeyValue<package.S3IndexKey>(bytes, this.sharing(), shard, new package.S3IndexKey(b2, s.id(), (int)t2), tier, id, writable.values());
    }

    @Override
    public package.S3IndexValues getIndexValues(Filter filter2, Explainer explain) {
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter2, this.org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$geomField, FilterHelper$.MODULE$.extractGeometries$default$3());
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Polygon[]{org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon()})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        Filter x$8 = filter2;
        String x$9 = this.org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$dtgField;
        boolean x$10 = true;
        boolean x$11 = FilterHelper$.MODULE$.extractIntervals$default$3();
        FilterValues intervals = FilterHelper$.MODULE$.extractIntervals(x$8, x$9, x$11, x$10);
        explain.apply((Function0<String>)new Serializable(this, geometries){
            public static final long serialVersionUID = 0L;
            private final FilterValues geometries$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geometries: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.geometries$1}));
            }
            {
                this.geometries$1 = geometries$1;
            }
        });
        explain.apply((Function0<String>)new Serializable(this, intervals){
            public static final long serialVersionUID = 0L;
            private final FilterValues intervals$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Intervals: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.intervals$1}));
            }
            {
                this.intervals$1 = intervals$1;
            }
        });
        if (geometries.disjoint() || intervals.disjoint()) {
            explain.apply((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Disjoint geometries or dates extracted, short-circuiting to empty query";
                }
            });
            return new package.S3IndexValues(this.sfc(), this.org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$maxTime(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)((Seq)Seq$.MODULE$.empty()), (FilterValues<Bounds<ZonedDateTime>>)intervals, (Map<Object, Seq<Tuple2<Object, Object>>>)Predef$.MODULE$.Map().empty(), (Seq<Tuple2<Object, Object>>)((Seq)Seq$.MODULE$.empty()));
        }
        int multiplier = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompMultiplier().toInt().get());
        int bits = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompBits().toInt().get());
        Seq xy = (Seq)geometries.values().flatMap((Function1)new Serializable(this, multiplier, bits){
            public static final long serialVersionUID = 0L;
            private final int multiplier$1;
            private final int bits$1;

            public final Seq<Tuple4<Object, Object, Object, Object>> apply(Geometry x$2) {
                return GeometryUtils$.MODULE$.bounds(x$2, this.multiplier$1, this.bits$1);
            }
            {
                this.multiplier$1 = multiplier$1;
                this.bits$1 = bits$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        scala.collection.mutable.Map timesByBin = Map$.MODULE$.empty().withDefaultValue((Object)Seq$.MODULE$.empty());
        Builder unboundedBins = Seq$.MODULE$.newBuilder();
        intervals.foreach((Function1)new Serializable(this, timesByBin, unboundedBins){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3IndexKeySpace $outer;
            public final scala.collection.mutable.Map timesByBin$1;
            private final Builder unboundedBins$1;

            public final Object apply(Bounds<ZonedDateTime> interval) {
                Tuple2 tuple2 = (Tuple2)this.$outer.org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$boundsToDates().apply((Object)interval.bounds());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    ZonedDateTime lower = (ZonedDateTime)tuple2._1();
                    ZonedDateTime upper = (ZonedDateTime)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)lower, (Object)upper);
                    ZonedDateTime lower2 = (ZonedDateTime)tuple23._1();
                    ZonedDateTime upper2 = (ZonedDateTime)tuple23._2();
                    BinnedTime binnedTime = (BinnedTime)this.$outer.org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$dateToIndex().apply((Object)lower2);
                    if (binnedTime != null) {
                        Tuple2 tuple24;
                        short lb = binnedTime.bin();
                        long lt = binnedTime.offset();
                        Tuple2 tuple25 = tuple24 = new Tuple2((Object)BoxesRunTime.boxToShort((short)lb), (Object)BoxesRunTime.boxToLong((long)lt));
                        short lb2 = BoxesRunTime.unboxToShort((Object)tuple25._1());
                        long lt2 = tuple25._2$mcJ$sp();
                        BinnedTime binnedTime2 = (BinnedTime)this.$outer.org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$dateToIndex().apply((Object)upper2);
                        if (binnedTime2 != null) {
                            BoxedUnit boxedUnit;
                            Tuple2 tuple26;
                            short ub = binnedTime2.bin();
                            long ut = binnedTime2.offset();
                            Tuple2 tuple27 = tuple26 = new Tuple2((Object)BoxesRunTime.boxToShort((short)ub), (Object)BoxesRunTime.boxToLong((long)ut));
                            short ub2 = BoxesRunTime.unboxToShort((Object)tuple27._1());
                            long ut2 = tuple27._2$mcJ$sp();
                            if (interval.isBoundedBothSides()) {
                                if (lb2 == ub2) {
                                    this.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)lb2), ((TraversableLike)this.timesByBin$1.apply((Object)BoxesRunTime.boxToShort((short)lb2))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp((int)lt2, (int)ut2)})), Seq$.MODULE$.canBuildFrom()));
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    this.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)lb2), ((TraversableLike)this.timesByBin$1.apply((Object)BoxesRunTime.boxToShort((short)lb2))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp((int)lt2, this.$outer.org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$maxTime())})), Seq$.MODULE$.canBuildFrom()));
                                    this.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)ub2), ((TraversableLike)this.timesByBin$1.apply((Object)BoxesRunTime.boxToShort((short)ub2))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(0, (int)ut2)})), Seq$.MODULE$.canBuildFrom()));
                                    package$.MODULE$.Range().inclusive(lb2 + 1, ub2 - 1).foreach$mVc$sp((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$getIndexValues$4 $outer;

                                        public final void apply(int b) {
                                            this.apply$mcVI$sp(b);
                                        }

                                        public void apply$mcVI$sp(int b) {
                                            this.$outer.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)((short)b)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(0, this.$outer.org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$anonfun$$$outer().org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$maxTime())})));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                            } else if (interval.lower().value().isDefined()) {
                                this.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)lb2), ((TraversableLike)this.timesByBin$1.apply((Object)BoxesRunTime.boxToShort((short)lb2))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp((int)lt2, this.$outer.org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$maxTime())})), Seq$.MODULE$.canBuildFrom()));
                                boxedUnit = this.unboundedBins$1.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)((short)(lb2 + 1))), (Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)));
                            } else if (interval.upper().value().isDefined()) {
                                this.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)ub2), ((TraversableLike)this.timesByBin$1.apply((Object)BoxesRunTime.boxToShort((short)ub2))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(0, (int)ut2)})), Seq$.MODULE$.canBuildFrom()));
                                boxedUnit = this.unboundedBins$1.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)0), (Object)BoxesRunTime.boxToShort((short)((short)(ub2 - 1)))));
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            return boxedUnit;
                        }
                        throw new MatchError((Object)binnedTime2);
                    }
                    throw new MatchError((Object)binnedTime);
                }
                throw new MatchError((Object)tuple2);
            }

            public /* synthetic */ S3IndexKeySpace org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timesByBin$1 = timesByBin$1;
                this.unboundedBins$1 = unboundedBins$1;
            }
        });
        return new package.S3IndexValues(this.sfc(), this.org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$maxTime(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy, (FilterValues<Bounds<ZonedDateTime>>)intervals, (Map<Object, Seq<Tuple2<Object, Object>>>)timesByBin.toMap(Predef$.MODULE$.$conforms()), (Seq<Tuple2<Object, Object>>)((Seq)unboundedBins.result()));
    }

    @Override
    public Iterator<package.ScanRange<package.S3IndexKey>> getRanges(package.S3IndexValues values2, int multiplier) {
        package.S3IndexValues s3IndexValues = values2;
        if (s3IndexValues != null) {
            Tuple4 tuple4;
            S2SFC s3 = s3IndexValues.sfc();
            Seq<Tuple4<Object, Object, Object, Object>> xy = s3IndexValues.spatialBounds();
            Map<Object, Seq<Tuple2<Object, Object>>> timesByBin = s3IndexValues.temporalBounds();
            Seq<Tuple2<Object, Object>> unboundedBins = s3IndexValues.temporalUnbounded();
            Tuple4 tuple42 = tuple4 = new Tuple4((Object)s3, xy, timesByBin, unboundedBins);
            S2SFC s32 = (S2SFC)tuple42._1();
            Seq xy2 = (Seq)tuple42._2();
            Map timesByBin2 = (Map)tuple42._3();
            Seq unboundedBins2 = (Seq)tuple42._4();
            Option target = QueryProperties$.MODULE$.ScanRangesTarget().option().map((Function1)new Serializable(this, multiplier, timesByBin2){
                public static final long serialVersionUID = 0L;
                private final int multiplier$2;
                private final Map timesByBin$2;

                public final int apply(String t) {
                    return scala.math.package$.MODULE$.max(1, this.timesByBin$2.isEmpty() ? new StringOps(Predef$.MODULE$.augmentString(t)).toInt() : new StringOps(Predef$.MODULE$.augmentString(t)).toInt() / this.timesByBin$2.size() / this.multiplier$2);
                }
                {
                    this.multiplier$2 = multiplier$2;
                    this.timesByBin$2 = timesByBin$2;
                }
            });
            Seq s2CellId = s32.ranges(xy2, -1, target);
            Iterator bounded = timesByBin2.iterator().flatMap((Function1)new Serializable(this, s2CellId){
                public static final long serialVersionUID = 0L;
                public final Seq s2CellId$1;

                public final Seq<package.BoundedRange<package.S3IndexKey>> apply(Tuple2<Object, Seq<Tuple2<Object, Object>>> x0$1) {
                    Tuple2<Object, Seq<Tuple2<Object, Object>>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        short bin = BoxesRunTime.unboxToShort((Object)tuple2._1());
                        Seq times = (Seq)tuple2._2();
                        Seq seq = (Seq)times.flatMap((Function1)new Serializable(this, bin){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$5 $outer;
                            public final short bin$1;

                            public final Seq<package.BoundedRange<package.S3IndexKey>> apply(Tuple2<Object, Object> time) {
                                return (Seq)this.$outer.s2CellId$1.map((Function1)new Serializable(this, time){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$5$$anonfun$apply$2 $outer;
                                    private final Tuple2 time$1;

                                    public final package.BoundedRange<package.S3IndexKey> apply(IndexRange s) {
                                        return new package.BoundedRange<package.S3IndexKey>(new package.S3IndexKey(this.$outer.bin$1, s.lower(), this.time$1._1$mcI$sp()), new package.S3IndexKey(this.$outer.bin$1, s.upper(), this.time$1._2$mcI$sp()));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.time$1 = time$1;
                                    }
                                }, Seq$.MODULE$.canBuildFrom());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.bin$1 = bin$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        return seq;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.s2CellId$1 = s2CellId$1;
                }
            });
            Iterator unbounded = unboundedBins2.iterator().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ S3IndexKeySpace $outer;

                public final Product apply(Tuple2<Object, Object> x0$2) {
                    Tuple2<Object, Object> tuple2;
                    block9: {
                        Product product;
                        block6: {
                            BoxedUnit boxedUnit;
                            block8: {
                                block7: {
                                    block5: {
                                        tuple2 = x0$2;
                                        if (tuple2 == null) break block5;
                                        short s = BoxesRunTime.unboxToShort((Object)tuple2._1());
                                        short s2 = BoxesRunTime.unboxToShort((Object)tuple2._2());
                                        if (0 != s || Short.MAX_VALUE != s2) break block5;
                                        product = new package.UnboundedRange<package.S3IndexKey>(new package.S3IndexKey(0, 0L, 0));
                                        break block6;
                                    }
                                    if (tuple2 == null) break block7;
                                    short lower = BoxesRunTime.unboxToShort((Object)tuple2._1());
                                    short s = BoxesRunTime.unboxToShort((Object)tuple2._2());
                                    if (Short.MAX_VALUE != s) break block7;
                                    product = new package.LowerBoundedRange<package.S3IndexKey>(new package.S3IndexKey(lower, 0L, 0));
                                    break block6;
                                }
                                if (tuple2 == null) break block8;
                                short s = BoxesRunTime.unboxToShort((Object)tuple2._1());
                                short upper = BoxesRunTime.unboxToShort((Object)tuple2._2());
                                if (0 != s) break block8;
                                product = new package.UpperBoundedRange<package.S3IndexKey>(new package.S3IndexKey(upper, 0L, Integer.MAX_VALUE));
                                break block6;
                            }
                            if (tuple2 == null) break block9;
                            short lower = BoxesRunTime.unboxToShort((Object)tuple2._1());
                            short upper = BoxesRunTime.unboxToShort((Object)tuple2._2());
                            if (this.$outer.logger().underlying().isErrorEnabled()) {
                                this.$outer.logger().underlying().error("Unexpected unbounded bin endpoints: {}:{}", new Object[]{BoxesRunTime.boxToShort((short)lower), BoxesRunTime.boxToShort((short)upper)});
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            product = new package.UnboundedRange<package.S3IndexKey>(new package.S3IndexKey(0, 0L, 0));
                        }
                        return product;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return bounded.$plus$plus((Function0)new Serializable(this, unbounded){
                public static final long serialVersionUID = 0L;
                private final Iterator unbounded$1;

                public final Iterator<Product> apply() {
                    return this.unbounded$1;
                }
                {
                    this.unbounded$1 = unbounded$1;
                }
            });
        }
        throw new MatchError((Object)s3IndexValues);
    }

    @Override
    public Iterator<package.ByteRange> getRangeBytes(Iterator<package.ScanRange<package.S3IndexKey>> ranges, boolean tier) {
        return this.sharding().length() == 0 ? ranges.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final package.ByteRange apply(package.ScanRange<package.S3IndexKey> x0$3) {
                package.ScanRange<package.S3IndexKey> scanRange;
                block6: {
                    package.BoundedByteRange boundedByteRange;
                    block3: {
                        block5: {
                            block4: {
                                block2: {
                                    scanRange = x0$3;
                                    if (!(scanRange instanceof package.BoundedRange)) break block2;
                                    package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                                    package.S3IndexKey lo = (package.S3IndexKey)boundedRange.lower();
                                    package.S3IndexKey hi = (package.S3IndexKey)boundedRange.upper();
                                    byte[] lower = ByteArrays$.MODULE$.toBytes(lo.bin(), lo.s(), lo.offset());
                                    byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.s(), hi.offset());
                                    boundedByteRange = new package.BoundedByteRange(lower, upper);
                                    break block3;
                                }
                                if (!(scanRange instanceof package.LowerBoundedRange)) break block4;
                                package.LowerBoundedRange lowerBoundedRange = (package.LowerBoundedRange)scanRange;
                                package.S3IndexKey lo = (package.S3IndexKey)lowerBoundedRange.lower();
                                boundedByteRange = new package.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo.bin(), lo.s(), lo.offset()), package$ByteRange$.MODULE$.UnboundedUpperRange());
                                break block3;
                            }
                            if (!(scanRange instanceof package.UpperBoundedRange)) break block5;
                            package.UpperBoundedRange upperBoundedRange = (package.UpperBoundedRange)scanRange;
                            package.S3IndexKey hi = (package.S3IndexKey)upperBoundedRange.upper();
                            boundedByteRange = new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.s(), hi.offset()));
                            break block3;
                        }
                        if (!(scanRange instanceof package.UnboundedRange)) break block6;
                        boundedByteRange = new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), package$ByteRange$.MODULE$.UnboundedUpperRange());
                    }
                    return boundedByteRange;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scanRange})));
            }
        }) : ranges.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3IndexKeySpace $outer;

            public final GenTraversableOnce<package.ByteRange> apply(package.ScanRange<package.S3IndexKey> x0$4) {
                package.ScanRange<package.S3IndexKey> scanRange;
                block6: {
                    GenTraversable genTraversable;
                    block3: {
                        block5: {
                            block4: {
                                block2: {
                                    scanRange = x0$4;
                                    if (!(scanRange instanceof package.BoundedRange)) break block2;
                                    package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                                    package.S3IndexKey lo = (package.S3IndexKey)boundedRange.lower();
                                    package.S3IndexKey hi = (package.S3IndexKey)boundedRange.upper();
                                    byte[] lower = ByteArrays$.MODULE$.toBytes(lo.bin(), lo.s(), lo.offset());
                                    byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.s(), hi.offset());
                                    genTraversable = (GenTraversableOnce)this.$outer.sharding().shards().map((Function1)new Serializable(this, lower, upper){
                                        public static final long serialVersionUID = 0L;
                                        private final byte[] lower$1;
                                        private final byte[] upper$1;

                                        public final package.BoundedByteRange apply(byte[] p) {
                                            return new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, this.lower$1), ByteArrays$.MODULE$.concat(p, this.upper$1));
                                        }
                                        {
                                            this.lower$1 = lower$1;
                                            this.upper$1 = upper$1;
                                        }
                                    }, Seq$.MODULE$.canBuildFrom());
                                    break block3;
                                }
                                if (!(scanRange instanceof package.LowerBoundedRange)) break block4;
                                package.LowerBoundedRange lowerBoundedRange = (package.LowerBoundedRange)scanRange;
                                package.S3IndexKey lo = (package.S3IndexKey)lowerBoundedRange.lower();
                                byte[] lower = ByteArrays$.MODULE$.toBytes(lo.bin(), lo.s(), lo.offset());
                                byte[] upper = package$ByteRange$.MODULE$.UnboundedUpperRange();
                                genTraversable = (GenTraversableOnce)this.$outer.sharding().shards().map((Function1)new Serializable(this, lower, upper){
                                    public static final long serialVersionUID = 0L;
                                    private final byte[] lower$2;
                                    private final byte[] upper$2;

                                    public final package.BoundedByteRange apply(byte[] p) {
                                        return new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, this.lower$2), ByteArrays$.MODULE$.concat(p, this.upper$2));
                                    }
                                    {
                                        this.lower$2 = lower$2;
                                        this.upper$2 = upper$2;
                                    }
                                }, Seq$.MODULE$.canBuildFrom());
                                break block3;
                            }
                            if (!(scanRange instanceof package.UpperBoundedRange)) break block5;
                            package.UpperBoundedRange upperBoundedRange = (package.UpperBoundedRange)scanRange;
                            package.S3IndexKey hi = (package.S3IndexKey)upperBoundedRange.upper();
                            byte[] lower = package$ByteRange$.MODULE$.UnboundedLowerRange();
                            byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.s(), hi.offset());
                            genTraversable = (GenTraversableOnce)this.$outer.sharding().shards().map((Function1)new Serializable(this, lower, upper){
                                public static final long serialVersionUID = 0L;
                                private final byte[] lower$3;
                                private final byte[] upper$3;

                                public final package.BoundedByteRange apply(byte[] p) {
                                    return new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, this.lower$3), ByteArrays$.MODULE$.concat(p, this.upper$3));
                                }
                                {
                                    this.lower$3 = lower$3;
                                    this.upper$3 = upper$3;
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            break block3;
                        }
                        if (!(scanRange instanceof package.UnboundedRange)) break block6;
                        genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.BoundedByteRange[]{new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), package$ByteRange$.MODULE$.UnboundedUpperRange())}));
                    }
                    return genTraversable;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scanRange})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public boolean useFullFilter(Option<package.S3IndexValues> values2, Option<GeoMesaDataStoreFactory.GeoMesaDataStoreConfig> config, Hints hints) {
        return true;
    }

    public S3IndexKeySpace(SimpleFeatureType sft, ShardStrategy sharding, String geomField, String dtgField) {
        this.sft = sft;
        this.sharding = sharding;
        this.org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$geomField = geomField;
        this.org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$dtgField = dtgField;
        IndexKeySpace$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        Predef$.MODULE$.require(Point.class.isAssignableFrom(sft.getDescriptor(geomField).getType().getBinding()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3IndexKeySpace $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected field ", " to have a point binding, but instead it has: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$geomField}))).append((Object)this.$outer.sft().getDescriptor(this.$outer.org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$geomField).getType().getBinding().getSimpleName()).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(Date.class.isAssignableFrom(sft.getDescriptor(dtgField).getType().getBinding()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3IndexKeySpace $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected field ", " to have a date binding, but instead it has: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$dtgField}))).append((Object)this.$outer.sft().getDescriptor(this.$outer.org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$dtgField).getType().getBinding().getSimpleName()).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.sfc = S2SFC$.MODULE$.apply(QueryProperties$.MODULE$.S2MinLevel(), QueryProperties$.MODULE$.S2MaxLevel(), QueryProperties$.MODULE$.S2LevelMod(), QueryProperties$.MODULE$.S2MaxCells());
        this.geomIndex = sft.indexOf(geomField);
        this.dtgIndex = sft.indexOf(dtgField);
        this.timeToIndex = BinnedTime$.MODULE$.timeToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getS3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$maxTime = (int)BinnedTime$.MODULE$.maxOffset(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getS3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$dateToIndex = BinnedTime$.MODULE$.dateToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getS3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.org$locationtech$geomesa$index$index$s3$S3IndexKeySpace$$boundsToDates = BinnedTime$.MODULE$.boundsToIndexableDates(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getS3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.attributes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{geomField, dtgField}));
        this.indexKeyByteLength = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(14 + sharding.length())));
        this.sharing = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
    }
}

