/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.stats;

import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.utils.stats.Histogram;
import org.locationtech.geomesa.utils.stats.Stat$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class StatsHistogramCommand$ {
    public static final StatsHistogramCommand$ MODULE$;
    private final Tuple2<String, Object> Threshold1;
    private final Tuple2<String, Object> Threshold2;
    private final Tuple2<String, Object> Threshold3;
    private final Tuple2<String, Object> Threshold4;
    private final int org$locationtech$geomesa$tools$stats$StatsHistogramCommand$$AsciiWorldMapLength;
    private final int AsciiWorldMapHeight;
    private final char[][] AsciiWorldMap;

    static {
        new StatsHistogramCommand$();
    }

    public void printHist(Histogram<Object> stat, SimpleFeatureType sft, String attribute) {
        Command$.MODULE$.output().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Binned histogram for '", "':"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attribute})));
        if (stat.isEmpty()) {
            Command$.MODULE$.output().info("  No values");
        } else {
            Function1 stringify2 = Stat$.MODULE$.stringifier(sft.getDescriptor(attribute).getType().getBinding(), Stat$.MODULE$.stringifier$default$2());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), stat.length()).foreach$mVc$sp((Function1)new Serializable(stat, stringify2){
                public static final long serialVersionUID = 0L;
                private final Histogram stat$2;
                private final Function1 stringify$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    Tuple2 tuple2 = this.stat$2.bounds(i);
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        Object min = tuple2._1();
                        Object max = tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2(min, max);
                        Object min2 = tuple23._1();
                        Object max2 = tuple23._2();
                        Command$.MODULE$.output().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  [ ", " to ", " ] ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stringify$1.apply(min2), this.stringify$1.apply(max2), BoxesRunTime.boxToLong((long)this.stat$2.count(i))})));
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                }
                {
                    this.stat$2 = stat$2;
                    this.stringify$1 = stringify$1;
                }
            });
        }
    }

    public String geomHistToString(String attribute, Histogram<Geometry> stat) {
        long[][] counts = (long[][])Array$.MODULE$.fill(this.AsciiWorldMapHeight(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long[] apply() {
                return (long[])Array$.MODULE$.fill(StatsHistogramCommand$.MODULE$.org$locationtech$geomesa$tools$stats$StatsHistogramCommand$$AsciiWorldMapLength(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                }, ClassTag$.MODULE$.Long());
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
        this.putCountsInGrid$1(stat, counts);
        long min = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])counts).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(long[] x$7) {
                return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps(x$7).min((Ordering)Ordering.Long$.MODULE$));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).min((Ordering)Ordering.Long$.MODULE$));
        long max = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])counts).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(long[] x$8) {
                return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps(x$8).max((Ordering)Ordering.Long$.MODULE$));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).max((Ordering)Ordering.Long$.MODULE$));
        StringBuilder sb = new StringBuilder();
        String currentColor = null;
        for (int i = 0; i < this.AsciiWorldMapHeight(); ++i) {
            long[] row = counts[i];
            for (int j = 0; j < this.org$locationtech$geomesa$tools$stats$StatsHistogramCommand$$AsciiWorldMapLength(); ++j) {
                Tuple2<String, Object> tuple2;
                float normalized = this.normalize$1(row[j], min, max);
                Tuple2<String, Object> tuple22 = normalized < 0.1f ? new Tuple2<String, Object>((Object)"\u001b[0m", (Object)BoxesRunTime.boxToCharacter((char)this.AsciiWorldMap()[i][j])) : (normalized < 0.3f ? this.Threshold1() : (normalized < 0.5f ? this.Threshold2() : (tuple2 = normalized < 0.8f ? this.Threshold3() : this.Threshold4())));
                if (tuple2 != null) {
                    Tuple2 tuple23;
                    String color = (String)tuple2._1();
                    char c = tuple2._2$mcC$sp();
                    Tuple2 tuple24 = tuple23 = new Tuple2((Object)color, (Object)BoxesRunTime.boxToCharacter((char)c));
                    String color2 = (String)tuple24._1();
                    char = tuple24._2$mcC$sp();
                    String string = color2;
                    String string2 = currentColor;
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        sb.append(color2);
                        currentColor = color2;
                    }
                    sb.append(char);
                    continue;
                }
                throw new MatchError((Object)tuple2);
            }
            sb.append('\n');
        }
        sb.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\nKey: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"\u001b[0m"})));
        sb.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "", "", " ", " to ", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.Threshold1()._1(), BoxesRunTime.boxToCharacter((char)this.Threshold1()._2$mcC$sp()), "\u001b[0m", BoxesRunTime.boxToLong((long)this.denormalize$1(0.1f, min, max)), BoxesRunTime.boxToLong((long)this.denormalize$1(0.3f, min, max))})));
        sb.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "", "", " ", " to ", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.Threshold2()._1(), BoxesRunTime.boxToCharacter((char)this.Threshold2()._2$mcC$sp()), "\u001b[0m", BoxesRunTime.boxToLong((long)this.denormalize$1(0.3f, min, max)), BoxesRunTime.boxToLong((long)this.denormalize$1(0.5f, min, max))})));
        sb.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "", "", " ", " to ", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.Threshold3()._1(), BoxesRunTime.boxToCharacter((char)this.Threshold3()._2$mcC$sp()), "\u001b[0m", BoxesRunTime.boxToLong((long)this.denormalize$1(0.5f, min, max)), BoxesRunTime.boxToLong((long)this.denormalize$1(0.8f, min, max))})));
        sb.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "", "", "  ", " to ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.Threshold4()._1(), BoxesRunTime.boxToCharacter((char)this.Threshold4()._2$mcC$sp()), "\u001b[0m", BoxesRunTime.boxToLong((long)this.denormalize$1(0.8f, min, max)), BoxesRunTime.boxToLong((long)max)})));
        return sb.toString();
    }

    private Tuple2<String, Object> Threshold1() {
        return this.Threshold1;
    }

    private Tuple2<String, Object> Threshold2() {
        return this.Threshold2;
    }

    private Tuple2<String, Object> Threshold3() {
        return this.Threshold3;
    }

    private Tuple2<String, Object> Threshold4() {
        return this.Threshold4;
    }

    public int org$locationtech$geomesa$tools$stats$StatsHistogramCommand$$AsciiWorldMapLength() {
        return this.org$locationtech$geomesa$tools$stats$StatsHistogramCommand$$AsciiWorldMapLength;
    }

    private int AsciiWorldMapHeight() {
        return this.AsciiWorldMapHeight;
    }

    private char[][] AsciiWorldMap() {
        return this.AsciiWorldMap;
    }

    private final void putCountsInGrid$1(Histogram stat$1, long[][] counts$1) {
        for (int i = 0; i < stat$1.length(); ++i) {
            long count = stat$1.count(i);
            if (count <= 0L) continue;
            Point point = (Point)stat$1.medianValue(i);
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(point.getX(), point.getY());
            if (sp2 != null) {
                Tuple2.mcDD.sp sp3;
                double x = sp2._1$mcD$sp();
                double y = sp2._2$mcD$sp();
                Tuple2.mcDD.sp sp4 = sp3 = new Tuple2.mcDD.sp(x, y);
                double x2 = sp4._1$mcD$sp();
                double y2 = sp4._2$mcD$sp();
                double xOffset = (x2 + (double)180) / (double)360;
                double yOffset = 1.0 - (y2 + (double)90) / (double)180;
                int j = (int)package$.MODULE$.floor(yOffset * (double)this.AsciiWorldMapHeight());
                int k = (int)package$.MODULE$.floor(xOffset * (double)this.org$locationtech$geomesa$tools$stats$StatsHistogramCommand$$AsciiWorldMapLength());
                long[] lArray = counts$1[j];
                lArray[k] = lArray[k] + count;
                continue;
            }
            throw new MatchError((Object)sp2);
        }
    }

    private final float normalize$1(long count, long min$1, long max$1) {
        return (float)(count - min$1) / (float)(max$1 - min$1);
    }

    private final long denormalize$1(float percent, long min$1, long max$1) {
        return (long)(percent * (float)(max$1 - min$1)) + min$1;
    }

    private StatsHistogramCommand$() {
        MODULE$ = this;
        this.Threshold1 = new Tuple2((Object)"\u001b[1m\u001b[36m", (Object)BoxesRunTime.boxToCharacter((char)'\u26ab'));
        this.Threshold2 = new Tuple2((Object)"\u001b[1m\u001b[32m", (Object)BoxesRunTime.boxToCharacter((char)'\u25cf'));
        this.Threshold3 = new Tuple2((Object)"\u001b[1m\u001b[33m", (Object)BoxesRunTime.boxToCharacter((char)'\u25cf'));
        this.Threshold4 = new Tuple2((Object)"\u001b[1m\u001b[31m", (Object)BoxesRunTime.boxToCharacter((char)'\u2b24'));
        this.org$locationtech$geomesa$tools$stats$StatsHistogramCommand$$AsciiWorldMapLength = 140;
        this.AsciiWorldMapHeight = 42;
        this.AsciiWorldMap = (char[][])Predef$.MODULE$.refArrayOps((Object[])new String[]{"                                                                                                                                            ", "                                                                                                                                            ", "                                          .      .   ,:,,:                                                                                  ", "                                    . :,.:,,,::,.,,,.,__,__,,.,;                                    :.                                      ", "                              ,. ;:,__:,.,,,,.,,____________,,          :,,:                          __                                    ", "                           ,.,::::,  .::;    .  ,,____________.                         ,,.        ;.,.,,__        ,;.                      ", "                          .,,:::;:,:: .,, .      ,__________,                         ,    .,. ,,________.,.,,__    ::                      ", "             ______,: :,,,/; ,.,,; ,;  ,. ,,,.    :______,,.,             ,____;   __    , __.,__________________________.:;;;.,,           ", "            ,,____________; ________.,,    .,,,.  __.,./.               ,.,,;__. ;,,,______.;__________________________________,,:,.,       ", "            ,,__.,.,________.:,__,.,,   .,,, ,     :.,.               ,,,__:__.,:______________________________________.,,.,.,__;           ", "             .:,,    .,,______;,,__.:     ____,                       ,,.,  ;,__.,________________________________.,      :,                ", "            ;          ,__________,,__,,.:,____,,                   .  ,.,,,______.,:__________________.,:________\\__    ,,                 ", "                         ,,,________,.:__.,.,,:: ,                 .:,________________________________,,,__________,,                       ", "                          __________.,.: .,__,/:                    __.,,,____,:;__.:,.,;__.,:,__________________,, :                       ", "                          .,__________,__.,                      ,,.:  : , .::;.,:.,__:,.,__________________,:__   __                       ", "                           ,,,__________.,,                       :,,__.      :,;__________________________,,  ,.:,,                        ", "                             :,____.,.,,:                        ______.,.:____,,__,,,____________________.,,,                              ", "                              ,,,.,                            ,,________________.,__:.: ,,,______,________.,;                              ", "                                 ,,, :,    ;:.                 ________________,. ,__,,,     ,.,,.  ,,__ :                                  ", "                                     ,:.                      ,________.,,______.,,,,        ,.,     ,,__.   :,                             ", "                                        , .,,,,,,               ,________________.,,,         ,:      ,       ,                             ", "                                         ,,____.,,.,                   ,__________.:                 .,; :,,. ,:                            ", "                                         __________.,__:                ,,____,,.,                     .   __: . :,__,                      ", "                                          ,,____________                 ________,                          . :     . :.                    ", "                                           ,,,________.                 __________ ,,.                        :__., ,,                      ", "                                            :________,:                  ,____.,.  .:                      ,__________,     ,.              ", "                                            ,,____.,                     ,____,,                           ,__________,,                    ", "                                            ____.,:                       :__,                             ;.,.:__,____,                    ", "                                           ,____.                                                                  .,,.        :;.          ", "                                           ;__/                                                                      ,,       .             ", "                                           ,__                                                                                              ", "                                           ,,                                                                                               ", "                                                                                                                                            ", "                                                                                                                                            ", "                                          /                                                                                                 ", "                                       ____                 _ _/:\\_____/________________ ____________________________________.              ", "          :.,.________________________.              ______________________________________________________________________                 ", "          .________________________________ .___/____________________________________________________________________________,              ", "  ________________________________________________________________________________________________________________________________          ", "                                                                                                                                            ", "                                                                                                                                            ", "                                                                                                                                            ", "                                                                                                                                            "}).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final char[] apply(String x$10) {
                return x$10.toCharArray();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Character.TYPE))));
    }
}

