/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.io.fs;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Locale;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate$CreateMode$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate$FileHandle$class;
import org.locationtech.geomesa.utils.io.fs.LocalDelegate$;
import org.locationtech.geomesa.utils.io.fs.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001B\u0001\u0003\u0001=\u0011Q\u0002T8dC2$U\r\\3hCR,'BA\u0002\u0005\u0003\t17O\u0003\u0002\u0006\r\u0005\u0011\u0011n\u001c\u0006\u0003\u000f!\tQ!\u001e;jYNT!!\u0003\u0006\u0002\u000f\u001d,w.\\3tC*\u00111\u0002D\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\f\u001b!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u0013\r&dWmU=ti\u0016lG)\u001a7fO\u0006$X\r\u0005\u0002\u001cE5\tAD\u0003\u0002\u001e=\u0005a1oY1mC2|wmZ5oO*\u0011q\u0004I\u0001\tif\u0004Xm]1gK*\t\u0011%A\u0002d_6L!a\t\u000f\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\u0006K\u0001!\tAJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u0002\"a\u0006\u0001\t\u000b%\u0002A\u0011\t\u0016\u0002\u0013\u001d,G\u000fS1oI2,GCA\u0016B!\tacH\u0004\u0002.y9\u0011af\u000f\b\u0003_ir!\u0001M\u001d\u000f\u0005EBdB\u0001\u001a8\u001d\t\u0019d'D\u00015\u0015\t)d\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u0013\ti$!\u0001\nGS2,7+_:uK6$U\r\\3hCR,\u0017BA A\u0005)1\u0015\u000e\\3IC:$G.\u001a\u0006\u0003{\tAQA\u0011\u0015A\u0002\r\u000bA\u0001]1uQB\u0011Ai\u0012\b\u0003#\u0015K!A\u0012\n\u0002\rA\u0013X\rZ3g\u0013\tA\u0015J\u0001\u0004TiJLgn\u001a\u0006\u0003\rJAQa\u0013\u0001\u0005B1\u000bQ\"\u001b8uKJ\u0004(/\u001a;QCRDGCA'W!\rq5k\u000b\b\u0003\u001fFs!a\r)\n\u0003MI!A\u0015\n\u0002\u000fA\f7m[1hK&\u0011A+\u0016\u0002\u0004'\u0016\f(B\u0001*\u0013\u0011\u0015\u0011%\n1\u0001D\u0011\u0015A\u0006\u0001\"\u0003Z\u00031\u0019'/Z1uK\"\u000bg\u000e\u001a7f)\tY#\fC\u0003\\/\u0002\u0007A,\u0001\u0003gS2,\u0007CA/b\u001b\u0005q&BA\u0003`\u0015\u0005\u0001\u0017\u0001\u00026bm\u0006L!A\u00190\u0003\t\u0019KG.Z\u0004\u0006I\nA\t!Z\u0001\u000e\u0019>\u001c\u0017\r\u001c#fY\u0016<\u0017\r^3\u0011\u0005]1g!B\u0001\u0003\u0011\u000397C\u00014\u0011\u0011\u0015)c\r\"\u0001j)\u0005)\u0007bB6g\u0005\u0004%I\u0001\\\u0001\bM\u0006\u001cGo\u001c:z+\u0005i\u0007C\u00018x\u001b\u0005y'B\u00019r\u0003%\t'o\u00195jm\u0016\u00148O\u0003\u0002sg\u0006A1m\\7qe\u0016\u001c8O\u0003\u0002uk\u000691m\\7n_:\u001c(B\u0001<\r\u0003\u0019\t\u0007/Y2iK&\u0011\u0001p\u001c\u0002\u0015\u0003J\u001c\u0007.\u001b<f'R\u0014X-Y7GC\u000e$xN]=\t\ri4\u0007\u0015!\u0003n\u0003!1\u0017m\u0019;pef\u0004c\u0001\u0002?g\u0001u\u0014q\u0002T8dC24\u0015\u000e\\3IC:$G.Z\n\u0004wBY\u0003\u0002C.|\u0005\u0003\u0005\u000b\u0011\u0002/\t\r\u0015ZH\u0011AA\u0001)\u0011\t\u0019!a\u0002\u0011\u0007\u0005\u001510D\u0001g\u0011\u0015Yv\u00101\u0001]\u0011\u0019\u00115\u0010\"\u0011\u0002\fU\t1\tC\u0004\u0002\u0010m$\t%!\u0005\u0002\r\u0015D\u0018n\u001d;t+\t\t\u0019\u0002E\u0002\u0012\u0003+I1!a\u0006\u0013\u0005\u001d\u0011un\u001c7fC:Dq!a\u0007|\t\u0003\ni\"\u0001\u0004mK:<G\u000f[\u000b\u0003\u0003?\u00012!EA\u0011\u0013\r\t\u0019C\u0005\u0002\u0005\u0019>tw\rC\u0004\u0002(m$\t%!\u000b\u0002\t=\u0004XM\\\u000b\u0003\u0003W\u0001b!!\f\u00024\u0005]RBAA\u0018\u0015\r\t\tDB\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u001b\u0003_\u0011\u0011c\u00117pg\u0016\f'\r\\3Ji\u0016\u0014\u0018\r^8s!\u001d\t\u0012\u0011HA\u001f\u0003\u0007J1!a\u000f\u0013\u0005\u0019!V\u000f\u001d7feA!\u0011#a\u0010D\u0013\r\t\tE\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007u\u000b)%C\u0002\u0002Hy\u00131\"\u00138qkR\u001cFO]3b[\"9\u00111J>\u0005B\u00055\u0013!B<sSR,GCBA(\u0003+\ny\u0006E\u0002^\u0003#J1!a\u0015_\u00051yU\u000f\u001e9viN#(/Z1n\u0011!\t9&!\u0013A\u0002\u0005e\u0013\u0001B7pI\u0016\u00042\u0001LA.\u0013\r\ti\u0006\u0011\u0002\u000b\u0007J,\u0017\r^3N_\u0012,\u0007BCA1\u0003\u0013\u0002\n\u00111\u0001\u0002\u0014\u0005i1M]3bi\u0016\u0004\u0016M]3oiNDq!!\u001a|\t\u0003\n9'\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003S\ny\u0007E\u0002\u0012\u0003WJ1!!\u001c\u0013\u0005\u0011)f.\u001b;\t\u0015\u0005E\u00141\rI\u0001\u0002\u0004\t\u0019\"A\u0005sK\u000e,(o]5wK\u001a1\u0011Q\u000f4\u0001\u0003o\u0012a\u0002T8dC2T\u0016\u000e\u001d%b]\u0012dWm\u0005\u0003\u0002t\u0005\r\u0001\"C.\u0002t\t\u0005\t\u0015!\u0003]\u0011\u001d)\u00131\u000fC\u0001\u0003{\"B!a \u0002\u0002B!\u0011QAA:\u0011\u0019Y\u00161\u0010a\u00019\"A\u0011qEA:\t\u0003\nI\u0003\u0003\u0005\u0002L\u0005MD\u0011IAD)\u0019\ty%!#\u0002\f\"A\u0011qKAC\u0001\u0004\tI\u0006\u0003\u0006\u0002b\u0005\u0015\u0005\u0013!a\u0001\u0003'1a!a$g\u0001\u0005E%A\u0004'pG\u0006dG+\u0019:IC:$G.Z\n\u0005\u0003\u001b\u000b\u0019\u0001C\u0005\\\u0003\u001b\u0013\t\u0011)A\u00059\"9Q%!$\u0005\u0002\u0005]E\u0003BAM\u00037\u0003B!!\u0002\u0002\u000e\"11,!&A\u0002qC\u0001\"a\n\u0002\u000e\u0012\u0005\u0013\u0011\u0006\u0005\t\u0003\u0017\ni\t\"\u0011\u0002\"R1\u0011qJAR\u0003KC\u0001\"a\u0016\u0002 \u0002\u0007\u0011\u0011\f\u0005\u000b\u0003C\ny\n%AA\u0002\u0005MaABAUM\u0002\tYKA\u0006Ti\u0012Le\u000eS1oI2,7\u0003BAT!-Bq!JAT\t\u0003\ty\u000b\u0006\u0002\u00022B!\u0011QAAT\u0011\u001d\u0011\u0015q\u0015C!\u0003\u0017A\u0001\"a\u0004\u0002(\u0012\u0005\u0013\u0011\u0003\u0005\t\u00037\t9\u000b\"\u0011\u0002\u001e!A\u0011qEAT\t\u0003\nI\u0003\u0003\u0005\u0002L\u0005\u001dF\u0011IA_)\u0019\ty%a0\u0002B\"A\u0011qKA^\u0001\u0004\tI\u0006\u0003\u0006\u0002b\u0005m\u0006\u0013!a\u0001\u0003'A\u0001\"!\u001a\u0002(\u0012\u0005\u0013Q\u0019\u000b\u0005\u0003S\n9\r\u0003\u0006\u0002J\u0006\r\u0007\u0013!a\u0001\u0003'\t\u0001B]3dkNLg/Z\u0004\b\u0003\u001b4\u0007\u0012AAh\u0003-\u0019F\u000fZ%o\u0011\u0006tG\r\\3\u0011\t\u0005\u0015\u0011\u0011\u001b\u0004\b\u0003S3\u0007\u0012AAj'\r\t\t\u000e\u0005\u0005\bK\u0005EG\u0011AAl)\t\ty\r\u0003\u0005\u0002\\\u0006EG\u0011AAo\u0003%\tg/Y5mC\ndW\r\u0006\u0002\u0002`B!\u0011#a\u0010,\u0011!\t\u0019/!5\u0005\u0002\u0005E\u0011aC5t\u0003Z\f\u0017\u000e\\1cY\u0016\u0004")
public class LocalDelegate
implements FileSystemDelegate {
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        LocalDelegate localDelegate = this;
        synchronized (localDelegate) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public FileSystemDelegate.FileHandle getHandle(String path) {
        return this.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$createHandle(new File(path));
    }

    @Override
    public Seq<FileSystemDelegate.FileHandle> interpretPath(String path) {
        Tuple2 tuple2;
        block11: {
            Seq seq;
            block10: {
                Tuple2 tuple22;
                int firstWildcard;
                block9: {
                    firstWildcard = path.indexOf(42);
                    if (firstWildcard != -1) break block9;
                    File file = new File(path);
                    if (file.isDirectory()) {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn("Input file is a directory: {}", new Object[]{file.getAbsolutePath()});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        seq = (Seq)Seq$.MODULE$.empty();
                    } else {
                        seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileSystemDelegate.FileHandle[]{this.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$createHandle(file)}));
                    }
                    break block10;
                }
                int lastSep = path.length() - 1 - ((String)new StringOps(Predef$.MODULE$.augmentString(path)).reverse()).indexOf(47, path.length() - firstWildcard - 1);
                Tuple2 tuple23 = tuple2 = lastSep == path.length() ? new Tuple2((Object)new File(".").toPath(), (Object)path) : new Tuple2((Object)new File(path.substring(0, lastSep)).toPath(), (Object)path.substring(lastSep + 1));
                if (tuple2 == null) break block11;
                Path basepath = (Path)tuple2._1();
                String glob = (String)tuple2._2();
                Tuple2 tuple24 = tuple22 = new Tuple2((Object)basepath, (Object)glob);
                Path basepath2 = (Path)tuple24._1();
                String glob2 = (String)tuple24._2();
                if (glob2.indexOf(47) == -1 && !glob2.contains("**")) {
                    seq = (Seq)WithClose$.MODULE$.apply(Files.newDirectoryStream(basepath2, glob2), new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ LocalDelegate $outer;

                        public final Seq<FileSystemDelegate.FileHandle> apply(DirectoryStream<Path> stream) {
                            return (Seq)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(stream).asScala()).toList().flatMap((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$interpretPath$1 $outer;

                                public final List<FileSystemDelegate.FileHandle> apply(Path p) {
                                    File file = p.toFile();
                                    return file.isDirectory() ? Nil$.MODULE$ : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileSystemDelegate.FileHandle[]{this.$outer.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$anonfun$$$outer().org$locationtech$geomesa$utils$io$fs$LocalDelegate$$createHandle(file)}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, List$.MODULE$.canBuildFrom());
                        }

                        public /* synthetic */ LocalDelegate org$locationtech$geomesa$utils$io$fs$LocalDelegate$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                } else {
                    PathMatcher matcher = FileSystems.getDefault().getPathMatcher(new StringBuilder().append((Object)"glob:").append((Object)glob2).toString());
                    ArrayBuffer result = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                    SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(this, matcher, result){
                        private final /* synthetic */ LocalDelegate $outer;
                        private final PathMatcher matcher$1;
                        private final ArrayBuffer result$1;

                        public FileVisitResult visitFile(Path file, BasicFileAttributes attributes2) {
                            Object object = this.matcher$1.matches(file) && attributes2.isRegularFile() && !attributes2.isDirectory() ? this.result$1.$plus$eq((Object)this.$outer.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$createHandle(file.toFile())) : BoxedUnit.UNIT;
                            return FileVisitResult.CONTINUE;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.matcher$1 = matcher$1;
                            this.result$1 = result$1;
                        }
                    };
                    Files.walkFileTree(basepath2, (FileVisitor<? super Path>)visitor);
                    seq = result;
                }
            }
            return seq;
        }
        throw new MatchError((Object)tuple2);
    }

    public FileSystemDelegate.FileHandle org$locationtech$geomesa$utils$io$fs$LocalDelegate$$createHandle(File file) {
        LocalFileHandle localFileHandle;
        String string2 = PathUtils$.MODULE$.getUncompressedExtension(file.getName()).toLowerCase(Locale.US);
        if ("tar".equals(string2)) {
            localFileHandle = new LocalTarHandle(file);
        } else {
            boolean bl = "zip".equals(string2) ? true : "jar".equals(string2);
            localFileHandle = bl ? new LocalZipHandle(file) : new LocalFileHandle(file);
        }
        return localFileHandle;
    }

    public LocalDelegate() {
        LazyLogging.class.$init$((LazyLogging)this);
    }

    public static class StdInHandle
    implements FileSystemDelegate.FileHandle {
        private final String format;
        private volatile boolean bitmap$0;

        private String format$lzycompute() {
            StdInHandle stdInHandle = this;
            synchronized (stdInHandle) {
                if (!this.bitmap$0) {
                    this.format = FileSystemDelegate$FileHandle$class.format(this);
                    this.bitmap$0 = true;
                }
                return this.format;
            }
        }

        @Override
        public String format() {
            return this.bitmap$0 ? this.format : this.format$lzycompute();
        }

        @Override
        public boolean write$default$2() {
            return FileSystemDelegate$FileHandle$class.write$default$2(this);
        }

        @Override
        public boolean delete$default$1() {
            return FileSystemDelegate$FileHandle$class.delete$default$1(this);
        }

        @Override
        public String path() {
            return "<stdin>";
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public long length() {
            return BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return System.in.available();
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return 0L;
                }
            }));
        }

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            return CloseableIterator$.MODULE$.single(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), (Object)System.in), (Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    CloseableIterator$.MODULE$.single$default$2();
                }
            });
        }

        @Override
        public OutputStream write(int mode, boolean createParents) {
            return System.out;
        }

        @Override
        public void delete(boolean recusive) {
        }

        public StdInHandle() {
            FileSystemDelegate$FileHandle$class.$init$(this);
        }
    }

    public static class LocalTarHandle
    extends LocalFileHandle {
        private final File file;

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            InputStream uncompressed = PathUtils$.MODULE$.handleCompression(new FileInputStream(this.file), this.file.getName());
            ArchiveInputStream archive = LocalDelegate$.MODULE$.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$factory().createArchiveInputStream("tar", uncompressed);
            return new package.ArchiveFileIterator(archive, this.file.getAbsolutePath());
        }

        @Override
        public OutputStream write(int mode, boolean createParents) {
            return LocalDelegate$.MODULE$.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$factory().createArchiveOutputStream("tar", super.write(mode, createParents));
        }

        public LocalTarHandle(File file) {
            this.file = file;
            super(file);
        }
    }

    public static class LocalZipHandle
    extends LocalFileHandle {
        private final File file;

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            return new package.ZipFileIterator(new ZipFile(this.file), this.file.getAbsolutePath());
        }

        @Override
        public OutputStream write(int mode, boolean createParents) {
            return LocalDelegate$.MODULE$.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$factory().createArchiveOutputStream("zip", super.write(mode, createParents));
        }

        public LocalZipHandle(File file) {
            this.file = file;
            super(file);
        }
    }

    public static class LocalFileHandle
    implements FileSystemDelegate.FileHandle {
        private final File file;
        private final String format;
        private volatile boolean bitmap$0;

        private String format$lzycompute() {
            LocalFileHandle localFileHandle = this;
            synchronized (localFileHandle) {
                if (!this.bitmap$0) {
                    this.format = FileSystemDelegate$FileHandle$class.format(this);
                    this.bitmap$0 = true;
                }
                return this.format;
            }
        }

        @Override
        public String format() {
            return this.bitmap$0 ? this.format : this.format$lzycompute();
        }

        @Override
        public boolean write$default$2() {
            return FileSystemDelegate$FileHandle$class.write$default$2(this);
        }

        @Override
        public boolean delete$default$1() {
            return FileSystemDelegate$FileHandle$class.delete$default$1(this);
        }

        @Override
        public String path() {
            return this.file.getAbsolutePath();
        }

        @Override
        public boolean exists() {
            return this.file.exists();
        }

        @Override
        public long length() {
            return this.file.length();
        }

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            InputStream is = PathUtils$.MODULE$.handleCompression(new FileInputStream(this.file), this.file.getName());
            return CloseableIterator$.MODULE$.single(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), (Object)is), (Function0<BoxedUnit>)new Serializable(this, is){
                public static final long serialVersionUID = 0L;
                private final InputStream is$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.is$1.close();
                }
                {
                    this.is$1 = is$1;
                }
            });
        }

        @Override
        public OutputStream write(int mode, boolean createParents) {
            block6: {
                block8: {
                    block9: {
                        FileOutputStream fileOutputStream;
                        block4: {
                            block7: {
                                block2: {
                                    block5: {
                                        block3: {
                                            FileSystemDelegate$CreateMode$.MODULE$.validate$extension(mode);
                                            if (!this.file.exists()) break block2;
                                            if (!FileSystemDelegate$CreateMode$.MODULE$.append$extension(mode)) break block3;
                                            fileOutputStream = new FileOutputStream(this.file, true);
                                            break block4;
                                        }
                                        if (!FileSystemDelegate$CreateMode$.MODULE$.overwrite$extension(mode)) break block5;
                                        fileOutputStream = new FileOutputStream(this.file, false);
                                        break block4;
                                    }
                                    throw new FileAlreadyExistsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File already exists for mode 'create': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path()})));
                                }
                                if (!FileSystemDelegate$CreateMode$.MODULE$.create$extension(mode)) break block6;
                                File parent = this.file.getParentFile();
                                if (parent == null || parent.exists()) break block7;
                                if (!createParents) break block8;
                                if (!parent.mkdirs()) break block9;
                            }
                            fileOutputStream = new FileOutputStream(this.file);
                        }
                        return fileOutputStream;
                    }
                    throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parent file does not exist and could not be created: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path()})));
                }
                throw new FileNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parent file does not exist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path()})));
            }
            throw new FileNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File does not exist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path()})));
        }

        @Override
        public void delete(boolean recursive) {
            block4: {
                block3: {
                    block2: {
                        if (!recursive) break block2;
                        PathUtils$.MODULE$.deleteRecursively(this.file.toPath());
                        break block3;
                    }
                    if (!this.file.delete()) break block4;
                }
                return;
            }
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not delete file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path()})));
        }

        public LocalFileHandle(File file) {
            this.file = file;
            FileSystemDelegate$FileHandle$class.$init$(this);
        }
    }
}

