/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.classifier;

import it.geosolutions.jaiext.classifier.ConstantColorMapElement;
import it.geosolutions.jaiext.classifier.LinearColorMapElement;
import it.geosolutions.jaiext.piecewise.DefaultPiecewiseTransform1DElement;
import java.awt.Color;
import java.util.Arrays;

public class ColorMapUtilities {
    private static final double EPS = 1.0E-6;
    static final int[] DEFAULT_ARGB = new int[]{-16777216, -1};

    static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("Argument: " + name + " is Null");
        }
    }

    static int compare(double v1, double v2) {
        if (Double.isNaN(v1) && Double.isNaN(v2)) {
            long bits2;
            long bits1 = Double.doubleToRawLongBits(v1);
            if (bits1 < (bits2 = Double.doubleToRawLongBits(v2))) {
                return -1;
            }
            if (bits1 > bits2) {
                return 1;
            }
        }
        return Double.compare(v1, v2);
    }

    static DefaultPiecewiseTransform1DElement[] checkPreservingElements(LinearColorMapElement[] preservingElements) {
        if (preservingElements != null) {
            double outval = Double.NaN;
            Color color = null;
            for (int i = 0; i < preservingElements.length; ++i) {
                if (!(preservingElements[i] instanceof ConstantColorMapElement)) {
                    throw new IllegalArgumentException("The element must be a ConstantColorMapElement");
                }
                ConstantColorMapElement nc = (ConstantColorMapElement)preservingElements[i];
                if (nc.getColors().length != 1) {
                    throw new IllegalArgumentException("Color size must be 1");
                }
                if (i == 0) {
                    outval = nc.getOutputMaximum();
                    color = nc.getColors()[0];
                    continue;
                }
                if (ColorMapUtilities.compare(outval, nc.getOutputMaximum()) != 0) {
                    throw new IllegalArgumentException("Wrong Color value");
                }
                if (color.equals(nc.getColors()[0])) continue;
                throw new IllegalArgumentException("Wrong Color value");
            }
        }
        return preservingElements;
    }

    public static void expand(Color[] colors, int[] ARGB, int lower, int upper) {
        switch (colors.length) {
            case 1: {
                Arrays.fill(ARGB, lower, upper, colors[0].getRGB());
            }
            case 0: {
                return;
            }
        }
        switch (upper - lower) {
            case 1: {
                ARGB[lower] = colors[0].getRGB();
            }
            case 0: {
                return;
            }
        }
        double scale = (double)(colors.length - 1) / (double)(upper - 1 - lower);
        int maxBase = colors.length - 2;
        double index = 0.0;
        int base = 0;
        int i = lower;
        while (true) {
            int C0 = colors[base + 0].getRGB();
            int C1 = colors[base + 1].getRGB();
            int A0 = C0 >>> 24 & 0xFF;
            int A1 = (C1 >>> 24 & 0xFF) - A0;
            int R0 = C0 >>> 16 & 0xFF;
            int R1 = (C1 >>> 16 & 0xFF) - R0;
            int G0 = C0 >>> 8 & 0xFF;
            int G1 = (C1 >>> 8 & 0xFF) - G0;
            int B0 = C0 & 0xFF;
            int B1 = (C1 & 0xFF) - B0;
            int oldBase = base;
            do {
                double delta = index - (double)base;
                ARGB[i] = ColorMapUtilities.roundByte((double)A0 + delta * (double)A1) << 24 | ColorMapUtilities.roundByte((double)R0 + delta * (double)R1) << 16 | ColorMapUtilities.roundByte((double)G0 + delta * (double)G1) << 8 | ColorMapUtilities.roundByte((double)B0 + delta * (double)B1);
                if (++i != upper) continue;
                return;
            } while ((base = Math.min(maxBase, (int)((index = (double)(i - lower) * scale) + 1.0E-6))) == oldBase);
        }
    }

    public static int roundByte(double value) {
        return (int)Math.min(Math.max(Math.round(value), 0L), 255L);
    }

    public static int getBitCount(int mapSize) {
        int max = mapSize - 1;
        if (max <= 1) {
            return 1;
        }
        int count = 0;
        do {
            ++count;
        } while ((max >>= 1) != 0);
        assert (1 << count >= mapSize) : mapSize;
        assert (1 << count - 1 < mapSize) : mapSize;
        return count;
    }

    public static int getTransferType(int mapSize) {
        return mapSize <= 256 ? 0 : 1;
    }
}

