/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import com.sun.media.jai.util.PropertyGeneratorImpl;
import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.translate.TranslateIntOpImage;
import it.geosolutions.jaiext.utilities.ImageLayout2;
import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.BorderExtender;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import org.locationtech.jts.geom.Geometry;

class Scale2PropertyGenerator
extends PropertyGeneratorImpl {
    public Scale2PropertyGenerator() {
        super(new String[]{"ROI"}, new Class[]{ROI.class}, new Class[]{RenderedOp.class});
    }

    public Object getProperty(String name, Object opNode) {
        this.validate(name, opNode);
        if (opNode instanceof RenderedOp && name.equalsIgnoreCase("roi")) {
            RenderedOp op = (RenderedOp)opNode;
            ParameterBlock pb = op.getParameterBlock();
            RenderedImage src = pb.getRenderedSource(0);
            Object property = src.getProperty("ROI");
            if (property == null || property.equals(Image.UndefinedProperty) || !(property instanceof ROI)) {
                if (pb.getObjectParameter(5) != null) {
                    property = pb.getObjectParameter(5);
                } else {
                    return Image.UndefinedProperty;
                }
            }
            ROI srcROI = (ROI)property;
            Interpolation interp = (Interpolation)pb.getObjectParameter(4);
            Rectangle srcBounds = null;
            PlanarImage dst = op.getRendering();
            srcBounds = dst instanceof GeometricOpImage && ((GeometricOpImage)dst).getBorderExtender() == null ? new Rectangle(src.getMinX() + interp.getLeftPadding(), src.getMinY() + interp.getTopPadding(), src.getWidth() - interp.getWidth() + 1, src.getHeight() - interp.getHeight() + 1) : new Rectangle(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight());
            if (!srcBounds.contains(srcROI.getBounds())) {
                srcROI = srcROI.intersect((ROI)new ROIShape((Shape)srcBounds));
            }
            double sx = pb.getDoubleParameter(0);
            double sy = pb.getDoubleParameter(1);
            double tx = pb.getDoubleParameter(2);
            double ty = pb.getDoubleParameter(3);
            Rectangle dstBounds = op.getBounds();
            TranslateIntOpImage roiImage = null;
            if (sx == 1.0 && sy == 1.0 && Math.abs(tx - (double)((int)tx)) < (double)0.01f && Math.abs(ty - (double)((int)ty)) < (double)0.01f) {
                roiImage = new TranslateIntOpImage((RenderedImage)srcROI.getAsImage(), null, (int)tx, (int)ty);
            } else if (interp instanceof InterpolationBilinear || interp instanceof javax.media.jai.InterpolationBilinear || interp instanceof InterpolationBicubic || interp instanceof javax.media.jai.InterpolationBicubic) {
                ImageLayout2 layout = new ImageLayout2();
                int minx = (int)srcBounds.getMinX();
                int miny = (int)srcBounds.getMinY();
                int w = (int)srcBounds.getWidth();
                int h = (int)srcBounds.getHeight();
                layout.setMinX(minx);
                layout.setMinY(miny);
                layout.setWidth(w);
                layout.setHeight(h);
                RenderingHints hints = op.getRenderingHints();
                hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
                RenderedOp constantImage = ConstantDescriptor.create((Float)new Float(w), (Float)new Float(h), (Number[])new Byte[]{(byte)-1}, (RenderingHints)hints);
                BorderExtender extender = BorderExtender.createInstance((int)1);
                RenderingHints scalingHints = op.getRenderingHints();
                scalingHints.remove(JAI.KEY_IMAGE_LAYOUT);
                scalingHints.put(JAI.KEY_BORDER_EXTENDER, extender);
                boolean isBilinear = interp instanceof InterpolationBilinear || interp instanceof javax.media.jai.InterpolationBilinear;
                InterpolationBilinear interpParam = isBilinear ? new InterpolationBilinear(interp.getSubsampleBitsH(), null, false, 0.0, constantImage.getSampleModel().getDataType()) : new InterpolationBicubic(interp.getSubsampleBitsH(), null, false, 0.0, constantImage.getSampleModel().getDataType(), false, 8);
                ParameterBlock paramBlock = new ParameterBlock();
                paramBlock.setSource(constantImage, 0);
                paramBlock.add((Object)sx);
                paramBlock.add((Object)sy);
                paramBlock.add((Object)tx);
                paramBlock.add((Object)ty);
                paramBlock.add(interpParam);
                if (srcROI instanceof ROIGeometry) {
                    ROIGeometry roiGeom = (ROIGeometry)srcROI;
                    Geometry geom = roiGeom.getAsGeometry();
                    if (geom != null && !geom.isEmpty()) {
                        paramBlock.add(srcROI);
                    }
                } else {
                    paramBlock.add(srcROI);
                }
                roiImage = JAI.create((String)"Scale2", (ParameterBlock)paramBlock, (RenderingHints)scalingHints);
            } else {
                PlanarImage roiMod = srcROI.getAsImage();
                ParameterBlock paramBlock = new ParameterBlock();
                paramBlock.setSource(roiMod, 0);
                paramBlock.add((Object)sx);
                paramBlock.add((Object)sy);
                paramBlock.add((Object)tx);
                paramBlock.add((Object)ty);
                if (interp != null) {
                    if (interp instanceof InterpolationBicubic || interp instanceof javax.media.jai.InterpolationBicubic) {
                        InterpolationBilinear interpBilinear = new InterpolationBilinear(interp.getSubsampleBitsH(), null, false, 0.0, roiMod.getSampleModel().getDataType());
                        paramBlock.add(interpBilinear);
                    } else {
                        paramBlock.add(interp);
                    }
                }
                roiImage = JAI.create((String)"Scale2", (ParameterBlock)paramBlock);
            }
            ROI dstROI = new ROI((RenderedImage)roiImage, 1);
            if (!dstBounds.contains(dstROI.getBounds())) {
                dstROI = dstROI.intersect((ROI)new ROIShape((Shape)dstBounds));
            }
            return dstROI;
        }
        return Image.UndefinedProperty;
    }
}

