/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.criteria.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.calrissian.mango.criteria.domain.AndNode;
import org.calrissian.mango.criteria.domain.EqualsLeaf;
import org.calrissian.mango.criteria.domain.GreaterThanEqualsLeaf;
import org.calrissian.mango.criteria.domain.GreaterThanLeaf;
import org.calrissian.mango.criteria.domain.HasLeaf;
import org.calrissian.mango.criteria.domain.HasNotLeaf;
import org.calrissian.mango.criteria.domain.InLeaf;
import org.calrissian.mango.criteria.domain.LessThanEqualsLeaf;
import org.calrissian.mango.criteria.domain.LessThanLeaf;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.criteria.domain.NotEqualsLeaf;
import org.calrissian.mango.criteria.domain.NotInLeaf;
import org.calrissian.mango.criteria.domain.OrNode;
import org.calrissian.mango.criteria.domain.ParentNode;
import org.calrissian.mango.criteria.domain.RangeLeaf;

public class QueryBuilder {
    protected ParentNode current;
    protected QueryBuilder parentBuilder;
    protected boolean finished = false;

    public QueryBuilder() {
    }

    public QueryBuilder(ParentNode current, QueryBuilder parentBuilder) {
        this.current = current;
        this.parentBuilder = parentBuilder;
    }

    public QueryBuilder and() {
        this.checkFinished();
        AndNode andNode = new AndNode(this.current, new ArrayList<Node>());
        if (this.current != null) {
            this.current.addChild(andNode);
            return new QueryBuilder(andNode, this);
        }
        this.current = andNode;
        return new QueryBuilder(andNode, null);
    }

    public QueryBuilder or() {
        this.checkFinished();
        OrNode orNode = new OrNode(this.current, new ArrayList<Node>());
        if (this.current != null) {
            this.current.addChild(orNode);
            return new QueryBuilder(orNode, this);
        }
        this.current = orNode;
        return new QueryBuilder(orNode, null);
    }

    public Node build() {
        if (!this.finished) {
            throw new IllegalArgumentException("Query Node not built, end first");
        }
        return this.current;
    }

    public QueryBuilder eq(String type, Object value) {
        this.checkFinished();
        if (this.current == null) {
            this.current = new AndNode();
            this.finished = true;
        }
        EqualsLeaf equalsLeaf = new EqualsLeaf(type, value, this.current);
        this.current.addChild(equalsLeaf);
        return this;
    }

    protected void checkFinished() {
        if (this.finished) {
            throw new IllegalArgumentException("Builder finished. Call build() to get constructed Query Node");
        }
    }

    public QueryBuilder has(String key) {
        this.checkFinished();
        if (this.current == null) {
            this.current = new AndNode();
            this.finished = true;
        }
        HasLeaf hasKeyLeaf = new HasLeaf(key, this.current);
        this.current.addChild(hasKeyLeaf);
        return this;
    }

    public QueryBuilder hasNot(String key) {
        this.checkFinished();
        if (this.current == null) {
            this.current = new AndNode();
            this.finished = true;
        }
        HasNotLeaf hasNotLeaf = new HasNotLeaf(key, this.current);
        this.current.addChild(hasNotLeaf);
        return this;
    }

    public QueryBuilder in(String key, Collection<Object> values) {
        this.checkFinished();
        if (this.current == null) {
            this.current = new AndNode();
            this.finished = true;
        }
        InLeaf leaf = new InLeaf(key, values, this.current);
        this.current.addChild(leaf);
        return this;
    }

    public QueryBuilder in(String key, Object ... values) {
        return this.in(key, Arrays.asList(values));
    }

    public QueryBuilder notIn(String key, Collection<Object> values) {
        this.checkFinished();
        if (this.current == null) {
            this.current = new AndNode();
            this.finished = true;
        }
        NotInLeaf leaf = new NotInLeaf(key, values, this.current);
        this.current.addChild(leaf);
        return this;
    }

    public QueryBuilder notIn(String key, Object ... values) {
        return this.notIn(key, Arrays.asList(values));
    }

    public QueryBuilder notEq(String type, Object value) {
        this.checkFinished();
        if (this.current == null) {
            this.current = new AndNode();
            this.finished = true;
        }
        NotEqualsLeaf notEqualsLeaf = new NotEqualsLeaf(type, value, this.current);
        this.current.addChild(notEqualsLeaf);
        return this;
    }

    public QueryBuilder lessThan(String type, Object value) {
        this.checkFinished();
        if (this.current == null) {
            this.current = new AndNode();
            this.finished = true;
        }
        LessThanLeaf leaf = new LessThanLeaf(type, value, this.current);
        this.current.addChild(leaf);
        return this;
    }

    public QueryBuilder lessThanEq(String type, Object value) {
        this.checkFinished();
        if (this.current == null) {
            this.current = new AndNode();
            this.finished = true;
        }
        LessThanEqualsLeaf leaf = new LessThanEqualsLeaf(type, value, this.current);
        this.current.addChild(leaf);
        return this;
    }

    public QueryBuilder greaterThan(String type, Object value) {
        this.checkFinished();
        if (this.current == null) {
            this.current = new AndNode();
            this.finished = true;
        }
        GreaterThanLeaf leaf = new GreaterThanLeaf(type, value, this.current);
        this.current.addChild(leaf);
        return this;
    }

    public QueryBuilder greaterThanEq(String type, Object value) {
        this.checkFinished();
        if (this.current == null) {
            this.current = new AndNode();
            this.finished = true;
        }
        GreaterThanEqualsLeaf leaf = new GreaterThanEqualsLeaf(type, value, this.current);
        this.current.addChild(leaf);
        return this;
    }

    public QueryBuilder range(String type, Object start, Object end) {
        this.checkFinished();
        if (this.current == null) {
            this.current = new AndNode();
            this.finished = true;
        }
        RangeLeaf rangeLeaf = new RangeLeaf(type, start, end, this.current);
        this.current.addChild(rangeLeaf);
        return this;
    }

    public QueryBuilder end() {
        this.checkFinished();
        this.finished = true;
        if (this.parentBuilder == null) {
            return this;
        }
        return this.parentBuilder;
    }
}

