/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.simple;

import com.google.common.base.Preconditions;
import org.calrissian.mango.types.encoders.AbstractBooleanEncoder;

public class BooleanEncoder
extends AbstractBooleanEncoder<String> {
    private static final long serialVersionUID = 1L;

    @Override
    public String encode(Boolean value) {
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        return value.toString();
    }

    @Override
    public Boolean decode(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        String lowercase = value.toLowerCase();
        if (!lowercase.equals("true") && !lowercase.equals("false")) {
            throw new IllegalArgumentException("The value is not a valid encoding");
        }
        return Boolean.parseBoolean(lowercase);
    }
}

