/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.ObjectEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.xsd.Encoder;
import org.locationtech.jts.geom.Envelope;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

class EnvelopeEncoder
extends ObjectEncoder<Envelope> {
    static final QualifiedName ENVELOPE = new QualifiedName("http://www.opengis.net/gml", "Envelope", "gml");
    static final QualifiedName LOWER_CORNER = new QualifiedName("http://www.opengis.net/gml", "lowerCorner", "gml");
    static final QualifiedName UPPER_CORNER = new QualifiedName("http://www.opengis.net/gml", "upperCorner", "gml");
    QualifiedName box;
    QualifiedName envelope;
    QualifiedName lowerCorner;
    QualifiedName upperCorner;

    protected EnvelopeEncoder(Encoder e, String gmlPrefix, String gmlNamespace) {
        super(e);
        this.envelope = ENVELOPE.derive(gmlPrefix, gmlNamespace);
        this.lowerCorner = LOWER_CORNER.derive(gmlPrefix, gmlNamespace);
        this.upperCorner = UPPER_CORNER.derive(gmlPrefix, gmlNamespace);
    }

    public void encode(Envelope e, AttributesImpl atts, GMLWriter handler) throws Exception {
        handler.startElement(this.envelope, (Attributes)atts);
        handler.startElement(this.lowerCorner, null);
        handler.position(e.getMinX(), e.getMinY(), Double.NaN);
        handler.endElement(this.lowerCorner);
        handler.startElement(this.upperCorner, null);
        handler.position(e.getMaxX(), e.getMaxY(), Double.NaN);
        handler.endElement(this.upperCorner);
        handler.endElement(this.envelope);
    }
}

