/*
 * Decompiled with CFR 0.152.
 */
package pureconfig;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import pureconfig.ConfigCursor;
import pureconfig.ConfigCursor$;
import pureconfig.ConfigObjectCursor;
import pureconfig.ConfigReader;
import pureconfig.ConfigReader$Result$;
import pureconfig.ConfigWriter;
import pureconfig.Derivation;
import pureconfig.ReadsMissingKeys;
import pureconfig.backend.ConfigFactoryWrapper$;
import pureconfig.backend.PathUtil$;
import pureconfig.error.CannotReadFile;
import pureconfig.error.ConfigReaderException;
import pureconfig.error.ConfigReaderFailure;
import pureconfig.error.ConfigReaderFailures;
import pureconfig.error.ConfigValueLocation$;
import pureconfig.error.ThrowableFailure;
import pureconfig.package$;
import pureconfig.package$$anonfun$pureconfig$package$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class package$ {
    public static final package$ MODULE$;

    static {
        new package$();
    }

    private Either<ConfigReaderFailures, ConfigCursor> getValue(Config conf, String namespace, boolean allowNullLeaf) {
        Either either;
        try {
            either = this.pureconfig$package$$getValue$1(ConfigCursor$.MODULE$.apply((ConfigValue)conf.root(), (List<String>)Nil$.MODULE$), PathUtil$.MODULE$.splitPath(namespace), allowNullLeaf);
        }
        catch (ConfigException configException) {
            either = ConfigReader$Result$.MODULE$.fail(new ThrowableFailure(configException, ConfigValueLocation$.MODULE$.apply(configException.origin())));
        }
        return either;
    }

    public <A> Either<ConfigReaderFailures, A> pureconfig$package$$loadValue(Config conf, String namespace, Derivation<ConfigReader<A>> reader) {
        ConfigReader<A> configReader = reader.value();
        return this.getValue(conf, namespace, reader.value() instanceof ReadsMissingKeys).right().flatMap((Function1)new Serializable(configReader){
            public static final long serialVersionUID = 0L;
            private final ConfigReader eta$0$1$1;

            public final Either<ConfigReaderFailures, A> apply(ConfigCursor cur) {
                return this.eta$0$1$1.from(cur);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Derivation<ConfigReader<Config>> reader) {
        return this.loadConfig("", reader);
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(String namespace, Derivation<ConfigReader<Config>> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1)new Serializable(namespace, reader){
            public static final long serialVersionUID = 0L;
            public final String namespace$2;
            public final Derivation reader$2;

            public final Either<ConfigReaderFailures, Config> apply(BoxedUnit _) {
                return ConfigFactoryWrapper$.MODULE$.load().right().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadConfig.1 $outer;

                    public final Product apply(Config rawConfig) {
                        return package$.MODULE$.pureconfig$package$$loadValue(rawConfig, this.$outer.namespace$2, this.$outer.reader$2).right().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Config apply(Config config) {
                                return config;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.namespace$2 = namespace$2;
                this.reader$2 = reader$2;
            }
        });
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Path path, Derivation<ConfigReader<Config>> reader) {
        return this.loadConfig(path, "", reader);
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Path path, String namespace, Derivation<ConfigReader<Config>> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1)new Serializable(path, namespace, reader){
            public static final long serialVersionUID = 0L;
            private final Path path$1;
            public final String namespace$1;
            public final Derivation reader$1;

            public final Either<ConfigReaderFailures, Config> apply(BoxedUnit _) {
                return ConfigFactoryWrapper$.MODULE$.loadFile(this.path$1).right().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadConfig.2 $outer;

                    public final Product apply(Config rawConfig) {
                        return package$.MODULE$.pureconfig$package$$loadValue(rawConfig, this.$outer.namespace$1, this.$outer.reader$1).right().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Config apply(Config config) {
                                return config;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.path$1 = path$1;
                this.namespace$1 = namespace$1;
                this.reader$1 = reader$1;
            }
        });
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Config conf, Derivation<ConfigReader<Config>> reader) {
        return this.pureconfig$package$$loadValue(conf, "", reader);
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Config conf, String namespace, Derivation<ConfigReader<Config>> reader) {
        return this.pureconfig$package$$loadValue(conf, namespace, reader);
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfigWithFallback(Config conf, Derivation<ConfigReader<Config>> reader) {
        return this.loadConfigWithFallback(conf, "", reader);
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfigWithFallback(Config conf, String namespace, Derivation<ConfigReader<Config>> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1)new Serializable(conf, namespace, reader){
            public static final long serialVersionUID = 0L;
            public final Config conf$1;
            public final String namespace$3;
            public final Derivation reader$3;

            public final Either<ConfigReaderFailures, Config> apply(BoxedUnit _) {
                return ConfigFactoryWrapper$.MODULE$.load().right().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadConfigWithFallback.1 $outer;

                    public final Product apply(Config rawConfig) {
                        return package$.MODULE$.loadConfig(this.$outer.conf$1.withFallback((ConfigMergeable)rawConfig), this.$outer.namespace$3, this.$outer.reader$3).right().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Config apply(Config config) {
                                return config;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.conf$1 = conf$1;
                this.namespace$3 = namespace$3;
                this.reader$3 = reader$3;
            }
        });
    }

    private <Config> Config getResultOrThrow(Either<ConfigReaderFailures, Config> failuresOrResult, ClassTag<Config> ct) {
        Either<ConfigReaderFailures, Config> either = failuresOrResult;
        if (either instanceof Right) {
            Object config;
            Right right = (Right)either;
            Object object = config = right.b();
            return (Config)object;
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            ConfigReaderFailures failures = (ConfigReaderFailures)left.a();
            throw new ConfigReaderException<Config>(failures, ct);
        }
        throw new MatchError(either);
    }

    public <Config> Config loadConfigOrThrow(ClassTag<Config> evidence$1, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(reader), evidence$1);
    }

    public <Config> Config loadConfigOrThrow(String namespace, ClassTag<Config> evidence$2, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(namespace, reader), evidence$2);
    }

    public <Config> Config loadConfigOrThrow(Path path, ClassTag<Config> evidence$3, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(path, reader), evidence$3);
    }

    public <Config> Config loadConfigOrThrow(Path path, String namespace, ClassTag<Config> evidence$4, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(path, namespace, reader), evidence$4);
    }

    public <Config> Config loadConfigOrThrow(Config conf, ClassTag<Config> evidence$5, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(conf, reader), evidence$5);
    }

    public <Config> Config loadConfigOrThrow(Config conf, String namespace, ClassTag<Config> evidence$6, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(conf, namespace, reader), evidence$6);
    }

    public <Config> Config loadConfigWithFallbackOrThrow(Config conf, ClassTag<Config> evidence$7, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfigWithFallback(conf, reader), evidence$7);
    }

    public <Config> Config loadConfigWithFallbackOrThrow(Config conf, String namespace, ClassTag<Config> evidence$8, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfigWithFallback(conf, namespace, reader), evidence$8);
    }

    public <Config> void saveConfigAsPropertyFile(Config conf, Path outputPath, boolean overrideOutputPath, ConfigRenderOptions options, Derivation<ConfigWriter<Config>> writer) throws IllegalArgumentException {
        if (!overrideOutputPath && Files.isRegularFile(outputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot save configuration in file '", "' because it already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputPath})));
        }
        if (Files.isDirectory(outputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot save configuration in file '", "' because it already exists and is a directory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputPath})));
        }
        this.saveConfigToStream(conf, Files.newOutputStream(outputPath, new OpenOption[0]), options, writer);
    }

    public <Config> boolean saveConfigAsPropertyFile$default$3() {
        return false;
    }

    public <Config> ConfigRenderOptions saveConfigAsPropertyFile$default$4() {
        return ConfigRenderOptions.defaults();
    }

    public <Config> void saveConfigToStream(Config conf, OutputStream outputStream, ConfigRenderOptions options, Derivation<ConfigWriter<Config>> writer) {
        OutputStreamWriter printOutputStream = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        ConfigValue rawConf = writer.value().to(conf);
        printOutputStream.write(rawConf.render(options));
        printOutputStream.close();
    }

    public <Config> ConfigRenderOptions saveConfigToStream$default$3() {
        return ConfigRenderOptions.defaults();
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfigFromFiles(Traversable<Path> files, boolean failOnReadError, String namespace, Derivation<ConfigReader<Config>> reader) {
        return ((Either)((TraversableOnce)((TraversableLike)files.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Either<ConfigReaderFailures, Config> apply(Path path) {
                return ConfigFactoryWrapper$.MODULE$.parseFile(path);
            }
        }, Traversable$.MODULE$.canBuildFrom())).map((Function1)new Serializable(failOnReadError){
            public static final long serialVersionUID = 0L;
            private final boolean failOnReadError$1;

            public final Either<ConfigReaderFailures, Config> apply(Either<ConfigReaderFailures, Config> x0$1) {
                Left left;
                ConfigReaderFailures failures;
                Right right = x0$1;
                Right right2 = right instanceof Left && (failures = (ConfigReaderFailures)(left = (Left)right).a()).toList().exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ConfigReaderFailure x$1) {
                        return x$1 instanceof CannotReadFile;
                    }
                }) && !this.failOnReadError$1 ? scala.package$.MODULE$.Right().apply((Object)ConfigFactory.empty()) : right;
                return right2;
            }
            {
                this.failOnReadError$1 = failOnReadError$1;
            }
        }, Traversable$.MODULE$.canBuildFrom())).foldLeft((Object)scala.package$.MODULE$.Right().apply((Object)ConfigFactory.empty()), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Either<ConfigReaderFailures, Config> apply(Either<ConfigReaderFailures, Config> x0$2, Either<ConfigReaderFailures, Config> x1$1) {
                Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
                if (tuple2 != null) {
                    Either c1 = (Either)tuple2._1();
                    Either c2 = (Either)tuple2._2();
                    Either<ConfigReaderFailures, C> either = ConfigReader$Result$.MODULE$.zipWith(c1, c2, new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Config apply(Config x$2, Config x$3) {
                            return x$2.withFallback((ConfigMergeable)x$3);
                        }
                    });
                    return either;
                }
                throw new MatchError((Object)tuple2);
            }
        })).right().flatMap((Function1)new Serializable(namespace, reader){
            public static final long serialVersionUID = 0L;
            private final String namespace$4;
            private final Derivation reader$4;

            public final Either<ConfigReaderFailures, Config> apply(Config conf) {
                return package$.MODULE$.loadConfig(conf.resolve(), this.namespace$4, this.reader$4);
            }
            {
                this.namespace$4 = namespace$4;
                this.reader$4 = reader$4;
            }
        });
    }

    public <Config> boolean loadConfigFromFiles$default$2() {
        return false;
    }

    public <Config> String loadConfigFromFiles$default$3() {
        return "";
    }

    public <Config> Config loadConfigFromFilesOrThrow(Traversable<Path> files, ClassTag<Config> evidence$9, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfigFromFiles(files, this.loadConfigFromFiles$default$2(), this.loadConfigFromFiles$default$3(), reader), evidence$9);
    }

    public final Either pureconfig$package$$getValue$1(ConfigCursor cur, List path, boolean allowNullLeaf$1) {
        List list2;
        block4: {
            Right right;
            block3: {
                block2: {
                    list2 = path;
                    if (!Nil$.MODULE$.equals(list2)) break block2;
                    right = scala.package$.MODULE$.Right().apply((Object)cur);
                    break block3;
                }
                if (!(list2 instanceof .colon.colon)) break block4;
                .colon.colon colon2 = (.colon.colon)list2;
                String key = (String)colon2.head();
                List remaining = colon2.tl$1();
                right = cur.asObjectCursor().right().flatMap((Function1)new Serializable(allowNullLeaf$1, key, remaining){
                    public static final long serialVersionUID = 0L;
                    public final boolean allowNullLeaf$1;
                    private final String key$1;
                    public final List remaining$1;

                    public final Either<ConfigReaderFailures, ConfigCursor> apply(ConfigObjectCursor objCur) {
                        return (!this.remaining$1.nonEmpty() && this.allowNullLeaf$1 ? scala.package$.MODULE$.Right().apply((Object)objCur.atKeyOrUndefined(this.key$1)) : objCur.atKey(this.key$1)).right().flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$pureconfig$package$$getValue$1$1 $outer;

                            public final Product apply(ConfigCursor keyCur) {
                                return package$.MODULE$.pureconfig$package$$getValue$1(keyCur, this.$outer.remaining$1, this.$outer.allowNullLeaf$1).right().map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final ConfigCursor apply(ConfigCursor finalCur) {
                                        return finalCur;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.allowNullLeaf$1 = allowNullLeaf$1;
                        this.key$1 = key$1;
                        this.remaining$1 = remaining$1;
                    }
                });
            }
            return right;
        }
        throw new MatchError((Object)list2);
    }

    private package$() {
        MODULE$ = this;
    }
}

