/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;

public class CharsetConverterFactory
implements ConverterFactory {
    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (CharSequence.class.isAssignableFrom(source) && Charset.class.isAssignableFrom(target)) {
            return new Converter(){

                public <T> T convert(Object source, Class<T> target) throws Exception {
                    try {
                        return (T)Charset.forName((String)source);
                    }
                    catch (UnsupportedCharsetException e) {
                        return null;
                    }
                }
            };
        }
        if (Charset.class.isAssignableFrom(source) && CharSequence.class.isAssignableFrom(target)) {
            return new Converter(){

                public <T> T convert(Object source, Class<T> target) throws Exception {
                    return (T)((Charset)source).toString();
                }
            };
        }
        return null;
    }
}

