/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.filters;

import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Strings;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.features.interop.SerializationOptions;
import org.locationtech.geomesa.features.kryo.KryoBufferSimpleFeature;
import org.locationtech.geomesa.filter.factory.FastFilterFactory;
import org.locationtech.geomesa.index.iterators.IteratorCache;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.immutable.Set;

@Deprecated
public class JSimpleFeatureFilter
extends FilterBase {
    public static int Priority = 30;
    private static Logger logger = LoggerFactory.getLogger(JSimpleFeatureFilter.class);
    private final Filter localFilter;
    private final KryoBufferSimpleFeature reusable;
    private final Transformer transformer;
    private String sftString;
    protected SimpleFeatureType sft;
    protected org.opengis.filter.Filter filter;
    private String filterString;
    private String transform;
    private String transformSchema;

    private JSimpleFeatureFilter(String sftString, String filterString, String transformString, String transformSchemaString) throws CQLException {
        this.sftString = sftString;
        this.sft = IteratorCache.sft((String)sftString);
        this.reusable = IteratorCache.serializer((String)sftString, (Set)SerializationOptions.withoutId()).getReusableFeature();
        this.filterString = filterString;
        this.transformSchema = transformSchemaString;
        this.transform = transformString;
        this.localFilter = JSimpleFeatureFilter.buildFilter(this.sft, filterString);
        this.transformer = JSimpleFeatureFilter.buildTransformer(this.transform, this.transformSchema);
        this.localFilter.setReusableSF(this.reusable);
        this.transformer.setReusableSF(this.reusable);
    }

    public JSimpleFeatureFilter(SimpleFeatureType sft, org.opengis.filter.Filter filter, String transform, String transformSchema) throws CQLException {
        this.sft = sft;
        this.filter = filter;
        this.sftString = SimpleFeatureTypes.encodeType((SimpleFeatureType)sft, (boolean)true);
        this.filterString = ECQL.toCQL((org.opengis.filter.Filter)filter);
        this.transformSchema = transformSchema;
        this.transform = transform;
        this.localFilter = JSimpleFeatureFilter.buildFilter(sft, this.filterString);
        this.transformer = JSimpleFeatureFilter.buildTransformer(transform, transformSchema);
        this.reusable = IteratorCache.serializer((String)this.sftString, (Set)SerializationOptions.withoutId()).getReusableFeature();
        this.localFilter.setReusableSF(this.reusable);
        this.transformer.setReusableSF(this.reusable);
    }

    public Filter.ReturnCode filterKeyValue(Cell v) throws IOException {
        this.reusable.setBuffer(v.getValueArray(), v.getValueOffset(), v.getValueLength());
        return this.localFilter.filterKeyValue(v);
    }

    public Cell transformCell(Cell v) throws IOException {
        return this.transformer.transformCell(v);
    }

    public byte[] toByteArray() throws IOException {
        byte[][] arrays = new byte[][]{JSimpleFeatureFilter.getLengthArray(this.sftString), JSimpleFeatureFilter.getLengthArray(this.filterString), JSimpleFeatureFilter.getLengthArray(this.transform), JSimpleFeatureFilter.getLengthArray(this.transformSchema)};
        return Bytes.add((byte[][])arrays);
    }

    public String toString() {
        return "JSimpleFeatureFilter[filter=" + this.filterString + ",transform=" + this.transform + "]";
    }

    public static byte[] toByteArray(String sftString, String filterString, String transform, String transformSchema) throws IOException {
        byte[][] arrays = new byte[][]{JSimpleFeatureFilter.getLengthArray(sftString), JSimpleFeatureFilter.getLengthArray(filterString), JSimpleFeatureFilter.getLengthArray(transform), JSimpleFeatureFilter.getLengthArray(transformSchema)};
        return Bytes.add((byte[][])arrays);
    }

    private static byte[] getLengthArray(String s) {
        int len = JSimpleFeatureFilter.getLen(s);
        if (len == 0) {
            return Bytes.toBytes((int)0);
        }
        return Bytes.add((byte[])Bytes.toBytes((int)len), (byte[])s.getBytes());
    }

    private static int getLen(String s) {
        if (s != null) {
            return s.length();
        }
        return 0;
    }

    public static org.apache.hadoop.hbase.filter.Filter parseFrom(byte[] pbBytes) throws DeserializationException {
        logger.trace("Parsing filter of length: " + pbBytes.length);
        int sftLen = Bytes.readAsInt((byte[])pbBytes, (int)0, (int)4);
        String sftString = new String(pbBytes, 4, sftLen);
        int filterLen = Bytes.readAsInt((byte[])pbBytes, (int)(sftLen + 4), (int)4);
        String filterString = new String(pbBytes, sftLen + 8, filterLen);
        int transformLen = Bytes.readAsInt((byte[])pbBytes, (int)(sftLen + filterLen + 8), (int)4);
        String transformString = new String(pbBytes, sftLen + filterLen + 12, transformLen);
        int transformSchemaLen = Bytes.readAsInt((byte[])pbBytes, (int)(sftLen + filterLen + transformLen + 12), (int)4);
        String transformSchemaString = new String(pbBytes, sftLen + filterLen + transformLen + 16, transformSchemaLen);
        try {
            return new JSimpleFeatureFilter(sftString, filterString, transformString, transformSchemaString);
        }
        catch (Exception e) {
            throw new DeserializationException((Throwable)e);
        }
    }

    private static Filter buildFilter(SimpleFeatureType sft, String filterString) throws CQLException {
        if (!"".equals(filterString)) {
            return new CQLFilter(FastFilterFactory.toFilter((SimpleFeatureType)sft, (String)filterString));
        }
        return new IncludeFilter();
    }

    private static Transformer buildTransformer(String transformString, String transformSchemaString) {
        if (Strings.isEmpty((String)transformString)) {
            return new NoTransform();
        }
        return new CQLTransfomer(transformString, SimpleFeatureTypes.createType((String)"", (String)transformSchemaString));
    }

    private static class CQLTransfomer
    extends AbstractTransformer {
        private final String transform;
        private final SimpleFeatureType schema;

        CQLTransfomer(String transform, SimpleFeatureType schema) {
            this.transform = transform;
            this.schema = schema;
        }

        @Override
        public void setReusableSF(KryoBufferSimpleFeature reusableSF) {
            super.setReusableSF(reusableSF);
            this.sf.setTransforms(this.transform, this.schema);
        }

        @Override
        public Cell transformCell(Cell c) throws IOException {
            byte[] newval = this.sf.transform();
            return new KeyValue(c.getRowArray(), c.getRowOffset(), (int)c.getRowLength(), c.getFamilyArray(), c.getFamilyOffset(), (int)c.getFamilyLength(), c.getQualifierArray(), c.getQualifierOffset(), c.getQualifierLength(), c.getTimestamp(), KeyValue.Type.Put, newval, 0, newval.length);
        }
    }

    private static class NoTransform
    extends AbstractTransformer {
        private NoTransform() {
        }

        @Override
        public Cell transformCell(Cell v) throws IOException {
            return v;
        }
    }

    private static abstract class AbstractTransformer
    implements Transformer {
        KryoBufferSimpleFeature sf;

        private AbstractTransformer() {
        }

        @Override
        public void setReusableSF(KryoBufferSimpleFeature reusableSF) {
            this.sf = reusableSF;
        }
    }

    private static interface Transformer {
        public Cell transformCell(Cell var1) throws IOException;

        public void setReusableSF(KryoBufferSimpleFeature var1);
    }

    private static class CQLFilter
    extends AbstractFilter {
        private org.opengis.filter.Filter filter;
        private static Logger log = LoggerFactory.getLogger(CQLFilter.class);

        CQLFilter(org.opengis.filter.Filter filter) {
            this.filter = filter;
        }

        @Override
        public Filter.ReturnCode filterKeyValue(Cell v) throws IOException {
            try {
                log.trace("Evaluating filter against SimpleFeature");
                if (this.filter.evaluate((Object)this.sf)) {
                    return Filter.ReturnCode.INCLUDE;
                }
                return Filter.ReturnCode.SKIP;
            }
            catch (Exception e) {
                log.error("Exception thrown while scanning, skipping", (Throwable)e);
                return Filter.ReturnCode.SKIP;
            }
        }
    }

    private static class IncludeFilter
    extends AbstractFilter {
        private IncludeFilter() {
        }

        @Override
        public Filter.ReturnCode filterKeyValue(Cell v) throws IOException {
            return Filter.ReturnCode.INCLUDE;
        }
    }

    private static abstract class AbstractFilter
    implements Filter {
        KryoBufferSimpleFeature sf;

        private AbstractFilter() {
        }

        @Override
        public void setReusableSF(KryoBufferSimpleFeature reusableSF) {
            this.sf = reusableSF;
        }
    }

    private static interface Filter {
        public Filter.ReturnCode filterKeyValue(Cell var1) throws IOException;

        public void setReusableSF(KryoBufferSimpleFeature var1);
    }
}

