/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.kryo.impl;

import com.esotericsoftware.kryo.io.Output;
import java.io.OutputStream;
import org.locationtech.geomesa.features.SerializationOption;
import org.locationtech.geomesa.features.SerializationOption$;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer$;
import org.locationtech.geomesa.features.kryo.impl.KryoFeatureSerialization;
import org.locationtech.geomesa.features.kryo.impl.KryoFeatureSerialization$;
import org.locationtech.geomesa.features.kryo.package$Metadata$;
import org.locationtech.geomesa.features.kryo.serialization.KryoUserDataSerialization$;
import org.locationtech.geomesa.utils.cache.CacheKeyGenerator$;
import org.locationtech.geomesa.utils.collection.IntBitSet;
import org.locationtech.geomesa.utils.collection.IntBitSet$;
import org.opengis.feature.simple.SimpleFeature;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class KryoFeatureSerialization$class {
    public static byte[] serialize(KryoFeatureSerialization $this, SimpleFeature sf) {
        Output output = KryoFeatureSerialization$.MODULE$.getOutput(null);
        KryoFeatureSerialization$class.writeFeature($this, sf, output);
        return output.toBytes();
    }

    public static void serialize(KryoFeatureSerialization $this, SimpleFeature sf, OutputStream out) {
        Output output = KryoFeatureSerialization$.MODULE$.getOutput(null);
        KryoFeatureSerialization$class.writeFeature($this, sf, output);
        out.write(output.getBuffer(), 0, output.position());
    }

    private static void writeFeature(KryoFeatureSerialization $this, SimpleFeature sf, Output output) {
        int end;
        output.writeByte(KryoFeatureSerializer$.MODULE$.Version3());
        int offset = package$Metadata$.MODULE$.write(output, $this.org$locationtech$geomesa$features$kryo$impl$KryoFeatureSerialization$$count(), 2);
        if ($this.org$locationtech$geomesa$features$kryo$impl$KryoFeatureSerialization$$withId()) {
            output.writeString(sf.getID());
        }
        int[] offsets = (int[])Array$.MODULE$.ofDim($this.org$locationtech$geomesa$features$kryo$impl$KryoFeatureSerialization$$count() + 1, ClassTag$.MODULE$.Int());
        IntBitSet nulls = IntBitSet$.MODULE$.apply($this.org$locationtech$geomesa$features$kryo$impl$KryoFeatureSerialization$$count());
        for (int i = 0; i < $this.org$locationtech$geomesa$features$kryo$impl$KryoFeatureSerialization$$count(); ++i) {
            Boolean bl;
            offsets[i] = output.position() - offset;
            Object attribute = sf.getAttribute(i);
            if (attribute == null) {
                bl = BoxesRunTime.boxToBoolean((boolean)nulls.add(i));
                continue;
            }
            $this.org$locationtech$geomesa$features$kryo$impl$KryoFeatureSerialization$$writers()[i].apply(output, attribute);
            bl = BoxedUnit.UNIT;
        }
        offsets[i] = output.position() - offset;
        if ($this.org$locationtech$geomesa$features$kryo$impl$KryoFeatureSerialization$$withUserData()) {
            KryoUserDataSerialization$.MODULE$.serialize(output, sf.getUserData());
        }
        if ((end = output.position()) - offset > KryoFeatureSerialization$.MODULE$.MaxUnsignedShort()) {
            int shift = 2 * ($this.org$locationtech$geomesa$features$kryo$impl$KryoFeatureSerialization$$count() + 1);
            if (output.getBuffer().length < end + shift) {
                byte[] expanded = (byte[])Array$.MODULE$.ofDim(end + shift, ClassTag$.MODULE$.Byte());
                System.arraycopy(output.getBuffer(), 0, expanded, 0, offset);
                System.arraycopy(output.getBuffer(), offset, expanded, offset + shift, end - offset);
                output.setBuffer(expanded);
            } else {
                byte[] buffer = output.getBuffer();
                for (int i = end; i > offset; --i) {
                    buffer[i + shift] = buffer[i];
                }
            }
            output.setPosition(offset - 1);
            output.write(4);
            Predef$.MODULE$.intArrayOps(offsets).foreach((Function1)new Serializable($this, output, shift){
                public static final long serialVersionUID = 0L;
                private final Output output$1;
                private final int shift$1;

                public final void apply(int o) {
                    this.apply$mcVI$sp(o);
                }

                public void apply$mcVI$sp(int o) {
                    this.output$1.writeInt(o + this.shift$1);
                }
                {
                    this.output$1 = output$1;
                    this.shift$1 = shift$1;
                }
            });
            nulls.serialize(output);
            output.setPosition(end + shift);
        } else {
            output.setPosition(offset);
            Predef$.MODULE$.intArrayOps(offsets).foreach((Function1)new Serializable($this, output){
                public static final long serialVersionUID = 0L;
                private final Output output$1;

                public final void apply(int x$1) {
                    this.apply$mcVI$sp(x$1);
                }

                public void apply$mcVI$sp(int x$1) {
                    this.output$1.writeShort(x$1);
                }
                {
                    this.output$1 = output$1;
                }
            });
            nulls.serialize(output);
            output.setPosition(end);
        }
    }

    public static void $init$(KryoFeatureSerialization $this) {
        $this.org$locationtech$geomesa$features$kryo$impl$KryoFeatureSerialization$_setter_$org$locationtech$geomesa$features$kryo$impl$KryoFeatureSerialization$$writers_$eq(KryoFeatureSerialization$.MODULE$.getWriters(CacheKeyGenerator$.MODULE$.cacheKey($this.in()), $this.in()));
        $this.org$locationtech$geomesa$features$kryo$impl$KryoFeatureSerialization$_setter_$org$locationtech$geomesa$features$kryo$impl$KryoFeatureSerialization$$withId_$eq(!SerializationOption.SerializationOptions$.MODULE$.withoutId$extension(SerializationOption$.MODULE$.SerializationOptions($this.options())));
        $this.org$locationtech$geomesa$features$kryo$impl$KryoFeatureSerialization$_setter_$org$locationtech$geomesa$features$kryo$impl$KryoFeatureSerialization$$withUserData_$eq(SerializationOption.SerializationOptions$.MODULE$.withUserData$extension(SerializationOption$.MODULE$.SerializationOptions($this.options())));
        $this.org$locationtech$geomesa$features$kryo$impl$KryoFeatureSerialization$_setter_$org$locationtech$geomesa$features$kryo$impl$KryoFeatureSerialization$$count_$eq($this.in().getAttributeCount());
    }
}

