/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.multithread;

import org.jets3t.service.model.S3Version;
import org.jets3t.service.multithread.ServiceEvent;
import org.jets3t.service.multithread.ThreadWatcher;

public class DeleteVersionedObjectsEvent
extends ServiceEvent {
    private S3Version[] versions = null;

    private DeleteVersionedObjectsEvent(int eventCode, Object uniqueOperationId) {
        super(eventCode, uniqueOperationId);
    }

    public static DeleteVersionedObjectsEvent newErrorEvent(Throwable t, Object uniqueOperationId) {
        DeleteVersionedObjectsEvent event = new DeleteVersionedObjectsEvent(0, uniqueOperationId);
        event.setErrorCause(t);
        return event;
    }

    public static DeleteVersionedObjectsEvent newStartedEvent(ThreadWatcher threadWatcher, Object uniqueOperationId) {
        DeleteVersionedObjectsEvent event = new DeleteVersionedObjectsEvent(1, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static DeleteVersionedObjectsEvent newInProgressEvent(ThreadWatcher threadWatcher, S3Version[] deletedVersions, Object uniqueOperationId) {
        DeleteVersionedObjectsEvent event = new DeleteVersionedObjectsEvent(3, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        event.setObjects(deletedVersions);
        return event;
    }

    public static DeleteVersionedObjectsEvent newCompletedEvent(Object uniqueOperationId) {
        DeleteVersionedObjectsEvent event = new DeleteVersionedObjectsEvent(2, uniqueOperationId);
        return event;
    }

    public static DeleteVersionedObjectsEvent newCancelledEvent(S3Version[] remainingVersions, Object uniqueOperationId) {
        DeleteVersionedObjectsEvent event = new DeleteVersionedObjectsEvent(4, uniqueOperationId);
        event.setObjects(remainingVersions);
        return event;
    }

    public static DeleteVersionedObjectsEvent newIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors, Object uniqueOperationId) {
        DeleteVersionedObjectsEvent event = new DeleteVersionedObjectsEvent(5, uniqueOperationId);
        event.setIgnoredErrors(ignoredErrors);
        return event;
    }

    private void setObjects(S3Version[] versions) {
        this.versions = versions;
    }

    public S3Version[] getDeletedVersions() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Deleted versions are only available from EVENT_IN_PROGRESS events");
        }
        return this.versions;
    }

    public S3Version[] getCancelledVersions() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled versions are  only available from EVENT_CANCELLED events");
        }
        return this.versions;
    }
}

