/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.palette;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.OperationDescriptorImpl;

public class ColorReductionDescriptor
extends OperationDescriptorImpl {
    private static final long serialVersionUID = -8931287738914712392L;
    public static final String OPERATION_NAME = "org.geotools.ColorReduction";

    public ColorReductionDescriptor() {
        super((String[][])new String[][]{{"GlobalName", OPERATION_NAME}, {"LocalName", OPERATION_NAME}, {"Vendor", "it.geosolutions"}, {"Description", "Produce a paletted imge from an RGB or RGBA image."}, {"DocURL", "http://www.geo-solutions.it/"}, {"Version", "1.0"}, {"arg0Desc", "Number of colors after the reduction."}, {"arg1Desc", "Threshold for thresholding alpha"}, {"arg2Desc", "Subsample x."}, {"arg3Desc", "Subsample y."}, {"arg4Desc", "Transparency Threshoold."}}, new String[]{"rendered"}, 0, new String[]{"numColors", "alphaThreshold", "subsampleX", "subsampleY"}, new Class[]{Integer.class, Integer.class, Integer.class, Integer.class}, new Object[]{255, 1, 1, 1}, null);
    }

    protected boolean validateSources(String modeName, ParameterBlock param, StringBuffer message) {
        if (super.validateSources(modeName, param, message)) {
            int i = param.getNumSources();
            while (--i >= 0) {
                Object source = param.getSource(i);
                if (source instanceof RenderedImage) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean validateParameters(String modeName, ParameterBlock param, StringBuffer message) {
        if (!super.validateParameters(modeName, param, message)) {
            return false;
        }
        int numColors = (Integer)param.getObjectParameter(0);
        int alphaThreashold = (Integer)param.getObjectParameter(1);
        int ssx = (Integer)param.getObjectParameter(2);
        int ssy = (Integer)param.getObjectParameter(3);
        RenderedImage source = (RenderedImage)param.getSource(0);
        if (ssx <= 1 && ssx >= source.getWidth()) {
            return false;
        }
        if (ssy <= 1 && ssy >= source.getHeight()) {
            return false;
        }
        if (alphaThreashold < 0 || alphaThreashold > 255) {
            return false;
        }
        return numColors > 0 && numColors <= 256;
    }
}

