/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.text.MessageFormat;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class PartiallyOrderedSet<E>
extends AbstractSet<E> {
    private final boolean throwOnCycle;
    private final Map<E, DirectedGraphNode> elementsToNodes = new LinkedHashMap<E, DirectedGraphNode>();

    public PartiallyOrderedSet(boolean throwOnCycle) {
        this.throwOnCycle = throwOnCycle;
    }

    public PartiallyOrderedSet() {
        this(true);
    }

    @Override
    public boolean add(E e) {
        if (this.elementsToNodes.containsKey(e)) {
            return false;
        }
        this.elementsToNodes.put(e, new DirectedGraphNode(e));
        return true;
    }

    @Override
    public boolean remove(Object o) {
        DirectedGraphNode node = this.elementsToNodes.remove(o);
        if (node == null) {
            return false;
        }
        this.clearNode(node);
        return true;
    }

    private void clearNode(DirectedGraphNode node) {
        node.outgoings.forEach(target -> target.ingoings.remove(node));
        node.outgoings.clear();
        node.ingoings.forEach(source -> source.outgoings.remove(node));
        node.ingoings.clear();
    }

    public boolean setOrder(E source, E target) {
        DirectedGraphNode sourceNode = this.elementsToNodes.get(source);
        DirectedGraphNode targetNode = this.elementsToNodes.get(target);
        if (sourceNode == null) {
            throw new IllegalArgumentException("Could not find source node in the set: " + source);
        }
        if (targetNode == null) {
            throw new IllegalArgumentException("Could not find target node in the set: " + target);
        }
        return this.createDirectedEdge(sourceNode, targetNode);
    }

    private boolean createDirectedEdge(DirectedGraphNode source, DirectedGraphNode target) {
        this.removeDirectedEdge(target, source);
        boolean sourceNew = source.outgoings.add(target);
        boolean targetNew = target.ingoings.add(source);
        if (sourceNew != targetNew) {
            String message = MessageFormat.format("Inconsistent edge encountered from [source: {0}] to [target: {1}]:", source, target);
            throw new IllegalStateException(message);
        }
        return targetNew;
    }

    public boolean clearOrder(E source, E target) {
        DirectedGraphNode sourceNode = this.elementsToNodes.get(source);
        DirectedGraphNode targetNode = this.elementsToNodes.get(target);
        if (sourceNode == null) {
            throw new IllegalArgumentException("Could not find source node in the set: " + source);
        }
        if (targetNode == null) {
            throw new IllegalArgumentException("Could not find target node in the set: " + target);
        }
        return this.removeDirectedEdge(sourceNode, targetNode);
    }

    private boolean removeDirectedEdge(DirectedGraphNode source, DirectedGraphNode target) {
        boolean targetExisted;
        boolean sourceExisted = source.outgoings.remove(target);
        if (sourceExisted != (targetExisted = target.ingoings.remove(source))) {
            String message = MessageFormat.format("Inconsistent edge encountered from [source: {0}] to [target: {1}]:", source, target);
            throw new IllegalStateException(message);
        }
        return targetExisted;
    }

    @Override
    public Iterator<E> iterator() {
        return new TopologicalSortIterator();
    }

    @Override
    public int size() {
        return this.elementsToNodes.size();
    }

    class TopologicalSortIterator
    implements Iterator<E> {
        private final LinkedList<DirectedGraphNode> sources = new LinkedList();
        private final Map<DirectedGraphNode, Countdown> residualInDegrees = new LinkedHashMap<DirectedGraphNode, Countdown>();

        public TopologicalSortIterator() {
            for (DirectedGraphNode node : PartiallyOrderedSet.this.elementsToNodes.values()) {
                int inDegree = node.getInDegree();
                if (inDegree == 0) {
                    this.sources.add(node);
                    continue;
                }
                this.residualInDegrees.put(node, new Countdown(inDegree));
            }
            if (this.sources.isEmpty() && !PartiallyOrderedSet.this.elementsToNodes.isEmpty()) {
                this.maybeThrowLoopException();
            }
        }

        private void maybeThrowLoopException() {
            if (PartiallyOrderedSet.this.throwOnCycle) {
                String message = "Some of the partial order relationship form a loop: " + this.residualInDegrees.keySet();
                throw new IllegalStateException(message);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.sources.isEmpty() && !this.residualInDegrees.isEmpty()) {
                this.maybeThrowLoopException();
            }
            return !this.sources.isEmpty();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            DirectedGraphNode next = this.sources.removeFirst();
            for (DirectedGraphNode out : next.outgoings) {
                Countdown countdown = this.residualInDegrees.get(out);
                if (countdown.decrement() != 0) continue;
                this.sources.add(out);
                this.residualInDegrees.remove(out);
            }
            return next.getValue();
        }
    }

    static final class Countdown {
        int value;

        public Countdown(int value) {
            this.value = value;
        }

        public int decrement() {
            return --this.value;
        }
    }

    class DirectedGraphNode {
        E element;
        Set<DirectedGraphNode> outgoings = new HashSet<DirectedGraphNode>();
        Set<DirectedGraphNode> ingoings = new HashSet<DirectedGraphNode>();

        public DirectedGraphNode(E element) {
            this.element = element;
        }

        public E getValue() {
            return this.element;
        }

        public int getInDegree() {
            return this.ingoings.size();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[");
            sb.append(this.element);
            if (this.outgoings.size() > 0) {
                sb.append(" -> (");
                for (DirectedGraphNode outgoing : this.outgoings) {
                    sb.append(outgoing.element).append(",");
                }
                sb.setCharAt(sb.length() - 1, ')');
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

