/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class PreventLocalEntityResolver
implements EntityResolver2,
Serializable {
    private static final long serialVersionUID = -5689036455423814933L;
    public static final String ERROR_MESSAGE_BASE = "Entity resolution disallowed for ";
    protected static final Logger LOGGER = Logging.getLogger(PreventLocalEntityResolver.class);
    public static final PreventLocalEntityResolver INSTANCE = new PreventLocalEntityResolver();

    protected PreventLocalEntityResolver() {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("resolveEntity request: publicId=" + publicId + ", systemId=" + systemId);
        }
        if (systemId != null && systemId.matches("(?i)(jar:file|http|vfs)[^?#;]*\\.xsd")) {
            return null;
        }
        throw new SAXException(ERROR_MESSAGE_BASE + systemId);
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        return null;
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        if (baseURI != null && baseURI.matches("(?i)(jar:file|http|vfs)[^?#;]*\\.xsd")) {
            return null;
        }
        return this.resolveEntity(publicId, systemId);
    }
}

