/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.StringJoiner;
import org.locationtech.geomesa.security.DefaultAuthorizationsProvider;
import org.locationtech.geomesa.security.FilteringAuthorizationsProvider;
import org.locationtech.geomesa.security.package$;

public interface AuthorizationsProvider {
    public static final String AUTH_PROVIDER_SYS_PROPERTY = "geomesa.auth.provider.impl";

    public List<String> getAuthorizations();

    public void configure(Map<String, Serializable> var1);

    /*
     * Enabled aggressive block sorting
     */
    public static AuthorizationsProvider apply(Map<String, Serializable> params, List<String> authorizations) {
        AuthorizationsProvider provider;
        block15: {
            String name;
            ArrayList<AuthorizationsProvider> providers;
            block16: {
                providers = new ArrayList<AuthorizationsProvider>();
                for (AuthorizationsProvider p : ServiceLoader.load(AuthorizationsProvider.class)) {
                    providers.add(p);
                }
                provider = (AuthorizationsProvider)package$.MODULE$.AuthProviderParam().lookup(params);
                if (provider != null) break block15;
                name = package$.MODULE$.GEOMESA_AUTH_PROVIDER_IMPL().get();
                if (name != null) break block16;
                if (providers.isEmpty()) {
                    provider = new DefaultAuthorizationsProvider();
                    break block15;
                } else if (providers.size() == 1) {
                    provider = (AuthorizationsProvider)providers.get(0);
                    break block15;
                } else {
                    String prop = package$.MODULE$.GEOMESA_AUTH_PROVIDER_IMPL().property();
                    StringJoiner options = new StringJoiner(", ");
                    Iterator iterator = providers.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            throw new IllegalStateException("Found multiple AuthorizationsProvider implementations: " + options.toString() + ". Please specify the one to use with the system property '" + prop + "'");
                        }
                        AuthorizationsProvider p = (AuthorizationsProvider)iterator.next();
                        options.add(p.getClass().getName());
                    }
                }
            }
            if (DefaultAuthorizationsProvider.class.getName().equals(name)) {
                provider = new DefaultAuthorizationsProvider();
            } else {
                for (AuthorizationsProvider p : providers) {
                    if (!p.getClass().getName().equals(name)) continue;
                    provider = p;
                    break;
                }
                if (provider == null) {
                    String prop = package$.MODULE$.GEOMESA_AUTH_PROVIDER_IMPL().property();
                    StringJoiner options = new StringJoiner(", ");
                    Iterator iterator = providers.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            throw new IllegalArgumentException("The service provider class '" + name + "' specified by '" + (String)prop + "' could not be loaded. Available providers are: " + options.toString());
                        }
                        AuthorizationsProvider p = (AuthorizationsProvider)iterator.next();
                        options.add(p.getClass().getName());
                    }
                }
            }
        }
        provider = new FilteringAuthorizationsProvider(provider);
        HashMap<String, Serializable> modifiedParams = new HashMap<String, Serializable>(params);
        StringJoiner auths = new StringJoiner(",");
        Iterator<String> iterator = authorizations.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                modifiedParams.put(package$.MODULE$.AuthsParam().key, (Serializable)((Object)auths.toString()));
                provider.configure(modifiedParams);
                return provider;
            }
            String auth = iterator.next();
            auths.add(auth);
        }
    }
}

