/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column;

import java.util.Arrays;
import org.apache.parquet.schema.PrimitiveType;

public class ColumnDescriptor
implements Comparable<ColumnDescriptor> {
    private final String[] path;
    private final PrimitiveType.PrimitiveTypeName type;
    private final int typeLength;
    private final int maxRep;
    private final int maxDef;

    public ColumnDescriptor(String[] path, PrimitiveType.PrimitiveTypeName type, int maxRep, int maxDef) {
        this(path, type, 0, maxRep, maxDef);
    }

    public ColumnDescriptor(String[] path, PrimitiveType.PrimitiveTypeName type, int typeLength, int maxRep, int maxDef) {
        this.path = path;
        this.type = type;
        this.typeLength = typeLength;
        this.maxRep = maxRep;
        this.maxDef = maxDef;
    }

    public String[] getPath() {
        return this.path;
    }

    public int getMaxRepetitionLevel() {
        return this.maxRep;
    }

    public int getMaxDefinitionLevel() {
        return this.maxDef;
    }

    public PrimitiveType.PrimitiveTypeName getType() {
        return this.type;
    }

    public int getTypeLength() {
        return this.typeLength;
    }

    public int hashCode() {
        return Arrays.hashCode(this.path);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ColumnDescriptor)) {
            return false;
        }
        ColumnDescriptor descriptor = (ColumnDescriptor)other;
        return Arrays.equals(this.path, descriptor.path);
    }

    @Override
    public int compareTo(ColumnDescriptor o) {
        int length = this.path.length < o.path.length ? this.path.length : o.path.length;
        for (int i = 0; i < length; ++i) {
            int compareTo = this.path[i].compareTo(o.path[i]);
            if (compareTo == 0) continue;
            return compareTo;
        }
        return this.path.length - o.path.length;
    }

    public String toString() {
        return Arrays.toString(this.path) + " " + (Object)((Object)this.type);
    }
}

